/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.menu.MenuUtilities;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenuBackgroundDelegate;

public class SubstanceSeparatorUI
extends BasicSeparatorUI {
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceSeparatorUI();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Container container = jComponent.getParent();
        if (!(container instanceof JPopupMenu)) {
            SeparatorPainterUtils.paintSeparator(jComponent, graphics, jComponent.getWidth(), jComponent.getHeight(), ((JSeparator)jComponent).getOrientation());
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n = MenuUtilities.getTextOffset(jComponent, container);
        SubstanceMenuBackgroundDelegate.paintBackground(graphics2D, jComponent, n);
        Dimension dimension = jComponent.getSize();
        int n2 = 0;
        int n3 = dimension.width;
        if (container.getComponentOrientation().isLeftToRight()) {
            n2 = n - 2;
            n3 = dimension.width - n2;
        } else {
            n2 = 0;
            n3 = n - 4;
        }
        graphics2D.translate(n2, 0);
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)container));
        SeparatorPainterUtils.paintSeparator(jComponent, graphics2D, n3, dimension.height, ((JSeparator)jComponent).getOrientation(), true, 2);
        graphics2D.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jComponent));
        int n = (int)Math.ceil(2.0 * (double)f);
        if (((JSeparator)jComponent).getOrientation() == 1) {
            return new Dimension(n, 0);
        }
        return new Dimension(0, n);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults(JSeparator jSeparator) {
        super.installDefaults(jSeparator);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners(JSeparator jSeparator) {
        super.installListeners(jSeparator);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults(JSeparator jSeparator) {
        super.uninstallDefaults(jSeparator);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallListeners(JSeparator jSeparator) {
        super.uninstallListeners(jSeparator);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }
}

