/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceLookAndFeelEx;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.api.tabbed.BaseTabCloseListener;
import org.pushingpixels.substance.api.tabbed.MultipleTabCloseListener;
import org.pushingpixels.substance.api.tabbed.TabCloseCallback;
import org.pushingpixels.substance.api.tabbed.TabCloseListener;
import org.pushingpixels.substance.api.tabbed.VetoableMultipleTabCloseListener;
import org.pushingpixels.substance.api.tabbed.VetoableTabCloseListener;
import org.pushingpixels.substance.internal.animation.StateTransitionMultiTracker;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;
import org.pushingpixels.substance.internal.utils.scroll.SubstanceScrollButton;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;

public class SubstanceTabbedPaneUI
extends BasicTabbedPaneUI {
    protected Point substanceMouseLocation;
    private static LazyResettableHashMap<BufferedImage> backgroundMap = new LazyResettableHashMap("SubstanceTabbedPaneUI.background");
    private static LazyResettableHashMap<BufferedImage> closeButtonMap = new LazyResettableHashMap("SubstanceTabbedPaneUI.closeButton");
    private Map<Component, Timeline> modifiedTimelines;
    private int currSelectedIndex = -1;
    private StateTransitionMultiTracker<Integer> stateTransitionMultiTracker = new StateTransitionMultiTracker();
    protected MouseRolloverHandler substanceRolloverHandler;
    protected TabbedContainerListener substanceContainerListener;
    protected ChangeListener substanceSelectionListener;
    private boolean substanceContentOpaque;
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceTabbedPaneUI();
    }

    private void installListenersInternal() {
        super.installListeners();
        this.substanceRolloverHandler = new MouseRolloverHandler();
        this.tabPane.addMouseMotionListener(this.substanceRolloverHandler);
        this.tabPane.addMouseListener(this.substanceRolloverHandler);
        this.substanceContainerListener = new TabbedContainerListener();
        this.substanceContainerListener.trackExistingTabs();
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            Component component = this.tabPane.getComponentAt(i);
            if (!SubstanceCoreUtilities.isTabModified(component)) continue;
            this.trackTabModification(i, component);
        }
        this.tabPane.addContainerListener(this.substanceContainerListener);
        this.substanceSelectionListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StateTransitionTracker stateTransitionTracker;
                        if (SubstanceTabbedPaneUI.this.tabPane == null) {
                            return;
                        }
                        int n = SubstanceTabbedPaneUI.this.tabPane.getSelectedIndex();
                        if (SubstanceTabbedPaneUI.this.currSelectedIndex >= 0 && SubstanceTabbedPaneUI.this.currSelectedIndex < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(SubstanceTabbedPaneUI.this.currSelectedIndex)) {
                            stateTransitionTracker = SubstanceTabbedPaneUI.this.getTracker(SubstanceTabbedPaneUI.this.currSelectedIndex, SubstanceTabbedPaneUI.this.getRolloverTabIndex() == SubstanceTabbedPaneUI.this.currSelectedIndex, true);
                            stateTransitionTracker.getModel().setSelected(false);
                        }
                        SubstanceTabbedPaneUI.this.currSelectedIndex = n;
                        if (n >= 0 && n < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                            stateTransitionTracker = SubstanceTabbedPaneUI.this.getTracker(n, SubstanceTabbedPaneUI.this.getRolloverTabIndex() == n, false);
                            stateTransitionTracker.getModel().setSelected(true);
                        }
                    }
                });
            }
        };
        this.tabPane.getModel().addChangeListener(this.substanceSelectionListener);
    }

    private void uninstallListenersInternal() {
        super.uninstallListeners();
        if (this.substanceRolloverHandler != null) {
            this.tabPane.removeMouseMotionListener(this.substanceRolloverHandler);
            this.tabPane.removeMouseListener(this.substanceRolloverHandler);
            this.substanceRolloverHandler = null;
        }
        if (this.substanceContainerListener != null) {
            for (Map.Entry<Component, List<PropertyChangeListener>> entry : this.substanceContainerListener.listeners.entrySet()) {
                Component component = entry.getKey();
                for (PropertyChangeListener propertyChangeListener : entry.getValue()) {
                    component.removePropertyChangeListener(propertyChangeListener);
                }
            }
            this.substanceContainerListener.listeners.clear();
            this.tabPane.removeContainerListener(this.substanceContainerListener);
            this.substanceContainerListener = null;
        }
        this.tabPane.getModel().removeChangeListener(this.substanceSelectionListener);
        this.substanceSelectionListener = null;
    }

    private void installDefaultsInternal() {
        super.installDefaults();
        this.substanceContentOpaque = UIManager.getBoolean("TabbedPane.contentOpaque");
        this.modifiedTimelines = new HashMap<Component, Timeline>();
        this.currSelectedIndex = this.tabPane.getSelectedIndex();
    }

    private void uninstallDefaultsInternal() {
        for (Timeline timeline : this.modifiedTimelines.values()) {
            timeline.cancel();
        }
        this.modifiedTimelines.clear();
        super.uninstallDefaults();
    }

    private static BufferedImage getTabBackground(JTabbedPane jTabbedPane, int n, int n2, int n3, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2, boolean bl) {
        SubstanceFillPainter substanceFillPainter = SubstanceCoreUtilities.getFillPainter(jTabbedPane);
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(jTabbedPane);
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(jTabbedPane);
        int n4 = (int)Math.ceil(2.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jTabbedPane)));
        int n5 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jTabbedPane)) / 2.0);
        int n6 = 2 + n4;
        EnumSet<SubstanceConstants.Side> enumSet = EnumSet.of(SubstanceConstants.Side.BOTTOM);
        int n7 = n2 / 3;
        if (substanceButtonShaper instanceof ClassicButtonShaper) {
            n7 = (int)SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(jTabbedPane));
            if (n3 == 1 || n3 == 3) {
                --n;
            } else {
                --n2;
            }
        }
        GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n, n2 + n6, (float)n7, enumSet, n5);
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (!bl) {
            substanceFillPainter.paintContourBackground(graphics2D, jTabbedPane, n, n2 + n6, generalPath, false, substanceColorScheme, true);
        }
        int n8 = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jTabbedPane));
        GeneralPath generalPath2 = substanceBorderPainter.isPaintingInnerContour() ? SubstanceOutlineUtilities.getBaseOutline(n, n2 + n6, (float)(n7 - n8), enumSet, n8 + n5) : null;
        substanceBorderPainter.paintBorder(graphics2D, jTabbedPane, n, n2 + n6, generalPath, generalPath2, substanceColorScheme2);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static BufferedImage getFinalTabBackgroundImage(JTabbedPane jTabbedPane, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, SubstanceConstants.Side side, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
        SubstanceFillPainter substanceFillPainter = SubstanceCoreUtilities.getFillPainter(jTabbedPane);
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(jTabbedPane);
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(jTabbedPane);
        Component component = jTabbedPane.getTabComponentAt(n);
        if (component == null) {
            component = jTabbedPane.getComponentAt(n);
        }
        if (component == null) {
            component = jTabbedPane;
        }
        Color color = component.getBackground();
        if (bl && color instanceof UIResource) {
            color = SubstanceColorUtilities.getBackgroundFillColor(component);
        }
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n4, n5, bl, n6, substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), substanceButtonShaper.getDisplayName(), n6 == 3, side.name(), substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), color);
        SubstanceSkin substanceSkin = SubstanceCoreUtilities.getSkin(jTabbedPane);
        BufferedImage bufferedImage = backgroundMap.get(hashMapKey);
        if (bufferedImage == null) {
            BufferedImage bufferedImage2 = null;
            switch (n6) {
                case 3: {
                    return SubstanceImageCreator.getRotated(SubstanceTabbedPaneUI.getFinalTabBackgroundImage(jTabbedPane, n, n2, n3, n4, n5, bl, 1, side, substanceColorScheme, substanceColorScheme2), 2);
                }
                case 1: 
                case 2: 
                case 4: {
                    bufferedImage2 = SubstanceTabbedPaneUI.getTabBackground(jTabbedPane, n4, n5, 1, substanceColorScheme, substanceColorScheme2, false);
                    if (!bl) break;
                    int n7 = bufferedImage2.getWidth();
                    int n8 = bufferedImage2.getHeight();
                    BufferedImage bufferedImage3 = SubstanceCoreUtilities.getBlankImage(n7, n8);
                    Graphics2D graphics2D = bufferedImage3.createGraphics();
                    graphics2D.setColor(color);
                    graphics2D.fillRect(0, 0, n7, n8);
                    if (substanceSkin.getWatermark() != null) {
                        graphics2D.translate(-n2, -n3);
                        substanceSkin.getWatermark().drawWatermarkImage(graphics2D, jTabbedPane, n2, n3, n7, n8);
                        graphics2D.translate(n2, n3);
                    }
                    graphics2D.drawImage((Image)SubstanceTabbedPaneUI.getTabBackground(jTabbedPane, n4, n5, n6, substanceColorScheme, substanceColorScheme2, true), 0, 0, null);
                    bufferedImage2 = SubstanceCoreUtilities.blendImagesVertical(bufferedImage2, bufferedImage3, substanceSkin.getSelectedTabFadeStart(), substanceSkin.getSelectedTabFadeEnd());
                }
            }
            backgroundMap.put(hashMapKey, bufferedImage2);
        }
        return backgroundMap.get(hashMapKey);
    }

    private static BufferedImage getCloseButtonImage(JTabbedPane jTabbedPane, int n, int n2, boolean bl, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
        SubstanceFillPainter substanceFillPainter = SubstanceCoreUtilities.getFillPainter(jTabbedPane);
        if (substanceFillPainter == null) {
            return null;
        }
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, n2, bl, substanceFillPainter.getDisplayName(), substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName());
        BufferedImage bufferedImage = closeButtonMap.get(hashMapKey);
        if (bufferedImage == null) {
            bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            if (bl) {
                GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n, n2, 1.0f, null);
                substanceFillPainter.paintContourBackground(graphics2D, jTabbedPane, n, n2, generalPath, false, substanceColorScheme, true);
                SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(jTabbedPane);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                substanceBorderPainter.paintBorder(graphics2D, jTabbedPane, n, n2, generalPath, null, substanceColorScheme2);
            }
            graphics2D.setStroke(new BasicStroke(SubstanceSizeUtils.getTabCloseButtonStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jTabbedPane))));
            int n3 = (int)Math.floor(SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jTabbedPane)));
            if (n3 % 2 != 0) {
                --n3;
            }
            int n4 = n - n3;
            Icon icon = SubstanceImageCreator.getCloseIcon(n4, substanceColorScheme2, substanceColorScheme2);
            icon.paintIcon(jTabbedPane, graphics2D, n3 / 2, n3 / 2);
            closeButtonMap.put(hashMapKey, bufferedImage);
        }
        return bufferedImage;
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry2;
        float f;
        Object object5;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.tabPane, (Graphics)graphics));
        boolean bl2 = this.tabPane.isEnabledAt(n2);
        ComponentState componentState = this.getTabState(n2);
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.getModelStateInfo(n2);
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n2, ColorSchemeAssociationKind.TAB_BORDER, componentState);
        SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n2, ColorSchemeAssociationKind.TAB, componentState);
        Object object6 = null;
        Component component = this.tabPane.getComponentAt(n2);
        boolean bl3 = SubstanceCoreUtilities.isTabModified(component);
        boolean bl4 = SubstanceCoreUtilities.toAnimateCloseIconOfModifiedTab(this.tabPane, n2);
        if (bl3 && bl2 && !bl4) {
            object5 = SubstanceColorSchemeUtilities.YELLOW;
            var20_20 = SubstanceColorSchemeUtilities.ORANGE;
            f = this.modifiedTimelines.get(component).getTimelinePosition();
            entry2 = SubstanceTabbedPaneUI.getFinalTabBackgroundImage(this.tabPane, n2, n3, n4, n5, n6, bl, n, SubstanceConstants.Side.BOTTOM, (SubstanceColorScheme)var20_20, substanceColorScheme);
            object4 = SubstanceTabbedPaneUI.getFinalTabBackgroundImage(this.tabPane, n2, n3, n4, n5, n6, bl, n, SubstanceConstants.Side.BOTTOM, (SubstanceColorScheme)object5, substanceColorScheme);
            object6 = SubstanceCoreUtilities.getBlankImage(n5, n6);
            object3 = ((BufferedImage)object6).createGraphics();
            if (f < 1.0f) {
                ((Graphics)object3).drawImage((Image)((Object)entry2), 0, 0, null);
            }
            if (f > 0.0f) {
                ((Graphics2D)object3).setComposite(AlphaComposite.SrcOver.derive(f));
                ((Graphics)object3).drawImage((Image)object4, 0, 0, null);
            }
            ((Graphics)object3).dispose();
        } else {
            object5 = SubstanceTabbedPaneUI.getFinalTabBackgroundImage(this.tabPane, n2, n3, n4, n5, n6, bl, n, SubstanceConstants.Side.BOTTOM, substanceColorScheme2, substanceColorScheme);
            if (modelStateInfo == null || componentState.isDisabled() || modelStateInfo.getStateContributionMap().size() == 1) {
                object6 = object5;
            } else {
                object6 = SubstanceCoreUtilities.getBlankImage(n5, n6);
                var20_20 = ((BufferedImage)object6).createGraphics();
                ((Graphics)var20_20).drawImage((Image)object5, 0, 0, null);
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry2 : modelStateInfo.getStateContributionMap().entrySet()) {
                    float f2;
                    object4 = entry2.getKey();
                    if (object4 == componentState || !((f2 = entry2.getValue().getContribution()) > 0.0f)) continue;
                    ((Graphics2D)var20_20).setComposite(AlphaComposite.SrcOver.derive(f2));
                    object2 = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n2, ColorSchemeAssociationKind.TAB, (ComponentState)object4);
                    SubstanceColorScheme substanceColorScheme3 = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n2, ColorSchemeAssociationKind.TAB_BORDER, (ComponentState)object4);
                    object = SubstanceTabbedPaneUI.getFinalTabBackgroundImage(this.tabPane, n2, n3, n4, n5, n6, bl, n, SubstanceConstants.Side.BOTTOM, (SubstanceColorScheme)object2, substanceColorScheme3);
                    ((Graphics)var20_20).drawImage((Image)object, 0, 0, null);
                }
            }
        }
        object5 = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n2, ColorSchemeAssociationKind.MARK, componentState);
        graphics2D.clip(new Rectangle(n3, n4, n5, n6));
        boolean bl5 = this.getRolloverTab() == n2;
        f = 0.5f;
        entry2 = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)n2);
        if (modelStateInfo != null) {
            f += 0.5f * ((StateTransitionTracker)((Object)entry2)).getFacetStrength(ComponentStateFacet.ROLLOVER);
            if (((StateTransitionTracker)((Object)entry2)).getFacetStrength(ComponentStateFacet.SELECTION) == 1.0f) {
                f = 1.0f;
            }
        } else {
            object4 = this.getTabState(n2);
            if (((ComponentState)object4).isFacetActive(ComponentStateFacet.ROLLOVER) || ((ComponentState)object4).isFacetActive(ComponentStateFacet.SELECTION)) {
                f = 1.0f;
            }
        }
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.tabPane, (float)(f *= SubstanceColorSchemeUtilities.getAlpha(this.tabPane.getComponentAt(n2), componentState)), (Graphics)graphics));
        graphics2D.drawImage((Image)object6, n3, n4, null);
        object4 = this.tabPane.getTabComponentAt(n2);
        if (object4 instanceof JComponent && (object3 = (Color)((JComponent)object4).getClientProperty("substancelaf.tabstripcolor")) != null) {
            object3 = new Color(((Color)object3).getRed(), ((Color)object3).getGreen(), ((Color)object3).getBlue(), bl ? 100 : 200);
            object2 = (Graphics2D)graphics2D.create();
            int n7 = 1;
            ((Graphics2D)object2).setComposite(AlphaComposite.SrcOver);
            ((Graphics)object2).setColor((Color)object3);
            ((Graphics)object2).fillRect(n3 + n7, n4 + n7, n5 - n7 * 2 - 1, 2);
            ((Graphics)object2).dispose();
        }
        if (SubstanceCoreUtilities.hasCloseButton(this.tabPane, n2) && bl2) {
            float f3;
            float f4 = f3 = bl || bl5 ? 1.0f : 0.0f;
            if (!bl && entry2 != null) {
                f3 = ((StateTransitionTracker)((Object)entry2)).getFacetStrength(ComponentStateFacet.ROLLOVER);
            }
            if ((double)f3 > 0.0) {
                Object object7;
                graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.tabPane, (float)(f * f3), (Graphics)graphics));
                object2 = this.getCloseButtonRectangleForDraw(n2, n3, n4, n5, n6);
                boolean bl6 = false;
                if (bl5 && this.substanceMouseLocation != null) {
                    object = new Rectangle();
                    object = this.getTabBounds(n2, (Rectangle)object);
                    if (this.toRotateTabsOnPlacement(n)) {
                        object = new Rectangle(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).height, ((Rectangle)object).width);
                    }
                    if (((Rectangle)(object7 = this.getCloseButtonRectangleForEvents(n2, ((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height))).contains(this.substanceMouseLocation)) {
                        bl6 = true;
                    }
                }
                if (bl3 && bl2 && bl4) {
                    object = SubstanceColorSchemeUtilities.YELLOW;
                    object7 = SubstanceColorSchemeUtilities.ORANGE;
                    float f5 = this.modifiedTimelines.get(component).getTimelinePosition();
                    BufferedImage bufferedImage = SubstanceTabbedPaneUI.getCloseButtonImage(this.tabPane, ((Rectangle)object2).width, ((Rectangle)object2).height, bl6, (SubstanceColorScheme)object7, (SubstanceColorScheme)object5);
                    BufferedImage bufferedImage2 = SubstanceTabbedPaneUI.getCloseButtonImage(this.tabPane, ((Rectangle)object2).width, ((Rectangle)object2).height, bl6, (SubstanceColorScheme)object, (SubstanceColorScheme)object5);
                    if (f5 < 1.0f) {
                        graphics2D.drawImage((Image)bufferedImage, ((Rectangle)object2).x, ((Rectangle)object2).y, null);
                    }
                    if (f5 > 0.0f) {
                        graphics2D.setComposite(AlphaComposite.SrcOver.derive(f5));
                        graphics2D.drawImage((Image)bufferedImage2, ((Rectangle)object2).x, ((Rectangle)object2).y, null);
                    }
                } else {
                    object = SubstanceTabbedPaneUI.getCloseButtonImage(this.tabPane, ((Rectangle)object2).width, ((Rectangle)object2).height, bl6, substanceColorScheme2, (SubstanceColorScheme)object5);
                    if (modelStateInfo == null || componentState.isDisabled() || modelStateInfo.getStateContributionMap().size() == 1) {
                        graphics2D.drawImage((Image)object, ((Rectangle)object2).x, ((Rectangle)object2).y, null);
                    } else {
                        object7 = SubstanceCoreUtilities.getBlankImage(((Rectangle)object2).width, ((Rectangle)object2).height);
                        Graphics2D graphics2D2 = ((BufferedImage)object7).createGraphics();
                        graphics2D2.drawImage((Image)object, 0, 0, null);
                        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry3 : modelStateInfo.getStateContributionMap().entrySet()) {
                            float f6;
                            ComponentState componentState2 = entry3.getKey();
                            if (componentState2 == componentState || !((f6 = entry3.getValue().getContribution()) > 0.0f)) continue;
                            graphics2D2.setComposite(AlphaComposite.SrcOver.derive(f6));
                            SubstanceColorScheme substanceColorScheme4 = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n2, ColorSchemeAssociationKind.TAB, componentState2);
                            SubstanceColorScheme substanceColorScheme5 = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n2, ColorSchemeAssociationKind.MARK, componentState2);
                            BufferedImage bufferedImage = SubstanceTabbedPaneUI.getCloseButtonImage(this.tabPane, ((Rectangle)object2).width, ((Rectangle)object2).height, bl6, substanceColorScheme4, substanceColorScheme5);
                            graphics2D2.drawImage((Image)bufferedImage, 0, 0, null);
                        }
                        graphics2D2.dispose();
                        graphics2D.drawImage((Image)object7, ((Rectangle)object2).x, ((Rectangle)object2).y, null);
                    }
                }
            }
        }
        graphics2D.dispose();
    }

    @Override
    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
    }

    @Override
    protected JButton createScrollButton(final int n) {
        SubstanceScrollButton substanceScrollButton = new SubstanceScrollButton(n);
        TransitionAwareIcon transitionAwareIcon = new TransitionAwareIcon(substanceScrollButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                int n2 = SubstanceSizeUtils.getComponentFontSize(SubstanceTabbedPaneUI.this.tabPane);
                return SubstanceImageCreator.getArrowIcon(n2, n, substanceColorScheme);
            }
        }, "substance.tabbedpane.scroll." + n);
        substanceScrollButton.setIcon(transitionAwareIcon);
        return substanceScrollButton;
    }

    @Override
    protected int calculateTabHeight(int n, int n2, int n3) {
        boolean bl = this.toRotateTabsOnPlacement(n);
        if (bl) {
            return this.getTabExtraWidth(n, n2) + super.calculateTabWidth(n, n2, this.getFontMetrics());
        }
        return super.calculateTabHeight(n, n2, n3);
    }

    @Override
    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        boolean bl = this.toRotateTabsOnPlacement(n);
        if (bl) {
            return super.calculateTabHeight(n, n2, fontMetrics.getHeight());
        }
        int n3 = this.getTabExtraWidth(n, n2) + super.calculateTabWidth(n, n2, fontMetrics);
        return n3;
    }

    @Override
    protected int calculateMaxTabHeight(int n) {
        if (this.toRotateTabsOnPlacement(n)) {
            return super.calculateMaxTabHeight(n);
        }
        int n2 = 0;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            n2 = Math.max(n2, this.calculateTabHeight(n, i, this.getFontMetrics().getHeight()));
        }
        return n2;
    }

    @Override
    protected int getTabRunOverlay(int n) {
        boolean bl = this.toRotateTabsOnPlacement(n);
        if (bl) {
            return super.getTabRunOverlay(n);
        }
        return 0;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getSelectedIndex();
        int n2 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (this.tabPane.getLayout().getClass() == TabbedPaneLayout.class) {
            this.paintTabArea(graphics, n2, n);
        }
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        switch (n2) {
            case 2: {
                n7 -= (n5 += this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n7 -= this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n8 -= this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n8 -= (n6 += this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create(n5, n6, n7, n8);
        BackgroundPaintingUtils.update(graphics2D, jComponent, false);
        this.paintContentBorder(graphics, n2, n);
    }

    @Override
    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        boolean bl = this.toRotateTabsOnPlacement(n);
        if (bl) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            Rectangle rectangle3 = rectangleArray[n2];
            Rectangle rectangle4 = new Rectangle(rectangle3.x, rectangle3.y, rectangle3.height, rectangle3.width);
            if (n == 2) {
                graphics2D.rotate(-1.5707963267948966, rectangle3.x, rectangle3.y);
                graphics2D.translate(-rectangle3.height, 0);
            } else {
                graphics2D.rotate(1.5707963267948966, rectangle3.x, rectangle3.y);
                graphics2D.translate(0.0, -rectangle3.getWidth());
            }
            graphics2D.setColor(Color.red);
            rectangleArray[n2] = rectangle4;
            super.paintTab(graphics2D, n, rectangleArray, n2, rectangle, rectangle2);
            rectangleArray[n2] = rectangle3;
            graphics2D.dispose();
        } else if (this.tabPane.getLayout().getClass() == TabbedPaneLayout.class) {
            super.paintTab(graphics, n, rectangleArray, n2, rectangle, rectangle2);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)this.tabPane);
            super.paintTab(graphics2D, n, rectangleArray, n2, rectangle, rectangle2);
            graphics2D.dispose();
        }
    }

    @Override
    protected void paintTabArea(Graphics graphics, int n, int n2) {
        if (this.substanceContentOpaque) {
            int n3 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
            if (n == 1 || n == 3) {
                n3 = Math.max(n3, this.tabPane.getWidth());
            }
            int n4 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
            if (this.toRotateTabsOnPlacement(n)) {
                n4 = Math.max(n4, this.tabPane.getHeight());
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create(0, 0, n3, n4);
            BackgroundPaintingUtils.update(graphics2D, this.tabPane, true);
            graphics2D.dispose();
        }
        super.paintTabArea(graphics, n, n2);
    }

    protected Rectangle getCloseButtonRectangleForDraw(int n, int n2, int n3, int n4, int n5) {
        int n6 = SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, n);
        int n7 = (int)Math.ceil(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)));
        int n8 = this.tabPane.getComponentOrientation().isLeftToRight() ? n2 + n4 - n6 - n7 : n2 + n7;
        int n9 = n3 + (n5 - n6) / 2 + 1;
        return new Rectangle(n8, n9, n6, n6);
    }

    protected Rectangle getCloseButtonRectangleForEvents(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.tabPane.getTabPlacement();
        boolean bl = this.toRotateTabsOnPlacement(n6);
        if (!bl) {
            return this.getCloseButtonRectangleForDraw(n, n2, n3, n4, n5);
        }
        int n7 = SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, n);
        Point2D point2D = null;
        Rectangle rectangle = this.getCloseButtonRectangleForDraw(n, n2, n3, n5, n4);
        if (n6 == 2) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(-1.5707963267948966, n2, n3);
            affineTransform.translate(-n5, 0.0);
            Point2D.Double double_ = new Point2D.Double(rectangle.getMaxX(), rectangle.getMinY());
            point2D = affineTransform.transform(double_, null);
        } else {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(1.5707963267948966, n2, n3);
            affineTransform.translate(0.0, -n4);
            Point2D.Double double_ = new Point2D.Double(rectangle.getMinX(), rectangle.getMaxY());
            point2D = affineTransform.transform(double_, null);
        }
        return new Rectangle((int)point2D.getX(), (int)point2D.getY(), n7, n7);
    }

    protected void ensureCurrentLayout() {
        LayoutManager layoutManager;
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid() && (layoutManager = this.tabPane.getLayout()) instanceof BasicTabbedPaneUI.TabbedPaneLayout) {
            BasicTabbedPaneUI.TabbedPaneLayout tabbedPaneLayout = (BasicTabbedPaneUI.TabbedPaneLayout)layoutManager;
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    protected void tryCloseTabs(int n, SubstanceConstants.TabCloseKind tabCloseKind) {
        if (tabCloseKind == null) {
            return;
        }
        if (tabCloseKind == SubstanceConstants.TabCloseKind.NONE) {
            return;
        }
        if (tabCloseKind == SubstanceConstants.TabCloseKind.ALL_BUT_THIS) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                if (i == n) continue;
                hashSet.add(i);
            }
            this.tryCloseTabs(hashSet);
            return;
        }
        if (tabCloseKind == SubstanceConstants.TabCloseKind.ALL) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                hashSet.add(i);
            }
            this.tryCloseTabs(hashSet);
            return;
        }
        this.tryCloseTab(n);
    }

    protected void tryCloseTab(int n) {
        Component component = this.tabPane.getComponentAt(n);
        HashSet<Component> hashSet = new HashSet<Component>();
        hashSet.add(component);
        boolean bl = false;
        for (BaseTabCloseListener baseTabCloseListener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            BaseTabCloseListener baseTabCloseListener2;
            if (baseTabCloseListener instanceof VetoableTabCloseListener) {
                baseTabCloseListener2 = (VetoableTabCloseListener)baseTabCloseListener;
                boolean bl2 = bl = bl || baseTabCloseListener2.vetoTabClosing(this.tabPane, component);
            }
            if (!(baseTabCloseListener instanceof VetoableMultipleTabCloseListener)) continue;
            baseTabCloseListener2 = (VetoableMultipleTabCloseListener)baseTabCloseListener;
            bl = bl || baseTabCloseListener2.vetoTabsClosing(this.tabPane, hashSet);
        }
        if (bl) {
            return;
        }
        for (BaseTabCloseListener baseTabCloseListener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (baseTabCloseListener instanceof TabCloseListener) {
                ((TabCloseListener)baseTabCloseListener).tabClosing(this.tabPane, component);
            }
            if (!(baseTabCloseListener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)baseTabCloseListener).tabsClosing(this.tabPane, hashSet);
        }
        this.tabPane.remove(n);
        if (this.tabPane.getTabCount() > 0) {
            this.selectPreviousTab(0);
            this.selectNextTab(this.tabPane.getSelectedIndex());
        }
        this.tabPane.repaint();
        for (BaseTabCloseListener baseTabCloseListener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (baseTabCloseListener instanceof TabCloseListener) {
                ((TabCloseListener)baseTabCloseListener).tabClosed(this.tabPane, component);
            }
            if (!(baseTabCloseListener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)baseTabCloseListener).tabsClosed(this.tabPane, hashSet);
        }
    }

    protected void tryCloseTabs(Set<Integer> set) {
        HashSet<Component> hashSet = new HashSet<Component>();
        for (int n : set) {
            hashSet.add(this.tabPane.getComponentAt(n));
        }
        boolean bl = false;
        for (BaseTabCloseListener object : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (!(object instanceof VetoableMultipleTabCloseListener)) continue;
            VetoableMultipleTabCloseListener vetoableMultipleTabCloseListener = (VetoableMultipleTabCloseListener)object;
            bl = bl || vetoableMultipleTabCloseListener.vetoTabsClosing(this.tabPane, hashSet);
        }
        if (bl) {
            return;
        }
        for (BaseTabCloseListener baseTabCloseListener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (!(baseTabCloseListener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)baseTabCloseListener).tabsClosing(this.tabPane, hashSet);
        }
        for (Component component : hashSet) {
            this.tabPane.remove(component);
        }
        if (this.tabPane.getTabCount() > 0) {
            this.selectPreviousTab(0);
            this.selectNextTab(this.tabPane.getSelectedIndex());
        }
        this.tabPane.repaint();
        for (BaseTabCloseListener baseTabCloseListener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (!(baseTabCloseListener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)baseTabCloseListener).tabsClosed(this.tabPane, hashSet);
        }
    }

    @Override
    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        int n3 = 0;
        if (SubstanceCoreUtilities.hasCloseButton(this.tabPane, n2)) {
            n3 = this.tabPane.getComponentOrientation().isLeftToRight() ? 5 - SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, n2) : SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, n2) - 5;
        }
        return n3 + super.getTabLabelShiftX(n, n2, bl);
    }

    @Override
    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        int n3 = 0;
        n3 = n == 3 ? -1 : 1;
        return n3;
    }

    protected int getTabExtraWidth(int n, int n2) {
        int n3 = 0;
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(this.tabPane);
        n3 = substanceButtonShaper instanceof ClassicButtonShaper ? (int)(2.0 * (double)SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.tabPane))) : super.calculateTabHeight(n, n2, this.getFontMetrics().getHeight()) / 3;
        if (SubstanceCoreUtilities.hasCloseButton(this.tabPane, n2) && this.tabPane.isEnabledAt(n2)) {
            n3 += 4 + SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, n2);
        }
        return n3;
    }

    public int getRolloverTabIndex() {
        return this.getRolloverTab();
    }

    public void setTabAreaInsets(Insets insets) {
        Insets insets2 = this.tabAreaInsets;
        this.tabAreaInsets = insets;
        LafWidgetUtilities.firePropertyChangeEvent((JComponent)this.tabPane, (String)"tabAreaInsets", (Object)insets2, (Object)this.tabAreaInsets);
    }

    public Insets getTabAreaInsets() {
        return this.tabAreaInsets;
    }

    public Rectangle getTabRectangle(int n) {
        return this.rects[n];
    }

    public static String getMemoryUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SubstanceTabbedPaneUI: \n");
        stringBuffer.append("\t" + backgroundMap.size() + " backgrounds");
        return stringBuffer.toString();
    }

    @Override
    protected boolean shouldPadTabRun(int n, int n2) {
        return this.runCount > 1 && n2 < this.runCount - 1;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return super.createLayoutManager();
        }
        return new TabbedPaneLayout();
    }

    @Override
    protected Insets getContentBorderInsets(int n) {
        int n2;
        Insets insets = SubstanceSizeUtils.getTabbedPaneContentInsets(SubstanceSizeUtils.getComponentFontSize(this.tabPane));
        SubstanceConstants.TabContentPaneBorderKind tabContentPaneBorderKind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean bl = tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_FULL || tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean bl2 = tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.SINGLE_PLACEMENT || tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        int n3 = n2 = bl ? (int)(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane))) : 0;
        if (bl2) {
            switch (n) {
                case 1: {
                    return new Insets(insets.top + n2, 0, 0, 0);
                }
                case 2: {
                    return new Insets(0, insets.left + n2, 0, 0);
                }
                case 4: {
                    return new Insets(0, 0, 0, insets.right + n2);
                }
                case 3: {
                    return new Insets(0, 0, insets.bottom + n2, 0);
                }
            }
        } else {
            switch (n) {
                case 1: {
                    return new Insets(insets.top + n2, insets.left, insets.bottom, insets.right);
                }
                case 2: {
                    return new Insets(insets.top, insets.left + n2, insets.bottom, insets.right);
                }
                case 4: {
                    return new Insets(insets.top, insets.left, insets.bottom, insets.right + n2);
                }
                case 3: {
                    return new Insets(insets.top, insets.left, insets.bottom + n2, insets.right);
                }
            }
        }
        return insets;
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        Object object;
        int n3 = n2;
        if (n2 >= 0 && SubstanceLookAndFeelEx.getBooleanClientProperty((Component)(object = this.tabPane.getComponentAt(n2)), "substancelaf.unread")) {
            n3 = -1;
        }
        this.highlight = (object = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n3, ColorSchemeAssociationKind.TAB, ComponentState.ENABLED)).isDark() ? SubstanceColorUtilities.getAlphaColor(object.getUltraDarkColor(), 100) : object.getLightColor();
        super.paintContentBorder(graphics, n, n2);
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl;
        SubstanceConstants.TabContentPaneBorderKind tabContentPaneBorderKind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean bl2 = tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_FULL || tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean bl3 = bl = tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.SINGLE_PLACEMENT || tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        if (bl && n != 3) {
            return;
        }
        int n7 = (int)(2.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)));
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane));
        int n8 = 1;
        int n9 = 0;
        graphics2D.setStroke(new BasicStroke(f, n9, n8));
        int n10 = (int)((double)f / 2.0);
        boolean bl4 = n != 3 || n2 < 0 || rectangle.y - 1 > n6 || rectangle.x < n3 || rectangle.x > n3 + n5;
        n3 += n10;
        n4 += n10;
        n5 -= 2 * n10;
        n6 -= 2 * n10;
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n2, ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED);
        Color color = SubstanceColorUtilities.getMidBorderColor(substanceColorScheme);
        if (bl4) {
            graphics2D.setColor(this.highlight);
            graphics2D.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        } else {
            SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(this.tabPane);
            int n11 = substanceButtonShaper instanceof ClassicButtonShaper ? 1 : 0;
            int n12 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2.0);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(n3, n4 + n6 - 1);
            generalPath.lineTo(rectangle.x + n12, n4 + n6 - 1);
            int n13 = super.calculateTabHeight(n, 0, SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2;
            generalPath.lineTo(rectangle.x + n12, n4 + n6 + n13);
            if (rectangle.x + rectangle.width < n3 + n5 - 1) {
                int n14 = rectangle.x + rectangle.width - n11 - 1 - n12;
                generalPath.lineTo(n14, n4 + n6 - 1 + n13);
                generalPath.lineTo(n14, n4 + n6 - 1);
                generalPath.lineTo(n3 + n5 - 1, n4 + n6 - 1);
            }
            graphics2D.setPaint(new GradientPaint(n3, n4 + n6 - 1, color, n3, n4 + n6 - 1 + n13, SubstanceColorUtilities.getAlphaColor(color, 0)));
            graphics2D.draw(generalPath);
        }
        if (bl2) {
            if (n == 3) {
                graphics2D.setColor(this.highlight);
                graphics2D.setColor(color);
                graphics2D.drawLine(n3, n4 + n6 - 1 - n7, n3 + n5 - 1, n4 + n6 - 1 - n7);
            }
            if (n == 2) {
                graphics2D.setPaint(new GradientPaint(n3, n4 + n6 - 1, color, n3 + 4 * n7, n4 + n6 - 1, this.highlight));
                graphics2D.drawLine(n3, n4 + n6 - 1, n3 + 4 * n7, n4 + n6 - 1);
            }
            if (n == 4) {
                graphics2D.setPaint(new GradientPaint(n3 + n5 - 1 - 4 * n7, n4 + n6 - 1, this.highlight, n3 + n5 - 1, n4 + n6 - 1, color));
                graphics2D.drawLine(n3 + n5 - 1 - 4 * n7, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            }
        }
        graphics2D.dispose();
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl;
        SubstanceConstants.TabContentPaneBorderKind tabContentPaneBorderKind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean bl2 = tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_FULL || tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean bl3 = bl = tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.SINGLE_PLACEMENT || tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        if (bl && n != 2) {
            return;
        }
        int n7 = (int)(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)));
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane));
        int n8 = 1;
        int n9 = 0;
        graphics2D.setStroke(new BasicStroke(f, n9, n8));
        int n10 = (int)((double)f / 2.0);
        boolean bl4 = n != 2 || n2 < 0 || rectangle.x + rectangle.width + 1 < n3 || rectangle.y < n4 || rectangle.y > n4 + n6;
        n3 += n10;
        n4 += n10;
        n6 -= 2 * n10;
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n2, ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED);
        Color color = SubstanceColorUtilities.getMidBorderColor(substanceColorScheme);
        if (bl4) {
            graphics2D.setColor(this.highlight);
            graphics2D.drawLine(n3, n4, n3, n4 + n6);
        } else {
            SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(this.tabPane);
            int n11 = substanceButtonShaper instanceof ClassicButtonShaper ? 1 : 0;
            int n12 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2.0);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(n3, n4);
            generalPath.lineTo(n3, rectangle.y + n12);
            int n13 = super.calculateTabHeight(n, 0, SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2;
            generalPath.lineTo(n3 - n13, rectangle.y + n12);
            if (rectangle.y + rectangle.height < n4 + n6) {
                int n14 = rectangle.y + rectangle.height - n11 - 1 - n12;
                generalPath.lineTo(n3 - n13, n14);
                generalPath.lineTo(n3, n14);
                generalPath.lineTo(n3, n4 + n6);
            }
            graphics2D.setPaint(new GradientPaint(n3, n4, color, n3 - n13, n4, SubstanceColorUtilities.getAlphaColor(color, 0)));
            graphics2D.draw(generalPath);
        }
        if (bl2) {
            if (n == 2) {
                graphics2D.setColor(color);
                graphics2D.drawLine(n3 + n7, n4, n3 + n7, n4 + n6);
            }
            if (n == 1) {
                graphics2D.setPaint(new GradientPaint(n3, n4, color, n3, n4 + 4 * n7, this.highlight));
                graphics2D.drawLine(n3, n4, n3, n4 + 4 * n7);
            }
            if (n == 3) {
                graphics2D.setPaint(new GradientPaint(n3, n4 + n6 - 1 - 4 * n7, this.highlight, n3, n4 + n6 - 1, color));
                graphics2D.drawLine(n3, n4 + n6 - 1 - 4 * n7, n3, n4 + n6 - 1);
            }
        }
        graphics2D.dispose();
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl;
        SubstanceConstants.TabContentPaneBorderKind tabContentPaneBorderKind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean bl2 = tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_FULL || tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean bl3 = bl = tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.SINGLE_PLACEMENT || tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        if (bl && n != 4) {
            return;
        }
        int n7 = (int)(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)));
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane));
        int n8 = 1;
        int n9 = 0;
        graphics2D.setStroke(new BasicStroke(f, n9, n8));
        int n10 = (int)((double)f / 2.0);
        boolean bl4 = n != 4 || n2 < 0 || rectangle.x - 1 > n5 || rectangle.y < n4 || rectangle.y > n4 + n6;
        n3 += n10;
        n4 += n10;
        n5 -= 2 * n10;
        n6 -= 2 * n10;
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n2, ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED);
        Color color = SubstanceColorUtilities.getMidBorderColor(substanceColorScheme);
        if (bl4) {
            graphics2D.setColor(this.highlight);
            graphics2D.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6);
        } else {
            SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(this.tabPane);
            int n11 = substanceButtonShaper instanceof ClassicButtonShaper ? 1 : 0;
            int n12 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2.0);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(n3 + n5 - 1, n4);
            generalPath.lineTo(n3 + n5 - 1, rectangle.y + n12);
            int n13 = super.calculateTabHeight(n, 0, SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2;
            generalPath.lineTo(n3 + n5 - 1 + n13, rectangle.y + n12);
            if (rectangle.y + rectangle.height < n4 + n6) {
                int n14 = rectangle.y + rectangle.height - n11 - 1 - n12;
                generalPath.lineTo(n3 + n5 - 1 + n13, n14);
                generalPath.lineTo(n3 + n5 - 1, n14);
                generalPath.lineTo(n3 + n5 - 1, n4 + n6);
            }
            graphics2D.setPaint(new GradientPaint(n3 + n5 - 1, n4, color, n3 + n5 - 1 + n13, n4, SubstanceColorUtilities.getAlphaColor(color, 0)));
            graphics2D.draw(generalPath);
        }
        if (bl2) {
            if (n == 4) {
                graphics2D.setColor(this.highlight);
                graphics2D.setColor(color);
                graphics2D.drawLine(n3 + n5 - 1 - n7, n4, n3 + n5 - 1 - n7, n4 + n6);
            }
            if (n == 1) {
                graphics2D.setPaint(new GradientPaint(n3 + n5 - 1, n4, color, n3 + n5 - 1, n4 + 4 * n7, this.highlight));
                graphics2D.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + 4 * n7);
            }
            if (n == 3) {
                graphics2D.setPaint(new GradientPaint(n3 + n5 - 1, n4 + n6 - 1 - 4 * n7, this.highlight, n3 + n5 - 1, n4 + n6 - 1, color));
                graphics2D.drawLine(n3 + n5 - 1, n4 + n6 - 1 - 4 * n7, n3 + n5 - 1, n4 + n6 - 1);
            }
        }
        graphics2D.dispose();
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl;
        SubstanceConstants.TabContentPaneBorderKind tabContentPaneBorderKind = SubstanceCoreUtilities.getContentBorderKind(this.tabPane);
        boolean bl2 = tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_FULL || tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        boolean bl3 = bl = tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.SINGLE_PLACEMENT || tabContentPaneBorderKind == SubstanceConstants.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
        if (bl && n != 1) {
            return;
        }
        int n7 = (int)(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)));
        Rectangle rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane));
        int n8 = 1;
        int n9 = 0;
        graphics2D.setStroke(new BasicStroke(f, n9, n8));
        int n10 = (int)((double)f / 2.0);
        boolean bl4 = n != 1 || n2 < 0 || rectangle.y + rectangle.height + 1 < n4 || rectangle.x < n3 || rectangle.x > n3 + n5;
        n3 += n10;
        n4 += n10;
        n5 -= 2 * n10;
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n2, ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED);
        Color color = SubstanceColorUtilities.getMidBorderColor(substanceColorScheme);
        if (bl4) {
            graphics2D.setColor(this.highlight);
            graphics2D.drawLine(n3, n4, n3 + n5 - 1, n4);
        } else {
            SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(this.tabPane);
            int n11 = substanceButtonShaper instanceof ClassicButtonShaper ? 1 : 0;
            int n12 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2.0);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(n3, n4);
            generalPath.lineTo(rectangle.x + n12, n4);
            int n13 = super.calculateTabHeight(n, 0, SubstanceSizeUtils.getComponentFontSize(this.tabPane)) / 2;
            generalPath.lineTo(rectangle.x + n12, n4 - n13);
            if (rectangle.x + rectangle.width < n3 + n5 - 1) {
                int n14 = rectangle.x + rectangle.width - n11 - 1 - n12;
                generalPath.lineTo(n14, n4 - n13);
                generalPath.lineTo(n14, n4);
                generalPath.lineTo(n3 + n5 - 1, n4);
            }
            graphics2D.setPaint(new GradientPaint(n3, n4, color, n3, n4 - n13, SubstanceColorUtilities.getAlphaColor(color, 0)));
            graphics2D.draw(generalPath);
        }
        if (bl2) {
            if (n == 1) {
                graphics2D.setColor(color);
                graphics2D.drawLine(n3, n4 + n7, n3 + n5 - 1, n4 + n7);
                graphics2D.setColor(this.highlight);
            }
            if (n == 2) {
                graphics2D.setPaint(new GradientPaint(n3, n4, color, n3 + 4 * n7, n4, this.highlight));
                graphics2D.drawLine(n3, n4, n3 + 4 * n7, n4);
            }
            if (n == 4) {
                graphics2D.setPaint(new GradientPaint(n3 + n5 - 1 - 4 * n7, n4, this.highlight, n3 + n5 - 1, n4, color));
                graphics2D.drawLine(n3 + n5 - 1 - 4 * n7, n4, n3 + n5 - 1, n4);
            }
        }
        graphics2D.dispose();
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        this.ensureCurrentLayout();
        Rectangle rectangle = new Rectangle();
        return this.getTabBounds(n, rectangle);
    }

    protected StateTransitionTracker.ModelStateInfo getModelStateInfo(int n) {
        if (this.stateTransitionMultiTracker.size() == 0) {
            return null;
        }
        StateTransitionTracker stateTransitionTracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)n);
        if (stateTransitionTracker == null) {
            return null;
        }
        return stateTransitionTracker.getModelStateInfo();
    }

    protected ComponentState getTabState(int n) {
        boolean bl = this.tabPane.isEnabledAt(n);
        StateTransitionTracker stateTransitionTracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)n);
        if (stateTransitionTracker == null) {
            boolean bl2 = this.getRolloverTabIndex() == n;
            boolean bl3 = this.tabPane.getSelectedIndex() == n;
            return ComponentState.getState(bl, bl2, bl3);
        }
        ComponentState componentState = stateTransitionTracker.getModelStateInfo().getCurrModelState();
        return ComponentState.getState(bl, componentState.isFacetActive(ComponentStateFacet.ROLLOVER), componentState.isFacetActive(ComponentStateFacet.SELECTION));
    }

    @Override
    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            Object object;
            Object object2;
            int n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            StateTransitionTracker.ModelStateInfo modelStateInfo = this.getModelStateInfo(n2);
            ComponentState componentState = this.getTabState(n2);
            Color color = null;
            if (modelStateInfo != null) {
                object2 = modelStateInfo.getStateContributionMap();
                object = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n2, ColorSchemeAssociationKind.TAB, componentState);
                if (componentState.isDisabled() || object2 == null || object2.size() == 1) {
                    color = object.getForegroundColor();
                } else {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    for (Map.Entry entry : object2.entrySet()) {
                        ComponentState componentState2 = (ComponentState)entry.getKey();
                        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n2, ColorSchemeAssociationKind.TAB, componentState2);
                        Color color2 = substanceColorScheme.getForegroundColor();
                        float f4 = ((StateTransitionTracker.StateContributionInfo)entry.getValue()).getContribution();
                        f += (float)color2.getRed() * f4;
                        f2 += (float)color2.getGreen() * f4;
                        f3 += (float)color2.getBlue() * f4;
                    }
                    color = new Color((int)f, (int)f2, (int)f3);
                }
            } else {
                object2 = SubstanceColorSchemeUtilities.getColorScheme(this.tabPane, n2, ColorSchemeAssociationKind.TAB, componentState);
                color = object2.getForegroundColor();
            }
            object2 = (Graphics2D)graphics.create();
            if (componentState.isDisabled()) {
                object = SubstanceColorUtilities.getBackgroundFillColor(this.tabPane);
                color = SubstanceColorUtilities.getInterpolatedColor(color, (Color)object, SubstanceColorSchemeUtilities.getAlpha(this.tabPane.getComponentAt(n2), componentState));
            }
            ((Graphics2D)object2).clip(this.getTabRectangle(n2));
            SubstanceTextUtilities.paintText((Graphics)object2, this.tabPane, rectangle, string, n3, ((Graphics)object2).getFont(), color, null);
            ((Graphics)object2).dispose();
        }
    }

    @Override
    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        if (icon == null) {
            return;
        }
        if (SubstanceCoreUtilities.useThemedDefaultIcon(this.tabPane)) {
            ComponentState componentState = this.getTabState(n2);
            StateTransitionTracker stateTransitionTracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)n2);
            if (stateTransitionTracker == null && (componentState.isFacetActive(ComponentStateFacet.ROLLOVER) || componentState.isFacetActive(ComponentStateFacet.SELECTION) || componentState.isDisabled())) {
                super.paintIcon(graphics, n, n2, icon, rectangle, bl);
                return;
            }
            Icon icon2 = SubstanceCoreUtilities.getThemedIcon(this.tabPane, n2, icon);
            if (stateTransitionTracker == null) {
                super.paintIcon(graphics, n, n2, icon2, rectangle, bl);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                super.paintIcon(graphics2D, n, n2, icon, rectangle, bl);
                graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.tabPane, (float)(1.0f - stateTransitionTracker.getFacetStrength(ComponentStateFacet.ROLLOVER)), (Graphics)graphics2D));
                super.paintIcon(graphics2D, n, n2, icon2, rectangle, bl);
                graphics2D.dispose();
            }
        } else {
            super.paintIcon(graphics, n, n2, icon, rectangle, bl);
        }
    }

    @Override
    protected MouseListener createMouseListener() {
        return null;
    }

    protected boolean toRotateTabsOnPlacement(int n) {
        Object object = this.tabPane.getClientProperty("substancelaf.rotate");
        if (!(object instanceof Boolean)) {
            object = UIManager.get("substancelaf.rotate");
        }
        boolean bl = object instanceof Boolean ? (Boolean)object : true;
        return bl && (n == 2 || n == 4);
    }

    private StateTransitionTracker getTracker(final int n, boolean bl, boolean bl2) {
        StateTransitionTracker stateTransitionTracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)n);
        if (stateTransitionTracker == null) {
            DefaultButtonModel defaultButtonModel = new DefaultButtonModel();
            defaultButtonModel.setSelected(bl2);
            defaultButtonModel.setRollover(bl);
            stateTransitionTracker = new StateTransitionTracker(this.tabPane, defaultButtonModel);
            stateTransitionTracker.registerModelListeners();
            stateTransitionTracker.setRepaintCallback(new StateTransitionTracker.RepaintCallback(){

                @Override
                public TimelineCallback getRepaintCallback() {
                    return new TabRepaintCallback(SubstanceTabbedPaneUI.this.tabPane, n);
                }
            });
            this.stateTransitionMultiTracker.addTracker((Comparable<Integer>)n, stateTransitionTracker);
        }
        return stateTransitionTracker;
    }

    private void trackTabModification(int n, Component component) {
        Timeline timeline = new Timeline((Object)this.tabPane);
        AnimationConfigurationManager.getInstance().configureModifiedTimeline(timeline);
        timeline.addCallback((TimelineCallback)new TabRepaintCallback(this.tabPane, n));
        timeline.playLoop(Timeline.RepeatBehavior.REVERSE);
        this.modifiedTimelines.put(component, timeline);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        this.installDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    @Override
    protected void installListeners() {
        this.installListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        this.uninstallDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallComponents() {
        super.uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.uninstallListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected class MouseRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        int prevRolledOver = -1;
        boolean prevInCloseButton = false;
        int tabOfPressedCloseButton = -1;

        protected MouseRolloverHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            final int n = SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
            TabCloseCallback tabCloseCallback = SubstanceCoreUtilities.getTabCloseCallback(mouseEvent, SubstanceTabbedPaneUI.this.tabPane, n);
            if (tabCloseCallback == null) {
                return;
            }
            final SubstanceConstants.TabCloseKind tabCloseKind = tabCloseCallback.onAreaClick(SubstanceTabbedPaneUI.this.tabPane, n, mouseEvent);
            if (tabCloseKind == SubstanceConstants.TabCloseKind.NONE) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubstanceTabbedPaneUI.this.tryCloseTabs(n, tabCloseKind);
                }
            });
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.handleMouseMoveDrag(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            SubstanceTabbedPaneUI.this.setRolloverTab(SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY()));
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SubstanceTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int n = SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0 && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                Rectangle rectangle = new Rectangle();
                rectangle = SubstanceTabbedPaneUI.this.getTabBounds(n, rectangle);
                Rectangle rectangle2 = SubstanceTabbedPaneUI.this.getCloseButtonRectangleForEvents(n, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                boolean bl = rectangle2.contains(mouseEvent.getPoint());
                int n2 = this.tabOfPressedCloseButton = bl ? n : -1;
                if (n != SubstanceTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (bl) {
                        return;
                    }
                    SubstanceTabbedPaneUI.this.tabPane.setSelectedIndex(n);
                } else if (SubstanceTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                    SubstanceTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.handleMouseMoveDrag(mouseEvent);
        }

        private void handleMouseMoveDrag(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() != SubstanceTabbedPaneUI.this.tabPane) {
                return;
            }
            SubstanceTabbedPaneUI.this.setRolloverTab(SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY()));
            if (!AnimationConfigurationManager.getInstance().isAnimationAllowed(AnimationFacet.ROLLOVER, (Component)SubstanceTabbedPaneUI.this.tabPane)) {
                return;
            }
            SubstanceTabbedPaneUI.this.substanceMouseLocation = mouseEvent.getPoint();
            int n = SubstanceTabbedPaneUI.this.getRolloverTab();
            TabCloseCallback tabCloseCallback = SubstanceCoreUtilities.getTabCloseCallback(mouseEvent, SubstanceTabbedPaneUI.this.tabPane, n);
            if (n == this.prevRolledOver) {
                if (n >= 0) {
                    Object object;
                    Rectangle rectangle = new Rectangle();
                    rectangle = SubstanceTabbedPaneUI.this.getTabBounds(n, rectangle);
                    Rectangle rectangle2 = SubstanceTabbedPaneUI.this.getCloseButtonRectangleForEvents(n, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    boolean bl = rectangle2.contains(mouseEvent.getPoint());
                    if (this.prevInCloseButton == bl) {
                        return;
                    }
                    this.prevInCloseButton = bl;
                    if (tabCloseCallback != null) {
                        if (bl) {
                            object = tabCloseCallback.getCloseButtonTooltip(SubstanceTabbedPaneUI.this.tabPane, n);
                            SubstanceTabbedPaneUI.this.tabPane.setToolTipTextAt(n, (String)object);
                        } else {
                            object = tabCloseCallback.getAreaTooltip(SubstanceTabbedPaneUI.this.tabPane, n);
                            SubstanceTabbedPaneUI.this.tabPane.setToolTipTextAt(n, (String)object);
                        }
                    }
                    if (n >= 0 && n < SubstanceTabbedPaneUI.this.tabPane.getTabCount()) {
                        object = SubstanceTabbedPaneUI.this.getTracker(n, true, n == SubstanceTabbedPaneUI.this.currSelectedIndex);
                        ((StateTransitionTracker)object).getModel().setRollover(false);
                        ((StateTransitionTracker)object).endTransition();
                    }
                }
            } else {
                StateTransitionTracker stateTransitionTracker;
                if (this.prevRolledOver >= 0 && this.prevRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(this.prevRolledOver)) {
                    stateTransitionTracker = SubstanceTabbedPaneUI.this.getTracker(this.prevRolledOver, true, this.prevRolledOver == SubstanceTabbedPaneUI.this.currSelectedIndex);
                    stateTransitionTracker.getModel().setRollover(false);
                }
                if (n >= 0 && n < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                    stateTransitionTracker = SubstanceTabbedPaneUI.this.getTracker(n, false, n == SubstanceTabbedPaneUI.this.currSelectedIndex);
                    stateTransitionTracker.getModel().setRollover(true);
                }
            }
            this.prevRolledOver = n;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            SubstanceTabbedPaneUI.this.setRolloverTab(-1);
            if (this.prevRolledOver >= 0 && this.prevRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(this.prevRolledOver)) {
                StateTransitionTracker stateTransitionTracker = SubstanceTabbedPaneUI.this.getTracker(this.prevRolledOver, true, this.prevRolledOver == SubstanceTabbedPaneUI.this.currSelectedIndex);
                stateTransitionTracker.getModel().setRollover(false);
                if (SubstanceCoreUtilities.getTabCloseCallback(mouseEvent, SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver) != null) {
                    SubstanceTabbedPaneUI.this.tabPane.setToolTipTextAt(this.prevRolledOver, null);
                }
            }
            this.prevRolledOver = -1;
        }

        @Override
        public void mouseReleased(final MouseEvent mouseEvent) {
            final int n = SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
            if (SubstanceCoreUtilities.hasCloseButton(SubstanceTabbedPaneUI.this.tabPane, n) && n == this.tabOfPressedCloseButton) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (n >= 0 && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                            Rectangle rectangle = new Rectangle();
                            rectangle = SubstanceTabbedPaneUI.this.getTabBounds(n, rectangle);
                            Rectangle rectangle2 = SubstanceTabbedPaneUI.this.getCloseButtonRectangleForEvents(n, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            if (rectangle2.contains(mouseEvent.getPoint())) {
                                TabCloseCallback tabCloseCallback = SubstanceCoreUtilities.getTabCloseCallback(mouseEvent, SubstanceTabbedPaneUI.this.tabPane, n);
                                SubstanceConstants.TabCloseKind tabCloseKind = tabCloseCallback == null ? SubstanceConstants.TabCloseKind.THIS : tabCloseCallback.onCloseButtonClick(SubstanceTabbedPaneUI.this.tabPane, n, mouseEvent);
                                SubstanceTabbedPaneUI.this.tryCloseTabs(n, tabCloseKind);
                            }
                        }
                    }
                });
                this.tabOfPressedCloseButton = -1;
            }
        }
    }

    protected final class TabbedContainerListener
    extends ContainerAdapter {
        private Map<Component, List<PropertyChangeListener>> listeners = new HashMap<Component, List<PropertyChangeListener>>();

        protected void trackExistingTabs() {
            for (int i = 0; i < SubstanceTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                this.trackTab(SubstanceTabbedPaneUI.this.tabPane.getComponentAt(i));
            }
        }

        protected void trackTab(final Component component) {
            int n;
            if (component == null) {
                return;
            }
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("windowModified".equals(propertyChangeEvent.getPropertyName())) {
                        int n;
                        Object object = propertyChangeEvent.getOldValue();
                        Object object2 = propertyChangeEvent.getNewValue();
                        boolean bl = Boolean.TRUE.equals(object);
                        boolean bl2 = Boolean.TRUE.equals(object2);
                        if (bl) {
                            if (!bl2) {
                                Timeline timeline = SubstanceTabbedPaneUI.this.modifiedTimelines.get(component);
                                timeline.cancel();
                                SubstanceTabbedPaneUI.this.modifiedTimelines.remove(component);
                            }
                        } else if (bl2 && (n = SubstanceTabbedPaneUI.this.tabPane.indexOfComponent(component)) >= 0) {
                            SubstanceTabbedPaneUI.this.trackTabModification(n, component);
                        }
                    }
                }
            };
            component.addPropertyChangeListener(propertyChangeListener);
            List<PropertyChangeListener> list = this.listeners.get(component);
            if (list == null) {
                list = new LinkedList<PropertyChangeListener>();
            }
            list.add(propertyChangeListener);
            this.listeners.put(component, list);
            if (component instanceof JComponent && Boolean.TRUE.equals(((JComponent)component).getClientProperty("windowModified")) && (n = SubstanceTabbedPaneUI.this.tabPane.indexOfComponent(component)) >= 0) {
                SubstanceTabbedPaneUI.this.trackTabModification(n, component);
            }
        }

        protected void stopTrackTab(Component component) {
            if (component == null) {
                return;
            }
            List<PropertyChangeListener> list = this.listeners.get(component);
            if (list != null) {
                for (PropertyChangeListener propertyChangeListener : list) {
                    component.removePropertyChangeListener(propertyChangeListener);
                }
            }
            this.listeners.put(component, null);
        }

        protected void stopTrackExistingTabs() {
            for (int i = 0; i < SubstanceTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                this.stopTrackTab(SubstanceTabbedPaneUI.this.tabPane.getComponentAt(i));
            }
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            this.trackTab(component);
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component == null) {
                return;
            }
            if (component instanceof UIResource) {
                return;
            }
            for (PropertyChangeListener propertyChangeListener : this.listeners.get(component)) {
                component.removePropertyChangeListener(propertyChangeListener);
            }
            this.listeners.get(component).clear();
            this.listeners.remove(component);
            Timeline timeline = SubstanceTabbedPaneUI.this.modifiedTimelines.get(component);
            if (timeline != null) {
                timeline.cancel();
                SubstanceTabbedPaneUI.this.modifiedTimelines.remove(component);
            }
        }
    }

    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public TabbedPaneLayout() {
            super(SubstanceTabbedPaneUI.this);
        }

        @Override
        protected void normalizeTabRuns(int n, int n2, int n3, int n4) {
            if (n == 1 || n == 3) {
                super.normalizeTabRuns(n, n2, n3, n4);
            }
        }

        @Override
        protected void rotateTabRuns(int n, int n2) {
        }

        @Override
        protected void padSelectedTab(int n, int n2) {
        }
    }

    protected class TabRepaintCallback
    extends UIThreadTimelineCallbackAdapter {
        protected JTabbedPane tabbedPane;
        protected int tabIndex;

        public TabRepaintCallback(JTabbedPane jTabbedPane, int n) {
            this.tabbedPane = jTabbedPane;
            this.tabIndex = n;
        }

        public void onTimelinePulse(float f, float f2) {
            this.repaintTab();
        }

        public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
            this.repaintTab();
        }

        protected void repaintTab() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubstanceTabbedPaneUI.this.tabPane == null) {
                        return;
                    }
                    SubstanceTabbedPaneUI.this.ensureCurrentLayout();
                    int n = SubstanceTabbedPaneUI.this.tabPane.getTabCount();
                    if (n > 0 && TabRepaintCallback.this.tabIndex < n && TabRepaintCallback.this.tabIndex < SubstanceTabbedPaneUI.this.rects.length) {
                        Rectangle rectangle = SubstanceTabbedPaneUI.this.getTabBounds(SubstanceTabbedPaneUI.this.tabPane, TabRepaintCallback.this.tabIndex);
                        SubstanceTabbedPaneUI.this.tabPane.repaint(rectangle);
                    }
                }
            });
        }
    }
}

