/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableHeaderCellRenderer;
import org.pushingpixels.substance.internal.animation.StateTransitionMultiTracker;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.painter.HighlightPainterUtils;
import org.pushingpixels.substance.internal.ui.SubstanceTableUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;

public class SubstanceTableHeaderUI
extends BasicTableHeaderUI {
    protected TableHeaderListener substanceHeaderListener;
    protected TableCellRenderer defaultHeaderRenderer;
    protected Map<Integer, Object> selectedIndices;
    protected ListSelectionListener substanceFadeSelectionListener;
    private StateTransitionMultiTracker<Integer> stateTransitionMultiTracker = new StateTransitionMultiTracker();
    protected PropertyChangeListener substancePropertyChangeListener;
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceTableHeaderUI();
    }

    public SubstanceTableHeaderUI() {
        this.selectedIndices = new HashMap<Integer, Object>();
    }

    private void installListenersInternal() {
        ListSelectionModel listSelectionModel;
        super.installListeners();
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        if (tableColumnModel != null && (listSelectionModel = tableColumnModel.getSelectionModel()) != null) {
            this.substanceHeaderListener = new TableHeaderListener(this);
            listSelectionModel.addListSelectionListener(this.substanceHeaderListener);
        }
        this.substanceFadeSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SubstanceTableHeaderUI.this.header == null) {
                    return;
                }
                if (!SubstanceTableHeaderUI.this.header.getColumnModel().getColumnSelectionAllowed()) {
                    return;
                }
                JTable jTable = SubstanceTableHeaderUI.this.header.getTable();
                if (jTable == null) {
                    return;
                }
                TableUI tableUI = jTable.getUI();
                if (!(tableUI instanceof SubstanceTableUI)) {
                    SubstanceTableHeaderUI.this.stateTransitionMultiTracker.clear();
                    return;
                }
                SubstanceTableUI substanceTableUI = (SubstanceTableUI)tableUI;
                if (!substanceTableUI._hasSelectionAnimations()) {
                    SubstanceTableHeaderUI.this.stateTransitionMultiTracker.clear();
                    return;
                }
                HashSet<StateTransitionTracker> hashSet = new HashSet<StateTransitionTracker>();
                boolean bl = false;
                TableColumnModel tableColumnModel = SubstanceTableHeaderUI.this.header.getColumnModel();
                int n = tableColumnModel.getColumnCount();
                ListSelectionModel listSelectionModel = tableColumnModel.getSelectionModel();
                for (int i = listSelectionEvent.getFirstIndex(); i <= listSelectionEvent.getLastIndex(); ++i) {
                    StateTransitionTracker stateTransitionTracker;
                    if (i >= n) continue;
                    if (listSelectionModel.isSelectedIndex(i)) {
                        if (SubstanceTableHeaderUI.this.selectedIndices.containsKey(i)) continue;
                        if (!bl) {
                            stateTransitionTracker = SubstanceTableHeaderUI.this.getTracker(i, SubstanceTableHeaderUI.this.getColumnState(i).isFacetActive(ComponentStateFacet.ROLLOVER), false);
                            stateTransitionTracker.getModel().setSelected(true);
                            hashSet.add(stateTransitionTracker);
                            if (hashSet.size() > 15) {
                                SubstanceTableHeaderUI.this.stateTransitionMultiTracker.clear();
                                hashSet.clear();
                                bl = true;
                            }
                        }
                        SubstanceTableHeaderUI.this.selectedIndices.put(i, tableColumnModel.getColumn(i));
                        continue;
                    }
                    if (!SubstanceTableHeaderUI.this.selectedIndices.containsKey(i)) continue;
                    if (SubstanceTableHeaderUI.this.selectedIndices.get(i) == tableColumnModel.getColumn(i) && !bl) {
                        stateTransitionTracker = SubstanceTableHeaderUI.this.getTracker(i, SubstanceTableHeaderUI.this.getColumnState(i).isFacetActive(ComponentStateFacet.ROLLOVER), true);
                        stateTransitionTracker.getModel().setSelected(false);
                        hashSet.add(stateTransitionTracker);
                        if (hashSet.size() > 15) {
                            SubstanceTableHeaderUI.this.stateTransitionMultiTracker.clear();
                            hashSet.clear();
                            bl = true;
                        }
                    }
                    SubstanceTableHeaderUI.this.selectedIndices.remove(i);
                }
            }
        };
        if (tableColumnModel != null && (listSelectionModel = tableColumnModel.getSelectionModel()) != null) {
            listSelectionModel.addListSelectionListener(this.substanceFadeSelectionListener);
        }
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("table".equals(propertyChangeEvent.getPropertyName())) {
                    TableColumnModel tableColumnModel = propertyChangeEvent.getOldValue() instanceof JTable ? ((JTable)propertyChangeEvent.getOldValue()).getColumnModel() : null;
                    TableColumnModel tableColumnModel2 = propertyChangeEvent.getNewValue() instanceof JTable ? ((JTable)propertyChangeEvent.getNewValue()).getColumnModel() : null;
                    SubstanceTableHeaderUI.this.processColumnModelChangeEvent(tableColumnModel, tableColumnModel2);
                }
            }
        };
        this.header.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    private void installDefaultsInternal() {
        super.installDefaults();
        this.defaultHeaderRenderer = this.header.getDefaultRenderer();
        if (this.defaultHeaderRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new SubstanceDefaultTableHeaderCellRenderer());
        }
        for (int i = 0; i < this.header.getColumnModel().getColumnCount(); ++i) {
            if (!this.header.getColumnModel().getSelectionModel().isSelectedIndex(i)) continue;
            this.selectedIndices.put(i, this.header.getColumnModel().getColumn(i));
        }
    }

    private void uninstallListenersInternal() {
        ListSelectionModel listSelectionModel;
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        if (tableColumnModel != null && (listSelectionModel = tableColumnModel.getSelectionModel()) != null) {
            listSelectionModel.removeListSelectionListener(this.substanceHeaderListener);
            this.substanceHeaderListener = null;
        }
        this.header.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    private void uninstallDefaultsInternal() {
        super.uninstallDefaults();
        this.selectedIndices.clear();
        if (this.header.getDefaultRenderer() instanceof SubstanceDefaultTableHeaderCellRenderer) {
            this.header.setDefaultRenderer(this.defaultHeaderRenderer);
            if (this.defaultHeaderRenderer instanceof Component) {
                SwingUtilities.updateComponentTreeUI((Component)((Object)this.defaultHeaderRenderer));
            }
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean bl = this.header.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int[] nArray = tableColumnModel.getSelectedColumns();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n2 : nArray) {
            hashSet.add(n2);
        }
        int n3 = this.header.columnAtPoint(bl ? point : point2);
        int n4 = this.header.columnAtPoint(bl ? point2 : point);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = tableColumnModel.getColumnCount() - 1;
        }
        TableColumn tableColumn = this.header.getDraggedColumn();
        Rectangle rectangle2 = this.header.getHeaderRect(bl ? n3 : n4);
        if (bl) {
            for (n = n3; n <= n4; ++n) {
                TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                rectangle2.width = n2 = tableColumn2.getWidth();
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n, hashSet.contains(n));
                }
                rectangle2.x += n2;
            }
        } else {
            for (n = n4; n >= n3; --n) {
                TableColumn tableColumn3 = tableColumnModel.getColumn(n);
                rectangle2.width = n2 = tableColumn3.getWidth();
                if (tableColumn3 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n, hashSet.contains(n));
                }
                rectangle2.x += n2;
            }
        }
        this.paintGrid(graphics, jComponent);
        if (tableColumn != null) {
            n = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle3 = this.header.getHeaderRect(n);
            graphics.setColor(this.header.getParent().getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle3.x += this.header.getDraggedDistance();
            graphics.setColor(this.header.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            this.paintCell(graphics, rectangle3, n, hashSet.contains(n));
        }
        this.rendererPane.removeAll();
    }

    private Component getHeaderRenderer(int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
    }

    protected void paintGrid(Graphics graphics, JComponent jComponent) {
        boolean bl = this.header.getComponentOrientation().isLeftToRight();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        int n = (int)Math.ceil(SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jComponent)));
        point = new Point(point.x - 2 * n, point.y);
        Point point2 = new Point(rectangle.x + rectangle.width + 2 * n, rectangle.y);
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n2 = this.header.columnAtPoint(bl ? point : point2);
        int n3 = this.header.columnAtPoint(bl ? point2 : point);
        if (n2 == -1) {
            n2 = 0;
        }
        Rectangle rectangle2 = this.header.getHeaderRect(n2);
        int n4 = rectangle2.y + rectangle2.height;
        Color color = SubstanceTableHeaderUI.getGridColor(this.header);
        float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.header));
        graphics2D.setStroke(new BasicStroke(f, 1, 2));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.header, (float)0.7f, (Graphics)graphics));
        graphics2D.drawLine((int)point.getX(), (int)((float)n4 - f / 2.0f), (int)point2.getX(), (int)((float)n4 - f / 2.0f));
        if (n3 == -1) {
            n3 = tableColumnModel.getColumnCount() - 1;
        }
        TableColumn tableColumn = this.header.getDraggedColumn();
        Rectangle rectangle3 = this.header.getHeaderRect(bl ? n2 : n3);
        if (bl) {
            for (int i = n2; i <= n3; ++i) {
                int n5;
                TableColumn tableColumn2 = tableColumnModel.getColumn(i);
                rectangle3.width = n5 = tableColumn2.getWidth();
                if (tableColumn2 != tableColumn) {
                    if (this.hasLeadingVerticalGridLine(this.header, rectangle3, i)) {
                        graphics2D.drawLine(rectangle3.x, rectangle3.y, rectangle3.x, n4);
                    }
                    if (this.hasTrailingVerticalGridLine(this.header, rectangle3, i)) {
                        graphics2D.drawLine(rectangle3.x + rectangle3.width - 1, rectangle3.y, rectangle3.x + rectangle3.width - 1, n4);
                    }
                }
                rectangle3.x += n5;
            }
        } else {
            for (int i = n3; i >= n2; --i) {
                int n6;
                TableColumn tableColumn3 = tableColumnModel.getColumn(i);
                rectangle3.width = n6 = tableColumn3.getWidth();
                if (tableColumn3 != tableColumn) {
                    if (this.hasLeadingVerticalGridLine(this.header, rectangle3, i)) {
                        graphics2D.drawLine(rectangle3.x + rectangle3.width - 1, rectangle3.y, rectangle3.x + rectangle3.width - 1, n4);
                    }
                    if (this.hasTrailingVerticalGridLine(this.header, rectangle3, i)) {
                        graphics2D.drawLine(rectangle3.x, rectangle3.y, rectangle3.x, n4);
                    }
                }
                rectangle3.x += n6;
            }
        }
        graphics2D.dispose();
    }

    private boolean hasTrailingVerticalGridLine(JTableHeader jTableHeader, Rectangle rectangle, int n) {
        boolean bl;
        boolean bl2 = bl = n != jTableHeader.getColumnModel().getColumnCount() - 1;
        if (!bl) {
            Container container = this.header.getParent();
            bl = jTableHeader.getComponentOrientation().isLeftToRight() ? container != null && container.getWidth() > rectangle.x + rectangle.width : container != null && rectangle.x > 0;
        }
        return bl;
    }

    private boolean hasLeadingVerticalGridLine(JTableHeader jTableHeader, Rectangle rectangle, int n) {
        Container container;
        if (n != 0) {
            return false;
        }
        Container container2 = jTableHeader.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            return ((JScrollPane)container).getRowHeader() != null;
        }
        return false;
    }

    protected static Color getGridColor(JTableHeader jTableHeader) {
        boolean bl = jTableHeader.isEnabled();
        if (jTableHeader.getTable() != null) {
            bl = bl && jTableHeader.getTable().isEnabled();
        }
        ComponentState componentState = bl ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        Color color = SubstanceColorSchemeUtilities.getColorScheme(jTableHeader, ColorSchemeAssociationKind.BORDER, componentState).getLineColor();
        return color;
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n, boolean bl) {
        Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry2;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.header, (Graphics)graphics));
        Component component = this.getHeaderRenderer(n);
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.getModelStateInfo(n);
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo == null ? null : modelStateInfo.getStateContributionMap();
        ComponentState componentState = modelStateInfo == null ? this.getColumnState(n) : modelStateInfo.getCurrModelState();
        boolean bl2 = false;
        if (map != null) {
            Iterator<Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo>> iterator = map.entrySet().iterator();
            while (iterator.hasNext() && !(bl2 = SubstanceColorSchemeUtilities.getHighlightAlpha(this.header, (entry2 = iterator.next()).getKey()) * entry2.getValue().getContribution() > 0.0f)) {
            }
        } else {
            boolean bl3 = bl2 = SubstanceColorSchemeUtilities.getHighlightAlpha(this.header, componentState) > 0.0f;
        }
        if (bl2) {
            if (map == null) {
                float f = SubstanceColorSchemeUtilities.getHighlightAlpha(this.header, componentState);
                if (f > 0.0f) {
                    entry2 = SubstanceColorSchemeUtilities.getColorScheme(this.header, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
                    SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.header, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.header, (float)f, (Graphics)graphics));
                    HighlightPainterUtils.paintHighlight(graphics2D, this.rendererPane, this.rendererPane, rectangle, 0.8f, null, (SubstanceColorScheme)((Object)entry2), substanceColorScheme);
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.header, (Graphics)graphics));
                }
            } else {
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry2 : map.entrySet()) {
                    ComponentState componentState2 = entry2.getKey();
                    float f = SubstanceColorSchemeUtilities.getHighlightAlpha(this.header, componentState2) * ((StateTransitionTracker.StateContributionInfo)entry2.getValue()).getContribution();
                    if (f == 0.0f) continue;
                    SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.header, ColorSchemeAssociationKind.HIGHLIGHT, componentState2);
                    SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.header, ColorSchemeAssociationKind.HIGHLIGHT, componentState2);
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.header, (float)f, (Graphics)graphics));
                    HighlightPainterUtils.paintHighlight(graphics2D, this.rendererPane, this.rendererPane, rectangle, 0.8f, null, substanceColorScheme, substanceColorScheme2);
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.header, (Graphics)graphics));
                }
            }
        }
        this.rendererPane.paintComponent(graphics2D, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        graphics2D.dispose();
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.updateInternal(graphics2D, jComponent);
        graphics2D.dispose();
    }

    private void updateInternal(Graphics graphics, JComponent jComponent) {
        boolean bl = this.header.isEnabled();
        if (this.header.getTable() != null) {
            bl = bl && this.header.getTable().isEnabled();
        }
        ComponentState componentState = bl ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            rectangle = jComponent.getBounds();
        }
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jComponent, componentState);
        SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(jComponent, ColorSchemeAssociationKind.BORDER, componentState);
        HighlightPainterUtils.paintHighlight(graphics, null, jComponent, rectangle, 0.0f, null, substanceColorScheme, substanceColorScheme2);
        this.paint(graphics, jComponent);
    }

    private void uninstallUIInternal(JComponent jComponent) {
        for (int i = 0; i < this.header.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.header.getColumnModel().getColumn(i);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.header.getDefaultRenderer();
            }
            Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, i);
            SwingUtilities.updateComponentTreeUI(component);
        }
        super.uninstallUI(jComponent);
    }

    public ComponentState getColumnState(int n) {
        StateTransitionTracker stateTransitionTracker;
        boolean bl = this.header.isEnabled();
        JTable jTable = this.header.getTable();
        if (jTable != null) {
            boolean bl2 = bl = bl && jTable.isEnabled();
        }
        if ((stateTransitionTracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)n)) == null) {
            boolean bl3 = false;
            TableColumnModel tableColumnModel = this.header.getColumnModel();
            boolean bl4 = false;
            if (tableColumnModel.getColumnSelectionAllowed()) {
                bl4 = tableColumnModel.getSelectionModel().isSelectedIndex(n);
                if (jTable != null && jTable.getUI() instanceof SubstanceTableUI) {
                    SubstanceTableUI substanceTableUI = (SubstanceTableUI)jTable.getUI();
                    int n2 = substanceTableUI.getRolloverColumnIndex();
                    bl3 = n2 >= 0 && n2 == n;
                    boolean bl5 = substanceTableUI.hasSelectionAnimations();
                    if (bl5 && AnimationConfigurationManager.getInstance().isAnimationAllowed(AnimationFacet.SELECTION, (Component)jTable)) {
                        bl4 = this.selectedIndices.containsKey(n);
                    }
                }
            }
            return ComponentState.getState(bl, bl3, bl4);
        }
        ComponentState componentState = stateTransitionTracker.getModelStateInfo().getCurrModelState();
        return ComponentState.getState(bl, componentState.isFacetActive(ComponentStateFacet.ROLLOVER), componentState.isFacetActive(ComponentStateFacet.SELECTION));
    }

    public StateTransitionTracker.ModelStateInfo getModelStateInfo(int n) {
        if (this.stateTransitionMultiTracker.size() == 0) {
            return null;
        }
        StateTransitionTracker stateTransitionTracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)n);
        if (stateTransitionTracker == null) {
            return null;
        }
        return stateTransitionTracker.getModelStateInfo();
    }

    public StateTransitionTracker getStateTransitionTracker(int n) {
        return this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)n);
    }

    public JComponent getScrollPaneCornerFiller() {
        return new ScrollPaneCornerFiller(this.header);
    }

    public void processColumnModelChangeEvent(TableColumnModel tableColumnModel, TableColumnModel tableColumnModel2) {
        if (tableColumnModel != null) {
            tableColumnModel.getSelectionModel().removeListSelectionListener(this.substanceFadeSelectionListener);
        }
        if (tableColumnModel2 != null) {
            tableColumnModel2.getSelectionModel().addListSelectionListener(this.substanceFadeSelectionListener);
        }
        this.selectedIndices.clear();
        this.stateTransitionMultiTracker.clear();
    }

    public StateTransitionTracker getTracker(final int n, boolean bl, boolean bl2) {
        StateTransitionTracker stateTransitionTracker = this.stateTransitionMultiTracker.getTracker((Comparable<Integer>)n);
        if (stateTransitionTracker == null) {
            DefaultButtonModel defaultButtonModel = new DefaultButtonModel();
            defaultButtonModel.setSelected(bl2);
            defaultButtonModel.setRollover(bl);
            stateTransitionTracker = new StateTransitionTracker(this.header, defaultButtonModel);
            stateTransitionTracker.registerModelListeners();
            stateTransitionTracker.setRepaintCallback(new StateTransitionTracker.RepaintCallback(){

                @Override
                public TimelineCallback getRepaintCallback() {
                    return new ColumnHeaderRepaintCallback(SubstanceTableHeaderUI.this.header, n);
                }
            });
            this.stateTransitionMultiTracker.addTracker((Comparable<Integer>)n, stateTransitionTracker);
        }
        return stateTransitionTracker;
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        this.installDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners() {
        this.installListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallUIInternal(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        this.uninstallDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.uninstallListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    private static class TableHeaderListener
    implements ListSelectionListener {
        private SubstanceTableHeaderUI ui;

        public TableHeaderListener(SubstanceTableHeaderUI substanceTableHeaderUI) {
            this.ui = substanceTableHeaderUI;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.ui.header == null) {
                return;
            }
            if (this.ui.header.isValid()) {
                this.ui.header.repaint();
            }
        }
    }

    protected static class ScrollPaneCornerFiller
    extends JComponent
    implements UIResource {
        protected JTableHeader header;

        public ScrollPaneCornerFiller(JTableHeader jTableHeader) {
            this.header = jTableHeader;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            boolean bl = this.header.getComponentOrientation().isLeftToRight();
            ComponentState componentState = this.header.isEnabled() && this.header.getTable().isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.header, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
            SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.header, ColorSchemeAssociationKind.HIGHLIGHT_BORDER, componentState);
            HighlightPainterUtils.paintHighlight(graphics2D, null, this.header, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0.0f, null, substanceColorScheme, substanceColorScheme2);
            graphics2D.setColor(SubstanceTableHeaderUI.getGridColor(this.header));
            float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.header));
            graphics2D.setStroke(new BasicStroke(f, 1, 2));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.header, (float)0.7f, (Graphics)graphics));
            int n = bl ? (int)f / 2 : this.getWidth() - 1 - (int)f / 2;
            graphics2D.drawLine(n, 0, n, this.getHeight());
            graphics2D.dispose();
        }
    }

    protected class ColumnHeaderRepaintCallback
    extends UIThreadTimelineCallbackAdapter {
        protected JTableHeader header;
        protected int columnIndex;

        public ColumnHeaderRepaintCallback(JTableHeader jTableHeader, int n) {
            this.header = jTableHeader;
            this.columnIndex = n;
        }

        public void onTimelinePulse(float f, float f2) {
            this.repaintColumnHeader();
        }

        public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
            this.repaintColumnHeader();
        }

        private void repaintColumnHeader() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ColumnHeaderRepaintCallback.this.header == null) {
                        return;
                    }
                    try {
                        int n = ColumnHeaderRepaintCallback.this.header.getColumnModel().getColumnCount();
                        if (n > 0 && ColumnHeaderRepaintCallback.this.columnIndex < n) {
                            Rectangle rectangle = ColumnHeaderRepaintCallback.this.header.getHeaderRect(ColumnHeaderRepaintCallback.this.columnIndex);
                            Rectangle rectangle2 = new Rectangle(rectangle.x - 5, rectangle.y, rectangle.width + 10, rectangle.height);
                            ColumnHeaderRepaintCallback.this.header.repaint(rectangle2);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        return;
                    }
                }
            });
        }
    }
}

