/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;
import org.pushingpixels.substance.internal.animation.StateTransitionMultiTracker;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.HighlightPainterUtils;
import org.pushingpixels.substance.internal.ui.SubstanceTableHeaderUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorResource;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceStripingUtils;
import org.pushingpixels.substance.internal.utils.UpdateOptimizationAware;
import org.pushingpixels.substance.internal.utils.UpdateOptimizationInfo;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;

public class SubstanceTableUI
extends BasicTableUI
implements UpdateOptimizationAware {
    protected Map<TableCellId, Object> selectedIndices = new HashMap<TableCellId, Object>();
    protected Set<TableCellId> rolledOverIndices = new HashSet<TableCellId>();
    protected TableCellId focusedCellId;
    protected int rolledOverColumn = -1;
    protected Map<Class<?>, TableCellRenderer> defaultRenderers;
    protected Map<Class<?>, TableCellEditor> defaultEditors;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected TableStateListener substanceTableStateListener;
    protected RolloverFadeListener substanceFadeRolloverListener;
    protected FocusListener substanceFocusListener;
    private StateTransitionMultiTracker<TableCellId> stateTransitionMultiTracker = new StateTransitionMultiTracker();
    protected Boolean drawLeadingVerticalLine;
    protected Boolean drawTrailingVerticalLine;
    private Insets cellRendererInsets;
    TableCellId cellId = new TableCellId(-1, -1);
    private TableUpdateOptimizationInfo updateInfo;
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceTableUI();
    }

    private void updateRowHeight() {
        Insets insets = SubstanceSizeUtils.getTableCellRendererInsets(SubstanceSizeUtils.getComponentFontSize(this.table));
        JLabel jLabel = new JLabel("dummy");
        jLabel.setFont(this.table.getFont());
        int n = jLabel.getPreferredSize().height + insets.bottom + insets.top;
        this.table.setRowHeight(n);
    }

    private void installDefaultsInternal() {
        int n;
        Class[] classArray;
        super.installDefaults();
        if (SubstanceCoreUtilities.toDrawWatermark(this.table)) {
            this.table.setOpaque(false);
        }
        this.defaultRenderers = new HashMap();
        Class[] classArray2 = classArray = new Class[]{Object.class, Icon.class, ImageIcon.class, Number.class, Float.class, Double.class, Date.class, Boolean.class};
        int n2 = classArray2.length;
        for (n = 0; n < n2; ++n) {
            Class clazz = classArray2[n];
            this.defaultRenderers.put(clazz, this.table.getDefaultRenderer(clazz));
        }
        this.installRendererIfNecessary(Object.class, new SubstanceDefaultTableCellRenderer());
        this.installRendererIfNecessary(Icon.class, new SubstanceDefaultTableCellRenderer.IconRenderer());
        this.installRendererIfNecessary(ImageIcon.class, new SubstanceDefaultTableCellRenderer.IconRenderer());
        this.installRendererIfNecessary(Number.class, new SubstanceDefaultTableCellRenderer.NumberRenderer());
        this.installRendererIfNecessary(Float.class, new SubstanceDefaultTableCellRenderer.DoubleRenderer());
        this.installRendererIfNecessary(Double.class, new SubstanceDefaultTableCellRenderer.DoubleRenderer());
        this.installRendererIfNecessary(Date.class, new SubstanceDefaultTableCellRenderer.DateRenderer());
        this.installRendererIfNecessary(Boolean.class, new SubstanceDefaultTableCellRenderer.BooleanRenderer());
        this.defaultEditors = new HashMap();
        for (Class clazz : classArray2 = new Class[]{Boolean.class}) {
            this.defaultEditors.put(clazz, this.table.getDefaultEditor(clazz));
        }
        this.installEditorIfNecessary(Boolean.class, new BooleanEditor());
        int n3 = this.table.getRowCount();
        n = this.table.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!this.table.isCellSelected(i, j)) continue;
                TableCellId tableCellId = new TableCellId(i, j);
                this.selectedIndices.put(tableCellId, this.table.getValueAt(i, j));
            }
        }
        this.updateRowHeight();
        this.updateCellRendererInsets();
        this.drawLeadingVerticalLine = (Boolean)this.table.getClientProperty("substancelaf.tableLeadingVerticalLine");
        this.drawTrailingVerticalLine = (Boolean)this.table.getClientProperty("substancelaf.tableTrailingVerticalLine");
    }

    private void updateCellRendererInsets() {
        this.cellRendererInsets = SubstanceSizeUtils.getTableCellRendererInsets(SubstanceSizeUtils.getComponentFontSize(this.table));
    }

    protected void installRendererIfNecessary(Class<?> clazz, TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.table.getDefaultRenderer(clazz);
        if (tableCellRenderer2 != null) {
            boolean bl;
            boolean bl2 = bl = tableCellRenderer2 instanceof DefaultTableCellRenderer.UIResource || tableCellRenderer2.getClass().getName().startsWith("javax.swing.JTable");
            if (!bl) {
                return;
            }
        }
        this.table.setDefaultRenderer(clazz, tableCellRenderer);
    }

    protected void installEditorIfNecessary(Class<?> clazz, TableCellEditor tableCellEditor) {
        boolean bl;
        TableCellEditor tableCellEditor2 = this.table.getDefaultEditor(clazz);
        if (tableCellEditor2 != null && !(bl = tableCellEditor2.getClass().getName().startsWith("javax.swing.JTable"))) {
            return;
        }
        this.table.setDefaultEditor(clazz, tableCellEditor);
    }

    private void uninstallDefaultsInternal() {
        for (Map.Entry<Class<?>, TableCellRenderer> entry : this.defaultRenderers.entrySet()) {
            this.uninstallRendererIfNecessary(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Class<?>, Object> entry : this.defaultEditors.entrySet()) {
            this.uninstallEditorIfNecessary(entry.getKey(), (TableCellEditor)entry.getValue());
        }
        this.selectedIndices.clear();
        super.uninstallDefaults();
    }

    protected void uninstallRendererIfNecessary(Class<?> clazz, TableCellRenderer tableCellRenderer) {
        boolean bl;
        TableCellRenderer tableCellRenderer2 = this.table.getDefaultRenderer(clazz);
        if (tableCellRenderer2 != null && !(bl = this.isSubstanceDefaultRenderer(tableCellRenderer2))) {
            return;
        }
        if (tableCellRenderer instanceof Component) {
            SwingUtilities.updateComponentTreeUI((Component)((Object)tableCellRenderer));
        }
        this.table.setDefaultRenderer(clazz, tableCellRenderer);
    }

    protected void uninstallEditorIfNecessary(Class<?> clazz, TableCellEditor tableCellEditor) {
        boolean bl;
        TableCellEditor tableCellEditor2 = this.table.getDefaultEditor(clazz);
        if (tableCellEditor2 != null && !(bl = this.isSubstanceDefaultEditor(tableCellEditor2))) {
            return;
        }
        if (tableCellEditor instanceof Component) {
            SwingUtilities.updateComponentTreeUI((Component)((Object)tableCellEditor));
        }
        this.table.setDefaultEditor(clazz, tableCellEditor);
    }

    private void installListenersInternal() {
        super.installListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                Object object2;
                Object object3;
                if ("substancelaf.watermark.visible".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceTableUI.this.table.setOpaque(!SubstanceCoreUtilities.toDrawWatermark(SubstanceTableUI.this.table));
                }
                if ("columnSelectionAllowed".equals(propertyChangeEvent.getPropertyName()) || "rowSelectionAllowed".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceTableUI.this.syncSelection(true);
                }
                if ("model".equals(propertyChangeEvent.getPropertyName())) {
                    object3 = (TableModel)propertyChangeEvent.getOldValue();
                    if (object3 != null) {
                        object3.removeTableModelListener(SubstanceTableUI.this.substanceTableStateListener);
                    }
                    SubstanceTableUI.this.table.getModel().addTableModelListener(SubstanceTableUI.this.substanceTableStateListener);
                    SubstanceTableUI.this.selectedIndices.clear();
                    SubstanceTableUI.this.stateTransitionMultiTracker.clear();
                    SubstanceTableUI.this.syncSelection(true);
                }
                if ("columnModel".equals(propertyChangeEvent.getPropertyName())) {
                    object3 = (TableColumnModel)propertyChangeEvent.getOldValue();
                    if (object3 != null) {
                        object3.getSelectionModel().removeListSelectionListener(SubstanceTableUI.this.substanceTableStateListener);
                    }
                    SubstanceTableUI.this.table.getColumnModel().getSelectionModel().addListSelectionListener(SubstanceTableUI.this.substanceTableStateListener);
                    SubstanceTableUI.this.selectedIndices.clear();
                    SubstanceTableUI.this.stateTransitionMultiTracker.clear();
                    SubstanceTableUI.this.syncSelection(true);
                    object2 = SubstanceTableUI.this.table.getTableHeader();
                    if (object2 != null) {
                        object = (SubstanceTableHeaderUI)((JTableHeader)object2).getUI();
                        ((SubstanceTableHeaderUI)object).processColumnModelChangeEvent((TableColumnModel)propertyChangeEvent.getOldValue(), (TableColumnModel)propertyChangeEvent.getNewValue());
                    }
                }
                if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                    object3 = (ListSelectionModel)propertyChangeEvent.getOldValue();
                    if (object3 != null) {
                        object3.removeListSelectionListener(SubstanceTableUI.this.substanceTableStateListener);
                    }
                    SubstanceTableUI.this.table.getSelectionModel().addListSelectionListener(SubstanceTableUI.this.substanceTableStateListener);
                    SubstanceTableUI.this.selectedIndices.clear();
                    SubstanceTableUI.this.stateTransitionMultiTracker.clear();
                    SubstanceTableUI.this.syncSelection(true);
                }
                if ("rowSorter".equals(propertyChangeEvent.getPropertyName())) {
                    object3 = (RowSorter)propertyChangeEvent.getOldValue();
                    if (object3 != null) {
                        ((RowSorter)object3).removeRowSorterListener(SubstanceTableUI.this.substanceTableStateListener);
                    }
                    if ((object2 = (RowSorter)propertyChangeEvent.getNewValue()) != null) {
                        ((RowSorter)object2).addRowSorterListener(SubstanceTableUI.this.substanceTableStateListener);
                    }
                    SubstanceTableUI.this.selectedIndices.clear();
                    SubstanceTableUI.this.stateTransitionMultiTracker.clear();
                    SubstanceTableUI.this.syncSelection(true);
                }
                if ("font".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceTableUI.this.updateRowHeight();
                    SubstanceTableUI.this.updateCellRendererInsets();
                }
                if ("background".equals(propertyChangeEvent.getPropertyName())) {
                    object3 = (Color)propertyChangeEvent.getNewValue();
                    object2 = SubstanceTableUI.this.table.getTableHeader();
                    if (object2 != null && SubstanceCoreUtilities.canReplaceChildBackgroundColor((Color)(object = ((Component)object2).getBackground()))) {
                        if (!(object3 instanceof UIResource)) {
                            if (object3 == null) {
                                ((JComponent)object2).setBackground(null);
                            } else {
                                ((JComponent)object2).setBackground(new SubstanceColorResource((Color)object3));
                            }
                        } else {
                            ((JComponent)object2).setBackground((Color)object3);
                        }
                    }
                }
                if ("enabled".equals(propertyChangeEvent.getPropertyName()) && (object3 = SubstanceTableUI.this.table.getTableHeader()) != null) {
                    ((JComponent)object3).setEnabled(SubstanceTableUI.this.table.isEnabled());
                }
                if ("dropLocation".equals(propertyChangeEvent.getPropertyName())) {
                    object3 = (JTable.DropLocation)propertyChangeEvent.getOldValue();
                    if (object3 != null) {
                        object2 = SubstanceTableUI.this.getCellRectangleForRepaint(((JTable.DropLocation)object3).getRow(), ((JTable.DropLocation)object3).getColumn());
                        SubstanceTableUI.this.table.repaint((Rectangle)object2);
                    }
                    if ((object2 = SubstanceTableUI.this.table.getDropLocation()) != null) {
                        object = SubstanceTableUI.this.getCellRectangleForRepaint(SubstanceTableUI.this.table.getDropLocation().getRow(), SubstanceTableUI.this.table.getDropLocation().getColumn());
                        SubstanceTableUI.this.table.repaint((Rectangle)object);
                    }
                }
                if ("tableCellEditor".equals(propertyChangeEvent.getPropertyName())) {
                    object3 = (TableCellEditor)propertyChangeEvent.getNewValue();
                    object2 = (TableCellEditor)propertyChangeEvent.getOldValue();
                    if (object2 != null && SubstanceTableUI.this.table.getEditorComponent() != null) {
                        SubstanceTableUI.this.table.getEditorComponent().removeMouseListener(SubstanceTableUI.this.substanceFadeRolloverListener);
                    }
                    if (object3 != null && SubstanceTableUI.this.table.getEditorComponent() != null) {
                        SubstanceTableUI.this.table.getEditorComponent().addMouseListener(SubstanceTableUI.this.substanceFadeRolloverListener);
                    }
                }
                if ("substancelaf.tableLeadingVerticalLine".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceTableUI.this.drawLeadingVerticalLine = (Boolean)propertyChangeEvent.getNewValue();
                }
                if ("substancelaf.tableTrailingVerticalLine".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceTableUI.this.drawTrailingVerticalLine = (Boolean)propertyChangeEvent.getNewValue();
                }
            }
        };
        this.table.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceTableStateListener = new TableStateListener();
        this.table.getSelectionModel().addListSelectionListener(this.substanceTableStateListener);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getSelectionModel().addListSelectionListener(this.substanceTableStateListener);
        this.table.getModel().addTableModelListener(this.substanceTableStateListener);
        if (this.table.getRowSorter() != null) {
            this.table.getRowSorter().addRowSorterListener(this.substanceTableStateListener);
        }
        this.substanceFadeRolloverListener = new RolloverFadeListener();
        this.table.addMouseMotionListener(this.substanceFadeRolloverListener);
        this.table.addMouseListener(this.substanceFadeRolloverListener);
        this.substanceFocusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (SubstanceTableUI.this.focusedCellId == null) {
                    return;
                }
                ComponentState componentState = SubstanceTableUI.this.getCellState(SubstanceTableUI.this.focusedCellId);
                StateTransitionTracker stateTransitionTracker = SubstanceTableUI.this.getTracker(SubstanceTableUI.this.focusedCellId, componentState.isFacetActive(ComponentStateFacet.ROLLOVER), componentState.isFacetActive(ComponentStateFacet.SELECTION));
                stateTransitionTracker.setFocusState(false);
                SubstanceTableUI.this.focusedCellId = null;
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                int n = SubstanceTableUI.this.table.getSelectionModel().getLeadSelectionIndex();
                int n2 = SubstanceTableUI.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                if (n >= 0 && n2 >= 0) {
                    TableCellId tableCellId = new TableCellId(n, n2);
                    if (tableCellId.equals(SubstanceTableUI.this.focusedCellId)) {
                        return;
                    }
                    ComponentState componentState = SubstanceTableUI.this.getCellState(tableCellId);
                    StateTransitionTracker stateTransitionTracker = SubstanceTableUI.this.getTracker(tableCellId, componentState.isFacetActive(ComponentStateFacet.ROLLOVER), componentState.isFacetActive(ComponentStateFacet.SELECTION));
                    stateTransitionTracker.setFocusState(true);
                    SubstanceTableUI.this.focusedCellId = tableCellId;
                }
            }
        };
        this.table.addFocusListener(this.substanceFocusListener);
    }

    private void uninstallListenersInternal() {
        this.table.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.table.getSelectionModel().removeListSelectionListener(this.substanceTableStateListener);
        this.table.getColumnModel().getSelectionModel().removeListSelectionListener(this.substanceTableStateListener);
        this.table.getModel().removeTableModelListener(this.substanceTableStateListener);
        if (this.table.getRowSorter() != null) {
            this.table.getRowSorter().removeRowSorterListener(this.substanceTableStateListener);
        }
        this.substanceTableStateListener = null;
        this.table.removeMouseMotionListener(this.substanceFadeRolloverListener);
        this.table.removeMouseListener(this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        this.table.removeFocusListener(this.substanceFocusListener);
        this.substanceFocusListener = null;
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl;
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = this.table.getBounds();
        rectangle2.y = 0;
        rectangle2.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !rectangle2.intersects(rectangle)) {
            return;
        }
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n = this.table.rowAtPoint(point);
        int n2 = this.table.rowAtPoint(point2);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = this.table.getRowCount() - 1;
        }
        int n3 = this.table.columnAtPoint((bl = this.table.getComponentOrientation().isLeftToRight()) ? point : point2);
        int n4 = this.table.columnAtPoint(bl ? point2 : point);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = this.table.getColumnCount() - 1;
        }
        this.paintCells(graphics, n, n2, n3, n4);
        this.paintGrid(graphics, n, n2, n3, n4);
        this.paintDropLines(graphics);
    }

    protected void paintGrid(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        ComponentState componentState = this.table.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        float f = SubstanceColorSchemeUtilities.getAlpha(this.table, componentState);
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.table, (float)f, (Graphics)graphics));
        Color color = this.table.getGridColor();
        if (color instanceof UIResource) {
            object = SubstanceColorSchemeUtilities.getColorScheme(this.table, ColorSchemeAssociationKind.BORDER, this.table.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
            color = object.getLineColor();
        }
        graphics2D.setColor(color);
        object = this.table.getCellRect(n, n3, true);
        Rectangle rectangle = this.table.getCellRect(n2, n4, true);
        Rectangle rectangle2 = ((Rectangle)object).union(rectangle);
        float f2 = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.table));
        graphics2D.setStroke(new BasicStroke(f2, 1, 2));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.table.getShowHorizontalLines()) {
            int n7 = rectangle2.x + rectangle2.width;
            n6 = rectangle2.y;
            for (n5 = n; n5 <= n2; ++n5) {
                graphics2D.drawLine(rectangle2.x, (n6 += this.table.getRowHeight(n5)) - 1, n7 - 1, n6 - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n6 = rectangle2.y + rectangle2.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                n5 = rectangle2.x;
                for (int i = n3; i <= n4; ++i) {
                    int n8 = tableColumnModel.getColumn(i).getWidth();
                    if (this.hasLeadingVerticalGridLine(tableColumnModel, i)) {
                        graphics2D.drawLine(n5, 0, n5, n6 - 1);
                    }
                    n5 += n8;
                    if (!this.hasTrailingVerticalGridLine(tableColumnModel, i)) continue;
                    graphics2D.drawLine(n5 - 1, 0, n5 - 1, n6 - 1);
                }
            } else {
                n5 = rectangle2.x + rectangle2.width;
                for (int i = n3; i <= n4; ++i) {
                    int n9 = tableColumnModel.getColumn(i).getWidth();
                    if (this.hasLeadingVerticalGridLine(tableColumnModel, i)) {
                        graphics2D.drawLine(n5 - 1, 0, n5 - 1, n6 - 1);
                    }
                    n5 -= n9;
                    if (!this.hasTrailingVerticalGridLine(tableColumnModel, i)) continue;
                    graphics2D.drawLine(n5, 0, n5, n6 - 1);
                }
            }
        }
        graphics2D.dispose();
    }

    private boolean hasTrailingVerticalGridLine(TableColumnModel tableColumnModel, int n) {
        boolean bl;
        boolean bl2 = bl = n != tableColumnModel.getColumnCount() - 1;
        if (!bl) {
            Container container;
            bl = this.drawTrailingVerticalLine != null ? this.drawTrailingVerticalLine : (container = this.table.getParent()) != null && container.getWidth() >= this.table.getWidth();
        }
        return bl;
    }

    private boolean hasLeadingVerticalGridLine(TableColumnModel tableColumnModel, int n) {
        Container container;
        if (n != 0) {
            return false;
        }
        if (this.drawLeadingVerticalLine != null) {
            return this.drawLeadingVerticalLine;
        }
        Container container2 = this.table.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            return ((JScrollPane)container).getRowHeader() != null;
        }
        return false;
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    protected void paintCells(Graphics graphics, int n, int n2, int n3, int n4) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n5 = tableColumnModel.getColumnMargin();
        int n6 = this.table.getRowMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (var15_11 = n; var15_11 <= n2; ++var15_11) {
                Rectangle rectangle = this.table.getCellRect(var15_11, n3, false);
                Rectangle rectangle2 = new Rectangle(rectangle);
                rectangle2.y -= n6 / 2;
                rectangle2.height += n6;
                for (int i = n3; i <= n4; ++i) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(i);
                    int n7 = tableColumn2.getWidth();
                    rectangle.width = n7 - n5;
                    rectangle2.x = rectangle.x - n5 / 2;
                    rectangle2.width = n7;
                    if (tableColumn2 != tableColumn) {
                        this.paintCell(graphics, rectangle, rectangle2, var15_11, i);
                    }
                    rectangle.x += n7;
                }
            }
        } else {
            for (var15_11 = n; var15_11 <= n2; ++var15_11) {
                Rectangle rectangle = this.table.getCellRect(var15_11, n3, false);
                Rectangle rectangle3 = new Rectangle(rectangle);
                rectangle3.y -= n6 / 2;
                rectangle3.height += n6;
                for (int i = n3; i <= n4; ++i) {
                    TableColumn tableColumn3 = tableColumnModel.getColumn(i);
                    int n8 = tableColumn3.getWidth();
                    rectangle.width = n8 - n5;
                    rectangle3.x = rectangle.x - n5 / 2;
                    rectangle3.width = n8;
                    if (tableColumn3 != tableColumn) {
                        this.paintCell(graphics, rectangle, rectangle3, var15_11, i);
                    }
                    rectangle.x -= n8;
                }
            }
        }
        if (tableColumn != null) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.table, (float)0.65f, (Graphics)graphics));
            this.paintDraggedArea(graphics2D, n, n2, tableColumn, jTableHeader.getDraggedDistance());
            graphics2D.dispose();
        }
        this.rendererPane.removeAll();
    }

    protected void paintDraggedArea(Graphics graphics, int n, int n2, TableColumn tableColumn, int n3) {
        int n4;
        int n5;
        int n6 = this.viewIndexForColumn(tableColumn);
        Rectangle rectangle = this.table.getCellRect(n, n6, true);
        Rectangle rectangle2 = this.table.getCellRect(n2, n6, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n3;
        graphics.setColor(this.table.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n5 = rectangle3.x;
            int n7 = rectangle3.y;
            int n8 = n5 + rectangle3.width - 1;
            n4 = n7 + rectangle3.height - 1;
            graphics.drawLine(n5 - 1, n7, n5 - 1, n4);
            graphics.drawLine(n8, n7, n8, n4);
        }
        for (n5 = n; n5 <= n2; ++n5) {
            Rectangle rectangle4 = this.table.getCellRect(n5, n6, false);
            rectangle4.x += n3;
            this.paintCell(graphics, rectangle4, rectangle4, n5, n6);
            if (!this.table.getShowHorizontalLines()) continue;
            graphics.setColor(this.table.getGridColor());
            Rectangle rectangle5 = this.table.getCellRect(n5, n6, true);
            rectangle5.x += n3;
            n4 = rectangle5.x;
            int n9 = rectangle5.y;
            int n10 = n4 + rectangle5.width - 1;
            int n11 = n9 + rectangle5.height - 1;
            graphics.drawLine(n4, n11, n10, n11);
        }
    }

    protected void paintCell(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, int n, int n2) {
        Object object;
        Object object2;
        boolean bl;
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map;
        Object object3;
        Component component = null;
        if (!this.table.isEditing() || this.table.getEditingRow() != n || this.table.getEditingColumn() != n2) {
            object3 = this.table.getCellRenderer(n, n2);
            boolean bl2 = this.isSubstanceDefaultRenderer(object3);
            component = this.table.prepareRenderer((TableCellRenderer)object3, n, n2);
            boolean bl3 = this.isSubstanceDefaultRenderer(component);
            if (bl2 && !bl3 && !Boolean.getBoolean("insubstantial.looseTableCellRenderers")) {
                throw new IllegalArgumentException("Renderer extends the SubstanceDefaultTableCellRenderer but does not return one in its getTableCellRendererComponent() method");
            }
            if (!bl2) {
                this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                return;
            }
        }
        object3 = (Graphics2D)graphics.create();
        ((Graphics2D)object3).setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.table, (Graphics)graphics));
        TableCellId tableCellId = new TableCellId(n, n2);
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.getModelStateInfo(tableCellId);
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map2 = map = modelStateInfo == null ? null : modelStateInfo.getStateContributionMap();
        if (!this.updateInfo.hasRolloverAnimations && !this.updateInfo.hasSelectionAnimations) {
            map = null;
        }
        ComponentState componentState = modelStateInfo == null ? this.getCellState(tableCellId) : modelStateInfo.getCurrModelState();
        boolean bl4 = bl = componentState != ComponentState.ENABLED || map != null;
        if (map != null) {
            object2 = map.entrySet().iterator();
            while (object2.hasNext() && !(bl = this.updateInfo.getHighlightAlpha((object = object2.next()).getKey()) * object.getValue().getContribution() > 0.0f)) {
            }
        } else {
            bl = this.updateInfo.getHighlightAlpha(componentState) > 0.0f;
        }
        bl = (object2 = this.table.getClientProperty("substancelaf.highlightCells")) instanceof Boolean ? ((Boolean)object2).booleanValue() && bl : bl;
        object = null;
        float f = 0.0f;
        if (bl) {
            ComponentState componentState2;
            object = EnumSet.noneOf(SubstanceConstants.Side.class);
            float f2 = f = this.table.getShowHorizontalLines() || this.table.getShowVerticalLines() ? 0.0f : 0.8f;
            if (!this.table.getColumnSelectionAllowed() && this.table.getRowSelectionAllowed()) {
                object.add(SubstanceConstants.Side.LEFT);
                object.add(SubstanceConstants.Side.RIGHT);
            }
            if (this.table.getColumnSelectionAllowed() && !this.table.getRowSelectionAllowed()) {
                object.add(SubstanceConstants.Side.TOP);
                object.add(SubstanceConstants.Side.BOTTOM);
            }
            if (n > 1 && componentState == (componentState2 = this.getCellState(new TableCellId(n - 1, n2)))) {
                object.add(SubstanceConstants.Side.TOP);
            }
            if (n2 > 1 && componentState == (componentState2 = this.getCellState(new TableCellId(n, n2 - 1)))) {
                object.add(SubstanceConstants.Side.LEFT);
            }
            if (n == 0) {
                object.add(SubstanceConstants.Side.TOP);
            }
            if (n == this.table.getRowCount() - 1) {
                object.add(SubstanceConstants.Side.BOTTOM);
            }
            if (n2 == 0) {
                object.add(SubstanceConstants.Side.LEFT);
            }
            if (n2 == this.table.getColumnCount() - 1) {
                object.add(SubstanceConstants.Side.RIGHT);
            }
        }
        boolean bl5 = this.rolledOverIndices.contains(tableCellId);
        if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
            Component component2 = this.table.getEditorComponent();
            component2.applyComponentOrientation(this.table.getComponentOrientation());
            if (bl) {
                float f3 = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.table.getTableHeader()));
                float f4 = object.contains((Object)SubstanceConstants.Side.LEFT) ? 0.0f : f3;
                float f5 = object.contains((Object)SubstanceConstants.Side.TOP) ? 0.0f : f3;
                Rectangle rectangle3 = new Rectangle(rectangle2.x - (int)f4, rectangle2.y - (int)f5, rectangle2.width + (int)f4, rectangle2.height + (int)f5);
                if (map == null) {
                    float f6 = this.updateInfo.getHighlightAlpha(componentState);
                    if (f6 > 0.0f) {
                        SubstanceColorScheme substanceColorScheme = this.updateInfo.getHighlightColorScheme(componentState);
                        SubstanceColorScheme substanceColorScheme2 = this.updateInfo.getHighlightBorderColorScheme(componentState);
                        ((Graphics2D)object3).setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.table, (float)f6, (Graphics)graphics));
                        HighlightPainterUtils.paintHighlight((Graphics)object3, this.rendererPane, component2, rectangle3, f, (Set<SubstanceConstants.Side>)object, substanceColorScheme, substanceColorScheme2);
                        ((Graphics2D)object3).setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.table, (Graphics)graphics));
                    }
                } else {
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
                        ComponentState componentState3 = entry.getKey();
                        float f7 = this.updateInfo.getHighlightAlpha(componentState3) * entry.getValue().getContribution();
                        if (f7 == 0.0f) continue;
                        SubstanceColorScheme substanceColorScheme = this.updateInfo.getHighlightColorScheme(componentState3);
                        SubstanceColorScheme substanceColorScheme3 = this.updateInfo.getHighlightBorderColorScheme(componentState3);
                        ((Graphics2D)object3).setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.table, (float)f7, (Graphics)graphics));
                        HighlightPainterUtils.paintHighlight((Graphics)object3, this.rendererPane, component2, rectangle3, f, (Set<SubstanceConstants.Side>)object, substanceColorScheme, substanceColorScheme3);
                        ((Graphics2D)object3).setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.table, (Graphics)graphics));
                    }
                }
            }
            component2.setBounds(rectangle);
            component2.validate();
        } else {
            Object object4;
            boolean bl6 = this.updateInfo.toDrawWatermark;
            if (component != null) {
                if (!bl6) {
                    object4 = component.getBackground();
                    if (object4 != null && (!this.table.getBackground().equals(object4) || this.updateInfo.isInDecorationArea)) {
                        ((Graphics)object3).setColor((Color)object4);
                        ((Graphics)object3).fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    }
                } else {
                    BackgroundPaintingUtils.fillAndWatermark((Graphics)object3, this.table, component.getBackground(), rectangle2);
                }
            }
            if (bl) {
                object4 = this.table.getDropLocation();
                if (object4 != null && !((JTable.DropLocation)object4).isInsertRow() && !((JTable.DropLocation)object4).isInsertColumn() && ((JTable.DropLocation)object4).getRow() == n && ((JTable.DropLocation)object4).getColumn() == n2) {
                    SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.table, ColorSchemeAssociationKind.TEXT_HIGHLIGHT, componentState);
                    SubstanceColorScheme substanceColorScheme4 = SubstanceColorSchemeUtilities.getColorScheme(this.table, ColorSchemeAssociationKind.BORDER, componentState);
                    var21_33 = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.table.getTableHeader()));
                    HighlightPainterUtils.paintHighlight((Graphics)object3, this.rendererPane, component, new Rectangle(rectangle2.x - (int)var21_33, rectangle2.y - (int)var21_33, rectangle2.width + (int)var21_33, rectangle2.height + (int)var21_33), 0.8f, null, substanceColorScheme, substanceColorScheme4);
                } else {
                    float f8 = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.table.getTableHeader()));
                    float f9 = object.contains((Object)SubstanceConstants.Side.LEFT) ? 0.0f : f8;
                    var21_33 = object.contains((Object)SubstanceConstants.Side.TOP) ? 0.0f : f8;
                    Rectangle rectangle4 = new Rectangle(rectangle2.x - (int)f9, rectangle2.y - (int)var21_33, rectangle2.width + (int)f9, rectangle2.height + (int)var21_33);
                    if (map == null) {
                        SubstanceColorScheme substanceColorScheme = this.updateInfo.getHighlightColorScheme(componentState);
                        SubstanceColorScheme substanceColorScheme5 = this.updateInfo.getHighlightBorderColorScheme(componentState);
                        float f10 = this.updateInfo.getHighlightAlpha(componentState);
                        if (f10 > 0.0f) {
                            ((Graphics2D)object3).setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.table, (float)f10, (Graphics)graphics));
                            HighlightPainterUtils.paintHighlight((Graphics)object3, this.rendererPane, component, rectangle4, f, (Set<SubstanceConstants.Side>)object, substanceColorScheme, substanceColorScheme5);
                            ((Graphics2D)object3).setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.table, (Graphics)graphics));
                        }
                    } else {
                        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
                            ComponentState componentState4 = entry.getKey();
                            SubstanceColorScheme substanceColorScheme = this.updateInfo.getHighlightColorScheme(componentState4);
                            SubstanceColorScheme substanceColorScheme6 = this.updateInfo.getHighlightBorderColorScheme(componentState4);
                            float f11 = this.updateInfo.getHighlightAlpha(componentState4) * entry.getValue().getContribution();
                            if (!(f11 > 0.0f)) continue;
                            ((Graphics2D)object3).setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.table, (float)f11, (Graphics)graphics));
                            HighlightPainterUtils.paintHighlight((Graphics)object3, this.rendererPane, component, rectangle4, f, (Set<SubstanceConstants.Side>)object, substanceColorScheme, substanceColorScheme6);
                            ((Graphics2D)object3).setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.table, (Graphics)graphics));
                        }
                    }
                }
            }
            component.applyComponentOrientation(this.table.getComponentOrientation());
            if (component instanceof JComponent) {
                boolean bl7;
                object4 = (JComponent)component;
                boolean bl8 = this.updateInfo.hasSelectionAnimations ? this.selectedIndices.containsKey(tableCellId) : this.table.isCellSelected(n, n2);
                boolean bl9 = bl7 = !bl8 && !bl5 && !bl;
                if (this.updateInfo.toDrawWatermark) {
                    bl7 = false;
                }
                HashMap<Component, Boolean> hashMap = new HashMap<Component, Boolean>();
                if (!bl7) {
                    SubstanceCoreUtilities.makeNonOpaque((Component)object4, hashMap);
                }
                this.rendererPane.paintComponent((Graphics)object3, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                if (!bl7) {
                    SubstanceCoreUtilities.restoreOpaque((Component)object4, hashMap);
                }
            } else {
                this.rendererPane.paintComponent((Graphics)object3, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            }
        }
        ((Graphics)object3).dispose();
    }

    protected void paintDropLines(Graphics graphics) {
        int n;
        int n2;
        JTable.DropLocation dropLocation = this.table.getDropLocation();
        if (dropLocation == null) {
            return;
        }
        Color color = UIManager.getColor("Table.dropLineColor");
        Color color2 = UIManager.getColor("Table.dropLineShortColor");
        if (color == null && color2 == null) {
            return;
        }
        Rectangle rectangle = this.getHDropLineRect(dropLocation);
        if (rectangle != null) {
            n2 = rectangle.x;
            n = rectangle.width;
            if (color != null) {
                this.extendRect(rectangle, true);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!dropLocation.isInsertColumn() && color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(n2, rectangle.y, n, rectangle.height);
            }
        }
        if ((rectangle = this.getVDropLineRect(dropLocation)) != null) {
            n2 = rectangle.y;
            n = rectangle.height;
            if (color != null) {
                this.extendRect(rectangle, false);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!dropLocation.isInsertRow() && color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(rectangle.x, n2, rectangle.width, n);
            }
        }
    }

    private Rectangle getHDropLineRect(JTable.DropLocation dropLocation) {
        if (!dropLocation.isInsertRow()) {
            return null;
        }
        int n = dropLocation.getRow();
        int n2 = dropLocation.getColumn();
        if (n2 >= this.table.getColumnCount()) {
            --n2;
        }
        Rectangle rectangle = this.table.getCellRect(n, n2, true);
        if (n >= this.table.getRowCount()) {
            Rectangle rectangle2 = this.table.getCellRect(--n, n2, true);
            rectangle.y = rectangle2.y + rectangle2.height;
        }
        rectangle.y = rectangle.y == 0 ? -1 : (rectangle.y -= 2);
        rectangle.height = 3;
        return rectangle;
    }

    private Rectangle getVDropLineRect(JTable.DropLocation dropLocation) {
        if (!dropLocation.isInsertColumn()) {
            return null;
        }
        boolean bl = this.table.getComponentOrientation().isLeftToRight();
        int n = dropLocation.getColumn();
        Rectangle rectangle = this.table.getCellRect(dropLocation.getRow(), n, true);
        if (n >= this.table.getColumnCount()) {
            rectangle = this.table.getCellRect(dropLocation.getRow(), --n, true);
            if (bl) {
                rectangle.x += rectangle.width;
            }
        } else if (!bl) {
            rectangle.x += rectangle.width;
        }
        rectangle.x = rectangle.x == 0 ? -1 : (rectangle.x -= 2);
        rectangle.width = 3;
        return rectangle;
    }

    private Rectangle extendRect(Rectangle rectangle, boolean bl) {
        if (rectangle == null) {
            return rectangle;
        }
        if (bl) {
            rectangle.x = 0;
            rectangle.width = this.table.getWidth();
        } else {
            rectangle.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle rectangle2 = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rectangle.height = rectangle2.y + rectangle2.height;
            } else {
                rectangle.height = this.table.getHeight();
            }
        }
        return rectangle;
    }

    public TableCellId getId(int n, int n2) {
        this.cellId.column = n2;
        this.cellId.row = n;
        return this.cellId;
    }

    protected void syncSelection(boolean bl) {
        if (this.table == null) {
            return;
        }
        int n = this.table.getRowCount();
        int n2 = this.table.getColumnCount();
        int n3 = this.table.getSelectionModel().getLeadSelectionIndex();
        int n4 = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        boolean bl2 = this.table.isFocusOwner();
        if (!this._hasSelectionAnimations()) {
            this.stateTransitionMultiTracker.clear();
            this.table.repaint();
            if (bl2) {
                this.focusedCellId = new TableCellId(n3, n4);
            }
            return;
        }
        HashSet<StateTransitionTracker> hashSet = new HashSet<StateTransitionTracker>();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                boolean bl3;
                Object object;
                TableCellId tableCellId = new TableCellId(i, j);
                if (this.table.isCellSelected(i, j)) {
                    if (!this.selectedIndices.containsKey(tableCellId)) {
                        if (!bl) {
                            StateTransitionTracker stateTransitionTracker = this.getTracker(tableCellId, this.getCellState(tableCellId).isFacetActive(ComponentStateFacet.ROLLOVER), false);
                            stateTransitionTracker.getModel().setSelected(true);
                            hashSet.add(stateTransitionTracker);
                            if (hashSet.size() > 20) {
                                this.stateTransitionMultiTracker.clear();
                                hashSet.clear();
                                bl = true;
                            }
                        }
                        this.selectedIndices.put(tableCellId, this.table.getValueAt(i, j));
                    }
                } else if (this.selectedIndices.containsKey(tableCellId)) {
                    Object object2 = this.selectedIndices.get(tableCellId);
                    if (i >= this.table.getModel().getRowCount() || j >= this.table.getModel().getColumnCount()) continue;
                    object = this.table.getValueAt(i, j);
                    boolean bl4 = object2 == null ? object == null : object2.equals(object);
                    if (bl4 && !bl) {
                        StateTransitionTracker stateTransitionTracker = this.getTracker(tableCellId, this.getCellState(tableCellId).isFacetActive(ComponentStateFacet.ROLLOVER), true);
                        stateTransitionTracker.getModel().setSelected(false);
                        hashSet.add(stateTransitionTracker);
                        if (hashSet.size() > 20) {
                            this.stateTransitionMultiTracker.clear();
                            hashSet.clear();
                            bl = true;
                        }
                    }
                    this.selectedIndices.remove(tableCellId);
                }
                boolean bl5 = bl3 = bl2 && i == n3 && j == n4;
                if (bl3) {
                    if (this.focusedCellId != null && this.focusedCellId.equals(tableCellId)) continue;
                    if (!bl) {
                        if (this.focusedCellId != null) {
                            object = this.getCellState(this.focusedCellId);
                            StateTransitionTracker stateTransitionTracker = this.getTracker(this.focusedCellId, ((ComponentState)object).isFacetActive(ComponentStateFacet.ROLLOVER), ((ComponentState)object).isFacetActive(ComponentStateFacet.SELECTION));
                            stateTransitionTracker.setFocusState(false);
                        }
                        object = this.getCellState(tableCellId);
                        StateTransitionTracker stateTransitionTracker = this.getTracker(tableCellId, ((ComponentState)object).isFacetActive(ComponentStateFacet.ROLLOVER), ((ComponentState)object).isFacetActive(ComponentStateFacet.SELECTION));
                        stateTransitionTracker.setFocusState(true);
                    }
                    if (!AnimationConfigurationManager.getInstance().isAnimationAllowed(AnimationFacet.FOCUS, (Component)this.table)) continue;
                    this.focusedCellId = new TableCellId(i, j);
                    continue;
                }
                if (!tableCellId.equals(this.focusedCellId)) continue;
                if (!bl) {
                    object = this.getCellState(tableCellId);
                    StateTransitionTracker stateTransitionTracker = this.getTracker(tableCellId, ((ComponentState)object).isFacetActive(ComponentStateFacet.ROLLOVER), ((ComponentState)object).isFacetActive(ComponentStateFacet.SELECTION));
                    stateTransitionTracker.setFocusState(false);
                }
                this.focusedCellId = null;
            }
        }
    }

    public ComponentState getCellState(TableCellId tableCellId) {
        boolean bl = this.table.isEnabled();
        StateTransitionTracker stateTransitionTracker = this.stateTransitionMultiTracker.getTracker(tableCellId);
        if (stateTransitionTracker == null) {
            int n = tableCellId.row;
            int n2 = tableCellId.column;
            TableCellId tableCellId2 = this.getId(n, n2);
            boolean bl2 = this.rolledOverIndices.contains(tableCellId2);
            boolean bl3 = this.updateInfo != null ? this.updateInfo.hasSelectionAnimations : this._hasSelectionAnimations();
            boolean bl4 = bl3 && AnimationConfigurationManager.getInstance().isAnimationAllowed(AnimationFacet.SELECTION, (Component)this.table) ? this.selectedIndices.containsKey(tableCellId2) : this.table.isCellSelected(n, n2);
            return ComponentState.getState(bl, bl2, bl4);
        }
        ComponentState componentState = stateTransitionTracker.getModelStateInfo().getCurrModelState();
        return ComponentState.getState(bl, componentState.isFacetActive(ComponentStateFacet.ROLLOVER), componentState.isFacetActive(ComponentStateFacet.SELECTION));
    }

    public StateTransitionTracker.ModelStateInfo getModelStateInfo(TableCellId tableCellId) {
        if (this.stateTransitionMultiTracker.size() == 0) {
            return null;
        }
        StateTransitionTracker stateTransitionTracker = this.stateTransitionMultiTracker.getTracker(tableCellId);
        if (stateTransitionTracker == null) {
            return null;
        }
        return stateTransitionTracker.getModelStateInfo();
    }

    protected boolean _hasAnimations() {
        int n;
        int n2 = this.table.getRowCount();
        if (n2 * (n = this.table.getColumnCount()) >= 500) {
            return false;
        }
        if (this.table.getColumnSelectionAllowed() && !this.table.getRowSelectionAllowed()) {
            if (!this.table.getShowHorizontalLines() && !this.table.getShowVerticalLines()) {
                return n2 <= 10;
            }
            return n2 <= 25;
        }
        if (!this.table.getColumnSelectionAllowed() && this.table.getRowSelectionAllowed()) {
            if (!this.table.getShowHorizontalLines() && !this.table.getShowVerticalLines()) {
                return n <= 10;
            }
            return n <= 25;
        }
        return true;
    }

    protected boolean _hasSelectionAnimations() {
        return this._hasAnimations() && !LafWidgetUtilities.hasNoAnimations((Component)this.table, (AnimationFacet)AnimationFacet.SELECTION);
    }

    protected boolean _hasRolloverAnimations() {
        return this._hasAnimations() && !LafWidgetUtilities.hasNoAnimations((Component)this.table, (AnimationFacet)AnimationFacet.ROLLOVER);
    }

    public int getRolloverColumnIndex() {
        return this.rolledOverColumn;
    }

    public boolean isFocusedCell(int n, int n2) {
        return this.focusedCellId != null && this.focusedCellId.row == n && this.focusedCellId.column == n2;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.updateInternal(graphics2D, jComponent);
        graphics2D.dispose();
    }

    private void updateInternal(Graphics graphics, JComponent jComponent) {
        BackgroundPaintingUtils.updateIfOpaque(graphics, jComponent);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        SubstanceStripingUtils.setup(jComponent);
        this.updateInfo = new TableUpdateOptimizationInfo();
        this.paint(graphics2D, jComponent);
        SubstanceStripingUtils.tearDown(jComponent);
        graphics2D.dispose();
        this.updateInfo = null;
    }

    public Insets getCellRendererInsets() {
        return this.cellRendererInsets;
    }

    public boolean hasSelectionAnimations() {
        if (this.updateInfo != null) {
            return this.updateInfo.hasSelectionAnimations;
        }
        return this._hasSelectionAnimations();
    }

    public boolean hasRolloverAnimations() {
        if (this.updateInfo != null) {
            return this.updateInfo.hasRolloverAnimations;
        }
        return this._hasRolloverAnimations();
    }

    @Override
    public UpdateOptimizationInfo getUpdateOptimizationInfo() {
        return this.updateInfo;
    }

    private boolean isSubstanceDefaultRenderer(Object object) {
        return object instanceof SubstanceDefaultTableCellRenderer || object instanceof SubstanceDefaultTableCellRenderer.BooleanRenderer;
    }

    private boolean isSubstanceDefaultEditor(TableCellEditor tableCellEditor) {
        return tableCellEditor instanceof BooleanEditor;
    }

    private Rectangle getCellRectangleForRepaint(int n, int n2) {
        Rectangle rectangle = this.table.getCellRect(n, n2, true);
        if (!this.table.getShowHorizontalLines() && !this.table.getShowVerticalLines()) {
            float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.table.getTableHeader()));
            rectangle.x -= (int)f;
            rectangle.width += 2 * (int)f;
            rectangle.y -= (int)f;
            rectangle.height += 2 * (int)f;
        }
        return rectangle;
    }

    private StateTransitionTracker getTracker(final TableCellId tableCellId, boolean bl, boolean bl2) {
        StateTransitionTracker stateTransitionTracker = this.stateTransitionMultiTracker.getTracker(tableCellId);
        if (stateTransitionTracker == null) {
            DefaultButtonModel defaultButtonModel = new DefaultButtonModel();
            defaultButtonModel.setSelected(bl2);
            defaultButtonModel.setRollover(bl);
            stateTransitionTracker = new StateTransitionTracker(this.table, defaultButtonModel);
            stateTransitionTracker.registerModelListeners();
            stateTransitionTracker.setRepaintCallback(new StateTransitionTracker.RepaintCallback(){

                @Override
                public TimelineCallback getRepaintCallback() {
                    return new CellRepaintCallback(SubstanceTableUI.this.table, tableCellId.row, tableCellId.column);
                }
            });
            stateTransitionTracker.setName("row " + tableCellId.row + ", col " + tableCellId.column);
            this.stateTransitionMultiTracker.addTracker(tableCellId, stateTransitionTracker);
        }
        return stateTransitionTracker;
    }

    public StateTransitionTracker getStateTransitionTracker(TableCellId tableCellId) {
        return this.stateTransitionMultiTracker.getTracker(tableCellId);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        this.installDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners() {
        this.installListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        this.uninstallDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.uninstallListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public static class TableCellId
    implements Comparable<TableCellId> {
        protected int row;
        protected int column;

        public TableCellId(int n, int n2) {
            this.row = n;
            this.column = n2;
        }

        @Override
        public int compareTo(TableCellId tableCellId) {
            if (this.row == tableCellId.row && this.column == tableCellId.column) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object object) {
            if (object instanceof TableCellId) {
                return this.compareTo((TableCellId)object) == 0;
            }
            return false;
        }

        public int hashCode() {
            return (this.row ^ this.row >>> 32) & (this.column ^ this.column >>> 32);
        }

        public String toString() {
            return "Row " + this.row + ", Column " + this.column;
        }
    }

    static class BooleanEditor
    extends DefaultCellEditor {
        public BooleanEditor() {
            super(new SubstanceEditorCheckBox());
            JCheckBox jCheckBox = (JCheckBox)this.getComponent();
            jCheckBox.setOpaque(false);
            jCheckBox.setHorizontalAlignment(0);
        }

        private static class SubstanceEditorCheckBox
        extends JCheckBox {
            private SubstanceEditorCheckBox() {
            }

            @Override
            public void setOpaque(boolean bl) {
                if (!bl) {
                    super.setOpaque(bl);
                }
            }

            @Override
            public boolean isOpaque() {
                return false;
            }

            @Override
            public void setBorder(Border border) {
            }
        }
    }

    protected class TableStateListener
    implements ListSelectionListener,
    TableModelListener,
    RowSorterListener {
        List<RowSorter.SortKey> oldSortKeys = null;

        protected TableStateListener() {
        }

        private boolean isSameSorter(List<? extends RowSorter.SortKey> list, List<? extends RowSorter.SortKey> list2) {
            int n;
            int n2 = list == null ? 0 : list.size();
            int n3 = n = list2 == null ? 0 : list2.size();
            if (n2 == 0 && n == 0) {
                return true;
            }
            if (list == null && list2 == null) {
                return true;
            }
            if (list == null || list2 == null) {
                return false;
            }
            if (n2 != n) {
                return false;
            }
            for (int i = 0; i < n2; ++i) {
                RowSorter.SortKey sortKey = list.get(i);
                RowSorter.SortKey sortKey2 = list2.get(i);
                if (sortKey.getColumn() == sortKey2.getColumn() && sortKey.getSortOrder() == sortKey2.getSortOrder()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl;
            List<RowSorter.SortKey> list = SubstanceTableUI.this.table.getRowSorter() == null ? null : SubstanceTableUI.this.table.getRowSorter().getSortKeys();
            boolean bl2 = bl = !this.isSameSorter(list, this.oldSortKeys);
            if (listSelectionEvent.getValueIsAdjusting() && bl) {
                return;
            }
            if (list == null) {
                this.oldSortKeys = null;
            } else {
                this.oldSortKeys = new ArrayList<RowSorter.SortKey>();
                for (RowSorter.SortKey sortKey : list) {
                    RowSorter.SortKey sortKey2 = new RowSorter.SortKey(sortKey.getColumn(), sortKey.getSortOrder());
                    this.oldSortKeys.add(sortKey2);
                }
            }
            SubstanceTableUI.this.syncSelection(bl);
        }

        @Override
        public void tableChanged(final TableModelEvent tableModelEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubstanceTableUI.this.table == null) {
                        return;
                    }
                    if (tableModelEvent.getType() != 0) {
                        SubstanceTableUI.this.selectedIndices.clear();
                        SubstanceTableUI.this.stateTransitionMultiTracker.clear();
                        SubstanceTableUI.this.focusedCellId = null;
                    }
                    SubstanceTableUI.this.syncSelection(true);
                    SubstanceTableUI.this.table.repaint();
                }
            });
        }

        @Override
        public void sorterChanged(RowSorterEvent rowSorterEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubstanceTableUI.this.stateTransitionMultiTracker.clear();
                }
            });
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (SubstanceTableUI.this.table == null) {
                return;
            }
            if (!SubstanceTableUI.this.table.isEnabled()) {
                return;
            }
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            Point point = pointerInfo == null ? null : pointerInfo.getLocation();
            Window window = SwingUtilities.getWindowAncestor(SubstanceTableUI.this.table);
            if (point != null && window != null) {
                SwingUtilities.convertPointFromScreen(point, window);
                for (Component component = SwingUtilities.getDeepestComponentAt(window, point.x, point.y); component != null; component = component.getParent()) {
                    if (component != SubstanceTableUI.this.table) continue;
                    return;
                }
            }
            this.fadeOutAllRollovers();
            this.fadeOutTableHeader();
            SubstanceTableUI.this.rolledOverIndices.clear();
            SubstanceTableUI.this.rolledOverColumn = -1;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!SubstanceTableUI.this.table.isEnabled()) {
                return;
            }
            this.handleMouseMove(mouseEvent.getPoint());
            this.handleMoveForHeader(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!SubstanceTableUI.this.table.isEnabled()) {
                return;
            }
            this.handleMouseMove(mouseEvent.getPoint());
            this.handleMoveForHeader(mouseEvent);
        }

        private void handleMoveForHeader(MouseEvent mouseEvent) {
        }

        private void fadeOutTableHeader() {
            if (SubstanceTableUI.this.rolledOverColumn >= 0) {
                JTableHeader jTableHeader = SubstanceTableUI.this.table.getTableHeader();
                if (jTableHeader == null || !jTableHeader.isVisible()) {
                    return;
                }
                SubstanceTableHeaderUI substanceTableHeaderUI = (SubstanceTableHeaderUI)jTableHeader.getUI();
                TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
                StateTransitionTracker stateTransitionTracker = substanceTableHeaderUI.getTracker(SubstanceTableUI.this.rolledOverColumn, true, tableColumnModel.getColumnSelectionAllowed() && tableColumnModel.getSelectionModel().isSelectedIndex(SubstanceTableUI.this.rolledOverColumn));
                stateTransitionTracker.getModel().setRollover(false);
            }
        }

        private void handleMouseMove(Point point) {
        }

        private void fadeOutRollover(TableCellId tableCellId) {
            if (SubstanceTableUI.this.rolledOverIndices.contains(tableCellId)) {
                StateTransitionTracker stateTransitionTracker = SubstanceTableUI.this.getTracker(tableCellId, true, SubstanceTableUI.this.getCellState(tableCellId).isFacetActive(ComponentStateFacet.SELECTION));
                stateTransitionTracker.getModel().setRollover(false);
            }
        }

        private void fadeOutAllRollovers() {
            if (SubstanceTableUI.this.rolledOverIndices.size() < 20) {
                for (TableCellId tableCellId : SubstanceTableUI.this.rolledOverIndices) {
                    this.fadeOutRollover(tableCellId);
                }
            }
        }
    }

    private class TableUpdateOptimizationInfo
    extends UpdateOptimizationInfo {
        public boolean hasSelectionAnimations;
        public boolean hasRolloverAnimations;

        public TableUpdateOptimizationInfo() {
            super(SubstanceTableUI.this.table);
            this.hasSelectionAnimations = SubstanceTableUI.this._hasSelectionAnimations();
            this.hasRolloverAnimations = SubstanceTableUI.this._hasRolloverAnimations();
        }
    }

    protected class ColumnRepaintCallback
    extends UIThreadTimelineCallbackAdapter {
        protected JTable table;
        protected int columnIndex;

        public ColumnRepaintCallback(JTable jTable, int n) {
            this.table = jTable;
            this.columnIndex = n;
        }

        public void onTimelinePulse(float f, float f2) {
            this.repaintColumn();
        }

        public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
            this.repaintColumn();
        }

        private void repaintColumn() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubstanceTableUI.this.table == null) {
                        return;
                    }
                    int n = ColumnRepaintCallback.this.table.getColumnCount();
                    if (n > 0 && ColumnRepaintCallback.this.columnIndex < n) {
                        Rectangle rectangle = ColumnRepaintCallback.this.table.getCellRect(0, ColumnRepaintCallback.this.columnIndex, true);
                        for (int i = 1; i < ColumnRepaintCallback.this.table.getRowCount(); ++i) {
                            rectangle = rectangle.union(ColumnRepaintCallback.this.table.getCellRect(i, ColumnRepaintCallback.this.columnIndex, true));
                        }
                        if (!ColumnRepaintCallback.this.table.getShowHorizontalLines() && !ColumnRepaintCallback.this.table.getShowVerticalLines()) {
                            float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(ColumnRepaintCallback.this.table.getTableHeader()));
                            rectangle.x -= (int)f;
                            rectangle.width += 2 * (int)f;
                        }
                        ColumnRepaintCallback.this.table.repaint(rectangle);
                    }
                }
            });
        }
    }

    protected class RowRepaintCallback
    extends UIThreadTimelineCallbackAdapter {
        protected JTable table;
        protected int rowIndex;

        public RowRepaintCallback(JTable jTable, int n) {
            this.table = jTable;
            this.rowIndex = n;
        }

        public void onTimelinePulse(float f, float f2) {
            this.repaintRow();
        }

        public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
            this.repaintRow();
        }

        private void repaintRow() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubstanceTableUI.this.table == null) {
                        return;
                    }
                    int n = RowRepaintCallback.this.table.getRowCount();
                    if (n > 0 && RowRepaintCallback.this.rowIndex < n) {
                        Rectangle rectangle = RowRepaintCallback.this.table.getCellRect(RowRepaintCallback.this.rowIndex, 0, true);
                        for (int i = 1; i < RowRepaintCallback.this.table.getColumnCount(); ++i) {
                            rectangle = rectangle.union(RowRepaintCallback.this.table.getCellRect(RowRepaintCallback.this.rowIndex, i, true));
                        }
                        if (!RowRepaintCallback.this.table.getShowHorizontalLines() && !RowRepaintCallback.this.table.getShowVerticalLines()) {
                            float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(RowRepaintCallback.this.table.getTableHeader()));
                            rectangle.y -= (int)f;
                            rectangle.height += 2 * (int)f;
                        }
                        RowRepaintCallback.this.table.repaint(rectangle);
                    }
                }
            });
        }
    }

    protected class CellRepaintCallback
    extends UIThreadTimelineCallbackAdapter {
        protected JTable table;
        protected int rowIndex;
        protected int columnIndex;

        public CellRepaintCallback(JTable jTable, int n, int n2) {
            this.table = jTable;
            this.rowIndex = n;
            this.columnIndex = n2;
        }

        public void onTimelinePulse(float f, float f2) {
            this.repaintCell();
        }

        public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
            this.repaintCell();
        }

        private void repaintCell() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubstanceTableUI.this.table == null) {
                        return;
                    }
                    int n = CellRepaintCallback.this.table.getRowCount();
                    int n2 = CellRepaintCallback.this.table.getColumnCount();
                    if (n > 0 && CellRepaintCallback.this.rowIndex < n && n2 > 0 && CellRepaintCallback.this.columnIndex < n2) {
                        Rectangle rectangle = SubstanceTableUI.this.getCellRectangleForRepaint(CellRepaintCallback.this.rowIndex, CellRepaintCallback.this.columnIndex);
                        CellRepaintCallback.this.table.repaint(rectangle);
                    }
                }
            });
        }
    }
}

