/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicTextFieldUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.RolloverTextControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceTextComponentBorder;
import org.pushingpixels.trident.swing.SwingRepaintCallback;

public class SubstanceTextFieldUI
extends BasicTextFieldUI
implements TransitionAwareUI {
    protected StateTransitionTracker stateTransitionTracker;
    protected JTextField textField;
    protected PropertyChangeListener substancePropertyChangeListener;
    private RolloverTextControlListener substanceRolloverListener;
    private ButtonModel transitionModel;
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceTextFieldUI(jComponent);
    }

    public SubstanceTextFieldUI(JComponent jComponent) {
        this.textField = (JTextField)jComponent;
        this.transitionModel = new DefaultButtonModel();
        this.transitionModel.setArmed(false);
        this.transitionModel.setSelected(false);
        this.transitionModel.setPressed(false);
        this.transitionModel.setRollover(false);
        this.transitionModel.setEnabled(this.textField.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(this.textField, this.transitionModel);
        this.stateTransitionTracker.setRepaintCallback(new StateTransitionTracker.RepaintCallback(){

            public SwingRepaintCallback getRepaintCallback() {
                return SubstanceCoreUtilities.getTextComponentRepaintCallback(SubstanceTextFieldUI.this.textField);
            }
        });
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        SubstanceTextUtilities.paintTextCompBackground(graphics, this.textField);
    }

    private void installListenersInternal() {
        super.installListeners();
        this.substanceRolloverListener = new RolloverTextControlListener(this.textField, this, this.transitionModel);
        this.substanceRolloverListener.registerListeners();
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("font".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceTextFieldUI.this.updateBorder();
                }
                if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceTextFieldUI.this.transitionModel.setEnabled(SubstanceTextFieldUI.this.textField.isEnabled());
                }
            }
        };
        this.textField.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    private void uninstallListenersInternal() {
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        this.textField.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.substanceRolloverListener.unregisterListeners();
        this.substanceRolloverListener = null;
        super.uninstallListeners();
    }

    private void updateBorder() {
        Border border = this.textField.getBorder();
        if (border == null || border instanceof UIResource) {
            BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(new SubstanceTextComponentBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.textField))), new BasicBorders.MarginBorder());
            this.textField.setBorder(compoundBorderUIResource);
        }
    }

    private void installDefaultsInternal() {
        super.installDefaults();
        this.updateBorder();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SubstanceTextFieldUI.this.textField == null) {
                    return;
                }
                Color color = SubstanceTextFieldUI.this.textField.getForeground();
                if (color == null || color instanceof UIResource) {
                    SubstanceTextFieldUI.this.textField.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceLookAndFeel.getCurrentSkin(SubstanceTextFieldUI.this.textField).getEnabledColorScheme(SubstanceLookAndFeel.getDecorationType(SubstanceTextFieldUI.this.textField))));
                }
            }
        });
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return false;
        }
        GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(this.textField, 2.0f * SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.textField)), null);
        return generalPath.contains(mouseEvent.getPoint());
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        this.installDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners() {
        this.installListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.uninstallListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }
}

