/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.lafwidget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.ButtonBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.ButtonVisualStateTracker;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceButtonBorder;
import org.pushingpixels.substance.internal.utils.icon.GlowingIcon;

public class SubstanceToggleButtonUI
extends BasicToggleButtonUI
implements TransitionAwareUI {
    private ButtonBackgroundDelegate delegate;
    protected GlowingIcon glowingIcon;
    protected PropertyChangeListener substancePropertyListener;
    protected ButtonVisualStateTracker substanceVisualStateTracker;
    protected JToggleButton toggleButton;
    private Rectangle viewRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();
    private Rectangle textRect = new Rectangle();
    protected boolean iconGhostingMarker;
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceToggleButtonUI((JToggleButton)jComponent);
    }

    public SubstanceToggleButtonUI(JToggleButton jToggleButton) {
        this.toggleButton = jToggleButton;
        this.delegate = new ButtonBackgroundDelegate();
    }

    private void installDefaultsInternal(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (abstractButton.getClientProperty("substancelaf.buttonborderoriginal") == null) {
            abstractButton.putClientProperty("substancelaf.buttonborderoriginal", abstractButton.getBorder());
        }
        if (abstractButton.getClientProperty("substancelaf.buttonborderoriginal") == null) {
            abstractButton.putClientProperty("substancelaf.buttonborderoriginal", abstractButton.getBorder());
        }
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(abstractButton);
        if (abstractButton.getClientProperty("substancelaf.buttonbordercomputed") == null) {
            abstractButton.setBorder(substanceButtonShaper.getButtonBorder(abstractButton));
        } else {
            Border border = abstractButton.getBorder();
            if (!(border instanceof SubstanceButtonBorder)) {
                abstractButton.setBorder(substanceButtonShaper.getButtonBorder(abstractButton));
            } else {
                SubstanceButtonBorder substanceButtonBorder = (SubstanceButtonBorder)border;
                if (substanceButtonShaper.getClass() != substanceButtonBorder.getButtonShaperClass()) {
                    abstractButton.setBorder(substanceButtonShaper.getButtonBorder(abstractButton));
                }
            }
        }
        abstractButton.putClientProperty("substancelaf.buttonopacityoriginal", abstractButton.isOpaque());
        abstractButton.setOpaque(false);
        abstractButton.setRolloverEnabled(true);
        LookAndFeel.installProperty(abstractButton, "iconTextGap", SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(abstractButton)));
    }

    private void uninstallDefaultsInternal(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        abstractButton.setBorder((Border)abstractButton.getClientProperty("substancelaf.buttonborderoriginal"));
        abstractButton.setOpaque((Boolean)abstractButton.getClientProperty("substancelaf.buttonopacityoriginal"));
        abstractButton.putClientProperty("substancelaf.buttonopacityoriginal", null);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return null;
    }

    private void installListenersInternal(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        this.substanceVisualStateTracker = new ButtonVisualStateTracker();
        this.substanceVisualStateTracker.installListeners(abstractButton, true);
        this.trackGlowingIcon();
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceToggleButtonUI.this.trackGlowingIcon();
                }
            }
        };
        abstractButton.addPropertyChangeListener(this.substancePropertyListener);
    }

    private void uninstallListenersInternal(AbstractButton abstractButton) {
        this.substanceVisualStateTracker.uninstallListeners(abstractButton);
        this.substanceVisualStateTracker = null;
        abstractButton.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners(abstractButton);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        this.viewRect.x = insets.left;
        this.viewRect.y = insets.top;
        this.viewRect.width = abstractButton.getWidth() - (insets.right + this.viewRect.x);
        this.viewRect.height = abstractButton.getHeight() - (insets.bottom + this.viewRect.y);
        this.textRect.height = 0;
        this.textRect.width = 0;
        this.textRect.y = 0;
        this.textRect.x = 0;
        this.iconRect.height = 0;
        this.iconRect.width = 0;
        this.iconRect.y = 0;
        this.iconRect.x = 0;
        Font font = jComponent.getFont();
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        View view = (View)jComponent.getClientProperty("html");
        graphics2D.setFont(font);
        this.delegate.updateBackground(graphics2D, abstractButton);
        if (view != null) {
            view.paint(graphics2D, this.textRect);
        } else {
            this.paintButtonText(graphics2D, abstractButton, this.textRect, string);
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon((Graphics)graphics2D, abstractButton, this.iconRect);
        }
        if (abstractButton.isFocusPainted()) {
            SubstanceCoreUtilities.paintFocus(graphics, abstractButton, abstractButton, this, null, this.textRect, 1.0f, SubstanceSizeUtils.getFocusRingPadding(SubstanceSizeUtils.getComponentFontSize(abstractButton)));
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(abstractButton);
        Dimension dimension = super.getPreferredSize(abstractButton);
        if (dimension == null) {
            return null;
        }
        if (substanceButtonShaper == null) {
            return dimension;
        }
        return substanceButtonShaper.getPreferredSize(abstractButton, dimension);
    }

    @Override
    public boolean contains(JComponent jComponent, int n, int n2) {
        return ButtonBackgroundDelegate.contains((JToggleButton)jComponent, n, n2);
    }

    @Override
    protected void paintIcon(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle) {
        abstractButton.putClientProperty("icon.bounds", new Rectangle(rectangle));
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        GhostPaintingUtils.paintGhostIcon((Graphics2D)graphics2D, (AbstractButton)abstractButton, (Rectangle)rectangle);
        graphics2D.dispose();
        this.paintIconInternal(graphics, abstractButton, rectangle);
    }

    private void paintIconInternal(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Icon icon = SubstanceCoreUtilities.getOriginalIcon(abstractButton, abstractButton.getIcon());
        Icon icon2 = !(abstractButton instanceof JRadioButton) && !(abstractButton instanceof JCheckBox) && SubstanceCoreUtilities.useThemedDefaultIcon(abstractButton) ? SubstanceCoreUtilities.getThemedIcon(abstractButton, icon) : icon;
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)abstractButton, (Graphics)graphics));
        float f = this.substanceVisualStateTracker.getStateTransitionTracker().getActiveStrength();
        if (f >= 0.0f) {
            if (AnimationConfigurationManager.getInstance().isAnimationAllowed(AnimationFacet.ICON_GLOW, (Component)abstractButton) && this.substanceVisualStateTracker.getStateTransitionTracker().getIconGlowTracker().isPlaying()) {
                this.glowingIcon.paintIcon(abstractButton, graphics2D, rectangle.x, rectangle.y);
            } else {
                icon2.paintIcon(abstractButton, graphics2D, rectangle.x, rectangle.y);
                graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)abstractButton, (float)f, (Graphics)graphics));
                icon.paintIcon(abstractButton, graphics2D, rectangle.x, rectangle.y);
            }
        } else {
            icon.paintIcon(abstractButton, graphics2D, rectangle.x, rectangle.y);
        }
        graphics2D.dispose();
    }

    protected void paintButtonText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        SubstanceTextUtilities.paintText(graphics, abstractButton, rectangle, string, abstractButton.getDisplayedMnemonicIndex());
    }

    protected void trackGlowingIcon() {
        Icon icon = this.toggleButton.getIcon();
        if (icon instanceof GlowingIcon) {
            return;
        }
        if (icon == null) {
            return;
        }
        this.glowingIcon = new GlowingIcon(icon, this.substanceVisualStateTracker.getStateTransitionTracker().getIconGlowTracker());
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.updateInternal(graphics2D, jComponent);
        graphics2D.dispose();
    }

    private void updateInternal(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        return this.contains(this.toggleButton, mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.substanceVisualStateTracker.getStateTransitionTracker();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void installDefaults(AbstractButton abstractButton) {
        this.installDefaultsInternal(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners(AbstractButton abstractButton) {
        this.installListenersInternal(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        this.uninstallDefaultsInternal(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton abstractButton) {
        this.uninstallListenersInternal(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }
}

