/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.text.View;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;

public class SubstanceToolTipUI
extends BasicToolTipUI {
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceToolTipUI();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Font font = jComponent.getFont();
        Dimension dimension = jComponent.getSize();
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        graphics.setColor(jComponent.getForeground());
        graphics.setFont(font);
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            string = "";
        }
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(insets.left + 3, insets.top, dimension.width - (insets.left + insets.right + 6), dimension.height - (insets.top + insets.bottom + 2));
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            SubstanceTextUtilities.paintText(graphics, jComponent, rectangle, string, -1, font, jComponent.getForeground(), null);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Font font = jComponent.getFont();
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null || string.equals("")) {
            string = "";
        } else {
            View view;
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                dimension.width += (int)(view.getPreferredSpan(0) + 6.0f);
                dimension.height += (int)(view.getPreferredSpan(1) + 2.0f);
            } else {
                FontMetrics fontMetrics = jComponent.getFontMetrics(font);
                dimension.width += fontMetrics.stringWidth(string) + 6;
                dimension.height += fontMetrics.getHeight() + 2;
            }
        }
        return dimension;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults(JComponent jComponent) {
        super.installDefaults(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners(JComponent jComponent) {
        super.installListeners(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults(JComponent jComponent) {
        super.uninstallDefaults(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        super.uninstallListeners(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }
}

