/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.utils.LookUtils;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTreeCellRenderer;
import org.pushingpixels.substance.internal.animation.StateTransitionMultiTracker;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.HighlightPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceStripingUtils;
import org.pushingpixels.substance.internal.utils.icon.SubstanceIconFactory;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;

public class SubstanceTreeUI
extends BasicTreeUI {
    protected Map<TreePathId, Object> selectedPaths = new HashMap<TreePathId, Object>();
    protected TreePathId currRolloverPathId;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected TreeSelectionListener substanceSelectionFadeListener;
    protected RolloverFadeListener substanceFadeRolloverListener;
    protected MouseListener substanceRowSelectionListener;
    private StateTransitionMultiTracker<TreePathId> stateTransitionMultiTracker = new StateTransitionMultiTracker();
    private SubstanceColorScheme currDefaultColorScheme;
    private Insets cellRendererInsets;
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceTreeUI();
    }

    private void updateIcon() {
        this.setExpandedIcon(new IconUIResource(SubstanceIconFactory.getTreeIcon(this.tree, false)));
        this.setCollapsedIcon(new IconUIResource(SubstanceIconFactory.getTreeIcon(this.tree, true)));
    }

    private void updateCellRendererInsets() {
        this.cellRendererInsets = SubstanceSizeUtils.getTreeCellRendererInsets(SubstanceSizeUtils.getComponentFontSize(this.tree));
    }

    private void installDefaultsInternal() {
        super.installDefaults();
        if (SubstanceCoreUtilities.toDrawWatermark(this.tree)) {
            this.tree.setOpaque(false);
        }
        if (this.tree.getSelectionPaths() != null) {
            for (TreePath treePath : this.tree.getSelectionPaths()) {
                TreePathId treePathId = new TreePathId(treePath);
                this.selectedPaths.put(treePathId, treePath.getLastPathComponent());
            }
        }
        this.updateIcon();
        this.updateCellRendererInsets();
    }

    private void uninstallDefaultsInternal() {
        this.selectedPaths.clear();
        super.uninstallDefaults();
    }

    @Override
    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n2;
        Serializable serializable;
        if (this.editingComponent != null && this.editingRow == n && this.shouldPaintExpandControl(treePath, n, bl, bl2, bl3)) {
            if (!this.tree.getComponentOrientation().isLeftToRight() && LookUtils.IS_JAVA_5) {
                rectangle2.x -= 4;
            }
            this.paintExpandControlEnforce(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
        }
        if (this.tree.hasFocus()) {
            serializable = this.tree.getLeadSelectionPath();
            n2 = this.getRowForPath(this.tree, (TreePath)serializable);
        } else {
            n2 = -1;
        }
        serializable = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, treePath.getLastPathComponent(), this.tree.isRowSelected(n), bl, bl3, n, n2 == n);
        if (!(serializable instanceof SubstanceDefaultTreeCellRenderer)) {
            super.paintRow(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
            if (this.shouldPaintExpandControl(treePath, n, bl, bl2, bl3)) {
                this.paintExpandControlEnforce(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
            }
            return;
        }
        TreePathId treePathId = new TreePathId(treePath);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.tree, (Graphics)graphics));
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.getModelStateInfo(treePathId);
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo == null ? null : modelStateInfo.getStateContributionMap();
        ComponentState componentState = modelStateInfo == null ? this.getPathState(treePathId) : modelStateInfo.getCurrModelState();
        boolean bl5 = false;
        if (((Component)serializable).isEnabled()) {
            if (map != null) {
                object4 = map.entrySet().iterator();
                while (object4.hasNext() && !(bl5 = SubstanceColorSchemeUtilities.getHighlightAlpha(this.tree, (ComponentState)(object3 = (Map.Entry)object4.next()).getKey()) * ((StateTransitionTracker.StateContributionInfo)object3.getValue()).getContribution() > 0.0f)) {
                }
            } else {
                bl5 = SubstanceColorSchemeUtilities.getHighlightAlpha(this.tree, componentState) > 0.0f;
            }
        }
        object4 = this.tree.getDropLocation();
        object3 = new Rectangle(this.tree.getInsets().left, rectangle2.y, this.tree.getWidth() - this.tree.getInsets().right - this.tree.getInsets().left, rectangle2.height);
        if (object4 != null && ((JTree.DropLocation)object4).getChildIndex() == -1 && this.tree.getRowForPath(((JTree.DropLocation)object4).getPath()) == n) {
            object2 = SubstanceColorSchemeUtilities.getColorScheme(this.tree, ColorSchemeAssociationKind.TEXT_HIGHLIGHT, componentState);
            entry = SubstanceColorSchemeUtilities.getColorScheme(this.tree, ColorSchemeAssociationKind.BORDER, componentState);
            HighlightPainterUtils.paintHighlight(graphics2D, this.rendererPane, (Component)serializable, (Rectangle)object3, 0.8f, null, (SubstanceColorScheme)object2, (SubstanceColorScheme)((Object)entry));
        } else if (bl5) {
            if (map == null) {
                float f = SubstanceColorSchemeUtilities.getHighlightAlpha(this.tree, componentState);
                if (f > 0.0f) {
                    entry = SubstanceColorSchemeUtilities.getColorScheme(this.tree, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
                    object = SubstanceColorSchemeUtilities.getColorScheme(this.tree, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.tree, (float)f, (Graphics)graphics));
                    HighlightPainterUtils.paintHighlight(graphics2D, this.rendererPane, (Component)serializable, (Rectangle)object3, 0.8f, null, (SubstanceColorScheme)((Object)entry), (SubstanceColorScheme)object);
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.tree, (Graphics)graphics));
                }
            } else {
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
                    object = entry.getKey();
                    float f = SubstanceColorSchemeUtilities.getHighlightAlpha(this.tree, (ComponentState)object) * ((StateTransitionTracker.StateContributionInfo)entry.getValue()).getContribution();
                    if (f == 0.0f) continue;
                    SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tree, ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)object);
                    SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.tree, ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)object);
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.tree, (float)f, (Graphics)graphics));
                    HighlightPainterUtils.paintHighlight(graphics2D, this.rendererPane, (Component)serializable, (Rectangle)object3, 0.8f, null, substanceColorScheme, substanceColorScheme2);
                    graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.tree, (Graphics)graphics));
                }
            }
        }
        object2 = (JComponent)serializable;
        boolean bl6 = bl4 = !this.tree.isRowSelected(n);
        if (SubstanceCoreUtilities.toDrawWatermark(this.tree)) {
            bl4 = false;
        }
        object = new HashMap();
        if (!bl4) {
            SubstanceCoreUtilities.makeNonOpaque((Component)object2, (Map<Component, Boolean>)object);
        }
        this.rendererPane.paintComponent(graphics2D, (Component)serializable, this.tree, rectangle2.x, rectangle2.y, Math.max(this.tree.getWidth() - this.tree.getInsets().right - this.tree.getInsets().left - rectangle2.x, rectangle2.width), rectangle2.height, true);
        if (!bl4) {
            SubstanceCoreUtilities.restoreOpaque((Component)object2, (Map<Component, Boolean>)object);
        }
        if (this.shouldPaintExpandControl(treePath, n, bl, bl2, bl3)) {
            this.paintExpandControlEnforce(graphics2D, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
        }
        graphics2D.dispose();
    }

    @Override
    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
    }

    protected void paintExpandControlEnforce(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        float f = SubstanceColorSchemeUtilities.getAlpha(this.tree, this.tree.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.tree, (float)f, (Graphics)graphics));
        super.paintExpandControl(graphics2D, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
        graphics2D.dispose();
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new SubstanceDefaultTreeCellRenderer();
    }

    private void installListenersInternal() {
        super.installListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("substancelaf.watermark.visible".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceTreeUI.this.tree.setOpaque(!SubstanceCoreUtilities.toDrawWatermark(SubstanceTreeUI.this.tree));
                }
                if ("font".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceTreeUI.this.updateIcon();
                    SubstanceTreeUI.this.updateCellRendererInsets();
                }
                if ("dropLocation".equals(propertyChangeEvent.getPropertyName())) {
                    Serializable serializable;
                    Object object;
                    JTree.DropLocation dropLocation = (JTree.DropLocation)propertyChangeEvent.getOldValue();
                    if (dropLocation != null) {
                        object = dropLocation.getPath();
                        serializable = SubstanceTreeUI.this.getPathBounds(SubstanceTreeUI.this.tree, (TreePath)object);
                        SubstanceTreeUI.this.tree.repaint(0, ((Rectangle)serializable).y, SubstanceTreeUI.this.tree.getWidth(), ((Rectangle)serializable).height);
                    }
                    if ((object = SubstanceTreeUI.this.tree.getDropLocation()) != null && (serializable = ((JTree.DropLocation)object).getPath()) != null) {
                        Rectangle rectangle = SubstanceTreeUI.this.getPathBounds(SubstanceTreeUI.this.tree, (TreePath)serializable);
                        SubstanceTreeUI.this.tree.repaint(0, rectangle.y, SubstanceTreeUI.this.tree.getWidth(), rectangle.height);
                    }
                }
            }
        };
        this.tree.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceSelectionFadeListener = new MyTreeSelectionListener();
        this.tree.getSelectionModel().addTreeSelectionListener(this.substanceSelectionFadeListener);
        this.substanceRowSelectionListener = new RowSelectionListener();
        this.tree.addMouseListener(this.substanceRowSelectionListener);
        this.substanceFadeRolloverListener = new RolloverFadeListener();
        this.tree.addMouseMotionListener(this.substanceFadeRolloverListener);
        this.tree.addMouseListener(this.substanceFadeRolloverListener);
    }

    private void uninstallListenersInternal() {
        this.tree.removeMouseListener(this.substanceRowSelectionListener);
        this.substanceRowSelectionListener = null;
        this.tree.getSelectionModel().removeTreeSelectionListener(this.substanceSelectionFadeListener);
        this.substanceSelectionFadeListener = null;
        this.tree.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.tree.removeMouseMotionListener(this.substanceFadeRolloverListener);
        this.tree.removeMouseListener(this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        super.uninstallListeners();
    }

    public int getPivotRendererX(Rectangle rectangle) {
        TreePath treePath = this.getClosestPathForLocation(this.tree, 0, rectangle.y);
        Enumeration<TreePath> enumeration = this.treeState.getVisiblePathsFrom(treePath);
        int n = rectangle.y + rectangle.height;
        int n2 = 0;
        int n3 = 0;
        if (treePath != null && enumeration != null) {
            boolean bl = false;
            Rectangle rectangle2 = new Rectangle();
            Insets insets = this.tree.getInsets();
            while (!bl && enumeration.hasMoreElements()) {
                TreePath treePath2 = enumeration.nextElement();
                if (treePath2 != null) {
                    Rectangle rectangle3 = this.treeState.getBounds(treePath2, rectangle2);
                    rectangle3.x += insets.left;
                    rectangle3.y += insets.top;
                    int n4 = rectangle3.x;
                    n2 += n4;
                    ++n3;
                    if (rectangle3.y + rectangle3.height < n) continue;
                    bl = true;
                    continue;
                }
                bl = true;
            }
        }
        if (n3 == 0) {
            return -1;
        }
        return n2 / n3 - 2 * SubstanceSizeUtils.getTreeIconSize(SubstanceSizeUtils.getComponentFontSize(this.tree));
    }

    public ComponentState getPathState(TreePathId treePathId) {
        boolean bl = this.tree.isEnabled();
        StateTransitionTracker stateTransitionTracker = this.stateTransitionMultiTracker.getTracker(treePathId);
        if (stateTransitionTracker == null) {
            int n = this.tree.getRowForPath(treePathId.path);
            boolean bl2 = this.currRolloverPathId != null && treePathId.equals(this.currRolloverPathId);
            boolean bl3 = this.tree.isRowSelected(n);
            return ComponentState.getState(bl, bl2, bl3);
        }
        ComponentState componentState = stateTransitionTracker.getModelStateInfo().getCurrModelState();
        return ComponentState.getState(bl, componentState.isFacetActive(ComponentStateFacet.ROLLOVER), componentState.isFacetActive(ComponentStateFacet.SELECTION));
    }

    public StateTransitionTracker.ModelStateInfo getModelStateInfo(TreePathId treePathId) {
        if (this.stateTransitionMultiTracker.size() == 0) {
            return null;
        }
        StateTransitionTracker stateTransitionTracker = this.stateTransitionMultiTracker.getTracker(treePathId);
        if (stateTransitionTracker == null) {
            return null;
        }
        return stateTransitionTracker.getModelStateInfo();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.updateInternal(graphics2D, jComponent);
        graphics2D.dispose();
    }

    private void updateInternal(Graphics graphics, JComponent jComponent) {
        BackgroundPaintingUtils.updateIfOpaque(graphics, jComponent);
        if (this.treeState == null) {
            return;
        }
        this.currDefaultColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.tree, ComponentState.ENABLED);
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.tree.getInsets();
        TreePath treePath = this.getClosestPathForLocation(this.tree, 0, rectangle.y);
        Enumeration<TreePath> enumeration = this.treeState.getVisiblePathsFrom(treePath);
        int n = this.treeState.getRowForPath(treePath);
        int n2 = rectangle.y + rectangle.height;
        boolean bl = SubstanceCoreUtilities.toDrawWatermark(this.tree) || !this.tree.isOpaque();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        SubstanceStripingUtils.setup(jComponent);
        if (treePath != null && enumeration != null) {
            boolean bl2 = false;
            Rectangle rectangle2 = new Rectangle();
            while (!bl2 && enumeration.hasMoreElements()) {
                TreePath treePath2 = enumeration.nextElement();
                if (treePath2 != null) {
                    Rectangle rectangle3;
                    boolean bl3 = this.treeModel.isLeaf(treePath2.getLastPathComponent());
                    boolean bl4 = bl3 ? false : this.treeState.getExpandedState(treePath2);
                    Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, treePath2.getLastPathComponent(), this.tree.isRowSelected(n), bl4, bl3, n, this.tree.hasFocus() ? this.tree.getLeadSelectionRow() == n : false);
                    Color color = component.getBackground();
                    if (color == null) {
                        color = this.tree.getBackground();
                    }
                    if ((rectangle3 = this.treeState.getBounds(treePath2, rectangle2)) != null) {
                        rectangle3.x += insets.left;
                        rectangle3.y += insets.top;
                        if (!bl) {
                            graphics2D.setColor(color);
                            graphics2D.fillRect(rectangle.x, rectangle3.y, rectangle.width, rectangle3.height);
                        } else if (this.tree.getComponentOrientation().isLeftToRight()) {
                            BackgroundPaintingUtils.fillAndWatermark(graphics2D, this.tree, color, new Rectangle(rectangle.x, rectangle3.y, rectangle.width, rectangle3.height));
                        } else {
                            BackgroundPaintingUtils.fillAndWatermark(graphics2D, this.tree, color, new Rectangle(rectangle.x, rectangle3.y, rectangle.width, rectangle3.height));
                        }
                        if (rectangle3.y + rectangle3.height >= n2) {
                            bl2 = true;
                        }
                    }
                } else {
                    bl2 = true;
                }
                ++n;
            }
        }
        this.paint(graphics2D, jComponent);
        SubstanceStripingUtils.tearDown(jComponent);
        graphics2D.dispose();
    }

    public SubstanceColorScheme getDefaultColorScheme() {
        return this.currDefaultColorScheme;
    }

    public Insets getCellRendererInsets() {
        return this.cellRendererInsets;
    }

    @Override
    public Rectangle getPathBounds(JTree jTree, TreePath treePath) {
        Rectangle rectangle = super.getPathBounds(jTree, treePath);
        if (rectangle != null && !jTree.getComponentOrientation().isLeftToRight()) {
            int n = rectangle.x - jTree.getInsets().left;
            rectangle.x -= n;
            rectangle.width += n;
        }
        return rectangle;
    }

    private StateTransitionTracker getTracker(final TreePathId treePathId, boolean bl, boolean bl2) {
        StateTransitionTracker stateTransitionTracker = this.stateTransitionMultiTracker.getTracker(treePathId);
        if (stateTransitionTracker == null) {
            DefaultButtonModel defaultButtonModel = new DefaultButtonModel();
            defaultButtonModel.setSelected(bl2);
            defaultButtonModel.setRollover(bl);
            stateTransitionTracker = new StateTransitionTracker(this.tree, defaultButtonModel);
            stateTransitionTracker.registerModelListeners();
            stateTransitionTracker.setRepaintCallback(new StateTransitionTracker.RepaintCallback(){

                @Override
                public TimelineCallback getRepaintCallback() {
                    return new PathRepaintCallback(SubstanceTreeUI.this.tree, treePathId.path);
                }
            });
            this.stateTransitionMultiTracker.addTracker(treePathId, stateTransitionTracker);
        }
        return stateTransitionTracker;
    }

    public StateTransitionTracker getStateTransitionTracker(TreePathId treePathId) {
        return this.stateTransitionMultiTracker.getTracker(treePathId);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        this.installDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    @Override
    protected void installListeners() {
        this.installListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        this.uninstallDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallComponents() {
        super.uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.uninstallListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public static class TreePathId
    implements Comparable {
        protected TreePath path;

        public TreePathId(TreePath treePath) {
            this.path = treePath;
        }

        public int compareTo(Object object) {
            if (object instanceof TreePathId) {
                Object[] objectArray;
                TreePathId treePathId = (TreePathId)object;
                if (this.path == null && treePathId.path != null) {
                    return 1;
                }
                if (treePathId.path == null && this.path != null) {
                    return -1;
                }
                Object[] objectArray2 = this.path.getPath();
                if (objectArray2.length != (objectArray = treePathId.path.getPath()).length) {
                    return 1;
                }
                for (int i = 0; i < objectArray2.length; ++i) {
                    if (objectArray2[i].equals(objectArray[i])) continue;
                    return 1;
                }
                return 0;
            }
            return -1;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int hashCode() {
            if (this.path == null) {
                return 0;
            }
            Object[] objectArray = this.path.getPath();
            int n = objectArray[0].hashCode();
            for (int i = 1; i < objectArray.length; ++i) {
                n ^= objectArray[i].hashCode();
            }
            return n;
        }
    }

    protected class MyTreeSelectionListener
    implements TreeSelectionListener {
        protected MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (SubstanceTreeUI.this.tree.getSelectionPaths() != null) {
                for (TreePath object : SubstanceTreeUI.this.tree.getSelectionPaths()) {
                    TreePathId treePathId = new TreePathId(object);
                    if (SubstanceTreeUI.this.selectedPaths.containsKey(treePathId)) continue;
                    StateTransitionTracker stateTransitionTracker = SubstanceTreeUI.this.getTracker(treePathId, SubstanceTreeUI.this.currRolloverPathId != null && treePathId.equals(SubstanceTreeUI.this.currRolloverPathId), false);
                    stateTransitionTracker.getModel().setSelected(true);
                    SubstanceTreeUI.this.selectedPaths.put(treePathId, object.getLastPathComponent());
                }
            }
            Iterator<Map.Entry<TreePathId, Object>> iterator = SubstanceTreeUI.this.selectedPaths.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (SubstanceTreeUI.this.tree.getSelectionModel().isPathSelected(((TreePathId)entry.getKey()).path)) continue;
                TreePathId treePathId = (TreePathId)entry.getKey();
                StateTransitionTracker stateTransitionTracker = SubstanceTreeUI.this.getTracker(treePathId, SubstanceTreeUI.this.currRolloverPathId != null && treePathId.equals(SubstanceTreeUI.this.currRolloverPathId), true);
                stateTransitionTracker.getModel().setSelected(false);
                iterator.remove();
            }
        }
    }

    private class RowSelectionListener
    extends MouseAdapter {
        private RowSelectionListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
            TreePath treePath = SubstanceTreeUI.this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            Rectangle rectangle = SubstanceTreeUI.this.tree.getPathBounds(treePath);
            if (mouseEvent.getY() >= rectangle.y && mouseEvent.getY() < rectangle.y + rectangle.height && (mouseEvent.getX() < rectangle.x || mouseEvent.getX() > rectangle.x + rectangle.width)) {
                if (SubstanceTreeUI.this.isLocationInExpandControl(treePath, mouseEvent.getX(), mouseEvent.getY())) {
                    return;
                }
                SubstanceTreeUI.this.selectPathForEvent(treePath, mouseEvent);
            }
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
            this.fadeOut();
            SubstanceTreeUI.this.currRolloverPathId = null;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
            this.handleMove(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!SubstanceTreeUI.this.tree.isEnabled()) {
                return;
            }
            this.handleMove(mouseEvent);
        }

        private void handleMove(MouseEvent mouseEvent) {
            TreePath treePath = SubstanceTreeUI.this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            Rectangle rectangle = SubstanceTreeUI.this.tree.getPathBounds(treePath);
            if (rectangle == null) {
                this.fadeOut();
                SubstanceTreeUI.this.currRolloverPathId = null;
                return;
            }
            if (mouseEvent.getY() < rectangle.y || mouseEvent.getY() > rectangle.y + rectangle.height) {
                this.fadeOut();
                SubstanceTreeUI.this.currRolloverPathId = null;
                return;
            }
            TreePathId treePathId = new TreePathId(treePath);
            if (SubstanceTreeUI.this.currRolloverPathId != null && treePathId.equals(SubstanceTreeUI.this.currRolloverPathId)) {
                return;
            }
            this.fadeOut();
            StateTransitionTracker stateTransitionTracker = SubstanceTreeUI.this.getTracker(treePathId, false, SubstanceTreeUI.this.selectedPaths.containsKey(treePathId));
            stateTransitionTracker.getModel().setRollover(true);
            SubstanceTreeUI.this.currRolloverPathId = treePathId;
        }

        private void fadeOut() {
            if (SubstanceTreeUI.this.currRolloverPathId == null) {
                return;
            }
            StateTransitionTracker stateTransitionTracker = SubstanceTreeUI.this.getTracker(SubstanceTreeUI.this.currRolloverPathId, true, SubstanceTreeUI.this.selectedPaths.containsKey(SubstanceTreeUI.this.currRolloverPathId));
            stateTransitionTracker.getModel().setRollover(false);
        }
    }

    protected class PathRepaintCallback
    extends UIThreadTimelineCallbackAdapter {
        protected JTree tree;
        protected TreePath treePath;

        public PathRepaintCallback(JTree jTree, TreePath treePath) {
            this.tree = jTree;
            this.treePath = treePath;
        }

        public void onTimelinePulse(float f, float f2) {
            this.repaintPath();
        }

        public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
            this.repaintPath();
        }

        private void repaintPath() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubstanceTreeUI.this.tree == null) {
                        return;
                    }
                    Rectangle rectangle = new Rectangle();
                    Rectangle rectangle2 = SubstanceTreeUI.this.treeState.getBounds(PathRepaintCallback.this.treePath, rectangle);
                    if (rectangle2 != null) {
                        rectangle2.x = 0;
                        rectangle2.width = PathRepaintCallback.this.tree.getWidth();
                        Insets insets = PathRepaintCallback.this.tree.getInsets();
                        rectangle2.x += insets.left;
                        rectangle2.y += insets.top;
                        PathRepaintCallback.this.tree.repaint(rectangle2);
                    }
                }
            });
        }
    }
}

