/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicViewportUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceViewportUI
extends BasicViewportUI {
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceViewportUI();
    }

    private void installDefaultsInternal(JComponent jComponent) {
        Color color;
        super.installDefaults(jComponent);
        Color color2 = jComponent.getBackground();
        if ((color2 == null || color2 instanceof UIResource) && (color = SubstanceColorUtilities.getBackgroundFillColor(jComponent)) != null) {
            jComponent.setBackground(new ColorUIResource(color));
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.updateInternal(graphics2D, jComponent);
        graphics2D.dispose();
    }

    private void updateInternal(Graphics graphics, JComponent jComponent) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        if (this.toPaintBackground(jComponent)) {
            BackgroundPaintingUtils.update(graphics, jComponent, false);
        }
        super.paint(graphics, jComponent);
    }

    protected boolean toPaintBackground(JComponent jComponent) {
        return SubstanceCoreUtilities.isOpaque(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults(JComponent jComponent) {
        this.installDefaultsInternal(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults(JComponent jComponent) {
        super.uninstallDefaults(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }
}

