/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.SoftHashMap;

public class LazyResettableHashMap<T> {
    private static final Object staticLock = new Object();
    private final Object instanceLock = new Object();
    private static List<LazyResettableHashMap<?>> all;
    private Map<HashMapKey, T> cache;
    private String displayName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyResettableHashMap(String string) {
        this.displayName = string;
        Object object = staticLock;
        synchronized (object) {
            if (all == null) {
                all = new LinkedList();
            }
            all.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIfNecessary() {
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.cache == null) {
                this.cache = new SoftHashMap<HashMapKey, T>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(HashMapKey hashMapKey, T t) {
        Object object = this.instanceLock;
        synchronized (object) {
            this.createIfNecessary();
            this.cache.put(hashMapKey, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(HashMapKey hashMapKey) {
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.cache == null) {
                return null;
            }
            return this.cache.get(hashMapKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(HashMapKey hashMapKey) {
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.cache == null) {
                return false;
            }
            return this.cache.containsKey(hashMapKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.cache == null) {
                return 0;
            }
            return this.cache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = staticLock;
        synchronized (object) {
            if (all != null) {
                for (LazyResettableHashMap<?> lazyResettableHashMap : all) {
                    Object object2 = lazyResettableHashMap.instanceLock;
                    synchronized (object2) {
                        if (lazyResettableHashMap.cache != null) {
                            lazyResettableHashMap.cache.clear();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getStats() {
        Object object = staticLock;
        synchronized (object) {
            if (all != null) {
                String string;
                LinkedList<String> linkedList = new LinkedList<String>();
                TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
                TreeMap<String, Integer> treeMap2 = new TreeMap<String, Integer>();
                for (LazyResettableHashMap<?> object2 : all) {
                    string = object2.displayName;
                    if (!treeMap.containsKey(string)) {
                        treeMap.put(string, 0);
                        treeMap2.put(string, 0);
                    }
                    treeMap.put(string, (Integer)treeMap.get(string) + 1);
                    treeMap2.put(string, (Integer)treeMap2.get(string) + object2.size());
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    string = (String)entry.getKey();
                    linkedList.add(String.valueOf(entry.getValue()) + " " + string + " with " + String.valueOf(treeMap2.get(string)) + " entries total");
                }
                return linkedList;
            }
            return null;
        }
    }
}

