/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.pushingpixels.lafwidget.utils.TrackableThread;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;

public class MemoryAnalyzer
extends TrackableThread {
    private long delay;
    private String filename;
    private static MemoryAnalyzer instance;
    private static boolean isStopRequest;
    private static ArrayList<String> usages;
    private static SimpleDateFormat sdf;

    private MemoryAnalyzer(long l, String string) {
        this.delay = l;
        this.filename = string;
        this.setName("Substance memory analyzer");
    }

    public static synchronized void commence(long l, String string) {
        if (instance == null) {
            instance = new MemoryAnalyzer(l, string);
            usages = new ArrayList();
            sdf = new SimpleDateFormat("HH:mm:ss.SSS");
            instance.start();
        }
    }

    public synchronized void requestStop() {
        isStopRequest = true;
    }

    private static synchronized boolean hasStopRequest() {
        return isStopRequest;
    }

    public static boolean isRunning() {
        return instance != null;
    }

    public static synchronized void enqueueUsage(String string) {
        if (instance != null) {
            usages.add(sdf.format(new Date()) + ": " + string);
        }
    }

    public static synchronized ArrayList<String> getUsages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : usages) {
            arrayList.add(string);
        }
        usages.clear();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BufferedWriter bufferedWriter = null;
                    try {
                        bufferedWriter = new BufferedWriter(new FileWriter(new File(MemoryAnalyzer.this.filename), true));
                        bufferedWriter.write(sdf.format(new Date()) + "\n");
                        UIDefaults uIDefaults = UIManager.getLookAndFeel().getDefaults();
                        Set set = uIDefaults.keySet();
                        LinkedList<String> linkedList = new LinkedList<String>();
                        for (Object object : set) {
                            linkedList.add((String)object);
                        }
                        Collections.sort(linkedList);
                        for (String string : linkedList) {
                            Object object = uIDefaults.get(string);
                            if (object instanceof Integer) {
                                int string2 = uIDefaults.getInt(string);
                                bufferedWriter.write(string + " (int) : " + string2);
                            } else if (object instanceof Boolean) {
                                boolean dimension = uIDefaults.getBoolean(string);
                                bufferedWriter.write(string + " (bool) : " + dimension);
                            } else if (object instanceof String) {
                                String insets = uIDefaults.getString(string);
                                bufferedWriter.write(string + " (string) : " + insets);
                            } else if (object instanceof Dimension) {
                                Dimension color = uIDefaults.getDimension(string);
                                bufferedWriter.write(string + " (Dimension) : " + color.width + "*" + color.height);
                            } else if (object instanceof Insets) {
                                Insets font = uIDefaults.getInsets(string);
                                bufferedWriter.write(string + " (Insets) : " + font.top + "*" + font.left + "*" + font.bottom + "*" + font.right);
                            } else if (object instanceof Color) {
                                Color color = uIDefaults.getColor(string);
                                bufferedWriter.write(string + " (int) : " + color.getRed() + "," + color.getGreen() + "," + color.getBlue());
                            } else if (object instanceof Font) {
                                Font font = uIDefaults.getFont(string);
                                bufferedWriter.write(string + " (Font) : " + font.getFontName() + "*" + font.getSize());
                            } else {
                                bufferedWriter.write(string + " (Object) : " + String.valueOf(uIDefaults.get(string)));
                            }
                            bufferedWriter.write("\n");
                        }
                    }
                    catch (IOException iOException) {
                        MemoryAnalyzer.this.requestStop();
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        if (bufferedWriter != null) {
                            try {
                                bufferedWriter.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            this.requestStop();
        }
        BufferedWriter bufferedWriter = null;
        while (!MemoryAnalyzer.hasStopRequest()) {
            bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(new File(this.filename), true));
                bufferedWriter.write(sdf.format(new Date()) + "\n");
                List<String> list = LazyResettableHashMap.getStats();
                if (list != null) {
                    for (String object2 : list) {
                        bufferedWriter.write(object2 + "\n");
                    }
                }
                ArrayList<String> arrayList = MemoryAnalyzer.getUsages();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    bufferedWriter.write(string + "\n");
                }
                bufferedWriter.write("UIManager has " + UIManager.getDefaults().size() + " entries\n");
                long l = Runtime.getRuntime().totalMemory();
                long l2 = Runtime.getRuntime().freeMemory();
                int n = (int)(l / 1024L);
                int n2 = (int)((l - l2) / 1024L);
                bufferedWriter.write("Heap : " + n2 + " / " + n);
                bufferedWriter.write("\n");
            }
            catch (IOException iOException) {
                this.requestStop();
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                MemoryAnalyzer.sleep((long)this.delay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static {
        isStopRequest = false;
    }
}

