/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.JMenuItem;
import javax.swing.event.MouseInputListener;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;

public class RolloverMenuItemListener
implements MouseInputListener {
    private boolean isMouseInside;
    private JMenuItem item;
    private StateTransitionTracker stateTransitionTracker;

    public RolloverMenuItemListener(JMenuItem jMenuItem, StateTransitionTracker stateTransitionTracker) {
        this.item = jMenuItem;
        this.stateTransitionTracker = stateTransitionTracker;
        this.isMouseInside = false;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            this.isMouseInside = true;
            this.item.getModel().setRollover(true);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            this.isMouseInside = false;
            this.item.getModel().setRollover(false);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            ButtonModel buttonModel = this.item.getModel();
            buttonModel.setRollover(false);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            this.item.getModel().setRollover(this.isMouseInside);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }
}

