/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;

public class RolloverTextControlListener
implements MouseListener,
MouseMotionListener,
FocusListener {
    private boolean isMouseInside;
    private ButtonModel model;
    private TransitionAwareUI trackableUI;
    private StateTransitionTracker stateTransitionTracker;
    private JComponent component;

    public RolloverTextControlListener(JComponent jComponent, TransitionAwareUI transitionAwareUI, ButtonModel buttonModel) {
        this.component = jComponent;
        this.trackableUI = transitionAwareUI;
        this.model = buttonModel;
        this.isMouseInside = false;
        this.stateTransitionTracker = this.trackableUI.getTransitionTracker();
    }

    public void registerListeners() {
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
        this.component.addFocusListener(this);
    }

    public void unregisterListeners() {
        this.component.removeMouseListener(this);
        this.component.removeMouseMotionListener(this);
        this.component.removeFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            this.model.setSelected(true);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            this.model.setSelected(false);
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            boolean bl;
            Component component = (Component)mouseEvent.getSource();
            if (!component.isEnabled()) {
                return;
            }
            this.isMouseInside = bl = this.trackableUI.isInside(mouseEvent);
            this.model.setRollover(bl);
            this.model.setEnabled(component.isEnabled());
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            Component component = (Component)mouseEvent.getSource();
            if (!component.isEnabled()) {
                return;
            }
            this.isMouseInside = false;
            this.model.setRollover(false);
            this.model.setEnabled(component.isEnabled());
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            boolean bl;
            Component component = (Component)mouseEvent.getSource();
            if (!component.isEnabled()) {
                return;
            }
            this.isMouseInside = bl = this.trackableUI.isInside(mouseEvent);
            this.model.setRollover(this.isMouseInside);
            this.model.setEnabled(component.isEnabled());
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            boolean bl;
            Component component = (Component)mouseEvent.getSource();
            if (!component.isEnabled()) {
                return;
            }
            this.isMouseInside = bl = this.trackableUI.isInside(mouseEvent);
            this.model.setRollover(this.isMouseInside);
            this.model.setEnabled(component.isEnabled());
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            boolean bl;
            Component component = (Component)mouseEvent.getSource();
            if (!component.isEnabled()) {
                return;
            }
            this.isMouseInside = bl = this.trackableUI.isInside(mouseEvent);
            this.model.setEnabled(component.isEnabled());
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.stateTransitionTracker.turnOffModelChangeTracking();
        try {
            boolean bl;
            Component component = (Component)mouseEvent.getSource();
            if (!component.isEnabled()) {
                return;
            }
            this.isMouseInside = bl = this.trackableUI.isInside(mouseEvent);
            this.model.setRollover(bl);
            this.model.setEnabled(component.isEnabled());
        }
        finally {
            this.stateTransitionTracker.onModelStateChanged();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

