/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceColorUtilities {
    private static final ComponentState EDITABLE = new ComponentState("editable", ComponentState.ENABLED, new ComponentStateFacet[]{ComponentStateFacet.ENABLE, ComponentStateFacet.EDITABLE}, null);
    private static final ComponentState UNEDITABLE = new ComponentState("uneditable", ComponentState.DISABLED_SELECTED, new ComponentStateFacet[]{ComponentStateFacet.ENABLE}, new ComponentStateFacet[]{ComponentStateFacet.EDITABLE});
    private static final ComponentState EDITABLE_DISABLED = new ComponentState("editable disabled", ComponentState.DISABLED_UNSELECTED, new ComponentStateFacet[]{ComponentStateFacet.EDITABLE}, new ComponentStateFacet[]{ComponentStateFacet.ENABLE});
    private static final ComponentState UNEDITABLE_DISABLED = new ComponentState("uneditable disabled", ComponentState.DISABLED_UNSELECTED, null, new ComponentStateFacet[]{ComponentStateFacet.ENABLE, ComponentStateFacet.EDITABLE});

    public static Color getTopBorderColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getUltraDarkColor();
    }

    public static Color getMidBorderColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getDarkColor();
    }

    public static Color getBottomBorderColor(SubstanceColorScheme substanceColorScheme) {
        return SubstanceColorUtilities.getInterpolatedColor(substanceColorScheme.getDarkColor(), substanceColorScheme.getMidColor(), 0.5);
    }

    public static Color getTopFillColor(SubstanceColorScheme substanceColorScheme) {
        Color color = SubstanceColorUtilities.getInterpolatedColor(substanceColorScheme.getDarkColor(), substanceColorScheme.getMidColor(), 0.4);
        return color;
    }

    public static Color getMidFillColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getMidColor();
    }

    public static Color getBottomFillColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getUltraLightColor();
    }

    public static Color getTopShineColor(SubstanceColorScheme substanceColorScheme) {
        return SubstanceColorUtilities.getBottomFillColor(substanceColorScheme);
    }

    public static Color getBottomShineColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getLightColor();
    }

    public static int getInterpolatedRGB(Color color, Color color2, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Color likeness should be in 0.0-1.0 range [is " + d + "]");
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        int n5 = color2.getRed();
        int n6 = color2.getGreen();
        int n7 = color2.getBlue();
        int n8 = color2.getAlpha();
        int n9 = n == n5 ? n : (int)Math.round(d * (double)n + (1.0 - d) * (double)n5);
        int n10 = n2 == n6 ? n2 : (int)Math.round(d * (double)n2 + (1.0 - d) * (double)n6);
        int n11 = n3 == n7 ? n3 : (int)Math.round(d * (double)n3 + (1.0 - d) * (double)n7);
        int n12 = n4 == n8 ? n4 : (int)Math.round(d * (double)n4 + (1.0 - d) * (double)n8);
        return n12 << 24 | n9 << 16 | n10 << 8 | n11;
    }

    public static Color getInterpolatedColor(Color color, Color color2, double d) {
        if (color.equals(color2)) {
            return color;
        }
        if (d == 1.0) {
            return color;
        }
        if (d == 0.0) {
            return color2;
        }
        return new Color(SubstanceColorUtilities.getInterpolatedRGB(color, color2, d), true);
    }

    public static Color invertColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static Color getNegativeColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static int getNegativeColor(int n) {
        int n2 = n >>> 24 & 0xFF;
        int n3 = n >>> 16 & 0xFF;
        int n4 = n >>> 8 & 0xFF;
        int n5 = n >>> 0 & 0xFF;
        return n2 << 24 | 255 - n3 << 16 | 255 - n4 << 8 | 255 - n5;
    }

    public static Color getAlphaColor(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static Color getSaturatedColor(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        if (n == n2 || n2 == n3) {
            return color;
        }
        float[] fArray = new float[3];
        Color.RGBtoHSB(n, n2, n3, fArray);
        float f = fArray[1];
        f = d > 0.0 ? (f += (float)d * (1.0f - f)) : (f += (float)d * f);
        return new Color(Color.HSBtoRGB(fArray[0], f, fArray[2]));
    }

    public static Color getHueShiftedColor(Color color, double d) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f = fArray[0];
        f = (float)((double)f + d);
        if ((double)f < 0.0) {
            f = (float)((double)f + 1.0);
        }
        if ((double)f > 1.0) {
            f = (float)((double)f - 1.0);
        }
        return new Color(Color.HSBtoRGB(f, fArray[1], fArray[2]));
    }

    public static Color deriveByBrightness(Color color, Color color2) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float[] fArray2 = new float[3];
        Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), fArray2);
        return new Color(Color.HSBtoRGB(fArray[0], fArray[1], (fArray2[2] + fArray[2]) / 2.0f));
    }

    public static ColorUIResource getForegroundColor(SubstanceColorScheme substanceColorScheme) {
        return new ColorUIResource(substanceColorScheme.getForegroundColor());
    }

    public static Color getLighterColor(Color color, double d) {
        int n = color.getRed() + (int)(d * (double)(255 - color.getRed()));
        int n2 = color.getGreen() + (int)(d * (double)(255 - color.getGreen()));
        int n3 = color.getBlue() + (int)(d * (double)(255 - color.getBlue()));
        return new Color(n, n2, n3);
    }

    public static Color getDarkerColor(Color color, double d) {
        int n = (int)((1.0 - d) * (double)color.getRed());
        int n2 = (int)((1.0 - d) * (double)color.getGreen());
        int n3 = (int)((1.0 - d) * (double)color.getBlue());
        return new Color(n, n2, n3);
    }

    public static int getColorBrightness(int n) {
        int n2 = n >>> 16 & 0xFF;
        int n3 = n >>> 8 & 0xFF;
        int n4 = n >>> 0 & 0xFF;
        return (222 * n2 + 707 * n3 + 71 * n4) / 1000;
    }

    public static Color getFocusColor(Component component, TransitionAwareUI transitionAwareUI) {
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState componentState = modelStateInfo.getCurrModelState();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, ColorSchemeAssociationKind.MARK, componentState);
        if (componentState.isDisabled() || map == null || map.size() == 1) {
            return substanceColorScheme.getFocusRingColor();
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
            ComponentState componentState2 = entry.getKey();
            float f4 = entry.getValue().getContribution();
            SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(component, ColorSchemeAssociationKind.MARK, componentState2);
            Color color = substanceColorScheme2.getFocusRingColor();
            f += f4 * (float)color.getRed();
            f2 += f4 * (float)color.getGreen();
            f3 += f4 * (float)color.getBlue();
        }
        return new Color((int)f, (int)f2, (int)f3);
    }

    public static float getColorStrength(Color color) {
        return (float)Math.max(SubstanceColorUtilities.getColorBrightness(color.getRGB()), SubstanceColorUtilities.getColorBrightness(SubstanceColorUtilities.getNegativeColor(color.getRGB()))) / 255.0f;
    }

    public static Color getMarkColor(SubstanceColorScheme substanceColorScheme, boolean bl) {
        if (substanceColorScheme.isDark()) {
            if (!bl) {
                return substanceColorScheme.getDarkColor();
            }
            return SubstanceColorUtilities.getInterpolatedColor(substanceColorScheme.getForegroundColor(), substanceColorScheme.getUltraLightColor(), 0.9);
        }
        Color color = bl ? substanceColorScheme.getUltraDarkColor() : substanceColorScheme.getUltraDarkColor();
        Color color2 = bl ? substanceColorScheme.getDarkColor() : substanceColorScheme.getLightColor();
        return SubstanceColorUtilities.getInterpolatedColor(color, color2, 0.6);
    }

    public static Color getForegroundColor(Component component, StateTransitionTracker.ModelStateInfo modelStateInfo) {
        Object object;
        ComponentState componentState = modelStateInfo.getCurrModelState();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
        if (component instanceof AbstractButton && (SubstanceCoreUtilities.isButtonNeverPainted((JComponent)(object = (AbstractButton)component)) || !((AbstractButton)object).isContentAreaFilled() || object instanceof JRadioButton || object instanceof JCheckBox) && !componentState.isDisabled()) {
            componentState = ComponentState.ENABLED;
            map = null;
        }
        object = SubstanceColorSchemeUtilities.getColorScheme(component, componentState);
        if (componentState.isDisabled() || map == null || map.size() == 1) {
            return object.getForegroundColor();
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
            ComponentState componentState2 = entry.getKey();
            float f4 = entry.getValue().getContribution();
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, componentState2);
            Color color = substanceColorScheme.getForegroundColor();
            f += f4 * (float)color.getRed();
            f2 += f4 * (float)color.getGreen();
            f3 += f4 * (float)color.getBlue();
        }
        return new Color((int)f, (int)f2, (int)f3);
    }

    public static Color getMenuComponentForegroundColor(Component component, StateTransitionTracker.ModelStateInfo modelStateInfo) {
        ComponentState componentState = modelStateInfo.getCurrModelStateNoSelection();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateNoSelectionContributionMap();
        ColorSchemeAssociationKind colorSchemeAssociationKind = ColorSchemeAssociationKind.FILL;
        if (!componentState.isDisabled() && componentState != ComponentState.ENABLED) {
            colorSchemeAssociationKind = ColorSchemeAssociationKind.HIGHLIGHT;
        }
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, colorSchemeAssociationKind, componentState);
        if (componentState.isDisabled() || map == null || map.size() == 1) {
            return substanceColorScheme.getForegroundColor();
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
            ComponentState componentState2 = entry.getKey();
            float f4 = entry.getValue().getContribution();
            ColorSchemeAssociationKind colorSchemeAssociationKind2 = ColorSchemeAssociationKind.FILL;
            if (!componentState2.isDisabled() && componentState2 != ComponentState.ENABLED) {
                colorSchemeAssociationKind2 = ColorSchemeAssociationKind.HIGHLIGHT;
            }
            SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(component, colorSchemeAssociationKind2, componentState2);
            Color color = substanceColorScheme2.getForegroundColor();
            f += f4 * (float)color.getRed();
            f2 += f4 * (float)color.getGreen();
            f3 += f4 * (float)color.getBlue();
        }
        return new Color((int)f, (int)f2, (int)f3);
    }

    public static Color getBackgroundFillColor(Component component) {
        if (component instanceof JCheckBox || component instanceof JRadioButton || component instanceof JSlider) {
            component = component.getParent() != null ? component.getParent() : component;
        } else if (component instanceof JTextComponent && !component.isOpaque()) {
            component = component.getParent() != null ? component.getParent() : component;
        }
        Color color = component.getBackground();
        if (SwingUtilities.getAncestorOfClass(CellRendererPane.class, component) != null) {
            return color;
        }
        boolean bl = color instanceof UIResource;
        if (!bl) {
            if (SubstanceCoreUtilities.getColorizationFactor(component) == 1.0 && component.isEnabled()) {
                return color;
            }
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, component.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
            color = substanceColorScheme.getBackgroundFillColor();
        } else {
            float f;
            ComponentState componentState = component.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
            JTextComponent jTextComponent = SubstanceCoreUtilities.getTextComponentForTransitions(component);
            if (jTextComponent != null) {
                component = jTextComponent;
                boolean bl2 = jTextComponent.isEditable();
                if (bl2) {
                    componentState = component.isEnabled() ? EDITABLE : EDITABLE_DISABLED;
                } else {
                    ComponentState componentState2 = componentState = component.isEnabled() ? UNEDITABLE : UNEDITABLE_DISABLED;
                }
            }
            if (component instanceof JMenuItem) {
                componentState = ComponentState.ENABLED;
            }
            color = SubstanceColorUtilities.getDefaultBackgroundColor(component, componentState);
            if (componentState.isDisabled() && (f = SubstanceColorSchemeUtilities.getAlpha(component, componentState)) < 1.0f) {
                ColorUIResource colorUIResource = SubstanceColorUtilities.getDefaultBackgroundColor(component, ComponentState.ENABLED);
                color = SubstanceColorUtilities.getInterpolatedColor(color, colorUIResource, 1.0f - (1.0f - f) / 2.0f);
            }
        }
        return color;
    }

    public static Color getOuterTextComponentBorderColor(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        fArray[2] = fArray[2] < 0.3f ? 1.0f - (float)Math.pow(1.0f - fArray[2], 1.4) : (fArray[2] < 0.5f ? 1.0f - (float)Math.pow(1.0f - fArray[2], 1.2) : (fArray[2] < 0.75f ? 1.0f - (float)Math.pow(1.0f - fArray[2], 1.7) : 1.0f - (float)Math.pow(1.0f - fArray[2], 2.0)));
        return new Color(Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]));
    }

    public static ColorUIResource getDefaultBackgroundColor(boolean bl, SubstanceSkin substanceSkin, boolean bl2) {
        if (bl || bl2) {
            return new ColorUIResource(substanceSkin.getEnabledColorScheme(DecorationAreaType.NONE).getTextBackgroundFillColor());
        }
        return new ColorUIResource(substanceSkin.getEnabledColorScheme(DecorationAreaType.NONE).getBackgroundFillColor());
    }

    public static ColorUIResource getDefaultBackgroundColor(Component component, ComponentState componentState) {
        if (component instanceof JTextComponent || component instanceof JTree || component instanceof JList) {
            return new ColorUIResource(SubstanceColorSchemeUtilities.getColorScheme(component, componentState).getTextBackgroundFillColor());
        }
        return new ColorUIResource(SubstanceLookAndFeel.getCurrentSkin(component).getBackgroundColorScheme(SubstanceLookAndFeel.getDecorationType(component)).getBackgroundFillColor());
    }

    public static Color getStripedBackground(JComponent jComponent, int n) {
        Color color = SubstanceColorUtilities.getBackgroundFillColor(jComponent);
        if (color == null) {
            return null;
        }
        if (n % 2 == 0) {
            return color;
        }
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        double d = 0.96;
        if (!jComponent.isEnabled()) {
            d = 1.0 - (1.0 - d) / 2.0;
        }
        ColorUIResource colorUIResource = new ColorUIResource((int)(d * (double)n2), (int)(d * (double)n3), (int)(d * (double)n4));
        return colorUIResource;
    }

    public static String encode(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("" + n);
        }
        String string = "0123456789ABCDEF";
        char c = string.charAt(n / 16);
        char c2 = string.charAt(n % 16);
        return "" + c + c2;
    }

    public static String encode(Color color) {
        return "#" + SubstanceColorUtilities.encode(color.getRed()) + SubstanceColorUtilities.encode(color.getGreen()) + SubstanceColorUtilities.encode(color.getBlue());
    }
}

