/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.utils.TrackableThread;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceLookAndFeelEx;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.UiThreadingViolationException;
import org.pushingpixels.substance.api.colorscheme.BottleGreenColorScheme;
import org.pushingpixels.substance.api.colorscheme.LightAquaColorScheme;
import org.pushingpixels.substance.api.colorscheme.SunfireRedColorScheme;
import org.pushingpixels.substance.api.colorscheme.SunsetColorScheme;
import org.pushingpixels.substance.api.combo.ComboPopupPrototypeCallback;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.api.tabbed.TabCloseCallback;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.ui.SubstanceInternalFrameUI;
import org.pushingpixels.substance.internal.ui.SubstanceRootPaneUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.MemoryAnalyzer;
import org.pushingpixels.substance.internal.utils.SubstanceColorResource;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceDropDownButton;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceInternalButton;
import org.pushingpixels.substance.internal.utils.SubstanceInternalFrameTitlePane;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceSpinnerButton;
import org.pushingpixels.substance.internal.utils.SubstanceTitleButton;
import org.pushingpixels.substance.internal.utils.combo.SubstanceComboPopup;
import org.pushingpixels.substance.internal.utils.icon.ArrowButtonTransitionAwareIcon;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenu;
import org.pushingpixels.substance.internal.utils.scroll.SubstanceScrollButton;
import org.pushingpixels.trident.swing.SwingRepaintCallback;

public class SubstanceCoreUtilities {
    public static final String IS_COVERED_BY_LIGHTWEIGHT_POPUPS = "substancelaf.internal.paint.isCoveredByLightweightPopups";
    public static final String TEXT_COMPONENT_AWARE = "substancelaf.internal.textComponentAware";
    public static final boolean reallyThrow = Boolean.valueOf(System.getProperty("insubstantial.checkEDT", "false"));
    public static final boolean reallyPrint = Boolean.valueOf(System.getProperty("insubstantial.logEDT", "true"));
    private static Boolean globalRoundingEnable = null;
    private static boolean defaultRoundingEnable = true;

    private SubstanceCoreUtilities() {
    }

    public static String clipString(FontMetrics fontMetrics, int n, String string) {
        if (fontMetrics.stringWidth(string) <= n) {
            return string;
        }
        String string2 = "...";
        int n2 = fontMetrics.stringWidth(string2);
        if (n2 > n) {
            return "";
        }
        Object object = "";
        Object object2 = "";
        int n3 = string.length();
        int n4 = n3 / 2 + n3 % 2;
        Object object3 = "";
        for (int i = 0; i < n4; ++i) {
            String string3;
            String string4 = (String)object + string.charAt(i);
            Object object4 = object2;
            if (n3 - i > n4) {
                object4 = string.charAt(n3 - i - 1) + (String)object4;
            }
            if (fontMetrics.stringWidth(string3 = string4 + string2 + (String)object4) > n) {
                return object3;
            }
            object = string4;
            object2 = object4;
            object3 = string3;
        }
        return string;
    }

    public static boolean hasIcon(AbstractButton abstractButton) {
        return abstractButton.getIcon() != null;
    }

    public static boolean hasText(AbstractButton abstractButton) {
        String string = abstractButton.getText();
        return string != null && string.length() > 0;
    }

    public static boolean isComboBoxButton(AbstractButton abstractButton) {
        Container container = abstractButton.getParent();
        return container != null && (container instanceof JComboBox || container.getParent() instanceof JComboBox);
    }

    public static boolean isScrollBarButton(AbstractButton abstractButton) {
        Container container = abstractButton.getParent();
        return container != null && (container instanceof JScrollBar || container.getParent() instanceof JScrollBar);
    }

    public static boolean isSpinnerButton(AbstractButton abstractButton) {
        Container container = abstractButton.getParent();
        if (!(abstractButton instanceof SubstanceSpinnerButton)) {
            return false;
        }
        return container != null && (container instanceof JSpinner || container.getParent() instanceof JSpinner);
    }

    public static boolean isToolBarButton(JComponent jComponent) {
        if (jComponent instanceof SubstanceDropDownButton) {
            return false;
        }
        if (jComponent instanceof SubstanceSpinnerButton) {
            return false;
        }
        Container container = jComponent.getParent();
        return container != null && (container instanceof JToolBar || container.getParent() instanceof JToolBar);
    }

    public static boolean isScrollButton(JComponent jComponent) {
        return jComponent instanceof SubstanceScrollButton;
    }

    public static boolean isButtonNeverPainted(JComponent jComponent) {
        JComponent jComponent2;
        Object object;
        Container container;
        if (jComponent instanceof JCheckBox) {
            return false;
        }
        if (jComponent instanceof JRadioButton) {
            return false;
        }
        Object object2 = jComponent.getClientProperty("substancelaf.buttonpaintnever");
        if (object2 != null) {
            if (Boolean.TRUE.equals(object2)) {
                return true;
            }
            if (Boolean.FALSE.equals(object2)) {
                return false;
            }
        }
        if (jComponent != null && (container = jComponent.getParent()) instanceof JComponent && (object = (jComponent2 = (JComponent)container).getClientProperty("substancelaf.buttonpaintnever")) != null) {
            if (Boolean.TRUE.equals(object)) {
                return true;
            }
            if (Boolean.FALSE.equals(object)) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.buttonpaintnever"));
    }

    public static SubstanceConstants.FocusKind getFocusKind(Component component) {
        Object object;
        while (component != null) {
            Object object2;
            if (component instanceof JComponent && (object2 = ((JComponent)(object = (JComponent)component)).getClientProperty("substancelaf.focusKind")) instanceof SubstanceConstants.FocusKind) {
                return (SubstanceConstants.FocusKind)((Object)object2);
            }
            component = component.getParent();
        }
        object = UIManager.get("substancelaf.focusKind");
        if (object instanceof SubstanceConstants.FocusKind) {
            return (SubstanceConstants.FocusKind)((Object)object);
        }
        return SubstanceConstants.FocusKind.ALL_INNER;
    }

    public static boolean toDrawWatermark(Component component) {
        Object object;
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            Object object2;
            if (!(component2 instanceof JComponent) || (object2 = ((JComponent)(object = (JComponent)component)).getClientProperty("substancelaf.watermark.visible")) == null) continue;
            if (Boolean.TRUE.equals(object2)) {
                return true;
            }
            if (!Boolean.FALSE.equals(object2)) continue;
            return false;
        }
        object = UIManager.get("substancelaf.watermark.visible");
        if (Boolean.TRUE.equals(object)) {
            return true;
        }
        if (Boolean.FALSE.equals(object)) {
            return false;
        }
        if (component instanceof JList) {
            return false;
        }
        if (component instanceof JTree) {
            return false;
        }
        if (component instanceof JTable) {
            return false;
        }
        return !(component instanceof JTextComponent);
    }

    public static SubstanceButtonShaper getButtonShaper(Component component) {
        Object object;
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty("substancelaf.buttonShaper")) instanceof SubstanceButtonShaper) {
            return (SubstanceButtonShaper)object;
        }
        object = SubstanceCoreUtilities.getSkin(component);
        if (object == null) {
            return null;
        }
        return ((SubstanceSkin)object).getButtonShaper();
    }

    public static SubstanceFillPainter getFillPainter(Component component) {
        return SubstanceCoreUtilities.getSkin(component).getFillPainter();
    }

    public static boolean isTabModified(Component component) {
        boolean bl = false;
        Component component2 = component;
        if (component2 instanceof JComponent) {
            JComponent jComponent = (JComponent)component2;
            bl = Boolean.TRUE.equals(jComponent.getClientProperty("windowModified"));
        }
        return bl;
    }

    public static boolean isRootPaneModified(JRootPane jRootPane) {
        return Boolean.TRUE.equals(jRootPane.getClientProperty("windowModified"));
    }

    public static boolean isInternalFrameModified(JInternalFrame jInternalFrame) {
        return Boolean.TRUE.equals(jInternalFrame.getRootPane().getClientProperty("windowModified"));
    }

    public static boolean isRootPaneAutoDeactivate(JRootPane jRootPane) {
        if (!UIManager.getBoolean("windowAutoDeactivate")) {
            return false;
        }
        if (jRootPane == null) {
            return false;
        }
        Object object = jRootPane.getClientProperty("windowAutoDeactivate");
        return !(object instanceof Boolean) || (Boolean)object != false;
    }

    public static boolean isPaintRootPaneActivated(JRootPane jRootPane) {
        if (SubstanceCoreUtilities.isRootPaneAutoDeactivate(jRootPane)) {
            Container container = jRootPane.getParent();
            if (container instanceof JInternalFrame) {
                return ((JInternalFrame)container).isSelected();
            }
            if (container instanceof Window) {
                return ((Window)container).isActive();
            }
            return false;
        }
        return true;
    }

    public static boolean isSecondaryWindow(JRootPane jRootPane) {
        Container container = jRootPane.getParent();
        return container instanceof JInternalFrame;
    }

    public static boolean isRoundedCorners(Component component) {
        Object object;
        if (globalRoundingEnable == null) {
            String string = System.getProperty("substancelaf.windowRoundedCorners");
            globalRoundingEnable = string == null || string.length() == 0 || Boolean.valueOf(string) != false;
            UIManager.getDefaults().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("windowRoundedCorners".equals(propertyChangeEvent.getPropertyName())) {
                        defaultRoundingEnable = !(propertyChangeEvent.getNewValue() instanceof Boolean) || (Boolean)propertyChangeEvent.getNewValue() != false;
                    }
                }
            });
            if (globalRoundingEnable.booleanValue() && (object = UIManager.get("windowRoundedCorners")) instanceof Boolean) {
                defaultRoundingEnable = (Boolean)object;
            }
        }
        if (!globalRoundingEnable.booleanValue()) {
            return false;
        }
        boolean bl = defaultRoundingEnable;
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty("windowRoundedCorners")) instanceof Boolean) {
            bl = (Boolean)object;
        }
        if (bl) {
            for (object = component; !(object instanceof Window) && !(object instanceof JInternalFrame) && object != null; object = ((Component)object).getParent()) {
            }
            if (object instanceof Frame) {
                if ((((Frame)object).getExtendedState() & 6) == 6) {
                    bl = false;
                }
            } else if (component instanceof JInternalFrame) {
                bl = !((JInternalFrame)component).isMaximum();
            }
        }
        return bl;
    }

    public static boolean hasCloseButton(JTabbedPane jTabbedPane, int n) {
        Object object;
        int n2 = jTabbedPane.getTabCount();
        if (n < 0 || n >= n2) {
            return false;
        }
        if (!jTabbedPane.isEnabledAt(n)) {
            return false;
        }
        Component component = jTabbedPane.getComponentAt(n);
        if (component instanceof JComponent) {
            object = ((JComponent)component).getClientProperty("substancelaf.tabbedpanehasclosebuttons");
            if (Boolean.TRUE.equals(object)) {
                return true;
            }
            if (Boolean.FALSE.equals(object)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(object = jTabbedPane.getClientProperty("substancelaf.tabbedpanehasclosebuttons"))) {
            return true;
        }
        if (Boolean.FALSE.equals(object)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.tabbedpanehasclosebuttons");
    }

    public static int getCloseButtonSize(JTabbedPane jTabbedPane, int n) {
        if (!SubstanceCoreUtilities.hasCloseButton(jTabbedPane, n)) {
            return 0;
        }
        return SubstanceSizeUtils.getTabCloseIconSize(SubstanceSizeUtils.getComponentFontSize(jTabbedPane));
    }

    public static SubstanceConstants.TabContentPaneBorderKind getContentBorderKind(JTabbedPane jTabbedPane) {
        Object object = jTabbedPane.getClientProperty("substancelaf.tabbedPaneContentBorderKind");
        if (object instanceof SubstanceConstants.TabContentPaneBorderKind) {
            return (SubstanceConstants.TabContentPaneBorderKind)((Object)object);
        }
        Object object2 = UIManager.get("substancelaf.tabbedPaneContentBorderKind");
        if (object2 instanceof SubstanceConstants.TabContentPaneBorderKind) {
            return (SubstanceConstants.TabContentPaneBorderKind)((Object)object2);
        }
        return SubstanceConstants.TabContentPaneBorderKind.DOUBLE_FULL;
    }

    public static boolean toAnimateCloseIconOfModifiedTab(JTabbedPane jTabbedPane, int n) {
        Object object;
        int n2 = jTabbedPane.getTabCount();
        if (n < 0 || n >= n2) {
            return false;
        }
        if (!SubstanceCoreUtilities.hasCloseButton(jTabbedPane, n)) {
            return false;
        }
        Component component = jTabbedPane.getComponentAt(n);
        if (component instanceof JComponent) {
            object = ((JComponent)component).getClientProperty("substancelaf.tabbedpaneclosebuttonsmodifiedanimation");
            if (Boolean.TRUE.equals(object)) {
                return true;
            }
            if (Boolean.FALSE.equals(object)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(object = jTabbedPane.getClientProperty("substancelaf.tabbedpaneclosebuttonsmodifiedanimation"))) {
            return true;
        }
        if (Boolean.FALSE.equals(object)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.tabbedpaneclosebuttonsmodifiedanimation");
    }

    public static BufferedImage getBlankImage(int n, int n2) {
        Object object;
        Object object2;
        if (MemoryAnalyzer.isRunning() && (n >= 100 || n2 >= 100)) {
            object2 = Thread.currentThread().getStackTrace();
            object = new StringBuilder();
            int n3 = 0;
            for (Object object3 : object2) {
                if (n3++ > 8) break;
                ((StringBuilder)object).append(((StackTraceElement)object3).getClassName()).append(".").append(((StackTraceElement)object3).getMethodName()).append(" [").append(((StackTraceElement)object3).getLineNumber()).append("]").append("\n");
            }
            MemoryAnalyzer.enqueueUsage("Blank " + n + "*" + n2 + "\n" + ((StringBuilder)object).toString());
        }
        if (GraphicsEnvironment.isHeadless()) {
            object2 = new BufferedImage(n, n2, 2);
        } else {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = ((GraphicsEnvironment)object).getDefaultScreenDevice();
            Object object4 = graphicsDevice.getDefaultConfiguration();
            object2 = ((GraphicsConfiguration)object4).createCompatibleImage(n, n2, 3);
        }
        return object2;
    }

    public static VolatileImage getBlankVolatileImage(int n, int n2) {
        Object object;
        StackTraceElement[] stackTraceElementArray;
        if (MemoryAnalyzer.isRunning() && (n >= 100 || n2 >= 100)) {
            stackTraceElementArray = Thread.currentThread().getStackTrace();
            object = new StringBuilder();
            int n3 = 0;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (n3++ > 8) break;
                ((StringBuilder)object).append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName()).append(" [").append(stackTraceElement.getLineNumber()).append("]").append("\n");
            }
            MemoryAnalyzer.enqueueUsage("Blank " + n + "*" + n2 + "\n" + ((StringBuilder)object).toString());
        }
        stackTraceElementArray = GraphicsEnvironment.getLocalGraphicsEnvironment();
        object = stackTraceElementArray.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = ((GraphicsDevice)object).getDefaultConfiguration();
        VolatileImage volatileImage = graphicsConfiguration.createCompatibleVolatileImage(n, n2, 3);
        return volatileImage;
    }

    public static boolean hasNoMinSizeProperty(AbstractButton abstractButton) {
        Object object = abstractButton.getClientProperty("substancelaf.buttonnominsize");
        if (Boolean.TRUE.equals(object)) {
            return true;
        }
        if (Boolean.FALSE.equals(object)) {
            return false;
        }
        Container container = abstractButton.getParent();
        if (container instanceof JComponent) {
            object = ((JComponent)container).getClientProperty("substancelaf.buttonnominsize");
            if (Boolean.TRUE.equals(object)) {
                return true;
            }
            if (Boolean.FALSE.equals(object)) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.buttonnominsize"));
    }

    public static boolean hasFlatAppearance(Component component, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        if (component instanceof JCheckBox) {
            return bl;
        }
        if (component instanceof JRadioButton) {
            return bl;
        }
        Component component2 = component;
        if (component2 instanceof JComponent && (object3 = ((JComponent)(object2 = (JComponent)component2)).getClientProperty("substancelaf.componentFlat")) != null) {
            if (Boolean.TRUE.equals(object3)) {
                return true;
            }
            if (Boolean.FALSE.equals(object3)) {
                return false;
            }
        }
        if (component2 != null && (object2 = component2.getParent()) instanceof JComponent && (object = ((JComponent)(object3 = (JComponent)object2)).getClientProperty("substancelaf.componentFlat")) != null) {
            if (Boolean.TRUE.equals(object)) {
                return true;
            }
            if (Boolean.FALSE.equals(object)) {
                return false;
            }
        }
        if ((object2 = UIManager.get("substancelaf.componentFlat")) != null) {
            if (Boolean.TRUE.equals(object2)) {
                return true;
            }
            if (Boolean.FALSE.equals(object2)) {
                return false;
            }
        }
        return bl;
    }

    public static boolean hasFlatAppearance(AbstractButton abstractButton) {
        if (abstractButton instanceof JCheckBox) {
            return false;
        }
        if (abstractButton instanceof JRadioButton) {
            return false;
        }
        return SubstanceCoreUtilities.isToolBarButton(abstractButton) && SubstanceCoreUtilities.hasFlatAppearance(abstractButton, true) || SubstanceCoreUtilities.hasFlatAppearance(abstractButton, false);
    }

    public static int getPopupFlyoutOrientation(JComboBox jComboBox) {
        Object object = jComboBox.getClientProperty("substancelaf.comboboxpopupFlyoutOrientation");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        Object object2 = UIManager.get("substancelaf.comboboxpopupFlyoutOrientation");
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        return 5;
    }

    public static void makeNonOpaque(Component component, Map<Component, Boolean> map) {
        Container container;
        if (component instanceof JComponent) {
            container = (JComponent)component;
            map.put(component, ((JComponent)container).isOpaque());
            ((JComponent)container).setOpaque(false);
        }
        if (component instanceof Container) {
            container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                SubstanceCoreUtilities.makeNonOpaque(container.getComponent(i), map);
            }
        }
    }

    public static void restoreOpaque(Component component, Map<Component, Boolean> map) {
        Container container;
        if (component instanceof JComponent) {
            container = (JComponent)component;
            if (map.containsKey(component)) {
                ((JComponent)container).setOpaque(map.get(component));
            } else {
                ((JComponent)container).setOpaque(true);
            }
        }
        if (component instanceof Container) {
            container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                SubstanceCoreUtilities.restoreOpaque(container.getComponent(i), map);
            }
        }
    }

    public static BufferedImage createCompatibleImage(BufferedImage bufferedImage) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 3);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        graphics.dispose();
        return bufferedImage2;
    }

    public static boolean useThemedDefaultIcon(JComponent jComponent) {
        if (jComponent instanceof SubstanceInternalButton) {
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.useThemedDefaultIcons"));
    }

    public static TabCloseCallback getTabCloseCallback(MouseEvent mouseEvent, JTabbedPane jTabbedPane, int n) {
        Object object;
        int n2 = jTabbedPane.getTabCount();
        if (n < 0 || n >= n2) {
            return null;
        }
        Component component = jTabbedPane.getComponentAt(n);
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty("substancelaf.tabbedpanecloseCallback")) instanceof TabCloseCallback) {
            return (TabCloseCallback)object;
        }
        object = jTabbedPane.getClientProperty("substancelaf.tabbedpanecloseCallback");
        if (object instanceof TabCloseCallback) {
            return (TabCloseCallback)object;
        }
        Object object2 = UIManager.get("substancelaf.tabbedpanecloseCallback");
        if (object2 instanceof TabCloseCallback) {
            return (TabCloseCallback)object2;
        }
        return null;
    }

    public static BufferedImage blendImagesVertical(BufferedImage bufferedImage, BufferedImage bufferedImage2, double d, double d2) {
        int n = bufferedImage.getWidth();
        if (n != bufferedImage2.getWidth()) {
            throw new IllegalArgumentException("Widths are not the same: " + bufferedImage.getWidth() + " and " + bufferedImage2.getWidth());
        }
        int n2 = bufferedImage.getHeight();
        if (n2 != bufferedImage2.getHeight()) {
            throw new IllegalArgumentException("Heights are not the same: " + bufferedImage.getHeight() + " and " + bufferedImage2.getHeight());
        }
        BufferedImage bufferedImage3 = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage3.getGraphics().create();
        int n3 = (int)(d2 * (double)n2);
        int n4 = (int)(d * (double)n2);
        int n5 = n3 - n4;
        if (n5 == 0) {
            graphics2D.drawImage(bufferedImage, 0, 0, n, n4, 0, 0, n, n4, null);
            graphics2D.drawImage(bufferedImage2, 0, n4, n, n2, 0, n4, n, n2, null);
        } else {
            BufferedImage bufferedImage4 = SubstanceCoreUtilities.getBlankImage(n, n5);
            Graphics2D graphics2D2 = (Graphics2D)bufferedImage4.getGraphics();
            graphics2D2.setPaint(new GradientPaint(new Point(0, 0), new Color(0, 0, 0, 255), new Point(0, n5), new Color(0, 0, 0, 0)));
            graphics2D2.fillRect(0, 0, n, n5);
            BufferedImage bufferedImage5 = SubstanceCoreUtilities.getBlankImage(n, n2 - n4);
            Graphics2D graphics2D3 = (Graphics2D)bufferedImage5.getGraphics();
            graphics2D3.drawImage(bufferedImage2, 0, 0, n, n2 - n4, 0, n4, n, n2, null);
            graphics2D3.setComposite(AlphaComposite.DstOut);
            graphics2D3.drawImage((Image)bufferedImage4, 0, 0, null);
            graphics2D3.setComposite(AlphaComposite.SrcOver);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.drawImage((Image)bufferedImage5, 0, n4, null);
        }
        graphics2D.dispose();
        return bufferedImage3;
    }

    public static BufferedImage blendImagesHorizontal(BufferedImage bufferedImage, BufferedImage bufferedImage2, double d, double d2) {
        int n = bufferedImage.getWidth();
        if (n != bufferedImage2.getWidth()) {
            throw new IllegalArgumentException("Widths are not the same: " + bufferedImage.getWidth() + " and " + bufferedImage2.getWidth());
        }
        int n2 = bufferedImage.getHeight();
        if (n2 != bufferedImage2.getHeight()) {
            throw new IllegalArgumentException("Heights are not the same: " + bufferedImage.getHeight() + " and " + bufferedImage2.getHeight());
        }
        BufferedImage bufferedImage3 = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage3.getGraphics().create();
        int n3 = (int)(d2 * (double)n);
        int n4 = (int)(d * (double)n);
        int n5 = n3 - n4;
        if (n5 == 0) {
            graphics2D.drawImage(bufferedImage, 0, 0, n4, n2, 0, 0, n4, n2, null);
            graphics2D.drawImage(bufferedImage2, n4, 0, n, n2, n4, 0, n, n2, null);
        } else {
            BufferedImage bufferedImage4 = SubstanceCoreUtilities.getBlankImage(n5, n2);
            Graphics2D graphics2D2 = (Graphics2D)bufferedImage4.getGraphics();
            graphics2D2.setPaint(new GradientPaint(new Point(0, 0), new Color(0, 0, 0, 255), new Point(n5, 0), new Color(0, 0, 0, 0)));
            graphics2D2.fillRect(0, 0, n5, n2);
            BufferedImage bufferedImage5 = SubstanceCoreUtilities.getBlankImage(n - n4, n2);
            Graphics2D graphics2D3 = (Graphics2D)bufferedImage5.getGraphics();
            graphics2D3.drawImage(bufferedImage2, 0, 0, n - n4, n2, n4, 0, n, n2, null);
            graphics2D3.setComposite(AlphaComposite.DstOut);
            graphics2D3.drawImage((Image)bufferedImage4, 0, 0, null);
            graphics2D3.setComposite(AlphaComposite.SrcOver);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.drawImage((Image)bufferedImage5, n4, 0, null);
        }
        graphics2D.dispose();
        return bufferedImage3;
    }

    public static SubstanceColorScheme getOptionPaneColorScheme(int n, SubstanceColorScheme substanceColorScheme) {
        if (!SubstanceLookAndFeel.isToUseConstantThemesOnDialogs()) {
            return substanceColorScheme;
        }
        switch (n) {
            case 1: {
                return new BottleGreenColorScheme();
            }
            case 3: {
                return new LightAquaColorScheme();
            }
            case 2: {
                return new SunsetColorScheme();
            }
            case 0: {
                return new SunfireRedColorScheme();
            }
        }
        return null;
    }

    public static Object getComboPopupPrototypeDisplayValue(JComboBox jComboBox) {
        Object object = jComboBox.getClientProperty("substancelaf.comboPopupPrototype");
        if (object == null) {
            object = UIManager.get("substancelaf.comboPopupPrototype");
        }
        if (object == null) {
            return null;
        }
        if (object instanceof ComboPopupPrototypeCallback) {
            ComboPopupPrototypeCallback comboPopupPrototypeCallback = (ComboPopupPrototypeCallback)object;
            return comboPopupPrototypeCallback.getPopupPrototypeDisplayValue(jComboBox);
        }
        return object;
    }

    public static SubstanceConstants.ScrollPaneButtonPolicyKind getScrollPaneButtonsPolicyKind(JScrollBar jScrollBar) {
        Object object;
        Container container = jScrollBar.getParent();
        if (container instanceof JScrollPane && (object = ((JScrollPane)container).getClientProperty("substancelaf.scrollPaneButtonsPolicy")) instanceof SubstanceConstants.ScrollPaneButtonPolicyKind) {
            return (SubstanceConstants.ScrollPaneButtonPolicyKind)((Object)object);
        }
        object = UIManager.get("substancelaf.scrollPaneButtonsPolicy");
        if (object instanceof SubstanceConstants.ScrollPaneButtonPolicyKind) {
            return (SubstanceConstants.ScrollPaneButtonPolicyKind)((Object)object);
        }
        return SubstanceConstants.ScrollPaneButtonPolicyKind.OPPOSITE;
    }

    public static Set<SubstanceConstants.Side> getSides(JComponent jComponent, String string) {
        if (jComponent == null) {
            return null;
        }
        Object object = jComponent.getClientProperty(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Set) {
            return (Set)object;
        }
        if (object != null && object instanceof SubstanceConstants.Side) {
            EnumSet<SubstanceConstants.Side> enumSet = EnumSet.noneOf(SubstanceConstants.Side.class);
            enumSet.add((SubstanceConstants.Side)((Object)object));
            return enumSet;
        }
        return null;
    }

    public static float getToolbarButtonCornerRadius(JComponent jComponent, Insets insets) {
        JToolBar jToolBar = null;
        for (Container container = jComponent.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JToolBar)) continue;
            jToolBar = (JToolBar)container;
            break;
        }
        if (jToolBar == null) {
            return 2.0f;
        }
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        if (insets != null) {
            n -= insets.left + insets.right;
            n2 -= insets.top + insets.bottom;
        }
        float f = n > n2 ? (float)n2 / 2.0f : (float)n / 2.0f;
        Object object = jComponent.getClientProperty("substancelaf.cornerRadius");
        if (object instanceof Float) {
            return Math.min(f, ((Float)object).floatValue());
        }
        Object object2 = jToolBar.getClientProperty("substancelaf.cornerRadius");
        if (object2 instanceof Float) {
            return Math.min(f, ((Float)object2).floatValue());
        }
        Object object3 = UIManager.get("substancelaf.cornerRadius");
        if (object3 instanceof Float) {
            return Math.min(f, ((Float)object3).floatValue());
        }
        return 2.0f;
    }

    public static int getEchoPerChar(JPasswordField jPasswordField) {
        int n;
        Object object = jPasswordField.getClientProperty("substancelaf.passwordEchoPerChar");
        if (object != null && object instanceof Integer && (n = ((Integer)object).intValue()) >= 1) {
            return n;
        }
        object = UIManager.get("substancelaf.passwordEchoPerChar");
        if (object != null && object instanceof Integer && (n = ((Integer)object).intValue()) >= 1) {
            return n;
        }
        return 1;
    }

    public static BufferedImage softClip(int n, int n2, BufferedImage bufferedImage, Shape shape) {
        BufferedImage bufferedImage2 = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(shape);
        graphics2D.setComposite(AlphaComposite.SrcAtop);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static boolean toShowExtraWidgets(Component component) {
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            JComponent jComponent;
            Object object;
            if (!(component2 instanceof JComponent) || (object = (jComponent = (JComponent)component2).getClientProperty("substancelaf.addWidgets")) == null) continue;
            if (Boolean.TRUE.equals(object)) {
                return false;
            }
            if (!Boolean.FALSE.equals(object)) continue;
            return true;
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.addWidgets"));
    }

    public static Icon getThemedIcon(Component component, Icon icon) {
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, ComponentState.ENABLED);
        float f = substanceColorScheme.isDark() ? 0.2f : 0.8f;
        return new ImageIcon(SubstanceImageCreator.getColorSchemeImage(component, icon, substanceColorScheme, f));
    }

    public static Icon getThemedIcon(JTabbedPane jTabbedPane, int n, Icon icon) {
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jTabbedPane, n, ColorSchemeAssociationKind.TAB, ComponentState.ENABLED);
        float f = substanceColorScheme.isDark() ? 0.2f : 0.8f;
        return new ImageIcon(SubstanceImageCreator.getColorSchemeImage(jTabbedPane, icon, substanceColorScheme, f));
    }

    public static Icon getOriginalIcon(AbstractButton abstractButton, Icon icon) {
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon2 = abstractButton.getIcon();
        if (icon2 == null) {
            icon2 = icon;
        }
        if (icon2.getClass().isAnnotationPresent(TransitionAware.class)) {
            return icon2;
        }
        Icon icon3 = null;
        if (icon2 != null) {
            if (!buttonModel.isEnabled()) {
                icon3 = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon3 = abstractButton.getPressedIcon();
            } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                if (buttonModel.isSelected()) {
                    icon3 = abstractButton.getRolloverSelectedIcon();
                    if (icon3 == null) {
                        icon3 = abstractButton.getSelectedIcon();
                    }
                } else {
                    icon3 = abstractButton.getRolloverIcon();
                }
            } else if (buttonModel.isSelected()) {
                icon3 = abstractButton.getSelectedIcon();
            }
            if (icon3 != null) {
                icon2 = icon3;
            }
        }
        return icon2;
    }

    public static SubstanceConstants.MenuGutterFillKind getMenuGutterFillKind() {
        Object object = UIManager.get("substancelaf.menuGutterFillKind");
        if (object instanceof SubstanceConstants.MenuGutterFillKind) {
            return (SubstanceConstants.MenuGutterFillKind)((Object)object);
        }
        return SubstanceConstants.MenuGutterFillKind.HARD;
    }

    public static Container getHeaderParent(Component component) {
        Container container = null;
        for (Container container2 = component.getParent(); container2 != null; container2 = container2.getParent()) {
            if (container2 instanceof JLayeredPane && container == null) {
                container = container2;
            }
            if (container != null || !(container2 instanceof Window)) continue;
            container = container2;
        }
        return container;
    }

    public static void paintFocus(Graphics graphics, Component component, Component component2, TransitionAwareUI transitionAwareUI, Shape shape, Rectangle rectangle, float f, int n) {
        float f2 = transitionAwareUI.getTransitionTracker().getFocusStrength(component2.hasFocus());
        if (f2 == 0.0f) {
            return;
        }
        SubstanceConstants.FocusKind focusKind = SubstanceCoreUtilities.getFocusKind(component);
        if (focusKind == SubstanceConstants.FocusKind.NONE) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f3 = f * f2;
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)component, (float)f3, (Graphics)graphics));
        Color color = SubstanceColorUtilities.getFocusColor(component, transitionAwareUI);
        graphics2D.setColor(color);
        focusKind.paintFocus(component, component2, transitionAwareUI, graphics2D, shape, rectangle, n);
        graphics2D.dispose();
    }

    public static boolean isTitleCloseButton(JComponent jComponent) {
        return jComponent instanceof SubstanceTitleButton && Boolean.TRUE.equals(jComponent.getClientProperty("substancelaf.internal.isTitleCloseButton"));
    }

    public static void uninstallMenu(JMenuItem jMenuItem) {
        Object object;
        Object object2;
        if (jMenuItem instanceof JMenu) {
            object2 = (JMenu)jMenuItem;
            object = ((JMenu)object2).getMenuComponents();
            int n = ((Component[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object3 = object[i];
                if (!(object3 instanceof JMenuItem)) continue;
                SubstanceCoreUtilities.uninstallMenu((JMenuItem)object3);
            }
        }
        if ((object2 = jMenuItem.getUI()) instanceof SubstanceMenu && (object = (SubstanceMenu)object2).getAssociatedMenuItem() != null) {
            ((ComponentUI)object2).uninstallUI(jMenuItem);
        }
        for (ActionListener actionListener : jMenuItem.getActionListeners()) {
            jMenuItem.removeActionListener(actionListener);
        }
        jMenuItem.removeAll();
    }

    public static Icon getIcon(String string) {
        ClassLoader classLoader = SubstanceCoreUtilities.getClassLoaderForResources();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            return null;
        }
        return new IconUIResource(new ImageIcon(uRL));
    }

    public static ClassLoader getClassLoaderForResources() {
        ClassLoader classLoader = (ClassLoader)UIManager.get("ClassLoader");
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    public static boolean isCoveredByLightweightPopups(Component component) {
        int n;
        JRootPane jRootPane = SwingUtilities.getRootPane(component);
        if (jRootPane == null) {
            return false;
        }
        Component[] componentArray = jRootPane.getLayeredPane().getComponentsInLayer(JLayeredPane.POPUP_LAYER);
        if (componentArray == null) {
            return false;
        }
        Rectangle rectangle = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), jRootPane.getLayeredPane());
        for (int i = n = SubstanceCoreUtilities.getPopupParentIndexOf(component, componentArray) - 1; i >= 0; --i) {
            Component component2 = componentArray[i];
            if (!rectangle.intersects(component2.getBounds())) continue;
            return true;
        }
        return false;
    }

    public static int getPopupParentIndexOf(Component component, Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            Component component2 = componentArray[i];
            for (Component component3 = component; component3 != null; component3 = component3.getParent()) {
                if (component3 != component2) continue;
                return i;
            }
        }
        return componentArray.length;
    }

    public static ResourceBundle getResourceBundle(JComponent jComponent) {
        if (LafWidgetUtilities.toIgnoreGlobalLocale((JComponent)jComponent)) {
            return SubstanceLookAndFeel.getLabelBundle(jComponent.getLocale());
        }
        return SubstanceLookAndFeel.getLabelBundle();
    }

    public static SubstanceBorderPainter getBorderPainter(Component component) {
        if (component instanceof SubstanceScrollButton) {
            return SubstanceLookAndFeelEx.SIMPLE_BORDER_PAINTER;
        }
        return SubstanceCoreUtilities.getSkin(component).getBorderPainter();
    }

    public static SubstanceBorderPainter getHighlightBorderPainter(Component component) {
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getSkin(component).getHighlightBorderPainter();
        if (substanceBorderPainter != null) {
            return substanceBorderPainter;
        }
        return SubstanceCoreUtilities.getBorderPainter(component);
    }

    public static String getHierarchy(Component component) {
        StringBuffer stringBuffer = new StringBuffer();
        SubstanceCoreUtilities.getHierarchy(component, stringBuffer, 0);
        while (component instanceof Window) {
            Window window = (Window)component;
            if ((component = window.getOwner()) == null) continue;
            stringBuffer.append("Owner --->\n");
            SubstanceCoreUtilities.getHierarchy(component, stringBuffer, 0);
        }
        return stringBuffer.toString();
    }

    public static void getHierarchy(Component component, StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("   ");
        }
        String string = component.getName();
        if (component instanceof Dialog) {
            string = ((Dialog)component).getTitle();
        }
        if (component instanceof Frame) {
            string = ((Frame)component).getTitle();
        }
        stringBuffer.append(component.getClass().getName() + "[" + string + "]\n");
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                SubstanceCoreUtilities.getHierarchy(container.getComponent(i), stringBuffer, n + 1);
            }
        }
    }

    public static JComponent getTitlePane(JRootPane jRootPane) {
        JInternalFrame jInternalFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, jRootPane);
        if (jInternalFrame != null && jInternalFrame.getUI() instanceof SubstanceInternalFrameUI) {
            SubstanceInternalFrameUI substanceInternalFrameUI = (SubstanceInternalFrameUI)jInternalFrame.getUI();
            return substanceInternalFrameUI.getTitlePane();
        }
        SubstanceRootPaneUI substanceRootPaneUI = (SubstanceRootPaneUI)jRootPane.getUI();
        if (substanceRootPaneUI == null) {
            return null;
        }
        return substanceRootPaneUI.getTitlePane();
    }

    public static Icon getArrowIcon(AbstractButton abstractButton, int n) {
        ArrowButtonTransitionAwareIcon arrowButtonTransitionAwareIcon = new ArrowButtonTransitionAwareIcon(abstractButton, n);
        return arrowButtonTransitionAwareIcon;
    }

    public static Icon getArrowIcon(JComponent jComponent, TransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate, int n) {
        ArrowButtonTransitionAwareIcon arrowButtonTransitionAwareIcon = new ArrowButtonTransitionAwareIcon(jComponent, transitionAwareUIDelegate, n);
        return arrowButtonTransitionAwareIcon;
    }

    public static double getColorizationFactor(Component component) {
        Object object;
        JPopupMenu jPopupMenu = null;
        while (component != null) {
            Object object2;
            if (component instanceof JComponent && (object2 = ((JComponent)(object = (JComponent)component)).getClientProperty("substancelaf.colorizationFactor")) instanceof Double) {
                return (Double)object2;
            }
            if (component instanceof JPopupMenu) {
                jPopupMenu = (JPopupMenu)component;
            }
            component = component.getParent();
        }
        if (jPopupMenu != null && jPopupMenu != (object = jPopupMenu.getInvoker())) {
            return SubstanceCoreUtilities.getColorizationFactor(jPopupMenu.getInvoker());
        }
        object = UIManager.get("substancelaf.colorizationFactor");
        if (object instanceof Double) {
            return (Double)object;
        }
        return 0.5;
    }

    public static SubstanceSkin getSkin(Component component) {
        Object object;
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return null;
        }
        if (!SubstanceRootPaneUI.hasCustomSkinOnAtLeastOneRootPane()) {
            return SubstanceLookAndFeel.getCurrentSkin();
        }
        SubstanceComboPopup substanceComboPopup = (SubstanceComboPopup)SwingUtilities.getAncestorOfClass(SubstanceComboPopup.class, component);
        if (substanceComboPopup != null) {
            return SubstanceCoreUtilities.getSkin(substanceComboPopup.getCombobox());
        }
        JRootPane jRootPane = SwingUtilities.getRootPane(component);
        if (component instanceof SubstanceInternalFrameTitlePane && (object = component.getParent()) != null && object instanceof JInternalFrame) {
            jRootPane = ((JInternalFrame)object).getRootPane();
        }
        if (component != null && component.getParent() instanceof SubstanceInternalFrameTitlePane && (object = component.getParent().getParent()) != null && object instanceof JInternalFrame) {
            jRootPane = ((JInternalFrame)object).getRootPane();
        }
        if (jRootPane != null && (object = jRootPane.getClientProperty("substancelaf.skin")) instanceof SubstanceSkin) {
            return (SubstanceSkin)object;
        }
        return SubstanceLookAndFeel.getCurrentSkin();
    }

    public static HashMapKey getHashKey(Object ... objectArray) {
        return new HashMapKey(objectArray);
    }

    public static void stopThreads() {
        TrackableThread.requestStopAllThreads();
    }

    public static String getVmParameter(String string) {
        try {
            String string2 = System.getProperty(string);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean reallyPrintThreadingExceptions() {
        return reallyPrint;
    }

    public static boolean reallyThrowThreadingExceptions() {
        return reallyThrow;
    }

    public static void testComponentCreationThreadingViolation(Component component) {
        if ((SubstanceCoreUtilities.reallyPrintThreadingExceptions() || SubstanceCoreUtilities.reallyThrowThreadingExceptions()) && !SwingUtilities.isEventDispatchThread()) {
            UiThreadingViolationException uiThreadingViolationException = new UiThreadingViolationException("Component creation must be done on Event Dispatch Thread");
            if (SubstanceCoreUtilities.reallyPrintThreadingExceptions()) {
                uiThreadingViolationException.printStackTrace(System.err);
            }
            if (SubstanceCoreUtilities.reallyThrowThreadingExceptions()) {
                throw uiThreadingViolationException;
            }
        }
    }

    public static void testComponentStateChangeThreadingViolation(Component component) {
        if ((SubstanceCoreUtilities.reallyPrintThreadingExceptions() || SubstanceCoreUtilities.reallyThrowThreadingExceptions()) && !SwingUtilities.isEventDispatchThread()) {
            UiThreadingViolationException uiThreadingViolationException = new UiThreadingViolationException("Component state change must be done on Event Dispatch Thread");
            if (SubstanceCoreUtilities.reallyPrintThreadingExceptions()) {
                uiThreadingViolationException.printStackTrace(System.err);
            }
            if (SubstanceCoreUtilities.reallyThrowThreadingExceptions()) {
                throw uiThreadingViolationException;
            }
        }
    }

    public static void testWindowCloseThreadingViolation(Window window) {
        if ((SubstanceCoreUtilities.reallyPrintThreadingExceptions() || SubstanceCoreUtilities.reallyThrowThreadingExceptions()) && !SwingUtilities.isEventDispatchThread()) {
            UiThreadingViolationException uiThreadingViolationException = new UiThreadingViolationException("Window close must be done on Event Dispatch Thread");
            if (SubstanceCoreUtilities.reallyPrintThreadingExceptions()) {
                uiThreadingViolationException.printStackTrace(System.err);
            }
            if (SubstanceCoreUtilities.reallyThrowThreadingExceptions()) {
                throw uiThreadingViolationException;
            }
        }
    }

    public static void traceSubstanceApiUsage(Component component, String string) {
        Window window = SwingUtilities.getWindowAncestor(component);
        String string2 = null;
        if (window instanceof Frame) {
            string2 = ((Frame)window).getTitle();
        }
        if (window instanceof Dialog) {
            string2 = ((Dialog)window).getTitle();
        }
        throw new IllegalArgumentException(string + " [component " + component.getClass().getSimpleName() + " in window " + window.getClass().getSimpleName() + ":'" + string2 + "' under " + UIManager.getLookAndFeel().getName() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getScaledIconImage(List<Image> list, int n, int n2) {
        int n3;
        int n4;
        if (n == 0 || n2 == 0) {
            return null;
        }
        Image object2 = null;
        int n5 = 0;
        int n6 = 0;
        double d = 3.0;
        for (Image object3 : list) {
            double d2;
            double d3;
            int n7;
            int n8;
            if (object3 == null) continue;
            try {
                n4 = object3.getWidth(null);
                n3 = object3.getHeight(null);
            }
            catch (Exception d4) {
                continue;
            }
            if (n4 <= 0 || n3 <= 0) continue;
            double d4 = Math.min((double)n / (double)n4, (double)n2 / (double)n3);
            if (d4 >= 2.0) {
                d4 = Math.floor(d4);
                n8 = n4 * (int)d4;
                n7 = n3 * (int)d4;
                d3 = 1.0 - 0.5 / d4;
            } else if (d4 >= 1.0) {
                n8 = n4;
                n7 = n3;
                d3 = 0.0;
            } else if (d4 >= 0.75) {
                n8 = n4 * 3 / 4;
                n7 = n3 * 3 / 4;
                d3 = 0.3;
            } else if (d4 >= 0.6666) {
                n8 = n4 * 2 / 3;
                n7 = n3 * 2 / 3;
                d3 = 0.33;
            } else {
                d2 = Math.ceil(1.0 / d4);
                n8 = (int)Math.round((double)n4 / d2);
                n7 = (int)Math.round((double)n3 / d2);
                d3 = 1.0 - 1.0 / d2;
            }
            d2 = ((double)n - (double)n8) / (double)n + ((double)n2 - (double)n7) / (double)n2 + d3;
            if (d2 < d) {
                d = d2;
                object2 = object3;
                n5 = n8;
                n6 = n7;
            }
            if (d2 != 0.0) continue;
            break;
        }
        if (object2 == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        try {
            n4 = (n - n5) / 2;
            n3 = (n2 - n6) / 2;
            graphics2D.drawImage(object2, n4, n3, n5, n6, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    public static boolean canReplaceChildBackgroundColor(Color color) {
        return color instanceof UIResource || color instanceof SubstanceColorResource;
    }

    public static JTextComponent getTextComponentForTransitions(Component component) {
        if (!(component instanceof JComponent)) {
            return null;
        }
        TextComponentAware textComponentAware = (TextComponentAware)((JComponent)component).getClientProperty(TEXT_COMPONENT_AWARE);
        if (textComponentAware != null) {
            return textComponentAware.getTextComponent(component);
        }
        if (component instanceof JTextComponent) {
            return (JTextComponent)component;
        }
        return null;
    }

    public static SwingRepaintCallback getTextComponentRepaintCallback(JTextComponent jTextComponent) {
        for (Container container = jTextComponent; container != null; container = container.getParent()) {
            TextComponentAware textComponentAware;
            if (!(container instanceof JComponent) || (textComponentAware = (TextComponentAware)((JComponent)container).getClientProperty(TEXT_COMPONENT_AWARE)) == null) continue;
            return new SwingRepaintCallback((Component)container);
        }
        return new SwingRepaintCallback((Component)jTextComponent);
    }

    public static boolean isOpaque(Component component) {
        return component.isOpaque();
    }

    public static interface TextComponentAware<T> {
        public JTextComponent getTextComponent(T var1);
    }
}

