/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.colorscheme.ShiftColorScheme;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.ui.SubstanceMenuBarUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTitleButton;
import org.pushingpixels.substance.internal.utils.icon.SubstanceIconFactory;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;

public class SubstanceInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected PropertyChangeListener substancePropertyListener;
    protected PropertyChangeListener substanceWinModifiedListener;
    protected static final String ICONIFYING = "substance.internal.internalTitleFramePane.iconifying";
    protected static final String UNINSTALLED = "substance.internal.internalTitleFramePane.uninstalled";

    public SubstanceInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
        this.setToolTipText(jInternalFrame.getTitle());
        SubstanceLookAndFeel.setDecorationType(this, DecorationAreaType.SECONDARY_TITLE_PANE);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            this.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceCoreUtilities.getSkin(this.frame).getActiveColorScheme(this.getThisDecorationType())));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("title".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceInternalFrameTitlePane.this.setToolTipText((String)propertyChangeEvent.getNewValue());
                }
                if ("JInternalFrame.messageType".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceInternalFrameTitlePane.this.updateOptionPaneState();
                    SubstanceInternalFrameTitlePane.this.frame.repaint();
                }
                if ("closed".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceInternalFrameTitlePane.this.windowMenu.setPopupMenuVisible(false);
                }
            }
        };
        this.frame.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceWinModifiedListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("windowModified".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceInternalFrameTitlePane.this.syncCloseButtonTooltip();
                }
            }
        };
        this.frame.getRootPane().addPropertyChangeListener(this.substanceWinModifiedListener);
    }

    @Override
    public void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.frame.getRootPane().removePropertyChangeListener(this.substanceWinModifiedListener);
        this.substanceWinModifiedListener = null;
        super.uninstallListeners();
    }

    public void uninstall() {
        if (this.menuBar != null && this.menuBar.getMenuCount() > 0) {
            SubstanceMenuBarUI substanceMenuBarUI;
            MenuBarUI menuBarUI = this.menuBar.getUI();
            if (menuBarUI instanceof SubstanceMenuBarUI && (substanceMenuBarUI = (SubstanceMenuBarUI)menuBarUI).getMenuBar() == this.menuBar) {
                menuBarUI.uninstallUI(this.menuBar);
            }
            SubstanceCoreUtilities.uninstallMenu(this.menuBar.getMenu(0));
            this.remove(this.menuBar);
            this.remove(this.maxButton);
            this.remove(this.closeButton);
            this.remove(this.iconButton);
        }
        this.uninstallListeners();
        this.putClientProperty(UNINSTALLED, Boolean.TRUE);
    }

    public void setActive(boolean bl) {
        if (this.getRootPane() != null) {
            this.getRootPane().repaint();
        }
    }

    @Override
    protected void enableActions() {
        super.enableActions();
        if (!this.frame.isIcon()) {
            if (this.maxButton != null) {
                this.maxButton.setEnabled(this.maximizeAction.isEnabled() || this.restoreAction.isEnabled());
            }
            if (this.iconButton != null) {
                this.iconButton.setEnabled(this.iconifyAction.isEnabled());
            }
        }
    }

    public DecorationAreaType getThisDecorationType() {
        DecorationAreaType decorationAreaType = SubstanceLookAndFeel.getDecorationType(this);
        if (decorationAreaType == DecorationAreaType.PRIMARY_TITLE_PANE) {
            return SubstanceCoreUtilities.isPaintRootPaneActivated(this.frame.getRootPane()) ? DecorationAreaType.PRIMARY_TITLE_PANE : DecorationAreaType.PRIMARY_TITLE_PANE_INACTIVE;
        }
        if (decorationAreaType == DecorationAreaType.SECONDARY_TITLE_PANE) {
            return SubstanceCoreUtilities.isPaintRootPaneActivated(this.frame.getRootPane()) ? DecorationAreaType.SECONDARY_TITLE_PANE : DecorationAreaType.SECONDARY_TITLE_PANE_INACTIVE;
        }
        return decorationAreaType;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Serializable serializable;
        Object object;
        int n;
        Serializable serializable2;
        JInternalFrame jInternalFrame;
        DecorationAreaType decorationAreaType = this.getThisDecorationType();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        float f = this.getParent() instanceof JInternalFrame.JDesktopIcon ? 0.6f : 1.0f;
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this.frame, (float)f, (Graphics)graphics));
        boolean bl = this.frame.getComponentOrientation().isLeftToRight();
        int n2 = this.getWidth();
        int n3 = this.getHeight() + 2;
        SubstanceColorScheme substanceColorScheme = SubstanceCoreUtilities.getSkin(this.frame).getEnabledColorScheme(decorationAreaType);
        Serializable serializable3 = jInternalFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, this);
        if (jInternalFrame == null) {
            serializable2 = (JInternalFrame.JDesktopIcon)SwingUtilities.getAncestorOfClass(JInternalFrame.JDesktopIcon.class, this);
            if (serializable2 != null) {
                jInternalFrame = ((JInternalFrame.JDesktopIcon)serializable2).getInternalFrame();
            }
            serializable3 = serializable2;
        }
        if (!((serializable2 = jInternalFrame.getBackground()) instanceof UIResource)) {
            double d = SubstanceCoreUtilities.getColorizationFactor(serializable3);
            substanceColorScheme = ShiftColorScheme.getShiftedScheme(substanceColorScheme, (Color)serializable2, d, null, 0.0);
        }
        String string = this.frame.getTitle();
        if (bl) {
            n = 5;
            object = this.frame.getFrameIcon();
            if (object != null) {
                n += object.getIconWidth() + 5;
            }
            int n4 = this.menuBar == null ? 0 : this.menuBar.getWidth() + 5;
            n += n4;
            if (object != null) {
                n4 += object.getIconWidth() + 5;
            }
            int n5 = n2 - 5;
            serializable = null;
            if (this.frame.isIconifiable()) {
                serializable = this.iconButton;
            } else if (this.frame.isMaximizable()) {
                serializable = this.maxButton;
            } else if (this.frame.isClosable()) {
                serializable = this.closeButton;
            }
            if (serializable != null) {
                var18_21 = ((Component)serializable).getBounds();
                n5 = ((Rectangle)var18_21).getBounds().x - 5;
            }
            if (string != null) {
                int n6;
                var18_21 = this.frame.getFontMetrics(graphics2D.getFont());
                String string2 = SubstanceCoreUtilities.clipString((FontMetrics)var18_21, n6 = n5 - n4, string);
                if (string.equals(string2)) {
                    this.setToolTipText(null);
                } else {
                    this.setToolTipText(string);
                }
                string = string2;
            }
        } else {
            n = n2 - 5;
            object = this.frame.getFrameIcon();
            if (object != null) {
                n -= object.getIconWidth() + 5;
            }
            int n7 = this.menuBar == null ? n : n - this.menuBar.getWidth() - 5;
            serializable = null;
            if (this.frame.isIconifiable()) {
                serializable = this.iconButton;
            } else if (this.frame.isMaximizable()) {
                serializable = this.maxButton;
            } else if (this.frame.isClosable()) {
                serializable = this.closeButton;
            }
            int n8 = 5;
            if (serializable != null) {
                var18_21 = ((Component)serializable).getBounds();
                n8 = ((Rectangle)var18_21).getBounds().x + 5;
            }
            if (string != null) {
                int n9;
                var18_21 = this.frame.getFontMetrics(graphics2D.getFont());
                String string3 = SubstanceCoreUtilities.clipString((FontMetrics)var18_21, n9 = n7 - n8, string);
                if (string.equals(string3)) {
                    this.setToolTipText(null);
                } else {
                    this.setToolTipText(string);
                }
                string = string3;
                n = n7 - ((FontMetrics)var18_21).stringWidth(string);
            }
        }
        BackgroundPaintingUtils.update(graphics2D, this, false, decorationAreaType);
        if (string != null) {
            object = this.getRootPane();
            serializable = ((JComponent)object).getFontMetrics(graphics2D.getFont());
            int n10 = (n3 - ((FontMetrics)serializable).getHeight()) / 2 + ((FontMetrics)serializable).getAscent();
            SubstanceTextUtilities.paintTextWithDropShadow(this, graphics2D, SubstanceColorUtilities.getForegroundColor(substanceColorScheme), string, n2, n3, n, n10);
        }
        graphics2D.dispose();
    }

    @Override
    protected void setButtonIcons() {
        super.setButtonIcons();
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        TransitionAwareIcon transitionAwareIcon = new TransitionAwareIcon(this.maxButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.RESTORE, substanceColorScheme, SubstanceCoreUtilities.getSkin(SubstanceInternalFrameTitlePane.this).getBackgroundColorScheme(SubstanceInternalFrameTitlePane.this.getThisDecorationType()));
            }
        }, "substance.internalFrame.restoreIcon");
        TransitionAwareIcon transitionAwareIcon2 = new TransitionAwareIcon(this.maxButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MAXIMIZE, substanceColorScheme, SubstanceCoreUtilities.getSkin(SubstanceInternalFrameTitlePane.this).getBackgroundColorScheme(SubstanceInternalFrameTitlePane.this.getThisDecorationType()));
            }
        }, "substance.internalFrame.maxIcon");
        TransitionAwareIcon transitionAwareIcon3 = new TransitionAwareIcon(this.iconButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MINIMIZE, substanceColorScheme, SubstanceCoreUtilities.getSkin(SubstanceInternalFrameTitlePane.this).getBackgroundColorScheme(SubstanceInternalFrameTitlePane.this.getThisDecorationType()));
            }
        }, "substance.internalFrame.minIcon");
        TransitionAwareIcon transitionAwareIcon4 = new TransitionAwareIcon(this.closeButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.CLOSE, substanceColorScheme, SubstanceCoreUtilities.getSkin(SubstanceInternalFrameTitlePane.this).getBackgroundColorScheme(SubstanceInternalFrameTitlePane.this.getThisDecorationType()));
            }
        }, "substance.internalFrame.closeIcon");
        if (this.frame.isIcon()) {
            this.iconButton.setIcon(transitionAwareIcon);
            this.iconButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.frame).getString("SystemMenu.restore"));
            this.maxButton.setIcon(transitionAwareIcon2);
            this.maxButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.frame).getString("SystemMenu.maximize"));
        } else {
            this.iconButton.setIcon(transitionAwareIcon3);
            this.iconButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.frame).getString("SystemMenu.iconify"));
            if (this.frame.isMaximum()) {
                this.maxButton.setIcon(transitionAwareIcon);
                this.maxButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.frame).getString("SystemMenu.restore"));
            } else {
                this.maxButton.setIcon(transitionAwareIcon2);
                this.maxButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.frame).getString("SystemMenu.maximize"));
            }
        }
        if (transitionAwareIcon4 != null) {
            this.closeButton.setIcon(transitionAwareIcon4);
            this.syncCloseButtonTooltip();
        }
    }

    @Override
    protected JMenuBar createSystemMenuBar() {
        this.menuBar = new SubstanceMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createSystemMenu());
        this.menuBar.setOpaque(false);
        this.menuBar.applyComponentOrientation(this.getComponentOrientation());
        return this.menuBar;
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.iconifyAction = new SubstanceIconifyAction();
    }

    @Override
    protected JMenu createSystemMenu() {
        JMenu jMenu = super.createSystemMenu();
        jMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    SubstanceInternalFrameTitlePane.this.closeAction.actionPerformed(new ActionEvent(mouseEvent.getSource(), 1001, null, EventQueue.getMostRecentEventTime(), mouseEvent.getModifiers()));
                }
            }
        });
        return jMenu;
    }

    @Override
    protected void addSystemMenuItems(JMenu jMenu) {
        jMenu.add(this.restoreAction);
        jMenu.add(this.iconifyAction);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            jMenu.add(this.maximizeAction);
        }
        jMenu.addSeparator();
        jMenu.add(this.closeAction);
    }

    @Override
    protected void createButtons() {
        this.iconButton = new SubstanceTitleButton("InternalFrameTitlePane.iconifyButtonAccessibleName");
        this.iconButton.addActionListener(this.iconifyAction);
        this.maxButton = new SubstanceTitleButton("InternalFrameTitlePane.maximizeButtonAccessibleName");
        this.maxButton.addActionListener(this.maximizeAction);
        this.closeButton = new SubstanceTitleButton("InternalFrameTitlePane.closeButtonAccessibleName");
        this.closeButton.addActionListener(this.closeAction);
        this.setButtonIcons();
        for (ActionListener actionListener : this.iconButton.getActionListeners()) {
            if (!(actionListener instanceof ClickListener)) continue;
            return;
        }
        this.iconButton.addActionListener(new ClickListener());
        for (ActionListener actionListener : this.maxButton.getActionListeners()) {
            if (!(actionListener instanceof ClickListener)) continue;
            return;
        }
        this.maxButton.addActionListener(new ClickListener());
        this.iconButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.maxButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.closeButton.putClientProperty("substancelaf.internal.isTitleCloseButton", Boolean.TRUE);
        this.closeButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.enableActions();
    }

    @Override
    protected LayoutManager createLayout() {
        return new SubstanceTitlePaneLayout();
    }

    protected void syncCloseButtonTooltip() {
        if (SubstanceCoreUtilities.isInternalFrameModified(this.frame)) {
            this.closeButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.frame).getString("SystemMenu.close") + " [" + SubstanceCoreUtilities.getResourceBundle(this.frame).getString("Tooltip.contentsNotSaved") + "]");
        } else {
            this.closeButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.frame).getString("SystemMenu.close"));
        }
        this.closeButton.repaint();
    }

    @Override
    public void removeNotify() {
        boolean bl;
        super.removeNotify();
        boolean bl2 = bl = this.frame.isIcon() && !this.frame.isClosed() || Boolean.TRUE.equals(this.frame.getClientProperty(ICONIFYING));
        if (!bl) {
            this.uninstall();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (Boolean.TRUE.equals(this.getClientProperty(UNINSTALLED))) {
            this.installTitlePane();
            this.putClientProperty(UNINSTALLED, null);
        }
    }

    private void updateOptionPaneState() {
        Object object = this.frame.getClientProperty("JInternalFrame.messageType");
        if (object == null) {
            return;
        }
        if (this.frame.isClosable()) {
            this.frame.setClosable(false);
        }
    }

    public AbstractButton getCloseButton() {
        return this.closeButton;
    }

    public class SubstanceMenuBar
    extends JMenuBar {
        @Override
        public void paint(Graphics graphics) {
            if (SubstanceInternalFrameTitlePane.this.frame.getFrameIcon() != null) {
                SubstanceInternalFrameTitlePane.this.frame.getFrameIcon().paintIcon(this, graphics, 0, 0);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, graphics, 0, 0);
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            int n = SubstanceSizeUtils.getTitlePaneIconSize();
            return new Dimension(Math.max(n, dimension.width), Math.max(dimension.height, n));
        }
    }

    public class SubstanceIconifyAction
    extends BasicInternalFrameTitlePane.IconifyAction {
        public SubstanceIconifyAction() {
            super(SubstanceInternalFrameTitlePane.this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SubstanceInternalFrameTitlePane.this.frame.putClientProperty(SubstanceInternalFrameTitlePane.ICONIFYING, Boolean.TRUE);
            super.actionPerformed(actionEvent);
            SubstanceInternalFrameTitlePane.this.frame.putClientProperty(SubstanceInternalFrameTitlePane.ICONIFYING, null);
        }
    }

    public static class ClickListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            buttonModel.setArmed(false);
            buttonModel.setPressed(false);
            buttonModel.setRollover(false);
            buttonModel.setSelected(false);
        }
    }

    protected class SubstanceTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        protected SubstanceTitlePaneLayout() {
            super(SubstanceInternalFrameTitlePane.this);
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int n;
            int n2;
            int n3 = 30;
            if (SubstanceInternalFrameTitlePane.this.frame.isClosable()) {
                n3 += 21;
            }
            if (SubstanceInternalFrameTitlePane.this.frame.isMaximizable()) {
                n3 += 16 + (SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (SubstanceInternalFrameTitlePane.this.frame.isIconifiable()) {
                n3 += 16 + (SubstanceInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fontMetrics = SubstanceInternalFrameTitlePane.this.frame.getFontMetrics(SubstanceInternalFrameTitlePane.this.getFont());
            String string = SubstanceInternalFrameTitlePane.this.frame.getTitle();
            int n4 = string != null ? fontMetrics.stringWidth(string) : 0;
            int n5 = n2 = string != null ? string.length() : 0;
            n3 = n2 > 2 ? (n3 += n4 < (n = fontMetrics.stringWidth(SubstanceInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...")) ? n4 : n) : (n3 += n4);
            int n6 = fontMetrics.getHeight();
            n6 += 7;
            Icon icon = SubstanceInternalFrameTitlePane.this.frame.getFrameIcon();
            int n7 = 0;
            if (icon != null) {
                n7 = Math.min(icon.getIconHeight(), 16);
            }
            n = Math.max(n6, n7 += 5);
            return new Dimension(n3, n);
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            boolean bl = SubstanceInternalFrameTitlePane.this.frame.getComponentOrientation().isLeftToRight();
            int n2 = SubstanceInternalFrameTitlePane.this.getWidth();
            int n3 = bl ? n2 : 0;
            int n4 = SubstanceInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            int n5 = SubstanceInternalFrameTitlePane.this.closeButton.getIcon().getIconWidth();
            int n6 = (SubstanceInternalFrameTitlePane.this.getHeight() - n4) / 2;
            Icon icon = SubstanceInternalFrameTitlePane.this.frame.getFrameIcon();
            int n7 = 0;
            int n8 = 0;
            if (icon != null) {
                n7 = icon.getIconHeight();
                n8 = icon.getIconWidth();
            }
            int n9 = bl ? 5 : n2 - 16 - 5;
            SubstanceInternalFrameTitlePane.this.menuBar.setBounds(n9, (SubstanceInternalFrameTitlePane.this.getHeight() - n7) / 2, n8, n7);
            if (SubstanceInternalFrameTitlePane.this.frame.isClosable()) {
                n = 4;
                SubstanceInternalFrameTitlePane.this.closeButton.setBounds(n3 += bl ? -n - n5 : n, n6, n5, n4);
                if (!bl) {
                    n3 += n5;
                }
            }
            if (SubstanceInternalFrameTitlePane.this.frame.isMaximizable()) {
                n = SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4;
                SubstanceInternalFrameTitlePane.this.maxButton.setBounds(n3 += bl ? -n - n5 : n, n6, n5, n4);
                if (!bl) {
                    n3 += n5;
                }
            }
            if (SubstanceInternalFrameTitlePane.this.frame.isIconifiable()) {
                n = SubstanceInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (SubstanceInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
                SubstanceInternalFrameTitlePane.this.iconButton.setBounds(n3 += bl ? -n - n5 : n, n6, n5, n4);
                if (!bl) {
                    n3 += n5;
                }
            }
        }
    }
}

