/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Component;
import java.awt.Insets;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.util.Set;
import org.pushingpixels.substance.api.SubstanceConstants;

public class SubstanceOutlineUtilities {
    public static GeneralPath getBaseOutline(Component component, float f, Set<SubstanceConstants.Side> set) {
        int n = component.getWidth();
        int n2 = component.getHeight();
        return SubstanceOutlineUtilities.getBaseOutline(n, n2, f, set);
    }

    public static GeneralPath getBaseOutline(int n, int n2, float f, Set<SubstanceConstants.Side> set) {
        return SubstanceOutlineUtilities.getBaseOutline(n, n2, f, set, null);
    }

    public static GeneralPath getBaseOutline(int n, int n2, float f, Set<SubstanceConstants.Side> set, int n3) {
        return SubstanceOutlineUtilities.getBaseOutline(n, n2, f, set, new Insets(n3, n3, n3, n3));
    }

    public static GeneralPath getBaseOutline(int n, int n2, float f, Set<SubstanceConstants.Side> set, Insets insets) {
        int n3;
        boolean bl = set != null && (set.contains((Object)SubstanceConstants.Side.LEFT) || set.contains((Object)SubstanceConstants.Side.TOP));
        boolean bl2 = set != null && (set.contains((Object)SubstanceConstants.Side.RIGHT) || set.contains((Object)SubstanceConstants.Side.TOP));
        boolean bl3 = set != null && (set.contains((Object)SubstanceConstants.Side.RIGHT) || set.contains((Object)SubstanceConstants.Side.BOTTOM));
        boolean bl4 = set != null && (set.contains((Object)SubstanceConstants.Side.LEFT) || set.contains((Object)SubstanceConstants.Side.BOTTOM));
        int n4 = insets == null ? 0 : insets.left;
        int n5 = n3 = insets == null ? 0 : insets.top;
        if (insets != null) {
            n -= insets.right + insets.left;
        }
        if (insets != null) {
            n2 -= insets.top + insets.bottom;
        }
        GeneralPath generalPath = new GeneralPath();
        if (bl) {
            generalPath.moveTo(n4, n3);
        } else {
            generalPath.moveTo((float)n4 + f, n3);
        }
        if (bl2) {
            generalPath.lineTo(n4 + n - 1, n3);
        } else {
            if (bl || (float)(n4 + n) - f - 1.0f >= f) {
                generalPath.lineTo((float)(n4 + n) - f - 1.0f, n3);
            }
            generalPath.append(new Arc2D.Double((float)(n4 + n - 1) - 2.0f * f, n3, 2.0f * f, 2.0f * f, 90.0, -90.0, 0), true);
        }
        if (bl3) {
            generalPath.lineTo(n4 + n - 1, n3 + n2 - 1);
        } else {
            if (bl2 || (float)(n3 + n2) - f - 1.0f >= f) {
                generalPath.lineTo(n4 + n - 1, (float)(n3 + n2) - f - 1.0f);
            }
            generalPath.append(new Arc2D.Double((float)(n4 + n) - 2.0f * f - 1.0f, (float)(n3 + n2 - 1) - 2.0f * f, 2.0f * f, 2.0f * f, 0.0, -90.0, 0), true);
        }
        if (bl4) {
            generalPath.lineTo(n4, n3 + n2 - 1);
        } else {
            if (bl3 || (float)(n4 + n) - f - 1.0f >= f) {
                generalPath.lineTo((float)n4 + f, n3 + n2 - 1);
            }
            generalPath.append(new Arc2D.Double(n4, (float)(n3 + n2) - 2.0f * f - 1.0f, 2.0f * f, 2.0f * f, 270.0, -90.0, 0), true);
        }
        if (bl) {
            generalPath.lineTo(n4, n3);
        } else {
            if (bl4 || (float)(n3 + n2) - f - 1.0f >= f) {
                generalPath.lineTo(n4, (float)n3 + f);
            }
            generalPath.append(new Arc2D.Double(n4, n3, 2.0f * f, 2.0f * f, 180.0, -90.0, 0), true);
        }
        return generalPath;
    }

    public static GeneralPath getTriangleButtonOutline(int n, int n2, float f, int n3) {
        return SubstanceOutlineUtilities.getTriangleButtonOutline(n, n2, f, new Insets(n3, n3, n3, n3));
    }

    public static GeneralPath getTriangleButtonOutline(int n, int n2, float f, Insets insets) {
        int n3 = insets.left;
        int n4 = insets.top;
        int n5 = n - insets.right;
        --n5;
        int n6 = n2 - insets.bottom;
        GeneralPath generalPath = new GeneralPath();
        float f2 = (float)((double)f / (1.5 * Math.pow(n2 -= insets.top + insets.bottom, 0.5)));
        if (Math.max(n -= insets.right + insets.left, n2) < 15) {
            f2 /= 2.0f;
        }
        generalPath.moveTo(f + (float)n3, n4);
        if ((float)n5 - f >= f) {
            generalPath.lineTo((float)n5 - f, n4);
        }
        generalPath.quadTo((float)n5 - f2, (float)n3 + f2, n5, (float)n3 + f);
        float f3 = ((float)n6 - 1.0f) / 2.0f;
        if (f3 >= f) {
            generalPath.lineTo(n5, f3);
        }
        generalPath.lineTo((float)(n5 + insets.right) / 2.0f, n6 - 1);
        generalPath.lineTo(n3, f3);
        if (f3 >= f) {
            generalPath.lineTo(n3, f3);
        }
        if ((float)n2 - f - 1.0f >= f) {
            generalPath.lineTo(n3, f + (float)n4);
        }
        generalPath.quadTo((float)n3 + f2, (float)n4 + f2, (float)n3 + f, n4);
        return generalPath;
    }
}

