/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JSpinner;
import javax.swing.border.Border;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.Sideable;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceInternalArrowButton;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.border.SubstanceButtonBorder;

public class SubstanceSpinnerButton
extends JButton
implements Sideable,
SubstanceInternalArrowButton {
    private int orientation;

    public SubstanceSpinnerButton(JSpinner jSpinner, final int n) {
        this.setEnabled(jSpinner.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(false);
        this.setMargin(new Insets(0, 0, 0, 2));
        this.setBorder(new SpinnerButtonBorder(ClassicButtonShaper.class){

            @Override
            public Insets getBorderInsets(Component component) {
                int n5 = SubstanceSizeUtils.getExtraPadding(SubstanceSizeUtils.getComponentFontSize(component));
                int n2 = SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(component), 3, 3, 1, false);
                int n3 = n == 1 ? n2 : 0;
                int n4 = n == 1 ? 0 : n2;
                return new Insets(n5 + n3, n5, n5 + n4, n5);
            }
        });
        this.orientation = n;
        this.setOpaque(false);
        this.setBorderPainted(false);
        this.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
    }

    @Override
    public void setBorder(Border border) {
        if (border instanceof SpinnerButtonBorder) {
            super.setBorder(border);
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public SubstanceConstants.Side getSide() {
        switch (this.orientation) {
            case 1: {
                return SubstanceConstants.Side.BOTTOM;
            }
            case 7: {
                return SubstanceConstants.Side.RIGHT;
            }
            case 5: {
                return SubstanceConstants.Side.TOP;
            }
            case 3: {
                return SubstanceConstants.Side.LEFT;
            }
        }
        return null;
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        if (SubstanceCoreUtilities.isButtonNeverPainted(this)) {
            return;
        }
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)this.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
        ComponentState componentState = modelStateInfo.getCurrModelState();
        float f = stateTransitionTracker.getActiveStrength();
        if (componentState == ComponentState.DISABLED_UNSELECTED) {
            f = 0.0f;
        }
        if (f == 0.0f) {
            return;
        }
        boolean bl = "Spinner.nextButton".equals(this.getName());
        int n = SubstanceSizeUtils.getComponentFontSize(this);
        int n2 = (int)Math.floor(1.5 * (double)SubstanceSizeUtils.getBorderStrokeWidth(n));
        float f2 = Math.max(0.0f, 2.0f * SubstanceSizeUtils.getClassicButtonCornerRadius(n) - (float)n2);
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        JSpinner jSpinner = (JSpinner)this.getParent();
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n3, n4);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n5 = this.getX();
        int n6 = this.getY();
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this, ColorSchemeAssociationKind.BORDER, componentState);
        if (bl) {
            SubstanceImageCreator.paintTextComponentBorder(this, graphics2D, 0, 0, n3, 1 * n4, f2, substanceColorScheme);
            graphics2D.translate(-n5, -n6);
            SubstanceImageCreator.paintTextComponentBorder(jSpinner, graphics2D, 0, 0, jSpinner.getWidth(), jSpinner.getHeight(), f2, substanceColorScheme);
            graphics2D.translate(n5, n6);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
                float f3;
                ComponentState componentState2 = entry.getKey();
                if (componentState2 == componentState || (f3 = entry.getValue().getContribution()) == 0.0f) continue;
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(f3));
                SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this, ColorSchemeAssociationKind.BORDER, componentState2);
                SubstanceImageCreator.paintTextComponentBorder(this, graphics2D, 0, 0, n3, 1 * n4, f2, substanceColorScheme2);
                graphics2D.translate(-n5, -n6);
                SubstanceImageCreator.paintTextComponentBorder(jSpinner, graphics2D, 0, 0, jSpinner.getWidth(), jSpinner.getHeight(), f2, substanceColorScheme2);
                graphics2D.translate(n5, n6);
            }
        } else {
            SubstanceImageCreator.paintTextComponentBorder(this, graphics2D, 0, 0, n3, 1 * n4, f2, substanceColorScheme);
            graphics2D.translate(-n5, -n6);
            SubstanceImageCreator.paintTextComponentBorder(jSpinner, graphics2D, 0, 0, jSpinner.getWidth(), jSpinner.getHeight(), f2, substanceColorScheme);
            graphics2D.translate(n5, n6);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
                float f4;
                ComponentState componentState3 = entry.getKey();
                if (componentState3 == componentState || (f4 = entry.getValue().getContribution()) == 0.0f) continue;
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(f4));
                SubstanceColorScheme substanceColorScheme3 = SubstanceColorSchemeUtilities.getColorScheme(this, ColorSchemeAssociationKind.BORDER, componentState3);
                SubstanceImageCreator.paintTextComponentBorder(this, graphics2D, 0, 0, n3, 1 * n4, f2, substanceColorScheme3);
                graphics2D.translate(-n5, -n6);
                SubstanceImageCreator.paintTextComponentBorder(jSpinner, graphics2D, 0, 0, jSpinner.getWidth(), jSpinner.getHeight(), f2, substanceColorScheme3);
                graphics2D.translate(n5, n6);
            }
        }
        graphics2D.dispose();
        Graphics2D graphics2D2 = (Graphics2D)graphics.create();
        graphics2D2.setComposite(LafWidgetUtilities.getAlphaComposite((Component)this, (float)f, (Graphics)graphics));
        graphics2D2.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D2.dispose();
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n = SubstanceSizeUtils.getComponentFontSize(this);
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = (int)SubstanceSizeUtils.getBorderStrokeWidth(n);
        if (this.getComponentOrientation().isLeftToRight()) {
            graphics2D.clipRect(n4, 0, n2 - n4, n3);
        } else {
            graphics2D.clipRect(0, 0, n2 - n4, n3);
        }
        super.paint(graphics2D);
        graphics2D.dispose();
    }

    static {
        AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.GHOSTING_BUTTON_PRESS, SubstanceSpinnerButton.class);
        AnimationConfigurationManager.getInstance().disallowAnimations(AnimationFacet.GHOSTING_ICON_ROLLOVER, SubstanceSpinnerButton.class);
    }

    private static abstract class SpinnerButtonBorder
    extends SubstanceButtonBorder {
        public SpinnerButtonBorder(Class<?> clazz) {
            super(clazz);
        }
    }
}

