/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.lafwidget.LafWidgetSupport;
import org.pushingpixels.lafwidget.utils.LafConstants;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.ui.SubstanceDesktopIconUI;
import org.pushingpixels.substance.internal.ui.SubstanceTabbedPaneUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePane;
import org.pushingpixels.substance.internal.utils.SubstanceWidgetManager;

public class SubstanceWidgetSupport
extends LafWidgetSupport {
    public JComponent getComponentForHover(JInternalFrame.JDesktopIcon jDesktopIcon) {
        SubstanceDesktopIconUI substanceDesktopIconUI = (SubstanceDesktopIconUI)jDesktopIcon.getUI();
        return substanceDesktopIconUI.getComponentForHover();
    }

    public boolean toInstallMenuSearch(JMenuBar jMenuBar) {
        if (!SubstanceWidgetManager.getInstance().isAllowed(SwingUtilities.getRootPane(jMenuBar), SubstanceConstants.SubstanceWidgetType.MENU_SEARCH)) {
            return false;
        }
        if (jMenuBar instanceof SubstanceTitlePane.SubstanceMenuBar) {
            return false;
        }
        return super.toInstallMenuSearch(jMenuBar);
    }

    public Icon getSearchIcon(int n, ComponentOrientation componentOrientation) {
        return SubstanceImageCreator.getSearchIcon(n, SubstanceColorSchemeUtilities.getColorScheme(null, ComponentState.DEFAULT), componentOrientation.isLeftToRight());
    }

    public Icon getArrowIcon(int n) {
        return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getControlFontSize(), n, SubstanceColorSchemeUtilities.getColorScheme(null, ComponentState.DEFAULT));
    }

    public Icon getNumberIcon(int n) {
        SubstanceColorScheme substanceColorScheme = SubstanceLookAndFeel.getCurrentSkin(null).getActiveColorScheme(DecorationAreaType.HEADER);
        return SubstanceImageCreator.getHexaMarker(n, substanceColorScheme);
    }

    public void markButtonAsFlat(AbstractButton abstractButton) {
        abstractButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        abstractButton.setOpaque(false);
    }

    public int getRolloverTabIndex(JTabbedPane jTabbedPane) {
        SubstanceTabbedPaneUI substanceTabbedPaneUI = (SubstanceTabbedPaneUI)jTabbedPane.getUI();
        return substanceTabbedPaneUI.getRolloverTabIndex();
    }

    public void setTabAreaInsets(JTabbedPane jTabbedPane, Insets insets) {
        SubstanceTabbedPaneUI substanceTabbedPaneUI = (SubstanceTabbedPaneUI)jTabbedPane.getUI();
        substanceTabbedPaneUI.setTabAreaInsets(insets);
    }

    public Insets getTabAreaInsets(JTabbedPane jTabbedPane) {
        SubstanceTabbedPaneUI substanceTabbedPaneUI = (SubstanceTabbedPaneUI)jTabbedPane.getUI();
        return substanceTabbedPaneUI.getTabAreaInsets();
    }

    public Rectangle getTabRectangle(JTabbedPane jTabbedPane, int n) {
        SubstanceTabbedPaneUI substanceTabbedPaneUI = (SubstanceTabbedPaneUI)jTabbedPane.getUI();
        return substanceTabbedPaneUI.getTabRectangle(n);
    }

    public void paintPasswordStrengthMarker(Graphics graphics, int n, int n2, int n3, int n4, LafConstants.PasswordStrength passwordStrength) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        SubstanceColorScheme substanceColorScheme = null;
        if (passwordStrength == LafConstants.PasswordStrength.WEAK) {
            substanceColorScheme = SubstanceColorSchemeUtilities.ORANGE;
        }
        if (passwordStrength == LafConstants.PasswordStrength.MEDIUM) {
            substanceColorScheme = SubstanceColorSchemeUtilities.YELLOW;
        }
        if (passwordStrength == LafConstants.PasswordStrength.STRONG) {
            substanceColorScheme = SubstanceColorSchemeUtilities.GREEN;
        }
        if (substanceColorScheme != null) {
            SubstanceImageCreator.paintRectangularBackground(null, graphics, n, n2, n3, n4, substanceColorScheme, 0.5f, false);
        }
        graphics2D.dispose();
    }

    public boolean hasLockIcon(Component component) {
        if (!SubstanceCoreUtilities.toShowExtraWidgets(component)) {
            return false;
        }
        return super.hasLockIcon(component);
    }

    public Icon getLockIcon(Component component) {
        return SubstanceImageCreator.makeTransparent(null, SubstanceImageCreator.getSmallLockIcon(SubstanceColorSchemeUtilities.getColorScheme(null, ComponentState.ENABLED), component), 0.3);
    }

    public boolean toInstallExtraElements(Component component) {
        return SubstanceCoreUtilities.toShowExtraWidgets(component);
    }

    public int getLookupIconSize() {
        int n = 2 + SubstanceSizeUtils.getControlFontSize();
        if (n % 2 != 0) {
            ++n;
        }
        return n;
    }

    public int getLookupButtonSize() {
        return 4 + SubstanceSizeUtils.getControlFontSize();
    }
}

