/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceBorder
implements Border,
UIResource {
    protected Insets myInsets;
    protected float alpha = 1.0f;
    protected float radiusScaleFactor = 0.5f;
    private static LazyResettableHashMap<BufferedImage> smallImageCache = new LazyResettableHashMap("SubstanceBorder");

    public SubstanceBorder() {
    }

    public SubstanceBorder(float f) {
        this();
        this.radiusScaleFactor = f;
    }

    public SubstanceBorder(Insets insets) {
        this();
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    private void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2, float f) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        if (f == 0.0f) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        float f2 = this.radiusScaleFactor * SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(component));
        ComponentState componentState = bl ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, ColorSchemeAssociationKind.BORDER, componentState);
        float f3 = f * SubstanceColorSchemeUtilities.getAlpha(component, componentState);
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)component, (float)f3, (Graphics)graphics));
        if (n3 * n4 < 100000) {
            HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(SubstanceCoreUtilities.getBorderPainter(component).getDisplayName(), SubstanceSizeUtils.getComponentFontSize(component), n3, n4, Float.valueOf(f2), substanceColorScheme.getDisplayName());
            BufferedImage bufferedImage = smallImageCache.get(hashMapKey);
            if (bufferedImage == null) {
                bufferedImage = SubstanceCoreUtilities.getBlankImage(n3, n4);
                Graphics2D graphics2D2 = bufferedImage.createGraphics();
                SubstanceImageCreator.paintBorder(component, graphics2D2, 0, 0, n3, n4, f2, substanceColorScheme);
                graphics2D2.dispose();
                smallImageCache.put(hashMapKey, bufferedImage);
            }
            graphics2D.drawImage((Image)bufferedImage, n, n2, null);
        } else {
            graphics2D.translate(n, n2);
            SubstanceImageCreator.paintSimpleBorder(component, graphics2D, n3, n4, substanceColorScheme);
        }
        graphics2D.dispose();
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintBorder(component, graphics, n, n2, n3, n4, component.isEnabled(), component.hasFocus(), this.alpha);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        if (this.myInsets == null) {
            return SubstanceSizeUtils.getDefaultBorderInsets(SubstanceSizeUtils.getComponentFontSize(component));
        }
        return this.myInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public float getRadiusScaleFactor() {
        return this.radiusScaleFactor;
    }
}

