/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstancePaneBorder
extends AbstractBorder
implements UIResource {
    private static final int BORDER_THICKNESS = 4;
    private static final int BORDER_ROUNDNESS = 12;
    private static final Insets INSETS = new Insets(4, 4, 4, 4);

    public static DecorationAreaType getRootPaneType(JRootPane jRootPane) {
        DecorationAreaType decorationAreaType = SubstanceLookAndFeel.getDecorationType(jRootPane);
        if (decorationAreaType == null || decorationAreaType == DecorationAreaType.NONE) {
            decorationAreaType = SubstanceCoreUtilities.isPaintRootPaneActivated(jRootPane) ? (SubstanceCoreUtilities.isSecondaryWindow(jRootPane) ? DecorationAreaType.SECONDARY_TITLE_PANE : DecorationAreaType.PRIMARY_TITLE_PANE) : (SubstanceCoreUtilities.isSecondaryWindow(jRootPane) ? DecorationAreaType.SECONDARY_TITLE_PANE_INACTIVE : DecorationAreaType.PRIMARY_TITLE_PANE_INACTIVE);
        } else if (decorationAreaType == DecorationAreaType.PRIMARY_TITLE_PANE) {
            if (!SubstanceCoreUtilities.isPaintRootPaneActivated(jRootPane)) {
                decorationAreaType = DecorationAreaType.PRIMARY_TITLE_PANE_INACTIVE;
            }
        } else if (decorationAreaType == DecorationAreaType.SECONDARY_TITLE_PANE && !SubstanceCoreUtilities.isPaintRootPaneActivated(jRootPane)) {
            decorationAreaType = DecorationAreaType.SECONDARY_TITLE_PANE_INACTIVE;
        }
        return decorationAreaType;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (SubstanceCoreUtilities.isRoundedCorners(component)) {
            this.paintRoundedBorder(component, graphics, n, n2, n3, n4);
        } else {
            this.paintSquareBorder(component, graphics, n, n2, n3, n4);
        }
    }

    public void paintSquareBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        SubstanceSkin substanceSkin = SubstanceCoreUtilities.getSkin(component);
        if (substanceSkin == null) {
            return;
        }
        SubstanceColorScheme substanceColorScheme = substanceSkin.getBackgroundColorScheme(SubstancePaneBorder.getRootPaneType(SwingUtilities.getRootPane(component)));
        JComponent jComponent = SubstanceLookAndFeel.getTitlePaneComponent(SwingUtilities.windowForComponent(component));
        SubstanceColorScheme substanceColorScheme2 = substanceSkin.getColorScheme(jComponent, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(substanceColorScheme2.getUltraDarkColor());
        graphics2D.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics2D.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        graphics2D.setColor(substanceColorScheme2.getDarkColor());
        graphics2D.drawLine(n, n2, n + n3 - 2, n2);
        graphics2D.drawLine(n, n2, n, n2 + n4 - 2);
        graphics2D.setColor(substanceColorScheme.getMidColor());
        graphics2D.drawLine(n + 1, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
        graphics2D.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + n4 - 2);
        graphics2D.setColor(substanceColorScheme.getMidColor());
        graphics2D.drawLine(n + 1, n2 + 1, n + n3 - 3, n2 + 1);
        graphics2D.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 3);
        graphics2D.setColor(substanceColorScheme.getLightColor());
        graphics2D.drawRect(n + 2, n2 + 2, n3 - 5, n4 - 5);
        graphics2D.drawRect(n + 3, n2 + 3, n3 - 7, n4 - 7);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return INSETS;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = SubstancePaneBorder.INSETS.top;
        insets.left = SubstancePaneBorder.INSETS.left;
        insets.bottom = SubstancePaneBorder.INSETS.bottom;
        insets.right = SubstancePaneBorder.INSETS.right;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void paintRoundedBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        SubstanceColorScheme substanceColorScheme = this.getColorScheme(component);
        if (substanceColorScheme == null) {
            return;
        }
        SubstanceColorScheme substanceColorScheme2 = this.getBorderColorScheme(component);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n5 = n + 4 + 2;
        int n6 = n + n3 - 4 - 3;
        int n7 = n2 + 4 + 2;
        int n8 = n2 + n4 - 4 - 3;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(substanceColorScheme2.getUltraDarkColor());
        graphics2D.drawLine(n5, n2 + n4 - 1, n6, n2 + n4 - 1);
        graphics2D.drawLine(n + n3 - 1, n7, n + n3 - 1, n8);
        graphics2D.fillOval(n + n3 - 12, n2 + n4 - 12, 12, 12);
        graphics2D.setColor(substanceColorScheme2.getDarkColor());
        graphics2D.drawLine(n5, n2, n6, n2);
        graphics2D.drawLine(n, n7, n, n8);
        graphics2D.fillOval(0, 0, 12, 12);
        graphics2D.fillOval(0, n2 + n4 - 12, 12, 12);
        graphics2D.fillOval(n + n3 - 12, 0, 12, 12);
        graphics2D.setColor(substanceColorScheme.getMidColor());
        graphics2D.drawLine(n5, n2 + n4 - 2, n6, n2 + n4 - 2);
        graphics2D.drawLine(n + n3 - 2, n7, n + n3 - 2, n8);
        graphics2D.drawLine(n5, n2 + 1, n6, n2 + 1);
        graphics2D.drawLine(n + 1, n7, n + 1, n8);
        graphics2D.fillOval(1, 1, 12, 12);
        graphics2D.fillOval(1, n2 + n4 - 12 - 1, 12, 12);
        graphics2D.fillOval(n + n3 - 12 - 1, 1, 12, 12);
        graphics2D.fillOval(n + n3 - 12 - 1, n2 + n4 - 12 - 1, 12, 12);
        graphics2D.setColor(substanceColorScheme.getLightColor());
        graphics2D.drawLine(n5, n2 + 2, n6, n2 + 2);
        graphics2D.drawLine(n + 2, n7, n + 2, n8);
        graphics2D.drawLine(n5, n2 + n4 - 3, n6, n2 + n4 - 3);
        graphics2D.drawLine(n + n3 - 3, n7, n + n3 - 3, n8);
        graphics2D.drawLine(n5, n2 + 3, n6, n2 + 3);
        graphics2D.drawLine(n + 3, n7, n + 3, n8);
        graphics2D.drawLine(n5, n2 + n4 - 4, n6, n2 + n4 - 4);
        graphics2D.drawLine(n + n3 - 4, n7, n + n3 - 4, n8);
        graphics2D.fillOval(2, 2, 12, 12);
        graphics2D.fillOval(2, n2 + n4 - 12 - 2, 12, 12);
        graphics2D.fillOval(n + n3 - 12 - 2, 2, 12, 12);
        graphics2D.fillOval(n + n3 - 12 - 2, n2 + n4 - 12 - 2, 12, 12);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    private SubstanceColorScheme getColorScheme(Component component) {
        JRootPane jRootPane = component instanceof JRootPane ? (JRootPane)component : SwingUtilities.getRootPane(component);
        SubstanceSkin substanceSkin = SubstanceCoreUtilities.getSkin(component);
        if (substanceSkin == null) {
            return null;
        }
        DecorationAreaType decorationAreaType = SubstancePaneBorder.getRootPaneType(jRootPane);
        return substanceSkin.getBackgroundColorScheme(decorationAreaType);
    }

    private SubstanceColorScheme getBorderColorScheme(Component component) {
        JRootPane jRootPane = component instanceof JRootPane ? (JRootPane)component : SwingUtilities.getRootPane(component);
        SubstanceSkin substanceSkin = SubstanceCoreUtilities.getSkin(component);
        if (substanceSkin == null) {
            return null;
        }
        JComponent jComponent = SubstanceLookAndFeel.getTitlePaneComponent(SwingUtilities.windowForComponent(component));
        return substanceSkin.getColorScheme(SubstancePaneBorder.getRootPaneType(jRootPane), ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
    }
}

