/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.combo;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class ComboBoxBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> regularBackgrounds = new LazyResettableHashMap("ComboBoxBackgroundDelegate");

    public static BufferedImage getFullAlphaBackground(JComboBox jComboBox, ButtonModel buttonModel, SubstanceFillPainter substanceFillPainter, SubstanceBorderPainter substanceBorderPainter, int n, int n2) {
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)jComboBox.getUI());
        StateTransitionTracker.ModelStateInfo modelStateInfo = transitionAwareUI.getTransitionTracker().getModelStateInfo();
        ComponentState componentState = modelStateInfo.getCurrModelState();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
        ClassicButtonShaper classicButtonShaper = ClassicButtonShaper.INSTANCE;
        int n3 = SubstanceSizeUtils.getComponentFontSize(jComboBox);
        float f = SubstanceSizeUtils.getClassicButtonCornerRadius(n3);
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jComboBox, componentState);
        SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(jComboBox, ColorSchemeAssociationKind.BORDER, componentState);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, n2, substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), jComboBox.getClass().getName(), Float.valueOf(f), n3);
        BufferedImage bufferedImage = regularBackgrounds.get(hashMapKey);
        if (bufferedImage == null) {
            bufferedImage = ComboBoxBackgroundDelegate.createBackgroundImage(jComboBox, classicButtonShaper, substanceFillPainter, substanceBorderPainter, n, n2, substanceColorScheme, substanceColorScheme2, f);
            regularBackgrounds.put(hashMapKey, bufferedImage);
        }
        if (componentState.isDisabled() || map.size() == 1) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
            float f2;
            ComponentState componentState2 = entry.getKey();
            if (componentState2 == componentState || !((f2 = entry.getValue().getContribution()) > 0.0f)) continue;
            graphics2D.setComposite(AlphaComposite.SrcOver.derive(f2));
            SubstanceColorScheme substanceColorScheme3 = SubstanceColorSchemeUtilities.getColorScheme(jComboBox, componentState2);
            SubstanceColorScheme substanceColorScheme4 = SubstanceColorSchemeUtilities.getColorScheme(jComboBox, ColorSchemeAssociationKind.BORDER, componentState2);
            HashMapKey hashMapKey2 = SubstanceCoreUtilities.getHashKey(n, n2, substanceColorScheme3.getDisplayName(), substanceColorScheme4.getDisplayName(), substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), jComboBox.getClass().getName(), Float.valueOf(f), n3);
            BufferedImage bufferedImage3 = regularBackgrounds.get(hashMapKey2);
            if (bufferedImage3 == null) {
                bufferedImage3 = ComboBoxBackgroundDelegate.createBackgroundImage(jComboBox, classicButtonShaper, substanceFillPainter, substanceBorderPainter, n, n2, substanceColorScheme3, substanceColorScheme4, f);
                regularBackgrounds.put(hashMapKey2, bufferedImage3);
            }
            graphics2D.drawImage((Image)bufferedImage3, 0, 0, null);
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    private static BufferedImage createBackgroundImage(JComboBox jComboBox, SubstanceButtonShaper substanceButtonShaper, SubstanceFillPainter substanceFillPainter, SubstanceBorderPainter substanceBorderPainter, int n, int n2, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2, float f) {
        int n3 = SubstanceSizeUtils.getComponentFontSize(jComboBox);
        int n4 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(n3) / 2.0);
        GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n, n2, f, null, n4);
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        substanceFillPainter.paintContourBackground(graphics2D, jComboBox, n, n2, generalPath, false, substanceColorScheme, true);
        int n5 = (int)SubstanceSizeUtils.getBorderStrokeWidth(n3);
        GeneralPath generalPath2 = substanceBorderPainter.isPaintingInnerContour() ? SubstanceOutlineUtilities.getBaseOutline(n, n2, f - (float)n5, null, n4 + n5) : null;
        substanceBorderPainter.paintBorder(graphics2D, jComboBox, n, n2, generalPath, generalPath2, substanceColorScheme2);
        return bufferedImage;
    }

    public void updateBackground(Graphics graphics, JComboBox jComboBox, ButtonModel buttonModel) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        int n = jComboBox.getWidth();
        int n2 = jComboBox.getHeight();
        int n3 = 0;
        SubstanceFillPainter substanceFillPainter = SubstanceCoreUtilities.getFillPainter(jComboBox);
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(jComboBox);
        BufferedImage bufferedImage = ComboBoxBackgroundDelegate.getFullAlphaBackground(jComboBox, buttonModel, substanceFillPainter, substanceBorderPainter, n, n2);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)jComboBox.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
        boolean bl = SubstanceCoreUtilities.hasFlatAppearance(jComboBox, false);
        boolean bl2 = bl || !jComboBox.isEnabled();
        float f = 1.0f;
        if (bl2) {
            if (bl) {
                f = 0.0f;
                for (Map.Entry entry : map.entrySet()) {
                    ComponentState componentState = (ComponentState)entry.getKey();
                    if (componentState.isDisabled() || componentState == ComponentState.ENABLED) continue;
                    f += ((StateTransitionTracker.StateContributionInfo)entry.getValue()).getContribution();
                }
            } else if (!jComboBox.isEnabled()) {
                f = SubstanceColorSchemeUtilities.getAlpha(jComboBox, modelStateInfo.getCurrModelState());
            }
        }
        if (f > 0.0f) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)jComboBox, (float)f, (Graphics)graphics));
            graphics2D.drawImage((Image)bufferedImage, 0, n3, null);
            graphics2D.dispose();
        }
    }

    static String getMemoryUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SubstanceBackgroundDelegate: \n");
        stringBuffer.append("\t" + regularBackgrounds.size() + " regular");
        return stringBuffer.toString();
    }
}

