/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.combo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseMotionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicComboPopup;
import org.pushingpixels.substance.internal.ui.SubstanceListUI;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceBorder;

public class SubstanceComboPopup
extends BasicComboPopup {
    public static final String MIN_HEIGHT_PROPERTY = "SubstanceComboPopup.MIN_HEIGHT_PROPERTY";

    public SubstanceComboPopup(JComboBox jComboBox) {
        super(jComboBox);
        this.setOpaque(true);
        this.list.setBackground(jComboBox.getBackground());
    }

    @Override
    protected ListDataListener createListDataListener() {
        return new BasicComboPopup.ListDataHandler(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                if (listDataEvent.getIndex0() == -2 && SubstanceComboPopup.this.isShowing() && SubstanceComboPopup.this.getClientProperty(SubstanceComboPopup.MIN_HEIGHT_PROPERTY) == null) {
                    SubstanceComboPopup.this.hide();
                    Point point = SubstanceComboPopup.this.getPopupLocation();
                    SubstanceComboPopup.this.show(SubstanceComboPopup.this.comboBox, point.x, point.y);
                }
            }
        };
    }

    @Override
    protected void configurePopup() {
        super.configurePopup();
        this.setBorder(new SubstanceBorder(new Insets(0, 2, 2, 2)));
    }

    @Override
    protected MouseMotionListener createListMouseMotionListener() {
        return null;
    }

    private Point getPopupLocation() {
        Dimension dimension = this.comboBox.getSize();
        Insets insets = this.getInsets();
        dimension.setSize(dimension.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
        Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
        Dimension dimension2 = rectangle.getSize();
        Point point = rectangle.getLocation();
        this.scroller.setMaximumSize(dimension2);
        this.scroller.setPreferredSize(dimension2);
        this.scroller.setMinimumSize(dimension2);
        this.list.revalidate();
        return new Point(point.x, point.y);
    }

    @Override
    protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
        Object object;
        Rectangle rectangle;
        Cloneable cloneable;
        Object object2 = this.getClientProperty(MIN_HEIGHT_PROPERTY);
        if (object2 instanceof Integer) {
            n4 = Math.max(n4, (Integer)object2);
        }
        int n5 = SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox);
        Insets insets = this.getInsets();
        int n6 = 0;
        int n7 = 0;
        switch (n5) {
            case 1: {
                n7 = -n4 - (int)this.comboBox.getSize().getHeight() - insets.top - insets.bottom;
                break;
            }
            case 0: {
                n7 = -n4 / 2 - (int)this.comboBox.getSize().getHeight() / 2 - insets.top / 2 - insets.bottom / 2;
                break;
            }
            case 3: {
                n6 = n3 + insets.left + insets.right;
                n7 = -((int)this.comboBox.getSize().getHeight());
                break;
            }
            case 7: {
                n6 = -n3 - insets.left - insets.right;
                n7 = -((int)this.comboBox.getSize().getHeight());
            }
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = this.comboBox.getGraphicsConfiguration();
        Point point = new Point();
        SwingUtilities.convertPointFromScreen(point, this.comboBox);
        if (graphicsConfiguration != null) {
            cloneable = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle = graphicsConfiguration.getBounds();
            rectangle.width -= cloneable.left + cloneable.right;
            rectangle.height -= cloneable.top + cloneable.bottom;
            rectangle.x += point.x + cloneable.left;
            rectangle.y += point.y + cloneable.top;
        } else {
            rectangle = new Rectangle(point, toolkit.getScreenSize());
        }
        cloneable = new Rectangle(n + n6, n2 + n7, n3, n4);
        if (n2 + n4 > rectangle.y + rectangle.height && n4 < rectangle.height) {
            ((Rectangle)cloneable).y = -((Rectangle)cloneable).height - insets.top - insets.bottom;
        }
        if ((object = SubstanceCoreUtilities.getComboPopupPrototypeDisplayValue(this.comboBox)) != null) {
            boolean bl;
            ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
            Component component = listCellRenderer.getListCellRendererComponent(this.list, object, -1, true, true);
            int n8 = component.getPreferredSize().width;
            boolean bl2 = bl = this.comboBox.getItemCount() > this.comboBox.getMaximumRowCount();
            if (bl) {
                JScrollBar jScrollBar = this.scroller.getVerticalScrollBar();
                n8 += jScrollBar.getPreferredSize().width;
            }
            ((Rectangle)cloneable).width = n3 = Math.max(n3, n8);
        }
        int n9 = this.getModelMinimumSize().width;
        if (this.comboBox.getItemCount() > this.comboBox.getMaximumRowCount()) {
            n9 += this.scroller.getVerticalScrollBar().getPreferredSize().width;
        }
        ((Rectangle)cloneable).width = Math.max(((Rectangle)cloneable).width, n9);
        ((Rectangle)cloneable).width = Math.min(((Rectangle)cloneable).width, rectangle.width);
        return cloneable;
    }

    private Dimension getModelMinimumSize() {
        DefaultListCellRenderer defaultListCellRenderer = this.comboBox.getRenderer();
        if (defaultListCellRenderer == null) {
            defaultListCellRenderer = new DefaultListCellRenderer();
        }
        Dimension dimension = new Dimension(100, 0);
        if (this.comboBox.getPrototypeDisplayValue() != null) {
            Dimension dimension2 = defaultListCellRenderer.getListCellRendererComponent(this.list, this.comboBox.getPrototypeDisplayValue(), -1, false, false).getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = dimension2.height;
        } else {
            ComboBoxModel comboBoxModel = this.comboBox.getModel();
            int n = Math.min(comboBoxModel.getSize(), 1000);
            for (int i = 0; i < n; ++i) {
                Dimension dimension3 = defaultListCellRenderer.getListCellRendererComponent(this.list, comboBoxModel.getElementAt(i), -1, false, false).getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension3.width);
                dimension.height = Math.max(dimension.height, dimension3.height);
            }
        }
        return dimension;
    }

    @Override
    public void hide() {
        super.hide();
        SubstanceListUI substanceListUI = (SubstanceListUI)this.list.getUI();
        substanceListUI.resetRolloverIndex();
    }

    public JComboBox getCombobox() {
        return this.comboBox;
    }
}

