/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.filters;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.filters.AbstractFilter;

public class ColorSchemeFilter
extends AbstractFilter {
    private int[] interpolated;
    public static final int MAPSTEPS = 512;
    protected static final LazyResettableHashMap<ColorSchemeFilter> filters = new LazyResettableHashMap("ColorSchemeFilter");
    protected float originalBrightnessFactor;

    public static ColorSchemeFilter getColorSchemeFilter(SubstanceColorScheme substanceColorScheme, float f) {
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(substanceColorScheme.getDisplayName(), Float.valueOf(f));
        ColorSchemeFilter colorSchemeFilter = filters.get(hashMapKey);
        if (colorSchemeFilter == null) {
            colorSchemeFilter = new ColorSchemeFilter(substanceColorScheme, f);
            filters.put(hashMapKey, colorSchemeFilter);
        }
        return colorSchemeFilter;
    }

    private ColorSchemeFilter(SubstanceColorScheme substanceColorScheme, float f) {
        int n;
        int n2;
        if (substanceColorScheme == null) {
            throw new IllegalArgumentException("mixColor cannot be null");
        }
        this.originalBrightnessFactor = f;
        TreeMap<Integer, Color> treeMap = new TreeMap<Integer, Color>();
        treeMap.put(SubstanceColorUtilities.getColorBrightness(substanceColorScheme.getUltraLightColor().getRGB()), substanceColorScheme.getUltraLightColor());
        treeMap.put(SubstanceColorUtilities.getColorBrightness(substanceColorScheme.getExtraLightColor().getRGB()), substanceColorScheme.getExtraLightColor());
        treeMap.put(SubstanceColorUtilities.getColorBrightness(substanceColorScheme.getLightColor().getRGB()), substanceColorScheme.getLightColor());
        treeMap.put(SubstanceColorUtilities.getColorBrightness(substanceColorScheme.getMidColor().getRGB()), substanceColorScheme.getMidColor());
        treeMap.put(SubstanceColorUtilities.getColorBrightness(substanceColorScheme.getDarkColor().getRGB()), substanceColorScheme.getDarkColor());
        treeMap.put(SubstanceColorUtilities.getColorBrightness(substanceColorScheme.getUltraDarkColor().getRGB()), substanceColorScheme.getUltraDarkColor());
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(treeMap.keySet());
        Collections.sort(arrayList);
        int n3 = (Integer)arrayList.get(0);
        int n4 = (Integer)arrayList.get(arrayList.size() - 1);
        boolean bl = n4 == n3;
        TreeMap<Integer, Color> treeMap2 = new TreeMap<Integer, Color>();
        for (Map.Entry entry : treeMap.entrySet()) {
            n2 = (Integer)entry.getKey();
            n = bl ? n2 : 255 - 255 * (n4 - n2) / (n4 - n3);
            treeMap2.put(n, (Color)entry.getValue());
        }
        arrayList = new ArrayList();
        arrayList.addAll(treeMap2.keySet());
        Collections.sort(arrayList);
        this.interpolated = new int[512];
        block1: for (int i = 0; i < 512; ++i) {
            int n5 = (int)(256.0 * (double)i / 512.0);
            if (arrayList.contains(n5)) {
                this.interpolated[i] = ((Color)treeMap2.get(n5)).getRGB();
                continue;
            }
            if (bl) {
                this.interpolated[i] = ((Color)treeMap2.get(n3)).getRGB();
                continue;
            }
            n2 = 0;
            while (true) {
                n = (Integer)arrayList.get(n2);
                int n6 = (Integer)arrayList.get(n2 + 1);
                if (n5 > n && n5 < n6) {
                    Color color = (Color)treeMap2.get(n);
                    Color color2 = (Color)treeMap2.get(n6);
                    this.interpolated[i] = SubstanceColorUtilities.getInterpolatedRGB(color, color2, 1.0 - (double)(n5 - n) / (double)(n6 - n));
                    continue block1;
                }
                ++n2;
            }
        }
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        this.getPixels(bufferedImage, 0, 0, n, n2, nArray);
        this.mixColor(nArray);
        this.setPixels(bufferedImage2, 0, 0, n, n2, nArray);
        return bufferedImage2;
    }

    private void mixColor(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = SubstanceColorUtilities.getColorBrightness(n);
            int n3 = n >>> 16 & 0xFF;
            int n4 = n >>> 8 & 0xFF;
            int n5 = n >>> 0 & 0xFF;
            float[] fArray = Color.RGBtoHSB(n3, n4, n5, null);
            int n6 = this.interpolated[n2 * 512 / 256];
            int n7 = n6 >>> 16 & 0xFF;
            int n8 = n6 >>> 8 & 0xFF;
            int n9 = n6 >>> 0 & 0xFF;
            float[] fArray2 = Color.RGBtoHSB(n7, n8, n9, null);
            fArray[0] = fArray2[0];
            fArray[1] = fArray2[1];
            fArray[2] = this.originalBrightnessFactor * fArray[2] + (1.0f - this.originalBrightnessFactor) * fArray2[2];
            int n10 = Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]);
            nArray[i] = n & 0xFF000000 | (n10 >> 16 & 0xFF) << 16 | (n10 >> 8 & 0xFF) << 8 | n10 & 0xFF;
        }
    }
}

