/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JSlider;
import javax.swing.JTree;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSliderUI;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceIconFactory {
    private static LazyResettableHashMap<Icon> sliderHorizontalIcons = new LazyResettableHashMap("SubstanceIconFactory.sliderHorizontalIcon");
    private static LazyResettableHashMap<Icon> sliderRoundIcons = new LazyResettableHashMap("SubstanceIconFactory.sliderRoundIcon");
    private static LazyResettableHashMap<Icon> sliderVerticalIcons = new LazyResettableHashMap("SubstanceIconFactory.sliderVerticalIcon");
    private static LazyResettableHashMap<Icon> treeIcons = new LazyResettableHashMap("SubstanceIconFactory.treeIcon");
    private static final Map<IconKind, LazyResettableHashMap<Icon>> titlePaneIcons = SubstanceIconFactory.createTitlePaneIcons();

    public static Icon getSliderHorizontalIcon(int n, boolean bl) {
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, bl);
        if (sliderHorizontalIcons.get(hashMapKey) == null) {
            SliderHorizontalIcon sliderHorizontalIcon = new SliderHorizontalIcon(n, bl);
            sliderHorizontalIcons.put(hashMapKey, sliderHorizontalIcon);
        }
        return sliderHorizontalIcons.get(hashMapKey);
    }

    public static Icon getSliderRoundIcon(int n) {
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n);
        if (sliderRoundIcons.get(hashMapKey) == null) {
            SliderRoundIcon sliderRoundIcon = new SliderRoundIcon(n);
            sliderRoundIcons.put(hashMapKey, sliderRoundIcon);
        }
        return sliderRoundIcons.get(hashMapKey);
    }

    public static Icon getSliderVerticalIcon(int n, boolean bl) {
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, bl);
        if (sliderVerticalIcons.get(hashMapKey) == null) {
            SliderVerticalIcon sliderVerticalIcon = new SliderVerticalIcon(n, bl);
            sliderVerticalIcons.put(hashMapKey, sliderVerticalIcon);
        }
        return sliderVerticalIcons.get(hashMapKey);
    }

    public static Icon getTreeIcon(JTree jTree, boolean bl) {
        int n = SubstanceSizeUtils.getComponentFontSize(jTree);
        int n2 = SubstanceSizeUtils.getTreeIconSize(n);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n2, bl);
        if (treeIcons.get(hashMapKey) == null) {
            TreeIcon treeIcon = new TreeIcon(n2, bl);
            treeIcons.put(hashMapKey, treeIcon);
        }
        return treeIcons.get(hashMapKey);
    }

    private static Map<IconKind, LazyResettableHashMap<Icon>> createTitlePaneIcons() {
        HashMap<IconKind, LazyResettableHashMap<Icon>> hashMap = new HashMap<IconKind, LazyResettableHashMap<Icon>>();
        hashMap.put(IconKind.CLOSE, new LazyResettableHashMap("Close title pane icons"));
        hashMap.put(IconKind.MINIMIZE, new LazyResettableHashMap("Minimize title pane icons"));
        hashMap.put(IconKind.MAXIMIZE, new LazyResettableHashMap("Maximize title pane icons"));
        hashMap.put(IconKind.RESTORE, new LazyResettableHashMap("Restore title pane icons"));
        return hashMap;
    }

    public static Icon getTitlePaneIcon(IconKind iconKind, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
        LazyResettableHashMap<Icon> lazyResettableHashMap = titlePaneIcons.get((Object)iconKind);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName());
        Icon icon = lazyResettableHashMap.get(hashMapKey);
        if (icon != null) {
            return icon;
        }
        switch (iconKind.ordinal()) {
            case 0: {
                icon = SubstanceImageCreator.getCloseIcon(substanceColorScheme, substanceColorScheme2);
                break;
            }
            case 1: {
                icon = SubstanceImageCreator.getMinimizeIcon(substanceColorScheme, substanceColorScheme2);
                break;
            }
            case 2: {
                icon = SubstanceImageCreator.getMaximizeIcon(substanceColorScheme, substanceColorScheme2);
                break;
            }
            case 3: {
                icon = SubstanceImageCreator.getRestoreIcon(substanceColorScheme, substanceColorScheme2);
            }
        }
        lazyResettableHashMap.put(hashMapKey, icon);
        return icon;
    }

    private static class SliderHorizontalIcon
    implements Icon,
    UIResource {
        private static LazyResettableHashMap<Icon> icons = new LazyResettableHashMap("SubstanceIconFactory.SliderHorizontalIcon");
        private int size;
        private boolean isMirrorred;

        public SliderHorizontalIcon(int n, boolean bl) {
            this.size = n;
            this.isMirrorred = bl;
        }

        private Icon getIcon(JSlider jSlider, StateTransitionTracker stateTransitionTracker) {
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
            ComponentState componentState = stateTransitionTracker.getModelStateInfo().getCurrModelState();
            float f = stateTransitionTracker.getActiveStrength();
            int n = (int)((double)this.size * (2.0 + (double)f) / 3.0);
            n = Math.min(n, this.size - 2);
            int n2 = (this.size - n) / 2;
            SubstanceFillPainter substanceFillPainter = SubstanceCoreUtilities.getFillPainter(jSlider);
            SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(jSlider);
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jSlider, componentState);
            SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(jSlider, ColorSchemeAssociationKind.BORDER, componentState);
            HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(this.size, n, substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), this.isMirrorred);
            Icon icon = icons.get(hashMapKey);
            if (icon == null) {
                icon = this.getSingleLayer(jSlider, n, n2, substanceFillPainter, substanceBorderPainter, substanceColorScheme, substanceColorScheme2);
                icons.put(hashMapKey, icon);
            }
            if (componentState.isDisabled() || map.size() == 1) {
                return icon;
            }
            BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(icon.getIconWidth(), icon.getIconHeight());
            Graphics2D graphics2D = bufferedImage.createGraphics();
            icon.paintIcon(jSlider, graphics2D, 0, 0);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
                float f2;
                ComponentState componentState2 = entry.getKey();
                if (componentState2 == componentState || (f2 = entry.getValue().getContribution()) == 0.0f) continue;
                SubstanceColorScheme substanceColorScheme3 = SubstanceColorSchemeUtilities.getColorScheme(jSlider, componentState2);
                SubstanceColorScheme substanceColorScheme4 = SubstanceColorSchemeUtilities.getColorScheme(jSlider, ColorSchemeAssociationKind.BORDER, componentState2);
                HashMapKey hashMapKey2 = SubstanceCoreUtilities.getHashKey(this.size, n, substanceColorScheme3.getDisplayName(), substanceColorScheme4.getDisplayName(), substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), this.isMirrorred);
                Icon icon2 = icons.get(hashMapKey2);
                if (icon2 == null) {
                    icon2 = this.getSingleLayer(jSlider, n, n2, substanceFillPainter, substanceBorderPainter, substanceColorScheme3, substanceColorScheme4);
                    icons.put(hashMapKey2, icon2);
                }
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(f2));
                icon2.paintIcon(jSlider, graphics2D, 0, 0);
            }
            graphics2D.dispose();
            return new ImageIcon(bufferedImage);
        }

        private Icon getSingleLayer(JSlider jSlider, int n, int n2, SubstanceFillPainter substanceFillPainter, SubstanceBorderPainter substanceBorderPainter, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
            int n3 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jSlider)) / 2.0);
            GeneralPath generalPath = SubstanceOutlineUtilities.getTriangleButtonOutline(n, this.size - 1, 2.0f, n3);
            BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(this.size - 1, this.size - 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(n2, 0);
            substanceFillPainter.paintContourBackground(graphics2D, jSlider, n, this.size - 1, generalPath, false, substanceColorScheme, true);
            int n4 = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jSlider));
            GeneralPath generalPath2 = SubstanceOutlineUtilities.getTriangleButtonOutline(n, this.size - 1, 2.0f, n4 + n3);
            substanceBorderPainter.paintBorder(graphics2D, jSlider, n, this.size - 1, generalPath, generalPath2, substanceColorScheme2);
            graphics2D.translate(-n2, 0);
            if (this.isMirrorred) {
                bufferedImage = SubstanceImageCreator.getRotated(bufferedImage, 2);
            }
            return new ImageIcon(bufferedImage);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!(graphics instanceof Graphics2D)) {
                return;
            }
            JSlider jSlider = (JSlider)component;
            TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)jSlider.getUI());
            StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
            Icon icon = this.getIcon(jSlider, stateTransitionTracker);
            icon.paintIcon(component, graphics, n, n2);
        }

        @Override
        public int getIconWidth() {
            return this.size - 1;
        }

        @Override
        public int getIconHeight() {
            return this.size - 1;
        }
    }

    private static class SliderRoundIcon
    implements Icon,
    UIResource {
        private static LazyResettableHashMap<Icon> icons = new LazyResettableHashMap("SubstanceIconFactory.SliderRoundIcon");
        private int size;

        public SliderRoundIcon(int n) {
            this.size = n;
        }

        private Icon getIcon(JSlider jSlider, StateTransitionTracker stateTransitionTracker) {
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
            ComponentState componentState = stateTransitionTracker.getModelStateInfo().getCurrModelState();
            float f = stateTransitionTracker.getActiveStrength();
            int n = (int)((double)this.size * (2.0 + (double)f) / 3.0);
            if ((n = Math.min(n, this.size - 2)) % 2 == 0) {
                --n;
            }
            int n2 = (this.size - n) / 2;
            SubstanceFillPainter substanceFillPainter = SubstanceCoreUtilities.getFillPainter(jSlider);
            SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(jSlider);
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jSlider, componentState);
            SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(jSlider, ColorSchemeAssociationKind.BORDER, componentState);
            HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(this.size, n, substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName());
            Icon icon = icons.get(hashMapKey);
            if (icon == null) {
                icon = this.getSingleLayer(jSlider, n, n2, substanceFillPainter, substanceBorderPainter, substanceColorScheme, substanceColorScheme2);
                icons.put(hashMapKey, icon);
            }
            if (componentState.isDisabled() || map.size() == 1) {
                return icon;
            }
            BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(icon.getIconWidth(), icon.getIconHeight());
            Graphics2D graphics2D = bufferedImage.createGraphics();
            icon.paintIcon(jSlider, graphics2D, 0, 0);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
                float f2;
                ComponentState componentState2 = entry.getKey();
                if (componentState2 == componentState || (f2 = entry.getValue().getContribution()) == 0.0f) continue;
                SubstanceColorScheme substanceColorScheme3 = SubstanceColorSchemeUtilities.getColorScheme(jSlider, componentState2);
                SubstanceColorScheme substanceColorScheme4 = SubstanceColorSchemeUtilities.getColorScheme(jSlider, ColorSchemeAssociationKind.BORDER, componentState2);
                HashMapKey hashMapKey2 = SubstanceCoreUtilities.getHashKey(this.size, n, substanceColorScheme3.getDisplayName(), substanceColorScheme4.getDisplayName(), substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName());
                Icon icon2 = icons.get(hashMapKey2);
                if (icon2 == null) {
                    icon2 = this.getSingleLayer(jSlider, n, n2, substanceFillPainter, substanceBorderPainter, substanceColorScheme3, substanceColorScheme4);
                    icons.put(hashMapKey2, icon2);
                }
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(f2));
                icon2.paintIcon(jSlider, graphics2D, 0, 0);
            }
            graphics2D.dispose();
            return new ImageIcon(bufferedImage);
        }

        private Icon getSingleLayer(JSlider jSlider, int n, int n2, SubstanceFillPainter substanceFillPainter, SubstanceBorderPainter substanceBorderPainter, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
            int n3 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jSlider)) / 2.0);
            Ellipse2D.Float float_ = new Ellipse2D.Float(n3, n3, n - 2 * n3 - 1, n - 2 * n3 - 1);
            BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(this.size - 1, this.size - 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(n2, n2);
            substanceFillPainter.paintContourBackground(graphics2D, jSlider, n, this.size - 1, float_, false, substanceColorScheme, true);
            int n4 = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jSlider));
            Ellipse2D.Float float_2 = new Ellipse2D.Float(n3 + n4, n3 + n4, n - 2 * n3 - 2 * n4 - 1, n - 2 * n3 - 2 * n4 - 1);
            substanceBorderPainter.paintBorder(graphics2D, jSlider, n, this.size - 1, float_, float_2, substanceColorScheme2);
            return new ImageIcon(bufferedImage);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!(graphics instanceof Graphics2D)) {
                return;
            }
            JSlider jSlider = (JSlider)component;
            TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)jSlider.getUI());
            StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
            Icon icon = this.getIcon(jSlider, stateTransitionTracker);
            icon.paintIcon(component, graphics, n, n2);
        }

        @Override
        public int getIconWidth() {
            return this.size - 1;
        }

        @Override
        public int getIconHeight() {
            return this.size - 1;
        }
    }

    private static class SliderVerticalIcon
    implements Icon,
    UIResource {
        private static LazyResettableHashMap<Icon> icons = new LazyResettableHashMap("SubstanceIconFactory.SliderVerticalIcon");
        private int size;
        private boolean isMirrorred;

        public SliderVerticalIcon(int n, boolean bl) {
            this.size = n;
            this.isMirrorred = bl;
        }

        private Icon getIcon(JSlider jSlider, StateTransitionTracker stateTransitionTracker) {
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
            ComponentState componentState = stateTransitionTracker.getModelStateInfo().getCurrModelState();
            float f = stateTransitionTracker.getActiveStrength();
            int n = (int)((double)this.size * (2.0 + (double)f) / 3.0);
            n = Math.min(n, this.size - 2);
            int n2 = (this.size - n) / 2 - 1;
            SubstanceFillPainter substanceFillPainter = SubstanceCoreUtilities.getFillPainter(jSlider);
            SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(jSlider);
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jSlider, componentState);
            SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(jSlider, ColorSchemeAssociationKind.BORDER, componentState);
            HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(this.size, n, jSlider.getComponentOrientation(), substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), this.isMirrorred);
            Icon icon = icons.get(hashMapKey);
            if (icon == null) {
                icon = this.getSingleLayer(jSlider, n, n2, substanceFillPainter, substanceBorderPainter, substanceColorScheme, substanceColorScheme2);
                icons.put(hashMapKey, icon);
            }
            if (componentState.isDisabled() || map.size() == 1) {
                return icon;
            }
            BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(icon.getIconWidth(), icon.getIconHeight());
            Graphics2D graphics2D = bufferedImage.createGraphics();
            icon.paintIcon(jSlider, graphics2D, 0, 0);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
                float f2;
                ComponentState componentState2 = entry.getKey();
                if (componentState2 == componentState || (f2 = entry.getValue().getContribution()) == 0.0f) continue;
                SubstanceColorScheme substanceColorScheme3 = SubstanceColorSchemeUtilities.getColorScheme(jSlider, componentState2);
                SubstanceColorScheme substanceColorScheme4 = SubstanceColorSchemeUtilities.getColorScheme(jSlider, ColorSchemeAssociationKind.BORDER, componentState2);
                HashMapKey hashMapKey2 = SubstanceCoreUtilities.getHashKey(this.size, n, jSlider.getComponentOrientation(), substanceColorScheme3.getDisplayName(), substanceColorScheme4.getDisplayName(), substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), this.isMirrorred);
                Icon icon2 = icons.get(hashMapKey2);
                if (icon2 == null) {
                    icon2 = this.getSingleLayer(jSlider, n, n2, substanceFillPainter, substanceBorderPainter, substanceColorScheme3, substanceColorScheme4);
                    icons.put(hashMapKey2, icon2);
                }
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(f2));
                icon2.paintIcon(jSlider, graphics2D, 0, 0);
            }
            graphics2D.dispose();
            return new ImageIcon(bufferedImage);
        }

        private Icon getSingleLayer(JSlider jSlider, int n, int n2, SubstanceFillPainter substanceFillPainter, SubstanceBorderPainter substanceBorderPainter, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
            int n3 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jSlider)) / 2.0);
            GeneralPath generalPath = SubstanceOutlineUtilities.getTriangleButtonOutline(n, this.size, 2.0f, n3);
            BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(this.size - 1, this.size - 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(n2, 0);
            substanceFillPainter.paintContourBackground(graphics2D, jSlider, n, this.size, generalPath, false, substanceColorScheme, true);
            int n4 = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jSlider));
            GeneralPath generalPath2 = SubstanceOutlineUtilities.getTriangleButtonOutline(n, this.size, 2.0f, n4 + n3);
            substanceBorderPainter.paintBorder(graphics2D, jSlider, n, this.size - 1, generalPath, generalPath2, substanceColorScheme2);
            bufferedImage = this.isMirrorred ? SubstanceImageCreator.getRotated(bufferedImage, 1) : SubstanceImageCreator.getRotated(bufferedImage, 3);
            if (!jSlider.getComponentOrientation().isLeftToRight()) {
                bufferedImage = SubstanceImageCreator.getRotated(bufferedImage, 2);
            }
            return new ImageIcon(bufferedImage);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!(graphics instanceof Graphics2D)) {
                return;
            }
            JSlider jSlider = (JSlider)component;
            TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)jSlider.getUI());
            StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
            Icon icon = this.getIcon(jSlider, stateTransitionTracker);
            icon.paintIcon(component, graphics, n, n2);
        }

        @Override
        public int getIconWidth() {
            return this.size - 1;
        }

        @Override
        public int getIconHeight() {
            return this.size - 1;
        }
    }

    private static class TreeIcon
    implements Icon,
    UIResource {
        private static LazyResettableHashMap<Icon> icons = new LazyResettableHashMap("SubstanceIconFactory.TreeIcon");
        private boolean isCollapsed;
        private int size;

        public TreeIcon(int n, boolean bl) {
            this.isCollapsed = bl;
            this.size = n;
        }

        private static Icon getIcon(JTree jTree, boolean bl) {
            ComponentState componentState = jTree == null || jTree.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jTree, componentState);
            SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(jTree, ColorSchemeAssociationKind.BORDER, componentState);
            int n = SubstanceSizeUtils.getComponentFontSize(jTree);
            HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), bl);
            Icon icon = icons.get(hashMapKey);
            if (icon != null) {
                return icon;
            }
            icon = new ImageIcon(SubstanceImageCreator.getTreeIcon(jTree, substanceColorScheme, substanceColorScheme2, bl));
            icons.put(hashMapKey, icon);
            return icon;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!(graphics instanceof Graphics2D)) {
                return;
            }
            JTree jTree = component instanceof JTree ? (JTree)component : null;
            Icon icon = TreeIcon.getIcon(jTree, this.isCollapsed);
            icon.paintIcon(component, graphics, n, n2);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    public static enum IconKind {
        CLOSE,
        MINIMIZE,
        MAXIMIZE,
        RESTORE;

    }

    private static class TrackableSlider
    implements TransitionAwareUI {
        private JSlider slider;
        private Field thumbRectField;
        private ButtonModel transitionModel;
        private StateTransitionTracker stateTransitionTracker;

        public TrackableSlider(JSlider jSlider, ButtonModel buttonModel) {
            this.slider = jSlider;
            this.transitionModel = buttonModel;
            SliderUI sliderUI = jSlider.getUI();
            if (sliderUI instanceof BasicSliderUI) {
                try {
                    this.thumbRectField = BasicSliderUI.class.getDeclaredField("thumbRect");
                    this.thumbRectField.setAccessible(true);
                }
                catch (Exception exception) {
                    this.thumbRectField = null;
                }
            }
            this.stateTransitionTracker = new StateTransitionTracker(this.slider, this.transitionModel);
        }

        @Override
        public boolean isInside(MouseEvent mouseEvent) {
            try {
                Rectangle rectangle = (Rectangle)this.thumbRectField.get(this.slider.getUI());
                if (rectangle == null) {
                    return false;
                }
                return rectangle.contains(mouseEvent.getX(), mouseEvent.getY());
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        public StateTransitionTracker getTransitionTracker() {
            return this.stateTransitionTracker;
        }
    }
}

