/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.menu;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.text.View;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenu;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenuBackgroundDelegate;

public class MenuUtilities {
    private static final String LAYOUT_METRICS = "substancelaf.internal.menus.layoutMetrics";
    private static final String GUTTER_X = "substancelaf.internal.menus.gutterX";
    public static final String LAYOUT_INFO = "substancelaf.internal.menus.layoutInfo";

    public static MenuLayoutInfo getMenuLayoutInfo(boolean bl, JMenuItem jMenuItem, Font font, Icon icon, Icon icon2, int n) {
        Insets insets = jMenuItem.getInsets();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle4 = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle5 = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle6 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        if (bl) {
            int n2 = jMenuItem.getWidth();
            int n3 = jMenuItem.getHeight();
            if (n2 > 0 && n3 > 0) {
                rectangle6.setBounds(0, 0, n2, n3);
            }
            rectangle6.x += insets.left;
            rectangle6.y += insets.top;
            rectangle6.width -= insets.right + rectangle6.x;
            rectangle6.height -= insets.bottom + rectangle6.y;
        }
        FontMetrics fontMetrics = jMenuItem.getFontMetrics(jMenuItem.getFont());
        FontMetrics fontMetrics2 = jMenuItem.getFontMetrics(font);
        KeyStroke keyStroke = jMenuItem.getAccelerator();
        Object object = "";
        if (keyStroke != null) {
            int n4;
            int n5 = keyStroke.getModifiers();
            if (n5 > 0) {
                object = KeyEvent.getKeyModifiersText(n5);
                object = (String)object + UIManager.getString("MenuItem.acceleratorDelimiter");
            }
            object = (n4 = keyStroke.getKeyCode()) != 0 ? (String)object + KeyEvent.getKeyText(n4) : (String)object + keyStroke.getKeyChar();
        }
        String string = MenuUtilities.layoutMenuItem(jMenuItem, fontMetrics, jMenuItem.getText(), fontMetrics2, (String)object, jMenuItem.getIcon(), icon, icon2, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), rectangle6, rectangle, rectangle2, rectangle3, rectangle4, rectangle5, jMenuItem.getText() == null ? 0 : n, n);
        MenuLayoutInfo menuLayoutInfo = new MenuLayoutInfo();
        menuLayoutInfo.checkIconRect = rectangle4;
        menuLayoutInfo.iconRect = rectangle;
        menuLayoutInfo.textRect = rectangle2;
        menuLayoutInfo.viewRect = rectangle6;
        menuLayoutInfo.acceleratorRect = rectangle3;
        menuLayoutInfo.arrowIconRect = rectangle5;
        menuLayoutInfo.text = string;
        return menuLayoutInfo;
    }

    private static String layoutMenuItem(JMenuItem jMenuItem, FontMetrics fontMetrics, String string, FontMetrics fontMetrics2, String string2, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6) {
        SwingUtilities.layoutCompoundLabel(jMenuItem, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        if (string2 == null || string2.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
            string2 = "";
        } else {
            rectangle4.width = fontMetrics2.stringWidth(string2);
            rectangle4.height = fontMetrics2.getHeight();
        }
        if (MenuUtilities.useCheckAndArrow(jMenuItem)) {
            if (icon2 != null) {
                rectangle5.width = icon2.getIconWidth();
                rectangle5.height = icon2.getIconHeight();
            } else {
                rectangle5.height = 0;
                rectangle5.width = 0;
            }
            if (icon3 != null) {
                rectangle6.width = icon3.getIconWidth();
                rectangle6.height = icon3.getIconHeight();
            } else {
                rectangle6.height = 0;
                rectangle6.width = 0;
            }
        }
        Rectangle rectangle7 = rectangle2.union(rectangle3);
        if (jMenuItem.getComponentOrientation().isLeftToRight()) {
            rectangle3.x += n6;
            rectangle2.x += n6;
            rectangle4.x = rectangle.x + rectangle.width - rectangle6.width - n6 - rectangle4.width;
            if (MenuUtilities.useCheckAndArrow(jMenuItem)) {
                rectangle5.x = rectangle.x + n6;
                rectangle3.x += n6 + rectangle5.width;
                rectangle2.x += n6 + rectangle5.width;
                rectangle6.x = rectangle.x + rectangle.width - n6 - rectangle6.width;
            }
        } else {
            rectangle3.x -= n6;
            rectangle2.x -= n6;
            rectangle4.x = rectangle.x + rectangle6.width + n6;
            if (MenuUtilities.useCheckAndArrow(jMenuItem)) {
                rectangle5.x = rectangle.x + rectangle.width - n6 - rectangle5.width;
                rectangle3.x -= n6 + rectangle5.width;
                rectangle2.x -= n6 + rectangle5.width;
                rectangle6.x = rectangle.x + n6;
            }
        }
        rectangle4.y = rectangle7.y + rectangle7.height / 2 - rectangle4.height / 2;
        if (MenuUtilities.useCheckAndArrow(jMenuItem)) {
            rectangle6.y = rectangle7.y + rectangle7.height / 2 - rectangle6.height / 2;
            rectangle5.y = rectangle7.y + rectangle7.height / 2 - rectangle5.height / 2;
        }
        return string;
    }

    private static boolean useCheckAndArrow(JMenuItem jMenuItem) {
        boolean bl = true;
        if (jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu()) {
            bl = false;
        }
        return bl;
    }

    public static void paintMenuItem(Graphics graphics, JMenuItem jMenuItem, Icon icon, Icon icon2, int n) {
        Object object;
        int n2;
        Object object2;
        Object object3;
        Component[] componentArray;
        Object object4;
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (Boolean.TRUE.equals(jMenuItem.getClientProperty("substancelaf.internal.paint.isCoveredByLightweightPopups")) && (object4 = SwingUtilities.getRootPane(jMenuItem)) != null && (componentArray = ((JRootPane)object4).getLayeredPane().getComponentsInLayer(JLayeredPane.POPUP_LAYER)) != null) {
            int n3 = SubstanceCoreUtilities.getPopupParentIndexOf(jMenuItem, componentArray) - 1;
            object3 = new Area(graphics2D.getClip());
            for (int i = n3; i >= 0; --i) {
                Component component = componentArray[i];
                Rectangle rectangle = SwingUtilities.convertRectangle(((JRootPane)object4).getLayeredPane(), component.getBounds(), jMenuItem);
                ((Area)object3).subtract(new Area(rectangle));
            }
            graphics2D.setClip((Shape)object3);
        }
        object4 = jMenuItem.getModel();
        componentArray = (Component[])jMenuItem.getUI();
        Font font = jMenuItem.getFont();
        graphics2D.setFont(font);
        object3 = jMenuItem.getAccelerator();
        Object object5 = "";
        if (object3 != null) {
            int n4;
            int n5 = ((AWTKeyStroke)object3).getModifiers();
            if (n5 > 0) {
                object5 = KeyEvent.getKeyModifiersText(n5);
                object5 = (String)object5 + UIManager.getString("MenuItem.acceleratorDelimiter");
            }
            object5 = (n4 = ((AWTKeyStroke)object3).getKeyCode()) != 0 ? (String)object5 + KeyEvent.getKeyText(n4) : (String)object5 + ((AWTKeyStroke)object3).getKeyChar();
        }
        Icon icon3 = jMenuItem.getIcon();
        MenuLayoutInfo menuLayoutInfo = MenuUtilities.getMenuLayoutInfo(true, jMenuItem, componentArray.getAcceleratorFont(), componentArray.getCheckIcon(), componentArray.getArrowIcon(), componentArray.getDefaultTextIconGap());
        MenuLayoutMetrics menuLayoutMetrics = MenuUtilities.getPopupLayoutMetrics(jMenuItem, true);
        Insets insets = jMenuItem.getInsets();
        if (menuLayoutMetrics != null) {
            object2 = SubstanceCoreUtilities.getMenuGutterFillKind();
            boolean bl = object2 != null && object2 != SubstanceConstants.MenuGutterFillKind.NONE;
            int n6 = menuLayoutMetrics.maxIconTextGap;
            if (jMenuItem.getComponentOrientation().isLeftToRight()) {
                int n7;
                n2 = insets.left + n6 / 2;
                if (icon != null) {
                    menuLayoutInfo.checkIconRect = new Rectangle(n2, insets.top, icon.getIconWidth(), icon.getIconHeight());
                    n7 = (menuLayoutMetrics.maxCheckIconWidth - icon.getIconWidth()) / 2;
                    menuLayoutInfo.checkIconRect.x += n7;
                }
                if (menuLayoutMetrics.maxCheckIconWidth > 0) {
                    n2 += menuLayoutMetrics.maxCheckIconWidth + n6;
                }
                if (icon3 != null) {
                    menuLayoutInfo.iconRect = new Rectangle(n2, insets.top, icon3.getIconWidth(), icon3.getIconHeight());
                    n7 = (menuLayoutMetrics.maxIconWidth - icon3.getIconWidth()) / 2;
                    menuLayoutInfo.iconRect.x += n7;
                }
                if (menuLayoutMetrics.maxIconWidth > 0) {
                    n2 += menuLayoutMetrics.maxIconWidth + n6;
                }
                jMenuItem.putClientProperty(GUTTER_X, n2 + n6 / 2);
                if (bl) {
                    n2 += n6;
                }
                if (jMenuItem.getText() != null) {
                    menuLayoutInfo.textRect = new Rectangle(n2, menuLayoutInfo.textRect.y, menuLayoutMetrics.maxTextWidth, menuLayoutInfo.textRect.height);
                    menuLayoutInfo.text = jMenuItem.getText();
                }
                n2 += menuLayoutMetrics.maxTextWidth + n6;
                if (menuLayoutMetrics.maxAcceleratorWidth > 0) {
                    menuLayoutInfo.acceleratorRect = new Rectangle((n2 += 5 * n6) + menuLayoutMetrics.maxAcceleratorWidth - menuLayoutInfo.acceleratorRect.width, menuLayoutInfo.textRect.y, menuLayoutInfo.acceleratorRect.width, menuLayoutInfo.textRect.height);
                }
                if (menuLayoutMetrics.maxAcceleratorWidth > 0) {
                    n2 += menuLayoutMetrics.maxAcceleratorWidth + n6;
                }
                if (icon2 != null) {
                    menuLayoutInfo.arrowIconRect = new Rectangle(n2, insets.top, menuLayoutMetrics.maxArrowIconWidth, icon2.getIconHeight());
                }
                object = new Rectangle(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight());
                if (menuLayoutInfo.textRect != null) {
                    object = menuLayoutInfo.textRect;
                }
                if (menuLayoutInfo.iconRect != null) {
                    menuLayoutInfo.iconRect.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - menuLayoutInfo.iconRect.height / 2;
                }
                if (menuLayoutInfo.arrowIconRect != null) {
                    menuLayoutInfo.arrowIconRect.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - menuLayoutInfo.arrowIconRect.height / 2;
                }
                if (menuLayoutInfo.checkIconRect != null) {
                    menuLayoutInfo.checkIconRect.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - menuLayoutInfo.checkIconRect.height / 2;
                }
            } else {
                int n8;
                n2 = jMenuItem.getWidth() - insets.right - n6 / 2;
                if (icon != null) {
                    menuLayoutInfo.checkIconRect = new Rectangle(n2 - menuLayoutMetrics.maxCheckIconWidth, insets.top, icon.getIconWidth(), icon.getIconHeight());
                    n8 = (menuLayoutMetrics.maxCheckIconWidth - icon.getIconWidth()) / 2;
                    menuLayoutInfo.checkIconRect.x += n8;
                }
                if (menuLayoutMetrics.maxCheckIconWidth > 0) {
                    n2 -= menuLayoutMetrics.maxCheckIconWidth + n6;
                }
                if (icon3 != null) {
                    menuLayoutInfo.iconRect = new Rectangle(n2 - menuLayoutMetrics.maxIconWidth, insets.top, icon3.getIconWidth(), icon3.getIconHeight());
                    n8 = (menuLayoutMetrics.maxIconWidth - icon3.getIconWidth()) / 2;
                    menuLayoutInfo.iconRect.x += n8;
                }
                if (menuLayoutMetrics.maxIconWidth > 0) {
                    n2 -= menuLayoutMetrics.maxIconWidth + n6;
                }
                jMenuItem.putClientProperty(GUTTER_X, n2 + n6 / 2);
                if (bl) {
                    n2 -= n6;
                }
                if (jMenuItem.getText() != null) {
                    menuLayoutInfo.textRect = new Rectangle(n2 - menuLayoutInfo.textRect.width, menuLayoutInfo.textRect.y, menuLayoutMetrics.maxTextWidth, menuLayoutInfo.textRect.height);
                    menuLayoutInfo.text = jMenuItem.getText();
                }
                n2 -= menuLayoutMetrics.maxTextWidth + n6;
                if (menuLayoutMetrics.maxAcceleratorWidth > 0) {
                    menuLayoutInfo.acceleratorRect = new Rectangle((n2 -= 5 * n6) - menuLayoutMetrics.maxAcceleratorWidth, menuLayoutInfo.textRect.y, menuLayoutInfo.acceleratorRect.width, menuLayoutInfo.textRect.height);
                }
                if (menuLayoutMetrics.maxAcceleratorWidth > 0) {
                    n2 -= menuLayoutMetrics.maxAcceleratorWidth + n6;
                }
                if (icon2 != null) {
                    menuLayoutInfo.arrowIconRect = new Rectangle(n2 - menuLayoutMetrics.maxArrowIconWidth, insets.top, menuLayoutMetrics.maxArrowIconWidth, icon2.getIconHeight());
                }
                object = new Rectangle(0, 0, jMenuItem.getWidth(), jMenuItem.getHeight());
                if (menuLayoutInfo.textRect != null) {
                    object = menuLayoutInfo.textRect;
                }
                if (menuLayoutInfo.iconRect != null) {
                    menuLayoutInfo.iconRect.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - menuLayoutInfo.iconRect.height / 2;
                }
                if (menuLayoutInfo.arrowIconRect != null) {
                    menuLayoutInfo.arrowIconRect.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - menuLayoutInfo.arrowIconRect.height / 2;
                }
                if (menuLayoutInfo.checkIconRect != null) {
                    menuLayoutInfo.checkIconRect.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - menuLayoutInfo.checkIconRect.height / 2;
                }
            }
        }
        jMenuItem.putClientProperty(LAYOUT_INFO, menuLayoutInfo);
        object2 = jMenuItem.getParent();
        if (object2 instanceof JPopupMenu) {
            ((JPopupMenu)object2).putClientProperty(GUTTER_X, jMenuItem.getClientProperty(GUTTER_X));
        }
        MenuUtilities.paintBackground(graphics2D, jMenuItem);
        SubstanceMenuBackgroundDelegate.paintHighlights(graphics, jMenuItem, 0.5f);
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        if (menuLayoutInfo.text != null) {
            View view = (View)jMenuItem.getClientProperty("html");
            if (view != null) {
                view.paint(graphics2D2, menuLayoutInfo.textRect);
            } else {
                SubstanceTextUtilities.paintText(graphics2D2, jMenuItem, menuLayoutInfo.textRect, menuLayoutInfo.text, jMenuItem.getDisplayedMnemonicIndex());
            }
        }
        if (object5 != null && !((String)object5).equals("")) {
            SubstanceTextUtilities.paintText(graphics2D2, jMenuItem, menuLayoutInfo.acceleratorRect, (String)object5, -1);
        }
        float f = SubstanceColorSchemeUtilities.getAlpha(jMenuItem, ComponentState.getState(jMenuItem.getModel(), jMenuItem, true));
        graphics2D2.setComposite(LafWidgetUtilities.getAlphaComposite((Component)jMenuItem, (float)f, (Graphics)graphics2D));
        if (icon != null && MenuUtilities.useCheckAndArrow(jMenuItem)) {
            icon.paintIcon(jMenuItem, graphics2D2, menuLayoutInfo.checkIconRect.x, menuLayoutInfo.checkIconRect.y);
        }
        if (icon3 != null) {
            if (!object4.isEnabled()) {
                icon3 = jMenuItem.getDisabledIcon();
            } else if (object4.isPressed() && object4.isArmed()) {
                icon3 = jMenuItem.getPressedIcon();
                if (icon3 == null) {
                    icon3 = jMenuItem.getIcon();
                }
            } else {
                icon3 = jMenuItem.getIcon();
            }
            if (icon3 != null) {
                n2 = SubstanceCoreUtilities.useThemedDefaultIcon(jMenuItem) ? 1 : 0;
                if (n2 == 0) {
                    icon3.paintIcon(jMenuItem, graphics2D, menuLayoutInfo.iconRect.x, menuLayoutInfo.iconRect.y);
                } else {
                    boolean bl;
                    object = SubstanceCoreUtilities.getThemedIcon(jMenuItem, icon3);
                    boolean bl2 = bl = object4.isPressed() || object4.isSelected();
                    if (bl) {
                        icon3.paintIcon(jMenuItem, graphics2D, menuLayoutInfo.iconRect.x, menuLayoutInfo.iconRect.y);
                    } else {
                        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)jMenuItem.getUI());
                        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
                        float f2 = Math.max(stateTransitionTracker.getFacetStrength(ComponentStateFacet.ROLLOVER), stateTransitionTracker.getFacetStrength(ComponentStateFacet.ARM));
                        if (f2 > 0.0f) {
                            object.paintIcon(jMenuItem, graphics2D, menuLayoutInfo.iconRect.x, menuLayoutInfo.iconRect.y);
                            graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)jMenuItem, (float)f2, (Graphics)graphics));
                            icon3.paintIcon(jMenuItem, graphics2D, menuLayoutInfo.iconRect.x, menuLayoutInfo.iconRect.y);
                            graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)jMenuItem, (Graphics)graphics));
                        } else {
                            object.paintIcon(jMenuItem, graphics2D, menuLayoutInfo.iconRect.x, menuLayoutInfo.iconRect.y);
                        }
                    }
                }
            }
        }
        if (icon2 != null && MenuUtilities.useCheckAndArrow(jMenuItem)) {
            icon2.paintIcon(jMenuItem, graphics2D2, menuLayoutInfo.arrowIconRect.x, menuLayoutInfo.arrowIconRect.y);
        }
        graphics2D2.dispose();
        graphics2D.dispose();
    }

    private static void paintBackground(Graphics graphics, JMenuItem jMenuItem) {
        int n = MenuUtilities.getTextOffset(jMenuItem, jMenuItem.getParent());
        SubstanceMenuBackgroundDelegate.paintBackground(graphics, jMenuItem, n);
    }

    protected static MenuLayoutMetrics getMetrics(JPopupMenu jPopupMenu, boolean bl) {
        MenuLayoutMetrics menuLayoutMetrics = new MenuLayoutMetrics();
        for (int i = 0; i < jPopupMenu.getComponentCount(); ++i) {
            JMenuItem jMenuItem;
            ButtonUI buttonUI;
            Component component = jPopupMenu.getComponent(i);
            if (!(component instanceof JMenuItem) || !((buttonUI = (jMenuItem = (JMenuItem)component).getUI()) instanceof SubstanceMenu)) continue;
            SubstanceMenu substanceMenu = (SubstanceMenu)((Object)buttonUI);
            MenuLayoutInfo menuLayoutInfo = MenuUtilities.getMenuLayoutInfo(bl, jMenuItem, substanceMenu.getAcceleratorFont(), substanceMenu.getCheckIcon(), substanceMenu.getArrowIcon(), substanceMenu.getDefaultTextIconGap());
            menuLayoutMetrics.maxIconWidth = Math.max(menuLayoutMetrics.maxIconWidth, menuLayoutInfo.iconRect.width);
            menuLayoutMetrics.maxCheckIconWidth = Math.max(menuLayoutMetrics.maxCheckIconWidth, menuLayoutInfo.checkIconRect.width);
            menuLayoutMetrics.maxTextWidth = Math.max(menuLayoutMetrics.maxTextWidth, menuLayoutInfo.textRect.width);
            menuLayoutMetrics.maxAcceleratorWidth = Math.max(menuLayoutMetrics.maxAcceleratorWidth, menuLayoutInfo.acceleratorRect.width);
            menuLayoutMetrics.maxArrowIconWidth = Math.max(menuLayoutMetrics.maxArrowIconWidth, menuLayoutInfo.arrowIconRect.width);
            menuLayoutMetrics.maxIconTextGap = Math.max(menuLayoutMetrics.maxIconTextGap, substanceMenu.getDefaultTextIconGap());
        }
        return menuLayoutMetrics;
    }

    public static MenuLayoutMetrics getPopupLayoutMetrics(JMenuItem jMenuItem, boolean bl) {
        ButtonUI buttonUI;
        Container container = jMenuItem.getParent();
        if (container instanceof JPopupMenu) {
            JPopupMenu jPopupMenu = (JPopupMenu)container;
            return MenuUtilities.getPopupLayoutMetrics(jPopupMenu, bl);
        }
        if (!(container instanceof JMenu) && (buttonUI = jMenuItem.getUI()) instanceof SubstanceMenu) {
            SubstanceMenu substanceMenu = (SubstanceMenu)((Object)buttonUI);
            MenuLayoutInfo menuLayoutInfo = MenuUtilities.getMenuLayoutInfo(bl, jMenuItem, substanceMenu.getAcceleratorFont(), substanceMenu.getCheckIcon(), substanceMenu.getArrowIcon(), substanceMenu.getDefaultTextIconGap());
            MenuLayoutMetrics menuLayoutMetrics = new MenuLayoutMetrics();
            menuLayoutMetrics.maxIconWidth = menuLayoutInfo.iconRect.width;
            menuLayoutMetrics.maxCheckIconWidth = menuLayoutInfo.checkIconRect.width;
            menuLayoutMetrics.maxTextWidth = menuLayoutInfo.textRect.width;
            menuLayoutMetrics.maxAcceleratorWidth = menuLayoutInfo.acceleratorRect.width;
            menuLayoutMetrics.maxArrowIconWidth = menuLayoutInfo.arrowIconRect.width;
            menuLayoutMetrics.maxIconTextGap = substanceMenu.getDefaultTextIconGap();
            return menuLayoutMetrics;
        }
        return null;
    }

    public static MenuLayoutMetrics getPopupLayoutMetrics(JPopupMenu jPopupMenu, boolean bl) {
        Object object = jPopupMenu.getClientProperty(LAYOUT_METRICS);
        if (object instanceof MenuLayoutMetrics) {
            return (MenuLayoutMetrics)object;
        }
        MenuLayoutMetrics menuLayoutMetrics = MenuUtilities.getMetrics(jPopupMenu, bl);
        jPopupMenu.putClientProperty(LAYOUT_METRICS, menuLayoutMetrics);
        return menuLayoutMetrics;
    }

    private static void cleanPopupLayoutMetrics(JMenuItem jMenuItem) {
        Container container = jMenuItem.getParent();
        if (container instanceof JPopupMenu) {
            JPopupMenu jPopupMenu = (JPopupMenu)container;
            MenuUtilities.cleanPopupLayoutMetrics(jPopupMenu);
        }
    }

    public static void cleanPopupLayoutMetrics(JPopupMenu jPopupMenu) {
        if (jPopupMenu != null) {
            jPopupMenu.putClientProperty(LAYOUT_METRICS, null);
        }
    }

    public static int getPreferredWidth(JMenuItem jMenuItem) {
        SubstanceConstants.MenuGutterFillKind menuGutterFillKind;
        boolean bl;
        Insets insets = jMenuItem.getInsets();
        MenuLayoutMetrics menuLayoutMetrics = MenuUtilities.getPopupLayoutMetrics(jMenuItem, false);
        int n = menuLayoutMetrics.maxCheckIconWidth + menuLayoutMetrics.maxIconWidth + menuLayoutMetrics.maxTextWidth + menuLayoutMetrics.maxAcceleratorWidth + menuLayoutMetrics.maxArrowIconWidth + insets.left + insets.right;
        int n2 = 0;
        if (menuLayoutMetrics.maxCheckIconWidth > 0) {
            ++n2;
        }
        if (menuLayoutMetrics.maxIconWidth > 0) {
            ++n2;
        }
        if (menuLayoutMetrics.maxAcceleratorWidth > 0) {
            ++n2;
        }
        if (menuLayoutMetrics.maxArrowIconWidth > 0) {
            ++n2;
        }
        int n3 = menuLayoutMetrics.maxIconTextGap;
        n += (1 + n2) * n3;
        if (menuLayoutMetrics.maxAcceleratorWidth > 0) {
            n += 5 * n3;
        }
        boolean bl2 = bl = (menuGutterFillKind = SubstanceCoreUtilities.getMenuGutterFillKind()) != null && menuGutterFillKind != SubstanceConstants.MenuGutterFillKind.NONE;
        if (bl) {
            n += n3;
        }
        return n;
    }

    public static int getTextOffset(JComponent jComponent, Component component) {
        if (!(component instanceof JPopupMenu)) {
            return 0;
        }
        Object object = jComponent.getClientProperty(GUTTER_X);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        JPopupMenu jPopupMenu = (JPopupMenu)component;
        Object object2 = jPopupMenu.getClientProperty(GUTTER_X);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        return 0;
    }

    public static class MenuLayoutInfo {
        public Rectangle viewRect;
        public Rectangle iconRect;
        public Rectangle checkIconRect;
        public Rectangle textRect;
        public Rectangle acceleratorRect;
        public Rectangle arrowIconRect;
        public String text;
    }

    public static class MenuLayoutMetrics {
        public int maxIconWidth;
        public int maxCheckIconWidth;
        public int maxTextWidth;
        public int maxAcceleratorWidth;
        public int maxArrowIconWidth;
        public int maxIconTextGap;
    }

    public static class MenuPropertyListener
    implements PropertyChangeListener {
        private JMenuItem menuItem;
        private Runnable cleanLayoutMetricsRunnable;

        public MenuPropertyListener(final JMenuItem jMenuItem) {
            this.menuItem = jMenuItem;
            this.cleanLayoutMetricsRunnable = new Runnable(){

                @Override
                public void run() {
                    MenuUtilities.cleanPopupLayoutMetrics(jMenuItem);
                }
            };
        }

        public void install() {
            this.menuItem.addPropertyChangeListener(this);
        }

        public void uninstall() {
            this.menuItem.removePropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!propertyChangeEvent.getPropertyName().equals(MenuUtilities.LAYOUT_METRICS)) {
                SwingUtilities.invokeLater(this.cleanLayoutMetricsRunnable);
            }
        }
    }
}

