/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.javaGD;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.Vector;
import org.rosuda.javaGD.GDContainer;
import org.rosuda.javaGD.GDObject;
import org.rosuda.javaGD.LocatorSync;

public class GDCanvas
extends Canvas
implements GDContainer,
MouseListener {
    Vector l = new Vector();
    boolean listChanged;
    public static boolean forceAntiAliasing = true;
    GDObject.GDState gs = new GDObject.GDState();
    Refresher r;
    Dimension lastSize;
    public int devNr = -1;
    LocatorSync lsCallback = null;
    long lastUpdate;
    long lastUpdateFinished;
    boolean updatePending = false;

    public GDCanvas(double d, double d2) {
        this((int)d, (int)d2);
    }

    public GDCanvas(int n, int n2) {
        this.gs.f = new Font(null, 0, 12);
        this.setSize(n, n2);
        this.lastSize = this.getSize();
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.r = new Refresher(this);
        this.r.start();
    }

    @Override
    public GDObject.GDState getGState() {
        return this.gs;
    }

    @Override
    public void setDeviceNumber(int n) {
        this.devNr = n;
    }

    @Override
    public int getDeviceNumber() {
        return this.devNr;
    }

    @Override
    public void closeDisplay() {
    }

    public synchronized void cleanup() {
        this.r.active = false;
        this.r.interrupt();
        this.reset();
        this.r = null;
        this.l = null;
    }

    @Override
    public void syncDisplay(boolean bl) {
        this.repaint();
    }

    public void initRefresh() {
        try {
            Class<?> clazz = Class.forName("org.rosuda.JRI.Rengine");
            if (clazz == null) {
                System.out.println(">> can't find Rengine, automatic resizing disabled. [c=null]");
            } else {
                Method method = clazz.getMethod("getMainEngine", null);
                Object object = method.invoke(null, (Object[])null);
                if (object != null) {
                    Class[] classArray = new Class[]{Class.forName("java.lang.String")};
                    method = clazz.getMethod("eval", classArray);
                    Object[] objectArray = new Object[]{"try(JavaGD:::.javaGD.resize(" + this.devNr + "),silent=TRUE)"};
                    method.invoke(object, objectArray);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(">> can't find Rengine, automatic resizing disabled. [x:" + exception.getMessage() + "]");
        }
    }

    @Override
    public synchronized void add(GDObject gDObject) {
        this.l.add(gDObject);
        this.listChanged = true;
    }

    @Override
    public synchronized void reset() {
        this.l.removeAllElements();
        this.listChanged = true;
    }

    @Override
    public synchronized boolean prepareLocator(LocatorSync locatorSync) {
        if (this.lsCallback != null && this.lsCallback != locatorSync) {
            this.lsCallback.triggerAction(null);
        }
        this.lsCallback = locatorSync;
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.lsCallback != null) {
            double[] dArray = null;
            if ((mouseEvent.getModifiers() & 0x10) > 0 && (mouseEvent.getModifiers() & 0xC) == 0) {
                dArray = new double[]{mouseEvent.getX(), mouseEvent.getY()};
            }
            LocatorSync locatorSync = this.lsCallback;
            this.lsCallback = null;
            locatorSync.triggerAction(dArray);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public synchronized Vector getGDOList() {
        return this.l;
    }

    @Override
    public void update(Graphics graphics) {
        if (System.currentTimeMillis() - this.lastUpdate < 200L) {
            this.updatePending = true;
            if (System.currentTimeMillis() - this.lastUpdateFinished > 700L) {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, 250, 25);
                graphics.setColor(Color.blue);
                graphics.drawString("Building plot... (" + this.l.size() + " objects)", 10, 10);
                this.lastUpdateFinished = System.currentTimeMillis();
            }
            this.lastUpdate = System.currentTimeMillis();
            return;
        }
        this.updatePending = false;
        super.update(graphics);
        this.lastUpdateFinished = this.lastUpdate = System.currentTimeMillis();
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        this.updatePending = false;
        Dimension dimension = this.getSize();
        if (!dimension.equals(this.lastSize)) {
            this.initRefresh();
            this.lastSize = dimension;
            return;
        }
        if (forceAntiAliasing) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int n = 0;
        int n2 = this.l.size();
        graphics.setFont(this.gs.f);
        graphics.setClip(0, 0, dimension.width, dimension.height);
        while (n < n2) {
            GDObject gDObject = (GDObject)this.l.elementAt(n++);
            gDObject.paint(this, this.gs, graphics);
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    @Override
    public Graphics getGDGraphics() {
        return this.getGraphics();
    }

    @Override
    public Dimension getGDSize() {
        return this.getSize();
    }

    class Refresher
    extends Thread {
        GDCanvas c;
        boolean active;

        public Refresher(GDCanvas gDCanvas2) {
            this.c = gDCanvas2;
        }

        @Override
        public void run() {
            this.active = true;
            while (this.active) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.active) break;
                if (!this.c.updatePending || System.currentTimeMillis() - GDCanvas.this.lastUpdate <= 200L) continue;
                this.c.repaint();
            }
            this.c = null;
        }
    }
}

