/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.javaGD;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.List;
import java.util.Map;

public abstract class GDObject {
    public abstract void paint(Component var1, GDState var2, Graphics var3);

    public abstract void toObjectMap(Map<String, Object> var1);

    public abstract void loadObjectMap(Map<String, Object> var1);

    private static double[] toDoubleArray(List list) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (Double)list.get(i);
        }
        return dArray;
    }

    private static int[] toIntArray(List list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)list.get(i);
        }
        return nArray;
    }

    public static class GDRaster
    extends GDObject {
        byte[] img;
        int img_w;
        int img_h;
        double x;
        double y;
        double w;
        double h;
        double rot;
        boolean interpolate;
        Image image;
        AffineTransform atrans;

        public GDRaster() {
        }

        public GDRaster(byte[] byArray, int n, int n2, double d, double d2, double d3, double d4, double d5, boolean bl) {
            this.img = byArray;
            this.img_w = n;
            this.img_h = n2;
            this.x = d;
            this.y = d2;
            this.w = d3;
            this.h = d4;
            this.rot = d5;
            this.interpolate = bl;
            this.init();
        }

        private void init() {
            this.atrans = new AffineTransform();
            this.y += this.h;
            this.h = -this.h;
            double d = this.w / (double)this.img_w;
            double d2 = this.h / (double)this.img_h;
            this.atrans.translate(this.x, this.y);
            this.atrans.rotate(-this.rot / 180.0 * Math.PI, 0.0, this.y);
            this.atrans.scale(d, d2);
            DataBufferByte dataBufferByte = new DataBufferByte(this.img, this.img_w * this.img_h, 0);
            int[] nArray = new int[]{0, 1, 2, 3};
            PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, this.img_w, this.img_h, 4, this.img_w * 4, nArray);
            WritableRaster writableRaster = Raster.createWritableRaster(pixelInterleavedSampleModel, dataBufferByte, null);
            ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
            this.image = new BufferedImage(componentColorModel, writableRaster, false, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Component component, GDState gDState, Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            try {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolate ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                graphics2D.drawImage(this.image, this.atrans, null);
            }
            finally {
                if (object != null) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
                }
            }
        }

        @Override
        public void toObjectMap(Map<String, Object> map) {
            map.put("img", this.img);
            map.put("img_w", this.img_w);
            map.put("img_h", this.img_h);
            map.put("x", this.x);
            map.put("y", this.y);
            map.put("w", this.w);
            map.put("h", this.h);
            map.put("rot", this.rot);
            map.put("interpolate", this.interpolate);
        }

        @Override
        public void loadObjectMap(Map<String, Object> map) {
            this.img = (byte[])map.get("img");
            this.img_w = (Integer)map.get("img_w");
            this.img_h = (Integer)map.get("img_h");
            this.x = (Double)map.get("x");
            this.y = (Double)map.get("y");
            this.w = (Double)map.get("w");
            this.h = (Double)map.get("h");
            this.rot = (Double)map.get("rot");
            this.interpolate = (Boolean)map.get("interpolate");
            this.init();
        }
    }

    public static class GDLinePar
    extends GDObject {
        double lwd;
        int lty;
        BasicStroke bs;

        public GDLinePar() {
        }

        public GDLinePar(double d, int n) {
            this.lwd = d;
            this.lty = n;
            this.init();
        }

        private void init() {
            this.bs = null;
            if (this.lty == 0) {
                this.bs = new BasicStroke((float)this.lwd);
            } else if (this.lty == -1) {
                this.bs = new BasicStroke(0.0f);
            } else {
                int n = 0;
                int n2 = this.lty;
                while (n2 > 0) {
                    n2 >>= 4;
                    ++n;
                }
                float[] fArray = new float[n];
                n = 0;
                for (n2 = this.lty; n2 > 0; n2 >>= 4) {
                    int n3 = n2 & 0xF;
                    fArray[n++] = n3;
                }
                this.bs = new BasicStroke((float)this.lwd, 0, 0, 3.0f, fArray, 0.0f);
            }
        }

        @Override
        public void paint(Component component, GDState gDState, Graphics graphics) {
            if (this.bs != null) {
                ((Graphics2D)graphics).setStroke(this.bs);
            }
        }

        @Override
        public void toObjectMap(Map<String, Object> map) {
            map.put("lwd", this.lwd);
            map.put("lty", this.lty);
        }

        @Override
        public void loadObjectMap(Map<String, Object> map) {
            this.lwd = (Double)map.get("lwd");
            this.lty = (Integer)map.get("lty");
            this.init();
        }
    }

    public static class GDFill
    extends GDObject {
        int col;
        Color gc;

        public GDFill() {
        }

        public GDFill(int n) {
            this.col = n;
            this.init();
        }

        private void init() {
            this.gc = (this.col & 0xFF000000) == 0 ? null : new Color((float)(this.col & 0xFF) / 255.0f, (float)(this.col >> 8 & 0xFF) / 255.0f, (float)(this.col >> 16 & 0xFF) / 255.0f, (float)(this.col >> 24 & 0xFF) / 255.0f);
        }

        @Override
        public void paint(Component component, GDState gDState, Graphics graphics) {
            gDState.fill = this.gc;
        }

        @Override
        public void toObjectMap(Map<String, Object> map) {
            map.put("col", this.col);
        }

        @Override
        public void loadObjectMap(Map<String, Object> map) {
            this.col = (Integer)map.get("col");
            this.init();
        }
    }

    public static class GDColor
    extends GDObject {
        int col;
        Color gc;

        public GDColor() {
        }

        public GDColor(int n) {
            this.col = n;
            this.init();
        }

        private void init() {
            this.gc = (this.col & 0xFF000000) == 0 ? null : new Color((float)(this.col & 0xFF) / 255.0f, (float)(this.col >> 8 & 0xFF) / 255.0f, (float)(this.col >> 16 & 0xFF) / 255.0f, (float)(this.col >> 24 & 0xFF) / 255.0f);
        }

        @Override
        public void paint(Component component, GDState gDState, Graphics graphics) {
            gDState.col = this.gc;
            if (this.gc != null) {
                graphics.setColor(this.gc);
            }
        }

        @Override
        public void toObjectMap(Map<String, Object> map) {
            map.put("col", this.col);
        }

        @Override
        public void loadObjectMap(Map<String, Object> map) {
            this.col = (Integer)map.get("col");
            this.init();
        }
    }

    public static class GDPath
    extends GDObject {
        int[] np;
        double[] x;
        double[] y;
        boolean winding;
        GeneralPath path;

        public GDPath() {
        }

        public GDPath(int[] nArray, double[] dArray, double[] dArray2, boolean bl) {
            this.x = dArray;
            this.y = dArray2;
            this.np = nArray;
            this.winding = bl;
            this.init();
        }

        private void init() {
            this.path = new GeneralPath(this.winding ? 1 : 0, this.x.length);
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.np.length; ++i) {
                n2 += this.np[i];
                this.path.moveTo((float)this.x[n], (float)this.y[n]);
                ++n;
                while (n < n2) {
                    this.path.lineTo((float)this.x[n], (float)this.y[n]);
                    ++n;
                }
                this.path.closePath();
            }
        }

        @Override
        public void paint(Component component, GDState gDState, Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (gDState.fill != null) {
                graphics2D.setColor(gDState.fill);
                graphics2D.fill(this.path);
                if (gDState.col != null) {
                    graphics2D.setColor(gDState.col);
                }
            }
            if (gDState.col != null) {
                graphics2D.draw(this.path);
            }
        }

        @Override
        public void toObjectMap(Map<String, Object> map) {
            map.put("np", this.np);
            map.put("x", this.x);
            map.put("y", this.y);
            map.put("winding", this.winding);
        }

        @Override
        public void loadObjectMap(Map<String, Object> map) {
            this.np = GDObject.toIntArray((List)map.get("np"));
            this.x = GDObject.toDoubleArray((List)map.get("x"));
            this.y = GDObject.toDoubleArray((List)map.get("y"));
            this.winding = (Boolean)map.get("winding");
            this.init();
        }
    }

    public static class GDPolygon
    extends GDObject {
        int n;
        double[] x;
        double[] y;
        int[] xi;
        int[] yi;
        boolean isPolyline;

        public GDPolygon() {
        }

        public GDPolygon(int n, double[] dArray, double[] dArray2, boolean bl) {
            this.x = dArray;
            this.y = dArray2;
            this.n = n;
            this.isPolyline = bl;
            this.init();
        }

        private void init() {
            this.xi = new int[this.n];
            this.yi = new int[this.n];
            for (int i = 0; i < this.n; ++i) {
                this.xi[i] = (int)(this.x[i] + 0.5);
                this.yi[i] = (int)(this.y[i] + 0.5);
            }
        }

        @Override
        public void paint(Component component, GDState gDState, Graphics graphics) {
            if (gDState.fill != null && !this.isPolyline) {
                graphics.setColor(gDState.fill);
                graphics.fillPolygon(this.xi, this.yi, this.n);
                if (gDState.col != null) {
                    graphics.setColor(gDState.col);
                }
            }
            if (gDState.col != null) {
                if (this.isPolyline) {
                    graphics.drawPolyline(this.xi, this.yi, this.n);
                } else {
                    graphics.drawPolygon(this.xi, this.yi, this.n);
                }
            }
        }

        @Override
        public void toObjectMap(Map<String, Object> map) {
            map.put("n", this.n);
            map.put("x", this.x);
            map.put("y", this.y);
            map.put("isPolyline", this.isPolyline);
        }

        @Override
        public void loadObjectMap(Map<String, Object> map) {
            this.n = (Integer)map.get("n");
            this.x = GDObject.toDoubleArray((List)map.get("x"));
            this.y = GDObject.toDoubleArray((List)map.get("y"));
            this.isPolyline = (Boolean)map.get("isPolyline");
            this.init();
        }
    }

    public static class GDFont
    extends GDObject {
        double cex;
        double ps;
        double lineheight;
        int face;
        String family;
        Font font;
        public static boolean useSymbolFont = true;

        public GDFont() {
        }

        public GDFont(double d, double d2, double d3, int n, String string) {
            this.cex = d;
            this.ps = d2;
            this.lineheight = d3;
            this.face = n;
            this.family = string;
            this.init();
        }

        private void init() {
            int n = 0;
            if (this.face == 2) {
                n = 1;
            }
            if (this.face == 3) {
                n = 2;
            }
            if (this.face == 4) {
                n = 3;
            }
            if (this.face == 5 && useSymbolFont) {
                this.family = "Symbol";
            }
            this.font = new Font(this.family.equals("") ? null : this.family, n, (int)(this.cex * this.ps + 0.5));
        }

        public Font getFont() {
            return this.font;
        }

        @Override
        public void paint(Component component, GDState gDState, Graphics graphics) {
            graphics.setFont(this.font);
            gDState.f = this.font;
        }

        @Override
        public void toObjectMap(Map<String, Object> map) {
            map.put("cex", this.cex);
            map.put("ps", this.ps);
            map.put("lineheight", this.lineheight);
            map.put("face", this.face);
            map.put("family", this.family);
        }

        @Override
        public void loadObjectMap(Map<String, Object> map) {
            this.cex = (Double)map.get("cex");
            this.ps = (Double)map.get("ps");
            this.lineheight = (Double)map.get("lineheight");
            this.face = (Integer)map.get("face");
            this.family = (String)map.get("family");
            this.init();
        }

        static {
            String string = System.getProperty("javagd.usesymbolfont");
            if (string != null && string.length() > 0) {
                useSymbolFont = string.equals("true") || string.equals("yes") || string.equals("1");
            } else {
                String string2 = System.getProperty("os.name");
                if (string2.length() > 2 && string2.substring(0, 3).equals("Win")) {
                    useSymbolFont = false;
                }
            }
        }
    }

    public static class GDText
    extends GDObject {
        double x;
        double y;
        double r;
        double h;
        String txt;

        public GDText() {
        }

        public GDText(double d, double d2, double d3, double d4, String string) {
            this.x = d;
            this.y = d2;
            this.r = d3;
            this.h = d4;
            this.txt = string;
        }

        @Override
        public void paint(Component component, GDState gDState, Graphics graphics) {
            if (gDState.col != null) {
                int n;
                double d = this.x;
                double d2 = this.y;
                double d3 = 0.0;
                if (this.h != 0.0) {
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    n = fontMetrics.stringWidth(this.txt);
                    d3 = (double)n * this.h;
                    d = this.x - (double)n * this.h;
                }
                int n2 = (int)(d + 0.5);
                n = (int)(d2 + 0.5);
                if (this.r != 0.0) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.translate(this.x, this.y);
                    double d4 = -this.r / 180.0 * Math.PI;
                    graphics2D.rotate(d4);
                    if (d3 != 0.0) {
                        graphics2D.translate(-d3, 0.0);
                    }
                    graphics2D.drawString(this.txt, 0, 0);
                    if (d3 != 0.0) {
                        graphics2D.translate(d3, 0.0);
                    }
                    graphics2D.rotate(-d4);
                    graphics2D.translate(-this.x, -this.y);
                } else {
                    graphics.drawString(this.txt, n2, n);
                }
            }
        }

        @Override
        public void toObjectMap(Map<String, Object> map) {
            map.put("x", this.x);
            map.put("y", this.y);
            map.put("r", this.r);
            map.put("h", this.h);
            map.put("txt", this.txt);
        }

        @Override
        public void loadObjectMap(Map<String, Object> map) {
            this.x = (Double)map.get("x");
            this.y = (Double)map.get("y");
            this.r = (Double)map.get("r");
            this.h = (Double)map.get("h");
            this.txt = (String)map.get("txt");
        }
    }

    public static class GDCircle
    extends GDObject {
        double x;
        double y;
        double r;

        public GDCircle() {
        }

        public GDCircle(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.r = d3;
        }

        @Override
        public void paint(Component component, GDState gDState, Graphics graphics) {
            if (gDState.fill != null) {
                graphics.setColor(gDState.fill);
                graphics.fillOval((int)(this.x - this.r + 0.5), (int)(this.y - this.r + 0.5), (int)(this.r + this.r + 1.5), (int)(this.r + this.r + 1.5));
                if (gDState.col != null) {
                    graphics.setColor(gDState.col);
                }
            }
            if (gDState.col != null) {
                graphics.drawOval((int)(this.x - this.r + 0.5), (int)(this.y - this.r + 0.5), (int)(this.r + this.r + 1.5), (int)(this.r + this.r + 1.5));
            }
        }

        @Override
        public void toObjectMap(Map<String, Object> map) {
            map.put("x", this.x);
            map.put("y", this.y);
            map.put("r", this.r);
        }

        @Override
        public void loadObjectMap(Map<String, Object> map) {
            this.x = (Double)map.get("x");
            this.y = (Double)map.get("y");
            this.r = (Double)map.get("r");
        }
    }

    public static class GDClip
    extends GDObject {
        double x1;
        double y1;
        double x2;
        double y2;
        private Rectangle rect;

        public GDClip() {
        }

        public GDClip(double d, double d2, double d3, double d4) {
            double d5;
            if (d > d3) {
                d5 = d;
                d = d3;
                d3 = d5;
            }
            if (d2 > d4) {
                d5 = d2;
                d2 = d4;
                d4 = d5;
            }
            this.x1 = d;
            this.y1 = d2;
            this.x2 = d3;
            this.y2 = d4;
            this.init();
        }

        private void init() {
            this.rect = new Rectangle((int)(this.x1 + 0.5), (int)(this.y1 + 0.5), (int)(this.x2 - this.x1 + 1.7), (int)(this.y2 - this.y1 + 1.7));
        }

        @Override
        public void paint(Component component, GDState gDState, Graphics graphics) {
            Rectangle rectangle = gDState.viewRect != null ? gDState.viewRect.intersection(this.rect) : this.rect;
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        @Override
        public void toObjectMap(Map<String, Object> map) {
            map.put("x1", this.x1);
            map.put("y1", this.y1);
            map.put("x2", this.x2);
            map.put("y2", this.y2);
        }

        @Override
        public void loadObjectMap(Map<String, Object> map) {
            this.x1 = (Double)map.get("x1");
            this.y1 = (Double)map.get("y1");
            this.x2 = (Double)map.get("x2");
            this.y2 = (Double)map.get("y2");
            this.init();
        }
    }

    public static class GDRect
    extends GDObject {
        double x1;
        double y1;
        double x2;
        double y2;

        public GDRect() {
        }

        public GDRect(double d, double d2, double d3, double d4) {
            double d5;
            if (d > d3) {
                d5 = d;
                d = d3;
                d3 = d5;
            }
            if (d2 > d4) {
                d5 = d2;
                d2 = d4;
                d4 = d5;
            }
            this.x1 = d;
            this.y1 = d2;
            this.x2 = d3;
            this.y2 = d4;
        }

        @Override
        public void paint(Component component, GDState gDState, Graphics graphics) {
            int n = (int)(this.x1 + 0.5);
            int n2 = (int)(this.y1 + 0.5);
            int n3 = (int)(this.x2 + 0.5) - n;
            int n4 = (int)(this.y2 + 0.5) - n2;
            if (gDState.fill != null) {
                graphics.setColor(gDState.fill);
                graphics.fillRect(n, n2, n3 + 1, n4 + 1);
                if (gDState.col != null) {
                    graphics.setColor(gDState.col);
                }
            }
            if (gDState.col != null) {
                graphics.drawRect(n, n2, n3, n4);
            }
        }

        @Override
        public void toObjectMap(Map<String, Object> map) {
            map.put("x1", this.x1);
            map.put("y1", this.y1);
            map.put("x2", this.x2);
            map.put("y2", this.y2);
        }

        @Override
        public void loadObjectMap(Map<String, Object> map) {
            this.x1 = (Double)map.get("x1");
            this.y1 = (Double)map.get("y1");
            this.x2 = (Double)map.get("x2");
            this.y2 = (Double)map.get("y2");
        }
    }

    public static class GDLine
    extends GDObject {
        double x1;
        double y1;
        double x2;
        double y2;

        public GDLine() {
        }

        public GDLine(double d, double d2, double d3, double d4) {
            this.x1 = d;
            this.y1 = d2;
            this.x2 = d3;
            this.y2 = d4;
        }

        @Override
        public void paint(Component component, GDState gDState, Graphics graphics) {
            if (gDState.col != null) {
                graphics.drawLine((int)(this.x1 + 0.5), (int)(this.y1 + 0.5), (int)(this.x2 + 0.5), (int)(this.y2 + 0.5));
            }
        }

        @Override
        public void toObjectMap(Map<String, Object> map) {
            map.put("x1", this.x1);
            map.put("y1", this.y1);
            map.put("x2", this.x2);
            map.put("y2", this.y2);
        }

        @Override
        public void loadObjectMap(Map<String, Object> map) {
            this.x1 = (Double)map.get("x1");
            this.y1 = (Double)map.get("y1");
            this.x2 = (Double)map.get("x2");
            this.y2 = (Double)map.get("y2");
        }
    }

    public static class GDState {
        public Color col;
        public Color fill;
        public Font f;
        public Rectangle viewRect;
    }
}

