/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow;

import com.ef_prime.rflow.RflowActions;
import com.ef_prime.rflow.SettingsDialog;
import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.app.file.ZipInfo;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.base.RSessionManager;
import com.ef_prime.rflow.core.app.r.base.RSupport;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.core.base.FileEditBackups;
import com.ef_prime.rflow.core.base.FileEditFiles;
import com.ef_prime.rflow.core.base.FileEditManager;
import com.ef_prime.rflow.core.base.FileManager;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.base.LocaleSettings;
import com.ef_prime.rflow.core.base.LogManager;
import com.ef_prime.rflow.core.base.LogThread;
import com.ef_prime.rflow.core.base.PluginManager;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.ProjectsManager;
import com.ef_prime.rflow.core.base.RflowEvent;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.base.RflowVersion;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.UpdateChecker;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.feature.backup.BackupThread;
import com.ef_prime.rflow.core.feature.history.HistoryManager;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNodeUIDManager;
import com.ef_prime.rflow.core.util.OperationFailedException;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.NodeModelManager;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RActions;
import com.ef_prime.rflow.ui.app.r.RFunctionIcons;
import com.ef_prime.rflow.ui.app.r.console.RConsoleView;
import com.ef_prime.rflow.ui.base.MainFrame;
import com.ef_prime.rflow.ui.base.MenuBar;
import com.ef_prime.rflow.ui.base.ProjectsView;
import com.ef_prime.rflow.ui.base.RflowUI;
import com.ef_prime.rflow.ui.common.component.EmfSelection;
import com.ef_prime.rflow.ui.common.component.OptionDialog;
import com.ef_prime.rflow.ui.common.component.RflowOptionPane;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PagesViewFactory;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.FXBrowserView;
import com.ef_prime.rflow.ui.view.MainView;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.rosuda.JRI.Rengine;

public class Rflow
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = Logger.getLogger(Rflow.class.getName());
    public static final String APP_NAME = "R AnalyticFlow";
    public static final Locale SYSTEM_LOCALE = Locale.getDefault();
    private static boolean devel;
    private Project project;
    private MainFrame frame;
    private TrayIcon trayIcon;
    private RConsoleView console;
    private RflowActions actions;
    private BackupThread backupThread;
    private LogThread logThread;
    private Settings settings = new Settings();
    private DevelSettings develSettings = new DevelSettings();
    private EventSupport<RflowEvent, RflowEventHandler> rflowEventSupport = new EventSupport();
    private static Rflow singleton;

    public static Rflow getInstance() {
        if (singleton == null) {
            singleton = new Rflow();
        }
        return singleton;
    }

    public static boolean isDevel() {
        return devel;
    }

    public static Project project() {
        return Rflow.getInstance().getProject();
    }

    public static MainFrame mainFrame() {
        return Rflow.getInstance().getMainFrame();
    }

    public static MainView mainView() {
        return Rflow.mainFrame().getMainView();
    }

    public static Settings settings() {
        return Rflow.getInstance().getSettings();
    }

    public static DevelSettings develSettings() {
        return Rflow.getInstance().getDevelSettings();
    }

    public static RflowActions actions() {
        return Rflow.getInstance().getActions();
    }

    private Rflow() {
    }

    private void initRflow() {
        LogManager.getInstance().init();
        this.initSettings();
        Rflow.setUIDefaults();
        try {
            RSupport.init();
        }
        catch (RSupport.RInitException rInitException) {
            Settings settings;
            int n = JOptionPane.showConfirmDialog(null, rInitException.getMessage() + "\n\n" + Messages.getString("Error.Main.error_ask_show_pref"), "", 2, 3);
            if (n == 0 && (settings = SettingsDialog.showSettingsDialog(Rflow.settings(), true)) != null) {
                Rflow.prepareRestart();
                System.exit(2);
                return;
            }
            System.exit(1);
            return;
        }
        if (!Rengine.jriLoaded) {
            try {
                System.loadLibrary("jri");
                Rengine.jriLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new RuntimeException(Messages.getString("Error.no_jri"), unsatisfiedLinkError);
            }
        }
        this.initManagers();
        this.backupThread = new BackupThread(FileEditManager.getInstance());
        this.logThread = new LogThread();
        this.actions = new RflowActions(this);
        this.frame = new MainFrame();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (Rflow.this.actions != null) {
                    Rflow.this.actions.doAction("EXIT");
                }
            }
        });
        this.frame.setJMenuBar(new MenuBar(this.actions, this.frame.getMainView().getActions()));
        if (!Platform.isMac() && SystemTray.isSupported()) {
            this.trayIcon = new TrayIcon(FileResource.getIcon("img/desktop_16.png").getImage(), APP_NAME, null);
            SystemTray systemTray = SystemTray.getSystemTray();
            try {
                systemTray.add(this.trayIcon);
            }
            catch (AWTException aWTException) {
                this.trayIcon = null;
                LOGGER.log(Level.SEVERE, "Failed to set system tray icon.", aWTException);
            }
        }
        this.console = new RConsoleView(FileEditManager.getInstance());
        this.console.addBusyListener(this.actions);
        this.console.addBusyListener(this.frame.getMainView().getTaskExplorer());
        this.console.addBrowseListener(this.frame.getMainView().getObjectExplorer());
        R.initClient(this.console);
        this.frame.getMainView().getDefaultConsolePane().openView(this.console.getView(), ViewOpenType.OPEN_NEW, true, 0);
        this.initForMac();
        PluginManager.getInstance().init();
        if (R.client().isEmbedded()) {
            RSessionManager.initR(true);
            this.frame.getMainView().openBrowser(null, true, false);
        }
    }

    private void initSettings() {
        Rflow.settings().putValue(Settings.CHECK_ERROR, true);
    }

    private static void setUIDefaults() {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setInitialDelay(200);
        toolTipManager.setDismissDelay(Integer.MAX_VALUE);
        if (Platform.isWindowsFamily()) {
            EmfSelection.installEmfFlavor();
        }
    }

    private void initManagers() {
        NodeModelManager.init();
        RFunctionIcons.getIcon("");
        OpManager.getInstance().init();
        ProjectsManager.getInstance();
        FileManager.getInstance();
        FileEditFiles.getInstance();
        FileEditBackups.getInstance();
        FlowNodeUIDManager.getInstance();
        if (Rflow.isDevel()) {
            try {
                Utility.invokeStaticMethod("com.ef_prime.rflow.core.object.ObjectManager", "init");
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.SEVERE, "Failed to ObjectManager.", invocationTargetException);
            }
            HistoryManager.getInstance();
        }
        FileEditManager.getInstance();
        TextFile.get(null);
        ZipInfo.get(null);
    }

    private void initForMac() {
        if (Platform.isMac()) {
            try {
                Utility.invokeStaticMethod("com.ef_prime.rflow.ui.base.RflowMac", "install");
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.SEVERE, "Failed to load supports for Mac.", throwable);
            }
        }
    }

    static void setRengineDebug(int n) {
        Rengine.DEBUG = n;
    }

    public void loadEmptyProject(boolean bl) {
        this.loadProject(Project.createEmptyProject(), bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProject(Project project, boolean bl, Boolean bl2) {
        this.backupThread.pause();
        try {
            this.unloadProject();
            this.project = project;
            try {
                this.project.load();
            }
            catch (IOException iOException) {
                UIUtility.showErrorDialog((Component)this.getMainFrame(), iOException);
                this.backupThread.restart();
                return;
            }
            WorkingDirectory.setWorkingDirectory(project.getWorkspaceDir());
            if (!R.client().isEmbedded()) {
                RSessionManager rSessionManager = R.sessionManager();
                if (!rSessionManager.isSessionEverAlive()) {
                    rSessionManager.restart(true);
                } else if (bl) {
                    if (!rSessionManager.isSessionAlive()) {
                        rSessionManager.restart(true);
                    } else {
                        switch (Rflow.settings().getValue(Settings.PROJECT_R_RESTART)) {
                            case "yes": {
                                rSessionManager.restart(true);
                                break;
                            }
                            case "no": {
                                break;
                            }
                            case "ask": {
                                int n = JOptionPane.showConfirmDialog(Rflow.mainFrame(), Messages.getString("Message.confirm_restart_r"), Messages.getString("Message.confirm"), 0, 3);
                                if (n != 0) break;
                                rSessionManager.restart(true);
                                break;
                            }
                        }
                    }
                }
            }
            this.dispatchEvent(new RflowEvent(2, 0));
            if (bl2 == null && this.hasAnyBackup()) {
                int n = JOptionPane.showConfirmDialog(Rflow.mainFrame(), Messages.getString("Message.confirm_restore_project"), Messages.getString("Message.confirm"), 1, 3);
                switch (n) {
                    case 0: {
                        bl2 = true;
                        break;
                    }
                    case 1: {
                        bl2 = false;
                        FileEditBackups.getInstance().unload();
                        break;
                    }
                    default: {
                        project.setNewProjectSaveMode(true);
                        this.loadEmptyProject(true);
                        return;
                    }
                }
            }
            this.dispatchEvent(new RflowEvent(2, 1));
            this.dispatchEvent(new RflowEvent(2));
            this.dispatchEvent(new RflowEvent(2, 2));
            FileEditManager.getInstance().loadProjectSession(bl2);
            if (project.isNewProject()) {
                project.saveFileRecord();
            }
        }
        finally {
            this.backupThread.restart();
        }
    }

    private boolean hasAnyBackup() {
        if (FileEditBackups.getInstance().hasBackup()) {
            return true;
        }
        File[] fileArray = FlowModel.searchAndCleanUpNewFlowBackupFiles(Rflow.project());
        return fileArray.length > 0;
    }

    public void unloadProject() {
        if (this.project != null) {
            this.project.setUnloading(true);
            try {
                try {
                    if (R.client().isConnected()) {
                        WorkingDirectory.setWorkingDirectory(SystemUtils.getUserHome());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Rflow.mainView().projectWillEnd();
                this.dispatchEvent(new RflowEvent(3));
                this.project.unload();
            }
            finally {
                this.project.setUnloading(false);
            }
            this.project = null;
        }
    }

    public void loadEmptyFlow(boolean bl) {
        this.loadFlow(FlowModel.createEmptyFlowModel(), !bl);
    }

    public void loadFlow(final FlowModel flowModel, Boolean bl) {
        if (!(bl != null && !bl.booleanValue() || flowModel.isSample() || flowModel.isNewFlow())) {
            try {
                File file = flowModel.getBackupFile();
                if (file.exists() && this.restoreFromBackup(flowModel, file, bl == null)) {
                    return;
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Failed to get backup.", iOException);
            }
        }
        if (!this.checkFlowDataConnection(flowModel)) {
            return;
        }
        FileEditManager.getInstance().load(flowModel, flowModel);
        this.getMainFrame().getMainView().openViewer(flowModel.getRootNode(), ViewOpenType.OPEN_NEW);
        try {
            flowModel.getCacheHandler().checkCacheStatus();
        }
        catch (OperationFailedException operationFailedException) {
            String string = Messages.getString("Error.cache_load_failed");
            RflowOptionPane.showTextAreaDialog(this.frame, Messages.getString("Error.title.error"), string, operationFailedException.getMessage(), 0, -1);
        }
        R.queryQueue().addQuery(() -> {
            RPackage[] rPackageArray = flowModel.getRequiredRPackages();
            RActions.getInstance().askInstallMissingPackages(rPackageArray);
            RActions.getInstance().attachPackagesIfNeeded(rPackageArray);
            R.client().getInstalledPackages();
            flowModel.refreshRPackageStates();
        });
        this.settings.addEventHandler(new ValueChangeEventHandler(){

            @Override
            public void valueChanged(ValueChangeEvent valueChangeEvent) {
                if (Settings.AUTO_DETECT_PACKAGES.equals(valueChangeEvent.getKey())) {
                    flowModel.refreshRPackageStates();
                }
            }
        });
    }

    private boolean checkFlowDataConnection(FlowModel flowModel) {
        if (flowModel.checkDataConnection()) {
            return true;
        }
        Integer n = OptionDialog.showOptionDialog(this.getMainFrame(), Messages.getString("Message.confirm"), Messages.getString("Message.unlinked_flow_cache"), new String[]{Messages.getString("Message.unlinked_option_copy"), Messages.getString("Message.unlinked_option_alter"), Messages.getString("Message.unlinked_option_do_nothing")});
        if (n == null) {
            return false;
        }
        try {
            switch (n) {
                case 0: {
                    flowModel.copyDataToNewDataDir();
                    break;
                }
                case 1: {
                    flowModel.moveDataToNewDataDir();
                    break;
                }
                default: {
                    flowModel.createNewDataDir();
                }
            }
            return true;
        }
        catch (IOException iOException) {
            UIUtility.showErrorDialog((Component)this.getMainFrame(), iOException);
            return false;
        }
    }

    public boolean restoreFromBackup(FlowModel flowModel, File file, boolean bl) {
        if (!bl) {
            this.restore(flowModel, file);
            return true;
        }
        String string = flowModel.isNewFlow() ? Messages.getString("Flow.new_flow") : flowModel.getWorkingFile().getName();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string2 = flowModel.isNewFlow() ? Messages.getString("Message.restart_from_backup.unsaved") : simpleDateFormat.format(new Date(flowModel.getWorkingFile().lastModified()));
        String string3 = simpleDateFormat.format(new Date(file.lastModified()));
        String string4 = Messages.format("Message.restart_from_backup", string, string2, string3);
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add(Messages.getString("Button.yes"));
        arrayList.add(Messages.getString("Button.no") + Messages.getString("Message.clear_history_notice"));
        if (!flowModel.isNewFlow()) {
            arrayList.add(Messages.getString("Button.cancel"));
        }
        JLabel jLabel = new JLabel(string4);
        Font font = UIManager.getFont("OptionPane.font");
        if (font != null) {
            jLabel.setFont(font);
        }
        JOptionPane jOptionPane = new JOptionPane(jLabel, 1, -1, null, arrayList.toArray(new Object[arrayList.size()]));
        JDialog jDialog = jOptionPane.createDialog(this.getMainFrame(), Messages.getString("Message.confirm"));
        jDialog.setDefaultCloseOperation(0);
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object = jOptionPane.getValue();
        if (arrayList.get(0).equals(object)) {
            this.restore(flowModel, file);
            return true;
        }
        if (arrayList.get(1).equals(object)) {
            if (flowModel.isNewFlow()) {
                FileUtils.deleteQuietly((File)file);
            }
            return false;
        }
        return true;
    }

    private void restore(FlowModel flowModel, File file) {
        try {
            FlowModel flowModel2 = this.actions.openFlowFile(file, flowModel.getWorkingFile(), false, null, false);
            flowModel2.setDirty(true);
            if (flowModel.isNewFlow()) {
                FileUtils.deleteQuietly((File)file);
            }
        }
        catch (Exception exception) {
            UIUtility.showErrorDialog((Component)this.getMainFrame(), exception);
        }
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isBusy() {
        return this.console.isBusy();
    }

    public TrayIcon getTrayIcon() {
        return this.trayIcon;
    }

    public MainFrame getMainFrame() {
        return this.frame;
    }

    public MainView getMainView() {
        return this.frame.getMainView();
    }

    public RConsoleView getConsole() {
        return this.console;
    }

    public RflowActions getActions() {
        return this.actions;
    }

    public BackupThread getBackupThread() {
        return this.backupThread;
    }

    public LogThread getLogThread() {
        return this.logThread;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public DevelSettings getDevelSettings() {
        return this.develSettings;
    }

    public void addRflowEventHandler(RflowEventHandler rflowEventHandler) {
        this.rflowEventSupport.addEventHandler(rflowEventHandler);
    }

    public void removeRflowEventHandler(RflowEventHandler rflowEventHandler) {
        this.rflowEventSupport.removeEventHandler(rflowEventHandler);
    }

    void dispatchEvent(RflowEvent rflowEvent) {
        this.rflowEventSupport.dispatchEvent(rflowEvent);
    }

    public File getDefaultDirForSelection() {
        return this.getProject().isNewProject() ? Rflow.settings().getDefaultWorkingDir() : WorkingDirectory.getWorkingDirectory();
    }

    public static void prepareRestart() {
        if (Platform.isWindowsFamily()) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    String string = Utility.getPathStr("rflow.bat");
                    if (new File(string).exists()) {
                        ProcessBuilder processBuilder = new ProcessBuilder(string);
                        try {
                            processBuilder.start();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }));
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        LOGGER.log(Level.SEVERE, "Uncaught exception", throwable);
        if (throwable instanceof Error) {
            SwingUtilities.invokeLater(() -> {
                String string = throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
                UIUtility.showErrorDialog(this.getMainFrame(), string, throwable, false);
            });
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        System.setProperty("jri.ignore.ule", "yes");
        Options options = new Options();
        options.addOption(Option.builder((String)"settings").longOpt("settings").hasArg().valueSeparator('=').build());
        options.addOption(Option.builder((String)"debug").longOpt("debug").desc("Enable debug outputs").build());
        options.addOption(Option.builder((String)"userdir").longOpt("userdir").desc("Directory to save user related files").hasArg().valueSeparator('=').build());
        options.addOption(Option.builder((String)"devel").longOpt("devel").hasArg().valueSeparator('=').build());
        CommandLine commandLine = null;
        boolean bl = true;
        try {
            commandLine = new DefaultParser().parse(options, stringArray, true);
            if (commandLine.hasOption("debug")) {
                Rflow.setRengineDebug(2);
            }
            if (commandLine.hasOption("userdir")) {
                UserFolder.setUserDir(commandLine.getOptionValue("userdir"));
            }
            if (commandLine.hasOption("settings")) {
                UserFolder.setUserSettings(commandLine.getOptionValue("settings"));
            }
            if (commandLine.hasOption("devel")) {
                object = commandLine.getOptionValue("devel");
                bl = "true".equals(object);
            }
        }
        catch (ParseException parseException) {
            new HelpFormatter().printHelp(APP_NAME, options);
        }
        LocaleSettings.initLocale();
        devel = false;
        if (bl) {
            try {
                Class.forName("com.ef_prime.rflow.core.base.Devel");
                devel = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        object = Rflow.getInstance();
        try {
            ((Rflow)object).getSettings().load();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to load settings file.", iOException);
        }
        if (Rflow.isDevel()) {
            try {
                ((Rflow)object).getDevelSettings().load();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Failed to load devel settings file.", iOException);
            }
        }
        CommandLine commandLine2 = commandLine;
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ Rflow val$rflow;
            final /* synthetic */ CommandLine val$cl;
            {
                this.val$rflow = rflow;
                this.val$cl = commandLine;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                Settings settings;
                RflowUI.initLookAndFeel();
                if (Platform.isLinux() && !RflowUI.checkFx()) {
                    JOptionPane.showMessageDialog(null, Messages.getString("Error.no_javafx"), Messages.getString("Error.title.error"), 0);
                    System.exit(1);
                }
                if ((settings = RflowUI.prepareSetting(this.val$rflow.getSettings())) == null) {
                    return;
                }
                if (!this.val$rflow.getSettings().getLocale().equals(settings.getLocale())) {
                    Rflow.prepareRestart();
                    System.exit(2);
                    return;
                }
                if (settings != this.val$rflow.getSettings()) {
                    this.val$rflow.getSettings().setPropertyAll(settings);
                }
                try {
                    this.val$rflow.initRflow();
                }
                catch (Throwable throwable) {
                    if (LOGGER != null) {
                        LOGGER.log(Level.SEVERE, "Failed to initialize app.", throwable);
                    }
                    UIUtility.showErrorDialog(null, Messages.getString("Error.Main.init"), throwable);
                    System.exit(1);
                }
                Thread.setDefaultUncaughtExceptionHandler(this.val$rflow);
                this.val$rflow.frame.setVisible(true);
                Rflow.showReleaseNotes();
                this.val$rflow.frame.setWaitingCursor(true);
                boolean bl = false;
                try {
                    Object object2;
                    object = null;
                    if (this.val$cl != null && ((String[])(object2 = this.val$cl.getArgs())).length > 0) {
                        object = new File(object2[0]);
                    }
                    if (object != null && ((File)object).exists()) {
                        if (((File)object).isDirectory() && Project.isProject((File)object)) {
                            this.val$rflow.loadProject(Project.createProject((File)object), true, null);
                        } else if (FilenameUtils.isExtension((String)((File)object).getName(), (String[])new String[]{"rflow", "afp"})) {
                            object2 = Project.getProjectHome((File)object);
                            if (object2 != null) {
                                this.val$rflow.loadProject(Project.createProject((File)object2), true, null);
                            } else {
                                this.val$rflow.loadEmptyProject(true);
                            }
                            if (FlowModel.isRflow(((File)object).getName())) {
                                this.val$rflow.actions.openFlow((File)object, true);
                            }
                        }
                    } else {
                        if (R.client().isEmbedded()) {
                            this.val$rflow.loadEmptyProject(true);
                        } else {
                            this.val$rflow.project = Project.createEmptyProject();
                        }
                        bl = true;
                    }
                }
                finally {
                    this.val$rflow.frame.setWaitingCursor(false);
                }
                Rflow.checkUpdate();
                Rflow.showStarterGuideNotification();
                Rflow.settings().putValue(Settings.VERSION, Settings.VERSION.getDefaultValue());
                if (bl) {
                    object = ProjectsManager.getInstance();
                    ProjectsView.createDialog(Rflow.mainFrame(), (ProjectsManager)object).setVisible(true);
                }
                R.queryQueue().addQuery(() -> {
                    RActions.getInstance().askInstallMissingPackages(RClient.REQUIRED_PACKAGES);
                    RActions.getInstance().attachPackagesIfNeeded(RClient.REQUIRED_PACKAGES);
                });
                this.val$rflow.backupThread.start();
                this.val$rflow.logThread.start();
            }
        });
    }

    private static void checkUpdate() {
        try {
            if (Rflow.settings().getValue(Settings.IS_AUTO_UPDATE).booleanValue()) {
                UpdateChecker.updateCheck();
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to check update.", exception);
        }
    }

    private static void showReleaseNotes() {
        Version version = Version.parseOrDefault(Rflow.settings().getValue(Settings.VERSION), RflowVersion.get());
        if (version.compareMainPartTo(RflowVersion.get()) < 0) {
            Path path = FileResource.getReleaseNotes();
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            FXBrowserView fXBrowserView = new FXBrowserView();
            fXBrowserView.setToolBarVisible(false);
            fXBrowserView.load(path.toUri().toString());
            PagesViewFactory.createCloseOnlyView(new Page(fXBrowserView)).showDialog(Rflow.mainFrame(), Messages.getString("Message.release_notes"), true, new Dimension(800, 600));
        }
    }

    private static void showStarterGuideNotification() {
        if (Rflow.settings().getValue(Settings.FIRST_GUIDE_NOTIFICATION).booleanValue()) {
            JOptionPane jOptionPane = new JOptionPane(Messages.getString("Message.starter_guide_notice"), 1);
            Object[] objectArray = new Object[]{Messages.getString("Button.yes"), Messages.getString("Button.no"), Messages.getString("Button.never")};
            jOptionPane.setOptions(objectArray);
            JDialog jDialog = jOptionPane.createDialog(Rflow.mainFrame(), Messages.getString("Message.hint"));
            jDialog.setVisible(true);
            int n = 1;
            Object object = jOptionPane.getValue();
            if (object != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!objectArray[i].equals(object)) continue;
                    n = i;
                    break;
                }
            }
            switch (n) {
                case 0: {
                    Rflow.settings().putValue(Settings.FIRST_GUIDE_NOTIFICATION, false);
                    Rflow.getInstance().actions.doAction("FIRST_GUIDE");
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    Rflow.settings().putValue(Settings.FIRST_GUIDE_NOTIFICATION, false);
                }
            }
        }
    }
}

