/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.SettingsDialog;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.BusyListener;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditManager;
import com.ef_prime.rflow.core.base.FileManager;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.base.LogManager;
import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.ProjectsManager;
import com.ef_prime.rflow.core.base.RflowEvent;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.base.SampleEntry;
import com.ef_prime.rflow.core.base.SessionEntry;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.feature.backup.FlowBackupManager;
import com.ef_prime.rflow.core.flow.FlowModel;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.task.TaskQueue;
import com.ef_prime.rflow.core.util.CancelledSaxException;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.core.util.ReadException;
import com.ef_prime.rflow.node.NodeBreakpointChangeListener;
import com.ef_prime.rflow.node.RequestNodeModelNotifyEvent;
import com.ef_prime.rflow.node.ui.OpTabPagesView;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.file.FileEditViewFactory;
import com.ef_prime.rflow.ui.app.file.FileUIUtility;
import com.ef_prime.rflow.ui.base.AboutDialog;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.LogView;
import com.ef_prime.rflow.ui.base.MenuActionProvider;
import com.ef_prime.rflow.ui.base.OpeningRflowFileView;
import com.ef_prime.rflow.ui.base.ProjectExportView;
import com.ef_prime.rflow.ui.base.ProjectImportView;
import com.ef_prime.rflow.ui.base.ProjectNode;
import com.ef_prime.rflow.ui.base.ProjectWizard;
import com.ef_prime.rflow.ui.base.ProjectsView;
import com.ef_prime.rflow.ui.base.RflowActionLogger;
import com.ef_prime.rflow.ui.base.SaveProjectWizard;
import com.ef_prime.rflow.ui.base.SubstanceUI;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.FileFilterFactory;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.MyFileFilter;
import com.ef_prime.rflow.ui.common.component.RflowOptionPane;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.event.FileEvent;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PagesView;
import com.ef_prime.rflow.ui.common.view.PagesViewFactory;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.ef_prime.rflow.ui.view.ActiveViewEvent;
import com.ef_prime.rflow.ui.view.ActiveViewEventHandler;
import com.ef_prime.rflow.ui.view.BasicFileNode;
import com.ef_prime.rflow.ui.view.FileEditView;
import com.ef_prime.rflow.ui.view.ViewPosition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.SystemTray;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;

public class RflowActions
extends Actions
implements BusyListener,
NodeBreakpointChangeListener,
RflowEventHandler,
ActiveViewEventHandler {
    private static final Logger LOGGER = Logger.getLogger(RflowActions.class.getName());
    public static final String PROJECTS = "PROJECTS";
    public static final String BOOKMARK = "BOOKMARK";
    public static final String NEW_PROJECT = "NEW_PROJECT";
    public static final String NEW_FLOW = "NEW_FLOW";
    public static final String OPEN_FLOW = "OPEN_FLOW";
    public static final String SAVE_PROJECT = "SAVE_PROJECT";
    public static final String SAVE = "SAVE";
    public static final String SAVE_AS = "SAVE_AS";
    public static final String EXPORT_PROJECT = "EXPORT_PROJECT";
    public static final String IMPORT_PROJECT = "IMPORT_PROJECT";
    public static final String EXIT = "EXIT";
    public static final String CONSOLE_WINDOW = "CONSOLE_WINDOW";
    public static final String STOP = "STOP";
    public static final String R_STOP = "R_STOP";
    public static final String R_RESTART = "R_RESTART";
    public static final String CHANGE_DIRECTORY = "CHANGE_DIRECTORY";
    public static final String FOCUS_CONSOLE = "FOCUS_CONSOLE";
    public static final String PREFERENCES = "PREFERENCES";
    public static final String PROJECT_PROPERTIES = "PROJECT_PROPERTIES";
    public static final String STARTER_GUIDE = "FIRST_GUIDE";
    public static final String LOG = "LOG";
    public static final String ABOUT = "ABOUT";
    public static final String DEVEL_SKIN = "DEVEL_SKIN";
    public static final String DEVEL_SETTINGS_ACTION = "DEVEL_SETTINGS_ACTION";
    public static final String TEST_ACTION = "TEST_ACTION";
    private final Rflow rflow;
    private boolean notBusy = true;

    public RflowActions(Rflow rflow) {
        this.rflow = rflow;
        FlowNode.addNodeBreakpointChangeListener(this);
        EventManager.getInstance().registerEventHandler(ActiveViewEvent.class, this);
        this.rflow.addRflowEventHandler(this);
        this.put(PROJECTS, new Projects());
        this.put(BOOKMARK, new Bookmark());
        this.put(NEW_PROJECT, new NewProjectAction());
        this.put(NEW_FLOW, new NewFlowAction());
        this.put(OPEN_FLOW, new OpenFlowAction());
        this.put(SAVE_PROJECT, new SaveProjectAction());
        this.put(SAVE, new SaveAction());
        this.put(SAVE_AS, new SaveAsAction());
        this.put(EXPORT_PROJECT, new ExportProject());
        this.put(IMPORT_PROJECT, new ImportProject());
        this.put(EXIT, new ExitAction());
        this.put(STOP, new StopAction());
        this.put(R_STOP, new RStopAction());
        this.put(R_RESTART, new RRestart());
        this.put(CHANGE_DIRECTORY, new ChangeDirAction());
        this.put(PREFERENCES, new PreferencesAction());
        this.put(PROJECT_PROPERTIES, new ProjectProperties());
        this.put(STARTER_GUIDE, new StarterGuideAction());
        this.put(LOG, new LogDialogAction());
        this.put(ABOUT, new AboutAction());
        this.put(FOCUS_CONSOLE, new FocusConsole());
        this.put("MENU_ACTION_SAVE", new GeneralMenuAction("MENU_ACTION_SAVE", Messages.getString("Action.save"), KeyStroke.getKeyStroke(83, UIUtility.MENU_KEY_MASK), Icons.getIcon("16/diskette.png")));
        this.put("MENU_ACTION_SAVE_AS", new GeneralMenuAction("MENU_ACTION_SAVE_AS", Messages.getStringWithDots("Action.save_as"), null, null));
        this.put("MENU_ACTION_UNDO", new GeneralMenuAction("MENU_ACTION_UNDO", Messages.getString("Action.undo"), KeyStroke.getKeyStroke(90, UIUtility.MENU_KEY_MASK), null));
        this.put("MENU_ACTION_REDO", new GeneralMenuAction("MENU_ACTION_REDO", Messages.getString("Action.redo"), KeyStroke.getKeyStroke(89, UIUtility.MENU_KEY_MASK), null));
        this.put("MENU_ACTION_COPY", new GeneralMenuAction("MENU_ACTION_COPY", Messages.getString("Action.copy"), KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK), null));
        this.put("MENU_ACTION_CUT", new GeneralMenuAction("MENU_ACTION_CUT", Messages.getString("Action.cut"), KeyStroke.getKeyStroke(88, UIUtility.MENU_KEY_MASK), null));
        this.put("MENU_ACTION_PASTE", new GeneralMenuAction("MENU_ACTION_PASTE", Messages.getString("Action.paste"), KeyStroke.getKeyStroke(86, UIUtility.MENU_KEY_MASK), null));
        this.put("MENU_ACTION_FIND", new FindAction("MENU_ACTION_FIND"));
        if (Rflow.isDevel()) {
            this.put(DEVEL_SKIN, new SkinOptions());
            this.put(DEVEL_SETTINGS_ACTION, new DevelSettingsAction());
        }
    }

    private FlowModel getFlowModel() {
        return Rflow.mainView().getActiveFlowModel();
    }

    @Override
    public void busyStateChanged(int n) {
        this.notBusy = n == 0;
        this.updateActionState();
    }

    @Override
    public void nodeBreakpointChanged(FlowNode flowNode, int n, int n2) {
        this.updateActionState();
    }

    @Override
    public void rflowWillShutdown() {
    }

    @Override
    public void rflowProjectDidStart() {
        this.get(EXPORT_PROJECT).setEnabled(!Rflow.project().isNewProject());
    }

    @Override
    public void rflowProjectWillEnd() {
    }

    public void updateActionState() {
        this.get(CHANGE_DIRECTORY).setEnabled(this.notBusy);
        this.get(R_STOP).setEnabled(!this.notBusy && (Platform.isWindowsFamily() || !this.rflow.getConsole().isWaitingForCommand()));
        this.get(STOP).setEnabled(this.get(R_STOP).isEnabled());
    }

    public boolean openProject(File file, boolean bl) {
        if (!this.askSave()) {
            return false;
        }
        this.rflow.loadProject(Project.createProject(file), bl, null);
        return true;
    }

    public void openSavedQuickStartProject(File file) {
        if (this.openProject(file, true)) {
            this.rflow.getProject().setDirtyQuickStart(true);
        }
    }

    public void open(List<File> list) {
        if (list.size() == 1) {
            File file = list.get(0);
            if (file.exists() && FlowModel.isRflow(file.getName())) {
                Rflow.getInstance().getActions().openFlow(file, false, true);
            }
        } else {
            boolean bl = true;
            for (Serializable serializable : list) {
                if (!bl || FlowModel.isRflow(serializable.getName()) || !Rflow.project().getLocation().equals(Project.getProjectHome(serializable))) continue;
                bl = false;
            }
            if (bl) {
                Serializable serializable;
                OpeningRflowFileView openingRflowFileView = new OpeningRflowFileView(true);
                openingRflowFileView.setPreferredSize(new Dimension(800, openingRflowFileView.getPreferredSize().height + 10));
                serializable = new JOptionPane(openingRflowFileView, -1, 2);
                int n = RflowOptionPane.showDialog((JOptionPane)serializable, Rflow.mainFrame(), Messages.getString("Message.confirm"), true);
                if (n != 0) {
                    return;
                }
                this.importFlowFiles(list, openingRflowFileView.getImportDestinationDir());
            }
        }
    }

    private void importFlowFiles(List<File> list, File file) {
        try {
            for (File file2 : list) {
                FlowModel flowModel = FlowModel.readFlowModel(file2, file2, null);
                flowModel = flowModel.copyToDir(file);
                DefaultTreeModel defaultTreeModel = ProjectsManager.getInstance().getCurrentProjectTreeModel();
                if (defaultTreeModel != null) {
                    ProjectNode projectNode = (ProjectNode)defaultTreeModel.getRoot();
                    projectNode.refreshChildrenWork();
                    projectNode.refreshChildrenDone();
                    defaultTreeModel.nodeStructureChanged(projectNode);
                }
                FileManager.getInstance().addNewItem(new File(file, file2.getName()));
                if (list.size() != 1) continue;
                this.rflow.loadFlow(flowModel, true);
            }
        }
        catch (ReadException | IOException exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            UIUtility.showErrorDialog((Component)this.rflow.getMainFrame(), exception);
        }
    }

    public View openFileEditView(Path path, SessionEntry sessionEntry, boolean bl, int n, ViewPosition viewPosition) {
        Class<? extends FileEditView> clazz = FileEditViewFactory.getInstance().getViewClass(path);
        FileEdit fileEdit = FileEditView.toFileEdit(clazz, path);
        if (fileEdit == null) {
            return null;
        }
        FileEditView fileEditView = FileEditViewFactory.getInstance().getView(path.toFile());
        if (fileEditView != null) {
            ViewTabbedPane viewTabbedPane = Rflow.mainView().getTabbedPane(viewPosition);
            viewTabbedPane.openView(fileEditView, ViewOpenType.OPEN_NEW, bl, n);
            if (sessionEntry != null) {
                fileEditView.loadSessionEntry(sessionEntry);
            }
        }
        return fileEditView;
    }

    public void openFlow(File file, boolean bl) {
        this.openFlow(file, bl, false);
    }

    public void openFlow(File file, boolean bl, boolean bl2) {
        try {
            int view2;
            int n;
            FileFilter[] fileFilterArray;
            if (file == null) {
                fileFilterArray = new FileFilter[]{FileFilterFactory.createRflowFileFilter()};
                file = UIUtility.chooseOpenFile(Messages.getString("Action.open"), WorkingDirectory.getWorkingDirectory(), fileFilterArray, this.rflow.getMainFrame());
                if (file == null) {
                    return;
                }
            }
            fileFilterArray = FileEditManager.getInstance();
            for (FlowModel object : fileFilterArray.getFlowModels()) {
                if (!file.equals(object.getWorkingFile())) continue;
                n = 1;
                if (object.isDirty() && (view2 = JOptionPane.showConfirmDialog(this.rflow.getMainFrame(), Messages.getString("Message.reopen"), Messages.getString("Message.confirm"), 0, 3)) == 0) {
                    n = 0;
                    object.setDirty(false);
                    fileFilterArray.unload(object, object);
                }
                if (n == 0) continue;
                View arrayList = Rflow.mainView().getView(object.getRootNode());
                if (arrayList != null) {
                    arrayList.toFront();
                }
                return;
            }
            if (bl2 && !Rflow.project().getLocation().equals(Project.getProjectHome(file))) {
                OpeningRflowFileView openingRflowFileView = new OpeningRflowFileView(false);
                openingRflowFileView.setPreferredSize(new Dimension(800, openingRflowFileView.getPreferredSize().height + 10));
                JOptionPane jOptionPane = new JOptionPane(openingRflowFileView, -1, 2);
                n = RflowOptionPane.showDialog(jOptionPane, Rflow.mainFrame(), Messages.getString("Message.confirm"), true);
                if (n != 0) {
                    return;
                }
                if (openingRflowFileView.getType() == "import") {
                    ArrayList<File> arrayList = new ArrayList<File>();
                    arrayList.add(file);
                    this.importFlowFiles(arrayList, openingRflowFileView.getImportDestinationDir());
                    return;
                }
                if (openingRflowFileView.getType() == "open_in_new_project") {
                    if (!this.askSave()) {
                        return;
                    }
                    this.rflow.loadEmptyProject(true);
                    view2 = WorkingDirectory.setWorkingDirectory(file.getParentFile()) ? 1 : 0;
                    Rflow.project().setWorkingDirectory(file.getParentFile().getAbsolutePath());
                    boolean bl3 = Rflow.settings().getValue(Settings.SHOW_HIDDEN_FILES);
                    FileManager fileManager = FileManager.getInstance();
                    fileManager.add(new BasicFileNode(file.getParentFile(), bl3));
                    fileManager.load();
                    if (view2 == 0) {
                        Rflow.actions().showSettingRWorkingDirFailedMessage(false);
                    }
                }
            }
            this.openFlowFile(file, file, bl, null, null);
            new OpenRflowFile().doAction();
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof CancelledSaxException) {
                return;
            }
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            UIUtility.showErrorDialog((Component)this.rflow.getMainFrame(), Messages.getString("Error.read"), exception);
            return;
        }
    }

    public FlowModel openFlowFile(Object object, File file, boolean bl, SampleEntry sampleEntry, Boolean bl2) throws ReadException, IOException {
        FlowModel flowModel = FlowModel.readFlowModel(object, file, sampleEntry);
        this.rflow.loadFlow(flowModel, bl2);
        return flowModel;
    }

    private void openSampleFlow(SampleEntry sampleEntry) {
        try {
            this.openFlowFile(sampleEntry.getFile(), null, false, sampleEntry, false);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public boolean save(FlowModel flowModel) {
        File file = flowModel.getWorkingFile();
        if (file == null) {
            return this.save_as(flowModel);
        }
        return this.save_internal(flowModel, file);
    }

    public boolean save_as(FlowModel flowModel) {
        JFileChooser jFileChooser = new JFileChooser(Rflow.project().getLocation());
        jFileChooser.setDialogTitle(Messages.getString("Message.save"));
        MyFileFilter myFileFilter = FileFilterFactory.createRflowFileFilter();
        jFileChooser.addChoosableFileFilter(myFileFilter);
        jFileChooser.setFileFilter(myFileFilter);
        File file = UIUtility.chooseSaveFile(jFileChooser, this.rflow.getMainFrame());
        return this.save_internal(flowModel, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save_internal(FlowModel flowModel, File file) {
        if (file == null) {
            return false;
        }
        EventManager.getInstance().dispatchEvent(RequestNodeModelNotifyEvent.getInstance());
        this.rflow.getBackupThread().pause();
        try {
            boolean bl;
            boolean bl2 = bl = flowModel.getWorkingFile() == null || !file.equals(flowModel.getWorkingFile());
            if (!bl && flowModel.hasLastModifiedChanged()) {
                String string = Messages.format("Message.confirm_changed", file.getName());
                JOptionPane jOptionPane = new JOptionPane(string, 2);
                String string2 = Messages.getStringWithDots("Action.save_as");
                String string3 = Messages.getString("ConfirmOverwrite.overwrite");
                String string4 = Messages.getString("Button.cancel");
                jOptionPane.setOptions(new String[]{string2, string3, string4});
                JDialog jDialog = jOptionPane.createDialog(Rflow.mainFrame(), Messages.getString("Error.title.warning"));
                jDialog.setVisible(true);
                jDialog.dispose();
                String string5 = (String)jOptionPane.getValue();
                if (string5 == null) {
                    boolean bl3 = false;
                    return bl3;
                }
                if (string5.equals(string2)) {
                    boolean bl4 = this.save_as(flowModel);
                    return bl4;
                }
                if (!string5.equals(string3)) {
                    boolean bl5 = false;
                    return bl5;
                }
            }
            boolean bl6 = true;
            if (bl && !flowModel.isNewFlow() && flowModel.isFlowData()) {
                int n = JOptionPane.showConfirmDialog(this.rflow.getMainFrame(), Messages.getString("Message.ask_copy_caches"), Messages.getString("Message.confirm"), 1, 3);
                switch (n) {
                    case 0: {
                        bl6 = true;
                        break;
                    }
                    case 1: {
                        bl6 = false;
                        break;
                    }
                    default: {
                        boolean bl7 = false;
                        return bl7;
                    }
                }
            }
            flowModel.save(file, bl6);
            FlowBackupManager.saveToBackup(flowModel, file);
            EventManager.getInstance().dispatchEvent(new FileEvent(file));
            boolean bl8 = true;
            return bl8;
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            UIUtility.showErrorDialog((Component)this.rflow.getMainFrame(), Messages.getString("Error.save"), exception);
            boolean bl = false;
            return bl;
        }
        finally {
            this.rflow.getBackupThread().restart();
        }
    }

    public boolean newProject() {
        if (!this.askSave()) {
            return false;
        }
        ProjectWizard projectWizard = new ProjectWizard();
        projectWizard.showDialog(this.rflow.getMainFrame(), Messages.getString("Action.new_project"), true, new Dimension(600, 0));
        return projectWizard.isSucceeded();
    }

    private boolean saveProject() {
        SaveProjectWizard saveProjectWizard = new SaveProjectWizard(this.rflow.getProject());
        saveProjectWizard.showDialog(Rflow.mainFrame(), Messages.getString("Action.save_project"), true, new Dimension(600, 0));
        if (saveProjectWizard.isSucceeded()) {
            this.rflow.getProject().setDirtyQuickStart(false);
        }
        return saveProjectWizard.isSucceeded();
    }

    public boolean askSave() {
        Project project = this.rflow.getProject();
        if (Rflow.getInstance().isBusy()) {
            int n = JOptionPane.showConfirmDialog(this.rflow.getMainFrame(), Messages.getString("Message.confirm_interrupt"), Messages.getString("Message.confirm"), 2, 2);
            if (n == 0) {
                this.stop(true);
            } else {
                return false;
            }
        }
        if (!this.askSaveEditingFiles()) {
            return false;
        }
        if (project.isNewProject() && project.checkDirty()) {
            String string = Messages.format("Message.confirm_save_project", Messages.getString("Action.new_project"));
            int n = RflowOptionPane.showConfirmDialog((Component)this.rflow.getMainFrame(), string, Messages.getString("Message.confirm"), 3);
            switch (n) {
                case 0: {
                    if (this.saveProject()) break;
                    return false;
                }
                case 1: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean askSaveEditingFiles() {
        HashSet<FileEdit> hashSet = new HashSet<FileEdit>();
        for (View object : Rflow.mainView().getAllViews()) {
            FileEdit fileEdit;
            View view2;
            if (object instanceof FileEditView) {
                view2 = (FileEditView)object;
                fileEdit = ((FileEditView)view2).getFileEdit();
                if (!hashSet.contains(fileEdit) && !((FileEditView)view2).askSave(true)) {
                    return false;
                }
                hashSet.add(fileEdit);
                continue;
            }
            if (!(object instanceof OpTabPagesView)) continue;
            view2 = (OpTabPagesView)object;
            fileEdit = ((OpTabPagesView)view2).getFileEdit();
            if (!hashSet.contains(fileEdit) && !((OpTabPagesView)view2).askSave(true)) {
                return false;
            }
            hashSet.add(fileEdit);
        }
        for (FileEdit fileEdit : FileEditManager.getInstance().getFileEdits()) {
            fileEdit.setDirty(false);
        }
        return true;
    }

    public void restart() {
        if (!this.askSave()) {
            return;
        }
        Rflow.prepareRestart();
        this.exit(2);
    }

    public void exit(int n) {
        this.rflow.unloadProject();
        this.rflow.dispatchEvent(new RflowEvent(1));
        try {
            Rflow.settings().save();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to save the settings file", iOException);
        }
        if (SystemTray.isSupported()) {
            SystemTray.getSystemTray().remove(this.rflow.getTrayIcon());
        }
        RflowActionLogger.getInstance().close();
        Logger logger = LogManager.getInstance().getRootLogger();
        for (Handler handler : logger.getHandlers()) {
            handler.close();
        }
        this.rflow.getLogThread().close();
        UserFolder.clearTempDirs();
        if (R.console().isDebugWaitingForInput()) {
            BasicCommand basicCommand = new BasicCommand("Q");
            R.receiver().passCommand(basicCommand);
            try {
                basicCommand.waitForCommand(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!R.client().isEmbedded()) {
            R.sessionManager().shutdown();
        }
        if (n == 0 && R.client().isEmbedded()) {
            R.receiver().passCommand("base::q(save=\"no\")");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOGGER.warning("Failed to exit with R q() command");
        }
        System.exit(n);
    }

    public void stop(boolean bl) {
        this.rflow.getConsole().stop(bl);
    }

    public void restartR() {
        SwingUtilities.invokeLater(() -> this.get(R_RESTART).setEnabled(false));
        R.sessionManager().restart(false);
        R.sessionManager().execute(() -> SwingUtilities.invokeLater(() -> this.get(R_RESTART).setEnabled(true)));
    }

    public Action createNextTutorialAction(SampleEntry sampleEntry) {
        return new NextTutorialAction(sampleEntry);
    }

    public Action createTutorialSelectionAction(SampleEntry sampleEntry) {
        return new TutorialSelectionAction(sampleEntry);
    }

    public void showSettingRWorkingDirFailedMessage(boolean bl) {
        String string = R.client().getWorkingDirectory();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Messages.getString("Error.set_r_wd") + "\n");
        if (bl) {
            stringBuilder.append(Messages.getString("Error.set_r_wd_guide") + "\n");
        }
        if (string != null) {
            stringBuilder.append("\n");
            stringBuilder.append(Messages.getString("Error.current_working_dir") + ":\n");
            stringBuilder.append(string);
        }
        UIUtility.showErrorDialog((Component)Rflow.mainFrame(), stringBuilder.toString());
    }

    public boolean importProject() {
        ProjectImportView projectImportView = new ProjectImportView();
        projectImportView.showDialog(this.rflow.getMainFrame(), Messages.getString("Action.import_project"), true, new Dimension(600, 285));
        return projectImportView.getResult() == 1;
    }

    @Override
    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        if (activeViewEvent.isActiveFileEditChanged()) {
            boolean bl = activeViewEvent.getActiveFileEdit() != null;
            this.get(SAVE).setEnabled(bl);
            this.get(SAVE_AS).setEnabled(bl);
        }
    }

    private class Projects
    extends LoggableAction {
        Projects() {
            this.putValue("Name", Messages.getStringWithDots("Action.start_page"));
            this.putValue("SmallIcon", Icons.getIcon("16/package.png"));
            this.putValue("SwingLargeIconKey", Icons.getIcon("32/package.png"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            JDialog jDialog = ProjectsView.createDialog(Rflow.mainFrame(), ProjectsManager.getInstance());
            jDialog.setVisible(true);
        }
    }

    private class Bookmark
    extends LoggableAction {
        Bookmark() {
            this.putValue("Name", Messages.getStringWithDots("Action.bookmark"));
            this.putValue("SmallIcon", Icons.getIcon("16/star.png"));
            this.putValue("SwingLargeIconKey", Icons.getIcon("32/star.png"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            JDialog jDialog = ProjectsView.createDialog(Rflow.mainFrame(), ProjectsManager.getInstance());
            if (!Rflow.project().isNewProject()) {
                ProjectsView projectsView = (ProjectsView)jDialog.getContentPane().getComponent(0);
                projectsView.addBookmark(Rflow.project().getLocation().getAbsolutePath());
            }
        }
    }

    private class NewProjectAction
    extends LoggableAction {
        NewProjectAction() {
            this.putValue("Name", Messages.getStringWithDots("Action.new_project"));
            this.putValue("SmallIcon", Icons.getIcon("16/page_white.png"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            RflowActions.this.newProject();
        }
    }

    private class NewFlowAction
    extends LoggableAction {
        NewFlowAction() {
            this.putValue("Name", Messages.getString("Action.new_flow"));
            this.putValue("SmallIcon", Icons.getIcon("16/page_white.png"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, UIUtility.MENU_KEY_MASK));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            RflowActions.this.rflow.loadEmptyFlow(false);
        }
    }

    private class OpenFlowAction
    extends LoggableAction {
        OpenFlowAction() {
            this.putValue("Name", Messages.getStringWithDots("Action.open_flow"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            RflowActions.this.openFlow(null, true);
        }
    }

    private class SaveProjectAction
    extends LoggableAction {
        SaveProjectAction() {
            this.putValue("Name", Messages.getStringWithDots("Action.save_project"));
            this.putValue("SmallIcon", Icons.getIcon("16/diskette.png"));
            this.putValue("SwingLargeIconKey", Icons.getIcon("32/diskette.png"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            if (!RflowActions.this.rflow.getProject().isNewProject()) {
                return;
            }
            RflowActions.this.saveProject();
        }
    }

    private class SaveAction
    extends LoggableAction {
        SaveAction() {
            this.putValue("Name", Messages.getString("Action.save"));
            this.putValue("SmallIcon", Icons.getIcon("16/diskette.png"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, UIUtility.MENU_KEY_MASK));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            FileEditView fileEditView = Rflow.mainView().getActiveFileEditView();
            if (fileEditView != null) {
                fileEditView.save(false);
            }
        }
    }

    private class SaveAsAction
    extends LoggableAction {
        SaveAsAction() {
            this.putValue("Name", Messages.getString("Action.save_as") + "...");
        }

        @Override
        public void action(ActionEvent actionEvent) {
            FileEditView fileEditView = Rflow.mainView().getActiveFileEditView();
            if (fileEditView != null) {
                fileEditView.save(true);
            }
        }
    }

    private class ExportProject
    extends LoggableAction {
        ExportProject() {
            this.putValue("Name", Messages.getStringWithDots("Action.export"));
            this.putValue("SmallIcon", Icons.getIcon("16/saved_exports.png"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            ProjectExportView.showExportDialog(Rflow.mainFrame(), Rflow.project());
        }
    }

    private class ImportProject
    extends LoggableAction {
        ImportProject() {
            this.putValue("Name", Messages.getStringWithDots("Action.import"));
            this.putValue("SmallIcon", Icons.getIcon("16/saved_imports.png"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            if (!RflowActions.this.askSave()) {
                return;
            }
            RflowActions.this.importProject();
        }
    }

    private class ExitAction
    extends LoggableAction {
        ExitAction() {
            this.putValue("Name", Messages.format("Action.exit_app", "R AnalyticFlow"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            if (!RflowActions.this.askSave()) {
                return;
            }
            RflowActions.this.exit(0);
        }
    }

    private class StopAction
    extends LoggableAction {
        StopAction() {
            this.putValue("Name", Messages.getString("Action.stop"));
            this.putValue("SmallIcon", FileResource.getIcon("img/action/stop.png"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            TaskQueue.getInstance().cancel();
        }
    }

    private class RStopAction
    extends LoggableAction {
        RStopAction() {
            this.putValue("Name", Messages.getString("Action.interrupt_r"));
            this.putValue("SmallIcon", Icons.getIcon("16/stop.png"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            RflowActions.this.stop(false);
        }
    }

    private class RRestart
    extends LoggableAction {
        RRestart() {
            this.putValue("Name", Messages.getString("Action.restart_r"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog(Rflow.mainFrame(), Messages.getString("Message.confirm_restart_r"), Messages.getString("Error.title.warning"), 0, 2);
            if (n != 0) {
                return;
            }
            RflowActions.this.restartR();
        }
    }

    private class ChangeDirAction
    extends LoggableAction {
        ChangeDirAction() {
            this.putValue("Name", Messages.getStringWithDots("Action.change_directory"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            File file;
            File file2 = WorkingDirectory.getWorkingDirectory();
            String string = R.client().getWorkingDirectory();
            if (string != null) {
                file2 = new File(RUtility.replaceFileSeparatorRtoSystem(string));
            }
            if ((file = UIUtility.chooseDirFx(RflowActions.this.rflow.getMainFrame(), file2)) != null && !WorkingDirectory.setWorkingDirectory(file)) {
                RflowActions.this.showSettingRWorkingDirFailedMessage(false);
            }
        }
    }

    private class PreferencesAction
    extends LoggableAction {
        PreferencesAction() {
            this.putValue("Name", Messages.getStringWithDots("Action.preferences"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            int n;
            Settings settings = SettingsDialog.showSettingsDialog(RflowActions.this.rflow.getMainFrame(), Rflow.settings(), false);
            if (settings == null) {
                return;
            }
            try {
                settings.save();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Failed to write settings file", iOException);
                UIUtility.showErrorDialog((Component)RflowActions.this.rflow.getMainFrame(), Messages.getString("Error.write_option"), iOException);
                return;
            }
            boolean bl = Rflow.settings().checkRestartRequired(settings);
            Rflow.settings().setPropertyAll(settings);
            if (bl && (n = JOptionPane.showConfirmDialog(RflowActions.this.rflow.getMainFrame(), Messages.getString("Message.confirm_prefs_restart"), Messages.getString("Action.preferences"), 0, 3)) == 0) {
                RflowActions.this.restart();
            }
        }
    }

    private class ProjectProperties
    extends LoggableAction {
        public ProjectProperties() {
            this.putValue("Name", Messages.getStringWithDots("Action.properties"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            StrKey strKey = ((StrKey.Builder)StrKey.builder("path", Messages.getString("Project.location")).setFixed(true)).build();
            WidgetNode widgetNode = new PanelWidgetNode().addKeys(Project.KEY_NAME, strKey, Project.ENCODING, Project.NEWLINE);
            ValueMap valueMap = RflowActions.this.rflow.getProject().getProjectProperties();
            valueMap.putValue(strKey, RflowActions.this.rflow.getProject().getLocation().getAbsolutePath());
            Component component = WidgetFactory.getInstance().create(valueMap, widgetNode);
            int n = JOptionPane.showConfirmDialog(Rflow.mainFrame(), component, Messages.getString("Project.properties"), 2, -1);
            if (n != 0) {
                return;
            }
            RflowActions.this.rflow.getProject().putValues(valueMap);
            try {
                RflowActions.this.rflow.getProject().saveProjectFile();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    private class StarterGuideAction
    extends LoggableAction {
        public StarterGuideAction() {
            this.putValue("Name", Messages.getString("Action.starter_guide"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            FileUIUtility.openFileWithSystemEditor(Rflow.mainFrame(), FileResource.getStarterGuide().toFile());
        }
    }

    private class LogDialogAction
    extends LoggableAction {
        private JDialog dialog;
        private LogView logView;

        public LogDialogAction() {
            this.putValue("Name", Messages.getStringWithDots("Action.applog"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            if (this.logView == null) {
                this.logView = new LogView();
                this.logView.install();
                this.dialog = new JDialog((Frame)RflowActions.this.rflow.getMainFrame(), this.logView.getTitle());
                this.dialog.setDefaultCloseOperation(1);
                this.dialog.add(this.logView);
                this.dialog.setSize(800, 400);
                this.dialog.setLocationRelativeTo(null);
            }
            this.dialog.setVisible(true);
        }
    }

    private class AboutAction
    extends LoggableAction {
        AboutAction() {
            this.putValue("Name", Messages.getStringWithDots("Action.about"));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            AboutDialog.show(RflowActions.this.rflow.getMainFrame());
        }
    }

    private class FocusConsole
    extends LoggableAction {
        FocusConsole() {
            this.putValue("Name", Messages.getString("Action.focus_console"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(48, PlatformUtility.getAltMask()));
        }

        @Override
        public void action(ActionEvent actionEvent) {
            if (!RflowActions.this.rflow.getConsole().inputHasFocus()) {
                RflowActions.this.rflow.getConsole().requestFocusOnInput();
            } else {
                ViewTabbedPane viewTabbedPane;
                View view2 = Rflow.mainView().getLastActiveView();
                if (view2 != null && (viewTabbedPane = view2.getParentTabbedPane()) != null) {
                    viewTabbedPane.requestFocusOnView();
                }
            }
        }
    }

    private class GeneralMenuAction
    extends LoggableAction {
        private String key;

        public GeneralMenuAction(String string, String string2, KeyStroke keyStroke, Icon icon) {
            this.key = string;
            this.putValue("Name", string2);
            if (keyStroke != null) {
                this.putValue("AcceleratorKey", keyStroke);
            }
            if (icon != null) {
                this.putValue("SmallIcon", icon);
            }
        }

        @Override
        public void action(ActionEvent actionEvent) {
            MenuActionProvider menuActionProvider;
            Action action;
            View view2 = Rflow.mainView().getActiveView();
            if (view2 instanceof MenuActionProvider && (action = (menuActionProvider = (MenuActionProvider)((Object)view2)).getAction(this.key)) != null) {
                action.actionPerformed(actionEvent);
                return;
            }
            this.defaultAction(actionEvent);
        }

        protected void defaultAction(ActionEvent actionEvent) {
        }
    }

    private class FindAction
    extends GeneralMenuAction {
        FindAction(String string) {
            super(string, Messages.getString("Action.find_replace"), KeyStroke.getKeyStroke(70, UIUtility.MENU_KEY_MASK), null);
        }

        @Override
        protected void defaultAction(ActionEvent actionEvent) {
            Rflow.mainView().getSearchExplorer().requestFocusOnSearchField();
        }
    }

    private class SkinOptions
    extends LoggableAction {
        public SkinOptions() {
            this.putValue("Name", "Skin...");
        }

        @Override
        public void action(ActionEvent actionEvent) {
            SubstanceUI.getInstance().showSkinOptionsDialog();
        }
    }

    private class DevelSettingsAction
    extends LoggableAction {
        DevelSettingsAction() {
            this.putValue("Name", "Devel Settings...");
        }

        @Override
        public void action(ActionEvent actionEvent) {
            DevelSettings develSettings = Rflow.develSettings();
            DevelSettings develSettings2 = (DevelSettings)develSettings.copy();
            Component component = WidgetFactory.getInstance().create(develSettings2);
            Page page = new Page();
            page.add(component);
            PagesView pagesView = PagesViewFactory.createOkCancelView(page);
            pagesView.showDialog(Rflow.mainFrame(), "Devel Settings", true, null);
            if (pagesView.getResult() != 1) {
                return;
            }
            develSettings.putValues(develSettings2);
            try {
                develSettings.store();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
            develSettings.dispatchEvent();
        }
    }

    private class OpenRflowFile
    extends LoggableAction {
        private OpenRflowFile() {
        }

        @Override
        public void action(ActionEvent actionEvent) {
        }
    }

    private class NextTutorialAction
    extends TutorialAction {
        public NextTutorialAction(SampleEntry sampleEntry) {
            super(sampleEntry);
            this.putValue("Name", Messages.getString("Action.next_tutorial"));
            this.setEnabled(sampleEntry != null);
        }

        @Override
        public void action(ActionEvent actionEvent) {
            FileEditManager fileEditManager = FileEditManager.getInstance();
            FlowModel flowModel = RflowActions.this.getFlowModel();
            if (flowModel == null) {
                return;
            }
            fileEditManager.unload(flowModel, flowModel);
            super.action(actionEvent);
        }
    }

    private class TutorialSelectionAction
    extends TutorialAction {
        public TutorialSelectionAction(SampleEntry sampleEntry) {
            super(sampleEntry);
            this.putValue("Name", sampleEntry.getName());
        }
    }

    private abstract class TutorialAction
    extends LoggableAction {
        private SampleEntry entry;

        public TutorialAction(SampleEntry sampleEntry) {
            this.entry = sampleEntry;
            if (sampleEntry != null) {
                this.putValue("logparameter", sampleEntry.getPathToKey());
            }
        }

        @Override
        public void action(ActionEvent actionEvent) {
            RflowActions.this.openSampleFlow(this.entry);
        }
    }
}

