/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow;

import com.ef_prime.rflow.core.app.r.base.RSupport;
import com.ef_prime.rflow.core.base.FileResource;
import com.ef_prime.rflow.core.base.LocaleSettings;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.packages.RCRANMirrorsView;
import com.ef_prime.rflow.ui.base.RflowUI;
import com.ef_prime.rflow.ui.common.component.JTextFieldEx;
import com.ef_prime.rflow.ui.common.component.RflowTextField;
import com.ef_prime.rflow.ui.common.component.VerticalLayout;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetConstants;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.Page;
import com.ef_prime.rflow.ui.common.view.PagesView;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;

public class SettingsDialog
extends PagesView {
    private static final Logger LOGGER = Logger.getLogger(SettingsDialog.class.getName());
    private boolean initOnly;
    private Settings settings = null;
    private List<UpdateSettings> updateSettings = new ArrayList<UpdateSettings>();

    private SettingsDialog(Window window, Settings settings, boolean bl) {
        this.initOnly = bl;
        this.settings = (Settings)settings.copy();
        this.setPage(new SettingsPage());
    }

    @Override
    protected boolean viewWillClose(int n) {
        if (n == 1 && !this.update(this.settings)) {
            return false;
        }
        return super.viewWillClose(n);
    }

    private boolean update(Settings settings) {
        for (UpdateSettings updateSettings : this.updateSettings) {
            updateSettings.update(settings);
        }
        return true;
    }

    public Settings getSettings() {
        return this.getResult() == 1 ? this.settings : null;
    }

    public static Settings showSettingsDialog(Window window, Settings settings, boolean bl) {
        SettingsDialog settingsDialog = new SettingsDialog(window, settings, bl);
        settingsDialog.showDialog(window, Messages.getString("Action.preferences"), true, null);
        return settingsDialog.getSettings();
    }

    private static Settings configSettings(Settings settings, boolean bl) {
        JFrame jFrame = new JFrame(Messages.getString("Action.preferences"));
        jFrame.setIconImage(FileResource.getIcon("img/desktop_16.png").getImage());
        jFrame.setUndecorated(true);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
        Settings settings2 = SettingsDialog.showSettingsDialog(jFrame, settings, true);
        jFrame.dispose();
        if (settings2 != null) {
            try {
                settings2.putValue(Settings.IS_FIRST, false);
                settings2.save();
            }
            catch (Exception exception) {
                UIUtility.showErrorDialog(null, Messages.getString("Error.write_option"), exception);
            }
        }
        return settings2;
    }

    public static Settings showSettingsDialog(Settings settings, boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            return SettingsDialog.configSettings(settings, bl);
        }
        FutureTask<Settings> futureTask = new FutureTask<Settings>(() -> SettingsDialog.configSettings(settings, bl));
        SwingUtilities.invokeLater(futureTask);
        try {
            return futureTask.get();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to get settings.", exception);
            return settings;
        }
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> {
            LocaleSettings.initLocale();
            RflowUI.initLookAndFeel();
            Settings settings = new Settings();
            if (settings.fileExists()) {
                try {
                    settings.load();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, "Failed to load settings file.", iOException);
                    UIUtility.showErrorDialog(null, Messages.getString("Error.read_option"), iOException);
                }
            } else {
                settings.setUpDefaults();
            }
            SettingsDialog.configSettings(settings, true);
            RflowUI.exitFx();
        });
    }

    private class SettingsPage
    extends Page {
        public SettingsPage() {
            StartUpPanel startUpPanel = new StartUpPanel();
            SettingsDialog.this.updateSettings.add(startUpPanel);
            if (SettingsDialog.this.initOnly) {
                this.add((Component)startUpPanel, "Center");
            } else {
                GeneralPanel generalPanel = new GeneralPanel();
                SettingsDialog.this.updateSettings.add(generalPanel);
                AppearancePanel appearancePanel = new AppearancePanel();
                SettingsDialog.this.updateSettings.add(appearancePanel);
                OtherPanel otherPanel = new OtherPanel();
                SettingsDialog.this.updateSettings.add(otherPanel);
                JTabbedPane jTabbedPane = new JTabbedPane();
                jTabbedPane.add((Component)startUpPanel, Messages.getString("Setting.sect.core"));
                jTabbedPane.add((Component)generalPanel, Messages.getString("Setting.sect.general"));
                jTabbedPane.add((Component)appearancePanel, Messages.getString("Setting.appearance"));
                jTabbedPane.add((Component)otherPanel, Messages.getString("Setting.other"));
                this.add((Component)jTabbedPane, "Center");
            }
        }
    }

    private static interface UpdateSettings {
        public void update(Settings var1);
    }

    private class DialogButton
    extends JButton
    implements ActionListener {
        private String title;
        private Component content;

        public DialogButton(String string, Component component) {
            super(string + "...");
            this.title = string;
            this.content = component;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), this.content, this.title, -1);
        }
    }

    private class OtherPanel
    extends UpdateSettingsContainer {
        public OtherPanel() {
            this.setLayout(new VerticalLayout());
            this.add(new PackageOptionPanel());
            this.add(new EditorOptionPanel());
        }

        private class PackageOptionPanel
        extends JPanel
        implements UpdateSettings {
            private JCheckBox autoDetectPackages;
            private JCheckBox autoAttachCachedPackages;

            public PackageOptionPanel() {
                this.autoDetectPackages = new JCheckBox(Messages.getString("Setting.auto_detect_packages"), (boolean)SettingsDialog.this.settings.getValue(Settings.AUTO_DETECT_PACKAGES));
                this.autoAttachCachedPackages = new JCheckBox(Messages.getString("Setting.auto_attach_cached_packages"), (boolean)SettingsDialog.this.settings.getValue(Settings.AUTO_ATTACH_CACHED_PACKAGES));
                this.setBorder(new TitledBorder(Messages.getString("Setting.package_option")));
                this.setLayout(new VerticalLayout());
                this.add(this.autoDetectPackages);
                this.add(this.autoAttachCachedPackages);
            }

            @Override
            public void update(Settings settings) {
                settings.putValue(Settings.AUTO_DETECT_PACKAGES, this.autoDetectPackages.isSelected());
                settings.putValue(Settings.AUTO_ATTACH_CACHED_PACKAGES, this.autoAttachCachedPackages.isSelected());
            }
        }

        private class EditorOptionPanel
        extends JPanel
        implements UpdateSettings {
            private JTable table;
            private static final int COLUMN_NAME = 0;
            private static final int COLUMN_PATH = 1;
            private final String[] COLUMN_NAMES = new String[]{Messages.getString("Message.name"), Messages.getString("Message.path")};

            EditorOptionPanel() {
                Object object;
                Object object2;
                this.setBorder(new TitledBorder(Messages.getString("Setting.external_editor") + " (" + Messages.getString("Setting.deprecated") + ")"));
                JLabel jLabel = new JLabel(Messages.getString("Setting.external_editor_description"));
                DefaultTableModel defaultTableModel = new DefaultTableModel(this.COLUMN_NAMES, 0){

                    @Override
                    public boolean isCellEditable(int n, int n2) {
                        return true;
                    }
                };
                List list = (List)((Object)SettingsDialog.this.settings.getValue(Settings.EDITORS));
                int n = 0;
                while (n + 1 < list.size()) {
                    object2 = (String)list.get(n);
                    object = (String)list.get(n + 1);
                    defaultTableModel.addRow(new String[]{object2, object});
                    n += 2;
                }
                this.table = new JTable(defaultTableModel){

                    @Override
                    public String getToolTipText(MouseEvent mouseEvent) {
                        int n = this.rowAtPoint(mouseEvent.getPoint());
                        int n2 = this.columnAtPoint(mouseEvent.getPoint());
                        if (n >= 0 && n2 == 1) {
                            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
                            return (String)defaultTableModel.getValueAt(n, 1);
                        }
                        return null;
                    }
                };
                this.table.setCellSelectionEnabled(true);
                n = this.table.getFontMetrics(this.table.getFont()).getHeight();
                this.table.setRowHeight(n + 2);
                this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
                this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
                object2 = new JScrollPane(this.table);
                object = new JButton(Messages.getString("Button.add"));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser jFileChooser = new JFileChooser();
                        if (jFileChooser.showOpenDialog(EditorOptionPanel.this) != 0) {
                            return;
                        }
                        File file = jFileChooser.getSelectedFile();
                        Object object = FilenameUtils.separatorsToUnix((String)file.getAbsolutePath());
                        if (((String)object).contains(" ")) {
                            object = "\"" + (String)object + "\"";
                        }
                        DefaultTableModel defaultTableModel = (DefaultTableModel)EditorOptionPanel.this.table.getModel();
                        defaultTableModel.addRow(new String[]{FilenameUtils.removeExtension((String)file.getName()), object});
                    }
                });
                JButton jButton = new JButton(Messages.getString("Button.remove"));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int[] nArray = EditorOptionPanel.this.table.getSelectedRows();
                        if (nArray.length > 0) {
                            DefaultTableModel defaultTableModel = (DefaultTableModel)EditorOptionPanel.this.table.getModel();
                            for (int i = nArray.length - 1; i >= 0; --i) {
                                defaultTableModel.removeRow(nArray[i]);
                            }
                        }
                    }
                });
                JButton jButton2 = new JButton(Messages.getString("Button.up"));
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int[] nArray = EditorOptionPanel.this.table.getSelectedRows();
                        if (nArray.length > 0 && nArray[0] != 0) {
                            EditorOptionPanel.this.table.clearSelection();
                            DefaultTableModel defaultTableModel = (DefaultTableModel)EditorOptionPanel.this.table.getModel();
                            for (int i = 0; i < nArray.length; ++i) {
                                defaultTableModel.moveRow(nArray[i], nArray[i], nArray[i] - 1);
                                EditorOptionPanel.this.table.addRowSelectionInterval(nArray[i] - 1, nArray[i] - 1);
                            }
                        }
                    }
                });
                JButton jButton3 = new JButton(Messages.getString("Button.down"));
                jButton3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int[] nArray = EditorOptionPanel.this.table.getSelectedRows();
                        if (nArray.length > 0 && nArray[nArray.length - 1] != EditorOptionPanel.this.table.getRowCount() - 1) {
                            EditorOptionPanel.this.table.clearSelection();
                            DefaultTableModel defaultTableModel = (DefaultTableModel)EditorOptionPanel.this.table.getModel();
                            for (int i = nArray.length - 1; i >= 0; --i) {
                                defaultTableModel.moveRow(nArray[i], nArray[i], nArray[i] + 1);
                                EditorOptionPanel.this.table.addRowSelectionInterval(nArray[i] + 1, nArray[i] + 1);
                            }
                        }
                    }
                });
                UIUtility.setHeight(25, new Component[]{object, jButton, jButton2, jButton3});
                UIUtility.setWidth(100, new Component[]{object, jButton, jButton2, jButton3});
                Box box = UIUtility.createVerticalBox(object, jButton, jButton2, jButton3, -1);
                int n2 = 1 + this.table.getRowHeight() * 5 + this.table.getTableHeader().getPreferredSize().height;
                this.setLayout((LayoutManager)new MigLayout());
                this.add((Component)jLabel, "wrap");
                this.add((Component)object2, "height " + n2);
                this.add((Component)box, "aligny top");
            }

            @Override
            public void update(Settings settings) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < this.table.getRowCount(); ++i) {
                    String string = (String)this.table.getValueAt(i, 0);
                    String string2 = (String)this.table.getValueAt(i, 1);
                    arrayList.add(string);
                    arrayList.add(string2);
                }
                settings.putValue(Settings.EDITORS, arrayList);
            }
        }
    }

    private class AppearancePanel
    extends UpdateSettingsContainer {
        public AppearancePanel() {
            this.setLayout(new VerticalLayout());
            this.add(new FileTabOptionPanel());
            this.add(new FontOptionPanel());
            this.add(new ToolBarOptionPanel());
            this.add(new EditorOptionPanel());
        }

        private class FileTabOptionPanel
        extends JPanel
        implements UpdateSettings {
            private JCheckBox showHiddenFiles;

            public FileTabOptionPanel() {
                this.showHiddenFiles = new JCheckBox(Messages.getString("Setting.show_hidden_files"), (boolean)SettingsDialog.this.settings.getValue(Settings.SHOW_HIDDEN_FILES));
                this.setBorder(new TitledBorder(Messages.getString("Setting.file_tree_view")));
                this.setLayout((LayoutManager)new MigLayout());
                this.add(this.showHiddenFiles);
            }

            @Override
            public void update(Settings settings) {
                settings.putValue(Settings.SHOW_HIDDEN_FILES, this.showHiddenFiles.isSelected());
            }
        }

        private class FontOptionPanel
        extends JPanel
        implements UpdateSettings {
            private JSpinner basicFontSize;
            private JSpinner codeFontSize;
            private JSpinner dataFontSize;
            private JSpinner helpFontSize;

            public FontOptionPanel() {
                this.basicFontSize = this.createFontSizeSpinner(Float.valueOf(SettingsDialog.this.settings.getValue(Settings.BASIC_FONT_SIZE).floatValue()));
                this.codeFontSize = this.createFontSizeSpinner(Float.valueOf(SettingsDialog.this.settings.getValue(Settings.CODE_FONT_SIZE).floatValue()));
                this.dataFontSize = this.createFontSizeSpinner(Float.valueOf(SettingsDialog.this.settings.getValue(Settings.DATA_FONT_SIZE).floatValue()));
                this.helpFontSize = this.createFontScaleSpinner(Float.valueOf(SettingsDialog.this.settings.getValue(Settings.HELP_FONT_SCALE).floatValue()));
                this.setBorder(new TitledBorder(Messages.getString("Setting.font")));
                this.setLayout((LayoutManager)new MigLayout());
                CC cC = new CC().split(2);
                CC cC2 = new CC().wrap();
                this.add(new JLabel(Messages.getString("Setting.basic_font_size")));
                this.add((Component)this.basicFontSize, cC);
                this.add((Component)new JLabel("pt"), cC2);
                this.add(new JLabel(Messages.getString("Setting.editor_font_size")));
                this.add((Component)this.codeFontSize, cC);
                this.add((Component)new JLabel("pt"), cC2);
                this.add(new JLabel(Messages.getString("Setting.data_font_size")));
                this.add((Component)this.dataFontSize, cC);
                this.add((Component)new JLabel("pt"), cC2);
                this.add(new JLabel(Messages.getString("Setting.help_font_size")));
                this.add((Component)this.helpFontSize, cC);
                this.add(new JLabel("%"));
            }

            private JSpinner createFontSizeSpinner(Float f) {
                SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(f.intValue(), 8, 72, 1);
                JSpinner jSpinner = new JSpinner(spinnerNumberModel);
                return jSpinner;
            }

            private JSpinner createFontScaleSpinner(Float f) {
                int n = (int)(f.floatValue() * 100.0f);
                SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, 1, 990, 10);
                JSpinner jSpinner = new JSpinner(spinnerNumberModel);
                return jSpinner;
            }

            @Override
            public void update(Settings settings) {
                settings.putValue(Settings.BASIC_FONT_SIZE, ((Number)this.basicFontSize.getValue()).doubleValue());
                settings.putValue(Settings.CODE_FONT_SIZE, ((Number)this.codeFontSize.getValue()).doubleValue());
                settings.putValue(Settings.DATA_FONT_SIZE, ((Number)this.dataFontSize.getValue()).doubleValue());
                settings.putValue(Settings.HELP_FONT_SCALE, ((Number)this.helpFontSize.getValue()).doubleValue() / 100.0);
            }
        }

        private class ToolBarOptionPanel
        extends JPanel
        implements UpdateSettings {
            private JComboBox<Integer> location = new JComboBox<Integer>(new Integer[]{0, 3});
            private JCheckBox smallIcon;
            private JCheckBox hideLabel;

            public ToolBarOptionPanel() {
                this.location.setRenderer((ListCellRenderer<Integer>)((Object)new LocationRenderer()));
                this.location.setSelectedItem(SettingsDialog.this.settings.getValue(Settings.TOOLBAR_LOCATION));
                this.smallIcon = new JCheckBox(Messages.getString("Setting.toolbar.small_icon"), (boolean)SettingsDialog.this.settings.getValue(Settings.TOOLBAR_SMALL_ICON));
                this.hideLabel = new JCheckBox(Messages.getString("Setting.toolbar.hide_label"), (boolean)SettingsDialog.this.settings.getValue(Settings.TOOLBAR_HIDE_LABEL));
                this.setBorder(new TitledBorder(Messages.getString("Setting.toolbar.title")));
                this.setLayout((LayoutManager)new MigLayout());
                this.add(new JLabel(Messages.getString("Setting.toolbar.location")));
                this.add(this.location, new CC().wrap());
                this.add((Component)this.smallIcon, new CC().wrap().spanX(2));
                this.add((Component)this.hideLabel, new CC().spanX(2));
            }

            @Override
            public void update(Settings settings) {
                settings.putValue(Settings.TOOLBAR_LOCATION, (Integer)this.location.getSelectedItem());
                settings.putValue(Settings.TOOLBAR_SMALL_ICON, this.smallIcon.isSelected());
                settings.putValue(Settings.TOOLBAR_HIDE_LABEL, this.hideLabel.isSelected());
            }

            private class LocationRenderer
            extends SubstanceDefaultListCellRenderer {
                private LocationRenderer() {
                }

                public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent(jList, object, n, bl, bl2);
                    Integer n2 = (Integer)object;
                    String string = "";
                    switch (n2) {
                        case 1: {
                            string = "Right";
                            break;
                        }
                        case 3: {
                            string = Messages.getString("Setting.toolbar.location.left");
                            break;
                        }
                        case 2: {
                            string = "Bottom";
                            break;
                        }
                        default: {
                            string = Messages.getString("Setting.toolbar.location.top");
                        }
                    }
                    this.setText(string);
                    return this;
                }
            }
        }

        private class EditorOptionPanel
        extends JPanel
        implements UpdateSettings {
            public EditorOptionPanel() {
                this.setBorder(new CompoundBorder(new TitledBorder(Messages.getString("Setting.r_editor")), new EmptyBorder(5, 5, 5, 5)));
                this.setLayout(new BorderLayout());
                Component component = WidgetFactory.getInstance().create(SettingsDialog.this.settings, PanelWidgetNode.noScroll().addElements(Settings.R_CODE_PARENS_AND_QUOTES, Settings.R_CODE_AUTO_INDENT));
                this.add(component);
            }

            @Override
            public void update(Settings settings) {
            }
        }
    }

    private class GeneralPanel
    extends UpdateSettingsContainer {
        GeneralPanel() {
            this.setLayout(new VerticalLayout());
            this.add(new WorkDirOptionPanel());
            this.add(new OpenModePanel());
            this.add(new TabOptionPanel());
            this.add(new ConsoleOptionPanel());
        }

        private class WorkDirOptionPanel
        extends JPanel
        implements UpdateSettings {
            private JTextField dirField;

            WorkDirOptionPanel() {
                this.setBorder(new TitledBorder(Messages.getString("Setting.default_project_location")));
                this.dirField = new RflowTextField(SettingsDialog.this.settings.getValue(Settings.DEFAULT_WORKING_DIRECTORY));
                this.dirField.setEditable(false);
                JButton jButton = new JButton(new AbstractAction("..."){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        File file = UIUtility.chooseDirFx(SwingUtilities.windowForComponent(WorkDirOptionPanel.this), new File(WorkDirOptionPanel.this.dirField.getText()));
                        if (file == null) {
                            return;
                        }
                        WorkDirOptionPanel.this.dirField.setText(file.getAbsolutePath());
                    }
                });
                this.setLayout((LayoutManager)new MigLayout("fillx"));
                this.add((Component)this.dirField, "growx");
                this.add(jButton);
            }

            @Override
            public void update(Settings settings) {
                if (this.dirField.getText().equals("")) {
                    settings.putValue(Settings.DEFAULT_WORKING_DIRECTORY, "");
                } else {
                    File file = new File(this.dirField.getText());
                    settings.putValue(Settings.DEFAULT_WORKING_DIRECTORY, file.getAbsolutePath());
                }
            }
        }

        private class OpenModePanel
        extends JPanel
        implements UpdateSettings {
            public OpenModePanel() {
                this.setBorder(new CompoundBorder(new TitledBorder(Settings.NODE_OPEN_MODE.getTitle()), new EmptyBorder(5, 5, 5, 5)));
                this.setLayout(new BorderLayout());
                JLabel jLabel = new JLabel(Messages.getString("Setting.OpenMode.description"));
                Component component = WidgetFactory.getInstance().create(SettingsDialog.this.settings, PanelWidgetNode.noScroll().addElements(Settings.NODE_OPEN_MODE));
                this.add((Component)jLabel, "North");
                this.add(component, "Center");
            }

            @Override
            public void update(Settings settings) {
            }
        }

        private class TabOptionPanel
        extends JPanel
        implements UpdateSettings {
            private List<JCheckBox> checkBoxes;
            private String[] tabs = new String[]{"TAB_BREAKPOINT", Messages.getString("Explorer.breakpoint"), "TAB_TASK", Messages.getString("Explorer.task")};

            public TabOptionPanel() {
                Object object;
                this.setBorder(new TitledBorder(Messages.getString("Setting.view")));
                JLabel jLabel = new JLabel(Messages.getString("Setting.view_description"));
                JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
                this.checkBoxes = new ArrayList<JCheckBox>();
                List list = (List)((Object)SettingsDialog.this.settings.getValue(Settings.INVISIBLE_TABS));
                for (int i = 0; i < this.tabs.length; i += 2) {
                    object = this.tabs[i];
                    String string = this.tabs[i + 1];
                    JCheckBox jCheckBox = new JCheckBox(string, !list.contains(object));
                    jPanel.add(jCheckBox);
                    this.checkBoxes.add(jCheckBox);
                }
                Component component = WidgetFactory.getInstance().create(SettingsDialog.this.settings, PanelWidgetNode.noScroll().addElements(Settings.AUTO_SELECT_ITEM));
                object = WidgetFactory.getInstance().create(SettingsDialog.this.settings, PanelWidgetNode.noScroll().addElements(Settings.USE_RFLOW_VIEW));
                this.setLayout((LayoutManager)new MigLayout());
                this.add(component, new CC().wrap());
                this.add((Component)object, new CC().wrap());
                this.add((Component)jLabel, new CC().wrap());
                this.add((Component)jPanel, new CC().gapLeft("20px"));
            }

            @Override
            public void update(Settings settings) {
                ArrayList<String> arrayList = new ArrayList<String>(4);
                for (int i = 0; i < this.checkBoxes.size(); ++i) {
                    JCheckBox jCheckBox = this.checkBoxes.get(i);
                    if (jCheckBox.isSelected()) continue;
                    arrayList.add(this.tabs[i * 2]);
                }
                settings.putValue(Settings.INVISIBLE_TABS, arrayList);
            }
        }

        private class ConsoleOptionPanel
        extends JPanel
        implements UpdateSettings {
            private JComboBox<String> projectRRestart;
            private ConsoleAdvancedOptionPanel advancedOptionPanel;

            public ConsoleOptionPanel() {
                this.setBorder(new TitledBorder(Messages.getString("Setting.console")));
                this.projectRRestart = new JComboBox<String>(new String[]{"yes", "no", "ask"});
                this.projectRRestart.setSelectedItem(SettingsDialog.this.settings.getValue(Settings.PROJECT_R_RESTART));
                this.projectRRestart.setRenderer((ListCellRenderer<String>)((Object)new RestartRenderer()));
                this.advancedOptionPanel = new ConsoleAdvancedOptionPanel();
                this.setLayout((LayoutManager)new MigLayout());
                this.add(new JLabel(Messages.getString("Setting.restart_r")));
                this.add(this.projectRRestart, new CC().wrap());
                this.add((Component)new DialogButton(Messages.getString("Setting.advanced"), this.advancedOptionPanel), new CC().span(new int[]{2}));
            }

            @Override
            public void update(Settings settings) {
                settings.putValue(Settings.PROJECT_R_RESTART, this.projectRRestart.getSelectedItem().toString());
                this.advancedOptionPanel.update(settings);
            }

            private class RestartRenderer
            extends SubstanceDefaultListCellRenderer {
                private RestartRenderer() {
                }

                public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent(jList, object, n, bl, bl2);
                    String string = (String)object;
                    if (string != null) {
                        switch (string) {
                            case "yes": {
                                string = Messages.getString("Message.always");
                                break;
                            }
                            case "no": {
                                string = Messages.getString("Message.never");
                                break;
                            }
                            case "ask": {
                                string = Messages.getString("Message.ask_every_time");
                            }
                        }
                        this.setText(string);
                    }
                    return this;
                }
            }
        }

        private class ConsoleAdvancedOptionPanel
        extends JPanel
        implements UpdateSettings {
            private JCheckBox useBuffer;
            private JSpinner maxChars;

            ConsoleAdvancedOptionPanel() {
                this.useBuffer = new JCheckBox(Messages.getString("Setting.use_buffer"), (boolean)SettingsDialog.this.settings.getValue(Settings.USE_CONSOLE_BUFFER));
                this.maxChars = new JSpinner(new SpinnerNumberModel(SettingsDialog.this.settings.getValue(Settings.CONSOLE_MAX_CHARS), 1000, Integer.MAX_VALUE, 1));
                JPanel jPanel = new JPanel(new FlowLayout(0));
                jPanel.add(new JLabel(Messages.getString("Setting.console_max_chars")));
                jPanel.add(this.maxChars);
                this.setLayout((LayoutManager)new MigLayout());
                this.add((Component)jPanel, "wrap");
                this.add(UIUtility.createHorizontalBox(this.useBuffer, -1));
            }

            @Override
            public void update(Settings settings) {
                settings.putValue(Settings.USE_CONSOLE_BUFFER, this.useBuffer.isSelected());
                settings.putValue(Settings.CONSOLE_MAX_CHARS, this.maxChars.getValue());
            }
        }
    }

    private class StartUpPanel
    extends UpdateSettingsContainer {
        StartUpPanel() {
            this.setLayout(new VerticalLayout());
            this.add(new ROptionPanel());
            this.add(new LanguageOptionPanel());
            this.add(new UpdateOptionPanel());
            if (!SettingsDialog.this.initOnly) {
                JLabel jLabel = new JLabel(Messages.getString("Setting.valid_after_restart"));
                Box box = Box.createHorizontalBox();
                box.add(Box.createHorizontalGlue());
                box.add(jLabel);
                this.add(Box.createVerticalStrut(10));
                this.add(box);
            }
        }

        private class ROptionPanel
        extends JPanel
        implements UpdateSettings {
            private RHomeOptionPanel baseOptionPanel;
            private ArgOptionPanel argOptionPanel;
            private JTextFieldEx cranMirror;
            private String cran_mirror_unselected = Messages.getString("Setting.cran_mirror_unselected");

            public ROptionPanel() {
                this.setBorder(new TitledBorder(Messages.getString("Setting.r_prop")));
                this.setLayout((LayoutManager)new MigLayout(new LC().fillX()));
                if (Platform.isWindowsFamily()) {
                    this.baseOptionPanel = new RHomeOptionPanel();
                    this.add((Component)this.baseOptionPanel, "wrap, growx");
                }
                String string = SettingsDialog.this.settings.getValue(Settings.CRAN_MIRROR);
                this.cranMirror = new JTextFieldEx(string);
                this.cranMirror.setEmptyMessage(this.cran_mirror_unselected);
                this.cranMirror.setEmptyMessageColor(WidgetConstants.AUTO_FONT_COLOR);
                JButton jButton = new JButton("...");
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = ROptionPanel.this.baseOptionPanel != null ? ROptionPanel.this.baseOptionPanel.getRHome() : System.getProperty("R_HOME");
                        RCRANMirrorsView rCRANMirrorsView = new RCRANMirrorsView(ROptionPanel.this.cranMirror.getText(), string);
                        rCRANMirrorsView.setPreferredSize(new Dimension(600, 600));
                        int n = JOptionPane.showConfirmDialog(ROptionPanel.this, rCRANMirrorsView, rCRANMirrorsView.getTitle(), 2, -1);
                        if (n == 2) {
                            return;
                        }
                        String string2 = rCRANMirrorsView.getSelectedUrl();
                        if (string2 != null) {
                            ROptionPanel.this.cranMirror.setText(string2);
                        }
                    }
                });
                this.add((Component)new JLabel(Messages.getString("Setting.cran_mirror_description")), "wrap");
                this.add((Component)this.cranMirror, "growx, split 2");
                this.add((Component)jButton, new CC().maxWidth("30").wrap());
                JPanel jPanel = new JPanel((LayoutManager)new MigLayout(new LC().insetsAll("0")));
                this.argOptionPanel = new ArgOptionPanel();
                jPanel.add((Component)this.argOptionPanel, "wrap");
                this.add(new DialogButton(Messages.getString("Setting.r_startup_options"), jPanel));
            }

            @Override
            public void update(Settings settings) {
                if (this.baseOptionPanel != null) {
                    this.baseOptionPanel.update(settings);
                }
                this.argOptionPanel.update(settings);
                if (this.cranMirror != null) {
                    String string = this.cranMirror.getText();
                    settings.putValue(Settings.CRAN_MIRROR, string);
                }
            }
        }

        private class LanguageOptionPanel
        extends JPanel
        implements UpdateSettings {
            private JComboBox<Object> language;

            public LanguageOptionPanel() {
                this.setBorder(new TitledBorder(Messages.getString("Setting.language")));
                Locale[] localeArray = Messages.getLocales();
                Locale[] localeArray2 = new Locale[localeArray.length + 1];
                localeArray2[0] = null;
                for (int i = 1; i < localeArray2.length; ++i) {
                    localeArray2[i] = localeArray[i - 1];
                }
                this.language = new JComboBox<Locale>(localeArray2);
                this.language.setRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                        super.getListCellRendererComponent(jList, object, n, bl, bl2);
                        Locale locale = (Locale)object;
                        if (locale == null) {
                            this.setText(Messages.getString("Setting.lang_system"));
                        } else {
                            this.setText(locale.getDisplayLanguage());
                        }
                        return this;
                    }
                });
                String string = SettingsDialog.this.settings.getValue(Settings.LANGUAGE);
                this.language.setSelectedItem(string.equals("system") ? null : new Locale(string));
                this.setLayout((LayoutManager)new MigLayout());
                this.add(this.language, "w pref+30");
            }

            @Override
            public void update(Settings settings) {
                Locale locale = (Locale)this.language.getSelectedItem();
                settings.putValue(Settings.LANGUAGE, locale == null ? "system" : locale.getLanguage());
            }
        }

        private class UpdateOptionPanel
        extends JPanel
        implements UpdateSettings {
            private JCheckBox checkUpdate;

            UpdateOptionPanel() {
                this.setBorder(new TitledBorder(Messages.getString("Setting.communication")));
                this.checkUpdate = new JCheckBox(Messages.getString("Setting.check_update"), (boolean)SettingsDialog.this.settings.getValue(Settings.IS_AUTO_UPDATE));
                this.setLayout((LayoutManager)new MigLayout());
                this.add(this.checkUpdate);
            }

            @Override
            public void update(Settings settings) {
                settings.putValue(Settings.IS_AUTO_UPDATE, this.checkUpdate.isSelected());
            }
        }

        private class ArgOptionPanel
        extends JPanel
        implements UpdateSettings {
            private JTextField args;

            ArgOptionPanel() {
                this.setBorder(new TitledBorder(Messages.getString("Setting.r_startup_options")));
                this.args = new RflowTextField(SettingsDialog.this.settings.getValue(Settings.R_OPTIONS));
                JButton jButton = new JButton(Messages.getString("Button.restore_default"));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ArgOptionPanel.this.args.setText((String)Settings.R_OPTIONS.getDefaultValue());
                    }
                });
                this.setLayout((LayoutManager)new MigLayout());
                this.add((Component)this.args, "w 400");
                this.add(jButton);
            }

            @Override
            public void update(Settings settings) {
                settings.putValue(Settings.R_OPTIONS, this.args.getText().trim());
            }
        }

        private class RHomeOptionPanel
        extends JPanel
        implements UpdateSettings,
        ItemListener {
            private JCheckBox autoRHome;
            private JLabel warningLabel = new JLabel(FileResource.getIcon("img/warning_16.png"));
            private JTextField dirField;
            private JButton refButton;

            RHomeOptionPanel() {
                String string = SettingsDialog.this.settings.getValue(Settings.R_HOME);
                this.autoRHome = new JCheckBox(Messages.getString("Setting.auto_detect"), string.isEmpty());
                this.autoRHome.addItemListener(this);
                this.dirField = new RflowTextField(string);
                this.dirField.setEditable(false);
                this.refButton = new JButton(new AbstractAction("..."){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        File file = UIUtility.chooseDirFx(SwingUtilities.windowForComponent(RHomeOptionPanel.this), new File(RHomeOptionPanel.this.dirField.getText()));
                        if (file == null) {
                            return;
                        }
                        if (!RHomeOptionPanel.this.rExists(file.getAbsolutePath())) {
                            JOptionPane.showMessageDialog(RHomeOptionPanel.this, Messages.getString("Setting.R_Not_Found"));
                            this.actionPerformed(actionEvent);
                        } else {
                            RHomeOptionPanel.this.dirField.setText(file.getAbsolutePath());
                            RHomeOptionPanel.this.checkR();
                        }
                    }
                });
                JLabel jLabel = new JLabel(Messages.getString("Setting.r_home"));
                this.setLayout((LayoutManager)new MigLayout("fillx, insets 0"));
                this.add((Component)jLabel, "wrap");
                this.add((Component)this.autoRHome, "wrap");
                this.add((Component)this.warningLabel, "split 3, hidemode 1");
                this.add((Component)this.dirField, "growx");
                this.add((Component)this.refButton, new CC().maxWidth("30"));
                this.refreshRHomeComponents();
                this.checkR();
            }

            private boolean rExists(String string) {
                File file = new File(string);
                return RSupport.checkRExistsForWindows(file);
            }

            private void checkR() {
                Object object = null;
                boolean bl = false;
                boolean bl2 = this.rExists(this.dirField.getText());
                if (!bl2) {
                    bl = true;
                    object = Messages.getString("Setting.R_Not_Found");
                }
                if (bl2) {
                    try {
                        File file;
                        File file2 = new File(this.dirField.getText());
                        File file3 = RSupport.getRBinForWindows(file2);
                        String string = file3.getAbsolutePath() + File.separator + "R";
                        String string2 = RSupport.getRVersion(string);
                        RSupport.Rversion rversion = RSupport.Rversion.parse(string2);
                        RSupport.Rversion rversion2 = RSupport.getLibraryPackVersion(Utility.programDir(), rversion, null);
                        File file4 = file = rversion2 == null ? null : RSupport.getLibraryPackLocation(Utility.programDir(), rversion2);
                        if (file != null && file.exists()) {
                            if (!rversion.minorEquals(rversion2)) {
                                object = Messages.getString("Message.newer_r") + RSupport.getSupportedRVersions(Utility.programDir());
                                bl = true;
                            }
                        } else {
                            object = Messages.getString("Error.Main.unsupported_r") + RSupport.getSupportedRVersions(Utility.programDir());
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl) {
                    if (object != null) {
                        this.warningLabel.setToolTipText(UIUtility.convertToHTML((String)object));
                    }
                    this.warningLabel.setVisible(true);
                } else {
                    this.warningLabel.setToolTipText(null);
                    this.warningLabel.setVisible(false);
                }
            }

            @Override
            public void update(Settings settings) {
                if (this.autoRHome.isSelected()) {
                    settings.putValue(Settings.R_HOME, "");
                } else {
                    File file = new File(this.dirField.getText());
                    settings.putValue(Settings.R_HOME, file.getAbsolutePath());
                }
            }

            public String getRHome() {
                return this.dirField.getText();
            }

            private void refreshRHomeComponents() {
                boolean bl = this.autoRHome.isSelected();
                this.dirField.setEnabled(!bl);
                this.refButton.setEnabled(!bl);
                if (bl) {
                    File file = RSupport.findRForWindows();
                    this.dirField.setText(file == null ? "" : file.getAbsolutePath());
                    this.checkR();
                }
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                this.refreshRHomeComponents();
            }
        }
    }

    private class UpdateSettingsContainer
    extends JPanel
    implements UpdateSettings {
        private List<UpdateSettings> updateSettings = new ArrayList<UpdateSettings>();

        private UpdateSettingsContainer() {
        }

        @Override
        public Component add(Component component) {
            if (component instanceof UpdateSettings) {
                UpdateSettings updateSettings = (UpdateSettings)((Object)component);
                this.addUpdateSetting(updateSettings);
            }
            return super.add(component);
        }

        protected void addUpdateSetting(UpdateSettings updateSettings) {
            this.updateSettings.add(updateSettings);
        }

        @Override
        public void update(Settings settings) {
            for (UpdateSettings updateSettings : this.updateSettings) {
                updateSettings.update(settings);
            }
        }
    }
}

