/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.base;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RTextKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.PreviewFunction;
import com.ef_prime.rflow.resource.Messages;

public abstract class KeyModel
extends Operation {
    protected static final String PREVIEW_FUNC_HEAD = "head";
    protected static final String PREVIEW_FUNC_CUSTOM = "custom";
    protected static final String PREVIEW_FUNC_FIXED = "fixed";
    protected static final StrKey ID = StrKey.builder("id", "ID").build();
    protected static final StrKey ARGUMENT = StrKey.builder("id", Messages.getString("Node.builder.key.argument")).build();
    protected static final StrKey TITLE = StrKey.builder("title", Messages.getString("Node.builder.key.title")).build();
    protected static final StrKey TITLE_ARG = ((StrKey.Builder)StrKey.builder("title", Messages.getString("Node.builder.key.title")).setDynamicDefault(true)).build();
    protected static final BoolKey REQUIRED = BoolKey.builder("required", Messages.getString("Node.builder.key.required")).build();
    protected static final BoolKey ENABLE_PREVIEW_FUNCTION = ((BoolKey.Builder)BoolKey.builder("enable_preview", Messages.getString("Node.builder.key.change_on_preview")).setLabelPosition("none")).build();
    protected static final RadioButtonKey PREVIEW_FUNCTION = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("preview_func", Messages.getString("Node.builder.key.type")).setValuesAndLabels("head", "head(x, n)", "custom", Messages.getString("Node.builder.key.custom"), "fixed", Messages.getString("Node.builder.key.fixed"))).addVisibleKeyLink(ENABLE_PREVIEW_FUNCTION, true)).build();
    protected static final RTextKey CUSTOM_PREVIEW_FUNCTION = ((RTextKey.Builder)((RTextKey.Builder)RTextKey.builder("custom_preview_func", "").addVisibleKeyLink(PREVIEW_FUNCTION, "custom")).setDefaultValue("function(x, n) { head(x, n) }")).build();
    protected static final StrKey FIXED_PREVIEW_VALUE = ((StrKey.Builder)StrKey.builder("fixed_preview_value", "").addVisibleKeyLink(PREVIEW_FUNCTION, "fixed")).build();

    public abstract Key<?> getKey();

    @Override
    protected void initKeys() {
    }

    @Override
    public String getDefaultTitle() {
        return "Key";
    }

    @Override
    public String getSummary() {
        return this.getValue(ID);
    }

    @Override
    public void run(Task task, boolean bl) throws Exception {
    }

    public String toString() {
        return this.getSummary();
    }

    public String getKeyId() {
        return (String)this.getValue("id");
    }

    public void setKeyId(String string) {
        this.putValue(this.getKey("id"), string);
    }

    public String getKeyTitle() {
        return (String)this.getValueOrDefault(this.getKey("title"));
    }

    public void setKeyTitle(String string) {
        this.putValue(this.getKey("title"), string);
    }

    protected boolean isIdEmpty() {
        String string = this.getValue(ID);
        return string == null || string.isEmpty() || string.startsWith("_empty");
    }

    @Override
    public Object getDynamicDefaultValue(Key<?> key) {
        if (key == TITLE_ARG) {
            return this.isIdEmpty() ? "" : this.getValue(ARGUMENT);
        }
        return super.getDynamicDefaultValue(key);
    }

    protected WidgetNode createPreviewWidgetNode() {
        return new PanelWidgetNode().setNoScroll(true).addElements(ENABLE_PREVIEW_FUNCTION, new PanelWidgetNode().setIndent(true).setNoScroll(true).addElements(PREVIEW_FUNCTION, CUSTOM_PREVIEW_FUNCTION, FIXED_PREVIEW_VALUE));
    }

    protected PreviewFunction<String> getPreviewFunction() {
        if (!this.getValue(ENABLE_PREVIEW_FUNCTION).booleanValue()) {
            return null;
        }
        switch (this.getValue(PREVIEW_FUNCTION)) {
            case "custom": {
                final String string = this.getValue(CUSTOM_PREVIEW_FUNCTION);
                return new PreviewFunction<String>(){

                    @Override
                    public String apply(String string2, ValueMap valueMap, PreviewOption previewOption) {
                        return "(" + string + ")(" + RUtility.args("x", string2, "n", previewOption.getNumberString()) + ")";
                    }
                };
            }
            case "fixed": {
                final String string = this.getValue(FIXED_PREVIEW_VALUE);
                return new PreviewFunction<String>(){

                    @Override
                    public String apply(String string2, ValueMap valueMap, PreviewOption previewOption) {
                        return string;
                    }
                };
            }
        }
        return ROperation.DATA_PREVIEW;
    }
}

