/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelConnection
implements Closeable {
    public static final long FILE_SIZE_LIMIT = 0xA00000L;
    private File file;
    private File excelFile;
    private String sheetName;
    private Workbook workBook;

    public ExcelConnection(File file) throws IOException {
        this.file = file;
        if (!file.exists()) {
            this.excelFile = file.getParentFile();
            this.sheetName = file.getName();
        } else {
            this.excelFile = file;
            this.sheetName = null;
        }
        try (FileInputStream fileInputStream = new FileInputStream(this.excelFile);){
            this.workBook = WorkbookFactory.create((InputStream)fileInputStream);
        }
    }

    public Workbook getWorkBook() {
        return this.workBook;
    }

    public File getFile() {
        return this.file;
    }

    public File getExcelFile() {
        return this.excelFile;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public Sheet getSheet() {
        if (this.sheetName != null) {
            return this.workBook.getSheet(this.sheetName);
        }
        return this.workBook.getSheetAt(0);
    }

    public List<String> getSheetNames() {
        int n = this.workBook.getNumberOfSheets();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.workBook.getSheetName(i));
        }
        return arrayList;
    }

    @Override
    public void close() {
        this.workBook = null;
    }
}

