/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.file;

import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.google.common.net.MediaType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class FileInfo {
    public static final String TYPE = "TYPE";
    public static final String CONTAINER = "CONTAINER";
    public static final String RFLOW = "RFLOW";
    public static final String R = "R";
    public static final String ZIP_DIR = "ZIP_DIR";
    public static final String TEXT = MediaType.ANY_TEXT_TYPE.toString();
    public static final String ZIP = MediaType.ZIP.toString();
    public static final String GZIP = MediaType.GZIP.toString();
    public static final String PNG = MediaType.PNG.toString();
    public static final String JPEG = MediaType.JPEG.toString();
    public static final String EXCEL = MediaType.MICROSOFT_EXCEL.toString();
    private static final Map<String, String> EXTENSION_MAP = new HashMap<String, String>();
    private File file;
    private boolean isDirectory;
    private BasicFileAttributes attributes = null;
    private String ext;
    private Map<String, Object> map = new HashMap<String, Object>(4);
    private Boolean isText;
    private Object lastViewSelection;

    public FileInfo(File file) {
        this.file = file;
        this.refresh();
    }

    public FileInfo(File file, BasicFileAttributes basicFileAttributes) {
        this.file = file;
        if (basicFileAttributes != null) {
            this.attributes = basicFileAttributes;
            this.isDirectory = this.attributes.isDirectory();
            if (this.isDirectory) {
                this.ext = "";
            } else {
                this.ext = FilenameUtils.getExtension((String)file.getName()).toLowerCase();
                this.refreshType();
            }
        } else {
            this.refresh();
        }
    }

    public void refresh() {
        if (this.file != null) {
            try {
                this.attributes = Files.readAttributes(this.file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                this.isDirectory = this.attributes.isDirectory();
            }
            catch (IOException iOException) {
                this.isDirectory = this.file.isDirectory();
            }
            if (this.isDirectory) {
                this.ext = "";
            } else {
                this.ext = FilenameUtils.getExtension((String)this.file.getName()).toLowerCase();
                this.refreshType();
            }
        } else {
            this.ext = "";
        }
        this.isText = null;
        this.map.clear();
        this.lastViewSelection = null;
    }

    public File getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.attributes != null;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isHidden() {
        if (this.attributes instanceof DosFileAttributes) {
            return ((DosFileAttributes)this.attributes).isHidden();
        }
        return false;
    }

    public boolean isText() {
        if (this.file == null || this.isDirectory) {
            return false;
        }
        if (this.isText == null) {
            try {
                this.isText = this.detectText();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return this.isText;
    }

    private boolean detectText() throws IOException {
        if (this.file.length() == 0L && !this.isContainer(EXCEL) && !this.isContainer(ZIP)) {
            return true;
        }
        if (this.isZipDirectory()) {
            return false;
        }
        try (InputStream inputStream = FileUtility.createInputStream(this.file);){
            int n;
            byte[] byArray = new byte[512];
            int n2 = inputStream.read(byArray, 0, byArray.length);
            if (n2 <= 0) {
                boolean bl = false;
                return bl;
            }
            for (n = 0; n < n2; n += 1) {
                if (byArray[n] != 0) continue;
                boolean bl = false;
                return bl;
            }
            n = 1;
            return n != 0;
        }
    }

    public String getExtension() {
        return this.ext;
    }

    public boolean isExtension(String string) {
        return this.ext.equals(string.toLowerCase());
    }

    public boolean isExtensionAny(String ... stringArray) {
        for (String string : stringArray) {
            if (!this.isExtension(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isRflow() {
        return this.is(RFLOW);
    }

    public boolean isZip() {
        return this.is(ZIP);
    }

    public boolean isZipDirectory() {
        if (!this.isContainer(ZIP)) {
            return false;
        }
        Boolean bl = (Boolean)this.map.get(ZIP_DIR);
        if (bl == null) {
            try {
                bl = FileUtility.isZipDirectory(this.file);
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean is(String string) {
        if (string == null) {
            return this.getType() == null;
        }
        return string.equals(this.getType());
    }

    public boolean isContainer(String string) {
        if (string == null) {
            return this.getContainer() == null;
        }
        return string.equals(this.getContainer());
    }

    public String getType() {
        String string = (String)this.map.get(TYPE);
        if (string == null) {
            string = this.refreshType();
        }
        return string;
    }

    private String refreshType() {
        String string = EXTENSION_MAP.get(this.ext);
        this.map.put(TYPE, string);
        return string;
    }

    public String getContainer() {
        String string = (String)this.map.get(CONTAINER);
        if (string == null) {
            string = this.refreshContainer();
        }
        return string;
    }

    private String refreshContainer() {
        File file;
        if (this.file == null || this.file.exists()) {
            return null;
        }
        for (file = this.file; file != null && !file.exists(); file = file.getParentFile()) {
        }
        if (file == null) {
            return null;
        }
        String string = null;
        FileInfo fileInfo = FileInfos.getInstance().getFileInfo(file);
        if (fileInfo.is(EXCEL)) {
            string = EXCEL;
        } else if (fileInfo.isZip()) {
            string = ZIP;
        }
        if (string != null) {
            this.map.put(CONTAINER, string);
        }
        return string;
    }

    public void setLastViewSelection(Object object) {
        this.lastViewSelection = object;
    }

    public Object getLastViewSelection() {
        return this.lastViewSelection;
    }

    static {
        EXTENSION_MAP.put("rflow", RFLOW);
        EXTENSION_MAP.put("r", R);
        EXTENSION_MAP.put("txt", TEXT);
        EXTENSION_MAP.put("zip", ZIP);
        EXTENSION_MAP.put("gz", GZIP);
        EXTENSION_MAP.put("gzip", GZIP);
        EXTENSION_MAP.put("png", PNG);
        EXTENSION_MAP.put("jpeg", JPEG);
        EXTENSION_MAP.put("jpg", JPEG);
        EXTENSION_MAP.put("xls", EXCEL);
        EXTENSION_MAP.put("xlsx", EXCEL);
    }
}

