/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.file;

import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import java.io.File;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;

public class FileInfos {
    private static FileInfos instance;
    private static final FileInfo NULL_INFO;
    private Map<File, FileInfo> files = new HashMap<File, FileInfo>();

    public static FileInfos getInstance() {
        if (instance == null) {
            instance = new FileInfos();
        }
        return instance;
    }

    public synchronized FileInfo getFileInfo(File file) {
        if (file == null) {
            return NULL_INFO;
        }
        FileInfo fileInfo = this.files.get(file = WorkingDirectory.toAbsolutePath(file));
        if (fileInfo == null) {
            fileInfo = new FileInfo(file);
            this.files.put(file, fileInfo);
        }
        return fileInfo;
    }

    public synchronized FileInfo getFileInfo(File file, BasicFileAttributes basicFileAttributes) {
        if (file == null) {
            return NULL_INFO;
        }
        file = WorkingDirectory.toAbsolutePath(file);
        FileInfo fileInfo = new FileInfo(file, basicFileAttributes);
        this.files.put(file, fileInfo);
        return fileInfo;
    }

    public synchronized FileInfo refreshFileInfo(File file) {
        FileInfo fileInfo = this.getFileInfo(file);
        fileInfo.refresh();
        return fileInfo;
    }

    static {
        NULL_INFO = new FileInfo(null);
    }
}

