/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.file;

import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.SessionEntry;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.ui.view.ViewPosition;
import java.io.File;
import javax.swing.Icon;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileSessionEntry
extends SessionEntry {
    private String file;
    private boolean edit;
    private String encoding;
    private String newline;
    private String syntax;

    public static FileSessionEntry create(Project project, File file, Icon icon, boolean bl, ViewPosition viewPosition, boolean bl2, String string, String string2, String string3) {
        return new FileSessionEntry(project.toProjectAbstractPath(file), icon, bl, viewPosition, bl2, string, string2, string3);
    }

    public FileSessionEntry() {
    }

    private FileSessionEntry(String string, Icon icon, boolean bl, ViewPosition viewPosition, boolean bl2, String string2, String string3, String string4) {
        super(viewPosition, bl2, icon);
        this.file = string;
        this.edit = bl;
        this.encoding = string2;
        this.newline = string3;
        this.syntax = string4;
    }

    @Override
    public String getTitle() {
        return FilenameUtils.getName((String)this.file);
    }

    @Override
    public String getType() {
        return "file";
    }

    public String getFile(Project project) {
        return project.toProjectAbsolutePath(this.file);
    }

    public boolean isEdit() {
        return this.edit;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getNewline() {
        return this.newline;
    }

    public String getSyntax() {
        return this.syntax;
    }

    @Override
    public void storeToElement(XmlContext xmlContext, Document document, Element element) {
        super.storeToElement(xmlContext, document, element);
        if (this.file != null) {
            element.setAttribute("file", this.file);
        }
        element.setAttribute("edit", Boolean.toString(this.edit));
        if (this.encoding != null) {
            element.setAttribute("encoding", this.encoding);
        }
        if (this.newline != null) {
            element.setAttribute("newline", this.newline);
        }
        if (this.syntax != null) {
            element.setAttribute("syntax", this.syntax);
        }
    }

    @Override
    public void loadElement(Element element, XmlContext xmlContext) {
        super.loadElement(element, xmlContext);
        this.file = XmlUtility.getAttribute(element, "file", null);
        this.edit = Boolean.parseBoolean(XmlUtility.getAttribute(element, "edit", "false"));
        this.encoding = XmlUtility.getAttribute(element, "encoding", null);
        this.newline = XmlUtility.getAttribute(element, "newline", null);
        this.syntax = XmlUtility.getAttribute(element, "syntax", null);
    }
}

