/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.file;

import com.ef_prime.rflow.core.app.file.ZipFileUtility;
import com.ef_prime.rflow.core.app.file.ZipInfo;
import com.ef_prime.rflow.core.base.FileManager;
import com.ef_prime.rflow.core.common.util.Archive;
import com.ef_prime.rflow.core.common.util.ZipFileInputStreamWrapper;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.ui.common.component.SaveToFile;
import com.ef_prime.rflow.ui.common.item.ItemEvent;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.mozilla.universalchardet.UniversalDetector;

public class FileUtility {
    public static final Comparator<File> NAME_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            if (file.isDirectory() ^ file2.isDirectory()) {
                return file.isDirectory() ? -1 : 1;
            }
            return file.getName().compareToIgnoreCase(file2.getName());
        }
    };

    public static File makeAbstractPath(File file, File file2) {
        if (file == null) {
            return file2;
        }
        if (file.equals(file2)) {
            return new File("");
        }
        String string = file.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        File file3 = file2;
        if (FileUtility.isChild(file, file2)) {
            file3 = new File(string2.substring(string.length() + 1, string2.length()));
        }
        return file3;
    }

    public static boolean isChild(File file, File file2) {
        String string = file.getAbsolutePath().toLowerCase();
        String string2 = file2.getAbsolutePath().toLowerCase();
        if (!string2.startsWith(string)) {
            return false;
        }
        File file3 = file2;
        while (file3.getParentFile() != null) {
            if (file.equals(file3)) {
                return true;
            }
            file3 = file3.getParentFile();
        }
        return false;
    }

    public static File getUniqueNumberFile(File file, String string, String string2, int n, boolean bl) {
        return FileUtility.getUniqueNumberFile(file, string, "", string2, n, bl);
    }

    public static File getUniqueNumberFile(File file, String string, String string2, String string3, int n, boolean bl) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        Object object = "";
        for (int i = 0; i < n; ++i) {
            object = (String)object + "0";
        }
        DecimalFormat decimalFormat = new DecimalFormat((String)object);
        int n2 = 1;
        String string4 = bl ? "" : string2 + decimalFormat.format(n2++);
        File file2 = new File(file, string + string4 + string3);
        while (file2.exists() && n2 < 100000) {
            file2 = new File(file, string + string2 + decimalFormat.format(n2++) + string3);
        }
        if (file2.exists()) {
            throw new RuntimeException("Failed to find unique name file");
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void safeSave(Path path, Path path2, SaveToFile saveToFile) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && !Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException("'saveTo' must be file");
        }
        if (Files.exists(path2, new LinkOption[0]) && !Files.isDirectory(path2, new LinkOption[0])) {
            throw new IllegalArgumentException("'tempDir' must be directory");
        }
        boolean bl = false;
        FileManager fileManager = FileManager.getInstance();
        Path path3 = path.getParent();
        fileManager.ignorePath(path3, true);
        fileManager.ignorePath(path2, true);
        try {
            Files.createDirectories(path2, new FileAttribute[0]);
            Path path4 = Files.createTempFile(path2, path.getFileName().toString(), ".tmp", new FileAttribute[0]);
            try {
                saveToFile.save(path4);
            }
            catch (Exception exception) {
                try {
                    Files.deleteIfExists(path4);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw exception;
            }
            if (Files.exists(path, new LinkOption[0])) {
                bl = true;
                Path path5 = Files.createTempFile(path.getParent(), path.getFileName().toString(), ".tmp", new FileAttribute[0]);
                Files.move(path, path5, StandardCopyOption.REPLACE_EXISTING);
                Files.move(path4, path, new CopyOption[0]);
                FileUtility.deleteQuietly(path5);
            } else {
                Files.move(path4, path, new CopyOption[0]);
            }
            fileManager.dispatchItemEvent(new ItemEvent(fileManager, bl ? 0 : 2, FileManager.pathToString(path)));
            fileManager.ignorePath(path2, false);
            fileManager.ignorePath(path3, false);
        }
        catch (Throwable throwable) {
            fileManager.dispatchItemEvent(new ItemEvent(fileManager, bl ? 0 : 2, FileManager.pathToString(path)));
            fileManager.ignorePath(path2, false);
            fileManager.ignorePath(path3, false);
            throw throwable;
        }
    }

    public static void deleteQuietly(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void moveDirectoryContents(File file, File file2) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file3 : fileArray) {
            File file4;
            if (file3.isDirectory()) {
                file4 = new File(file2, file3.getName());
                if (file4.exists()) {
                    if (file4.isDirectory()) {
                        FileUtility.moveDirectoryContents(file3, file4);
                        continue;
                    }
                    throw new IOException("Failed to move directory contents. Collision of same name directory and file.");
                }
                FileUtils.moveDirectoryToDirectory((File)file3, (File)file2, (boolean)true);
                continue;
            }
            file4 = new File(file2, file3.getName());
            if (file4.exists()) {
                if (file4.isFile()) {
                    FileUtils.forceDelete((File)file4);
                } else {
                    throw new IOException("Failed to move directory contents. Collision of same name directory and file.");
                }
            }
            FileUtils.moveFileToDirectory((File)file3, (File)file2, (boolean)true);
        }
    }

    public static void removeDirectoryIfEmpty(File file) {
        try {
            if (file.isDirectory()) {
                Files.deleteIfExists(file.toPath());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String toLegalFileName(String string) {
        return string.replaceAll("[\\s/:\\*\\?\"<>\\|\\\\]", "_");
    }

    public static void openWithSystemEditor(File file) throws IOException {
        if (Platform.isWindowsFamily()) {
            ProcessBuilder processBuilder = new ProcessBuilder("cmd", "/c", file.getAbsolutePath());
            processBuilder.start();
        }
    }

    public static void removeFile(File file) throws IOException {
        if ((Platform.isWindowsFamily() || Platform.isMac()) && com.sun.jna.platform.FileUtils.getInstance().hasTrash()) {
            com.sun.jna.platform.FileUtils.getInstance().moveToTrash(new File[]{file});
        } else {
            FileUtils.forceDelete((File)file);
        }
    }

    public static void removeFiles(File[] fileArray) throws IOException {
        if ((Platform.isWindowsFamily() || Platform.isMac()) && com.sun.jna.platform.FileUtils.getInstance().hasTrash()) {
            com.sun.jna.platform.FileUtils.getInstance().moveToTrash(fileArray);
        } else {
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File file : fileArray) {
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException iOException) {
                    arrayList.add(file);
                }
            }
            if (arrayList.size() > 0) {
                throw new IOException("The following files could not be removed: " + String.valueOf(arrayList));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getFileSize(File file) {
        if (file.exists()) {
            return file.length();
        }
        File file2 = ZipFileUtility.getParentZipFile(file);
        if (file2 == null) {
            return 0L;
        }
        try (ZipFile zipFile = ZipInfo.get(file2).createZipFile();){
            ZipArchiveEntry zipArchiveEntry = ZipFileUtility.getEntry(zipFile, file, file2);
            if (zipArchiveEntry == null) {
                long l2 = 0L;
                return l2;
            }
            long l = zipArchiveEntry.getSize();
            return l;
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public static boolean isZipDirectory(File file) throws IOException {
        if (file.exists()) {
            return false;
        }
        File file2 = ZipFileUtility.getParentZipFile(file);
        if (file2 == null) {
            throw new FileNotFoundException();
        }
        try (ZipFile zipFile = ZipInfo.get(file2).createZipFile();){
            ZipArchiveEntry zipArchiveEntry = ZipFileUtility.getEntry(zipFile, file, file2);
            if (zipArchiveEntry == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = zipArchiveEntry.isDirectory();
            return bl;
        }
    }

    public static InputStream createInputStream(File file) throws IOException {
        if (!file.exists()) {
            File file2 = ZipFileUtility.getParentZipFile(file);
            if (file2 == null) {
                throw new FileNotFoundException();
            }
            ZipFile zipFile = ZipInfo.get(file2).createZipFile();
            ZipArchiveEntry zipArchiveEntry = ZipFileUtility.getEntry(zipFile, file, file2);
            if (zipArchiveEntry == null) {
                zipFile.close();
                throw new FileNotFoundException();
            }
            return new ZipFileInputStreamWrapper(zipFile, zipFile.getInputStream(zipArchiveEntry));
        }
        Archive archive = FileUtility.detectArchive(file);
        if (archive == null) {
            return new FileInputStream(file);
        }
        switch (archive) {
            case ZIP: {
                return new ZipInputStream(new FileInputStream(file));
            }
            case GZIP: {
                return new GZIPInputStream(new FileInputStream(file));
            }
        }
        return new FileInputStream(file);
    }

    public static Archive detectArchive(File file) {
        Archive archive;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Archive archive2 = null;
            byte[] byArray = new byte[4];
            if (fileInputStream.read(byArray) == byArray.length) {
                if (byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4) {
                    archive2 = Archive.ZIP;
                } else if (byArray[0] == 31 && byArray[1] == -117) {
                    archive2 = Archive.GZIP;
                }
            }
            archive = archive2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        fileInputStream.close();
        return archive;
    }

    public static Charset detectEncoding(File file, Charset charset) {
        Charset charset2;
        block8: {
            InputStream inputStream = FileUtility.createInputStream(file);
            try {
                charset2 = FileUtility.detectEncoding(inputStream, charset);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return charset;
                }
            }
            inputStream.close();
        }
        return charset2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Charset detectEncoding(InputStream inputStream, Charset charset) {
        try {
            byte[] byArray = new byte[4096];
            UniversalDetector universalDetector = null;
            try {
                Charset charset3;
                universalDetector = new UniversalDetector(null);
                int n = inputStream.read(byArray);
                if (n > 0 && !universalDetector.isDone()) {
                    universalDetector.handleData(byArray, 0, n);
                }
                universalDetector.dataEnd();
                String string = universalDetector.getDetectedCharset();
                if (string == null) {
                    Charset charset4 = charset;
                    return charset4;
                }
                Charset charset2 = charset3 = Charset.forName(string);
                return charset2;
            }
            finally {
                if (universalDetector != null) {
                    universalDetector.reset();
                }
            }
        }
        catch (Throwable throwable2) {
            return charset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String detectNewline(File file, String string) {
        try {
            byte[] byArray = new byte[4096];
            try (FileInputStream fileInputStream = null;){
                fileInputStream = new FileInputStream(file);
                int n = fileInputStream.read(byArray);
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        char c = (char)byArray[i];
                        switch (c) {
                            case '\n': {
                                String string2 = "\n";
                                return string2;
                            }
                            case '\r': {
                                char c2;
                                if (++i < n && (c2 = (char)byArray[i]) == '\n') {
                                    String string3 = "\r\n";
                                    return string3;
                                }
                                String string4 = "\r";
                                return string4;
                            }
                        }
                    }
                }
                String string5 = string;
                return string5;
            }
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public static String detectSeparator(File file, String string) {
        String string2;
        block8: {
            InputStream inputStream = FileUtility.createInputStream(file);
            try {
                string2 = FileUtility.detectSeparator(inputStream, string);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return string;
                }
            }
            inputStream.close();
        }
        return string2;
    }

    public static String detectSeparator(InputStream inputStream, String string) {
        try {
            char c;
            byte[] byArray = new byte[4096];
            HashMap<Character, MutableInt> hashMap = new HashMap<Character, MutableInt>();
            int n = inputStream.read(byArray);
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    c = (char)byArray[i];
                    switch (c) {
                        case '\u0000': {
                            return null;
                        }
                        case '\t': 
                        case '\n': 
                        case ' ': 
                        case ',': {
                            MutableInt mutableInt = (MutableInt)hashMap.get(Character.valueOf(c));
                            if (mutableInt == null) {
                                mutableInt = new MutableInt(0);
                                hashMap.put(Character.valueOf(c), mutableInt);
                            }
                            mutableInt.increment();
                        }
                    }
                }
            }
            String string2 = string;
            c = '\u0000';
            for (Map.Entry entry : hashMap.entrySet()) {
                if (c >= ((MutableInt)entry.getValue()).intValue()) continue;
                string2 = ((Character)entry.getKey()).toString();
                c = (char)((MutableInt)entry.getValue()).intValue();
            }
            return string2;
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public static String detectSeparator2(File file) {
        String string;
        block8: {
            InputStream inputStream = FileUtility.createInputStream(file);
            try {
                string = FileUtility.detectSeparator2(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static String detectSeparator2(InputStream inputStream) {
        try {
            Object object2;
            byte[] byArray = new byte[524288];
            ArrayList<HashMultiset> arrayList = new ArrayList<HashMultiset>();
            HashMultiset hashMultiset = HashMultiset.create();
            int n = inputStream.read(byArray);
            if (n > 0) {
                block7: for (int i = 0; i < n; ++i) {
                    char c = (char)byArray[i];
                    switch (c) {
                        case '\u0000': {
                            return null;
                        }
                        case '\t': 
                        case ' ': 
                        case ',': 
                        case ';': {
                            if (hashMultiset.isEmpty()) {
                                arrayList.add(hashMultiset);
                            }
                            hashMultiset.add((Object)Character.valueOf(c));
                            continue block7;
                        }
                        case '\n': {
                            hashMultiset = HashMultiset.create();
                        }
                    }
                }
            }
            if (arrayList.size() < 1) {
                return null;
            }
            if (arrayList.size() > 2) {
                arrayList.remove(arrayList.size() - 1);
            }
            HashMultiset hashMultiset2 = HashMultiset.create();
            for (Multiset object2 : arrayList) {
                for (Multiset.Entry iterator : object2.entrySet()) {
                    hashMultiset2.add((Object)((Character)iterator.getElement()), iterator.getCount());
                }
            }
            HashSet hashSet = new HashSet();
            for (Object object2 : hashMultiset2.entrySet()) {
                if (hashMultiset2.count(object2.getElement()) < arrayList.size()) continue;
                double d = (double)object2.getCount() / (double)arrayList.size();
                double d2 = 0.0;
                for (Multiset multiset : arrayList) {
                    int n2 = multiset.count(object2.getElement());
                    d2 += Math.abs(d - (double)n2);
                }
                if (!(d2 < (double)(arrayList.size() / 2))) continue;
                hashSet.add((Character)object2.getElement());
            }
            boolean bl = false;
            object2 = null;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                int n3;
                Character c = (Character)iterator.next();
                if (n3 >= hashMultiset2.count((Object)c)) continue;
                object2 = c;
                n3 = hashMultiset2.count((Object)c);
            }
            return object2 == null ? null : object2.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static boolean detectQuoted(File file, Charset charset, String string, String string2, boolean bl) {
        try (BufferedReader bufferedReader = null;){
            int n;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
            for (n = 0; n < 2; ++n) {
                String[] stringArray;
                String string3 = bufferedReader.readLine();
                if (string3 == null) {
                    boolean bl2 = bl;
                    return bl2;
                }
                for (String string4 : stringArray = string3.split(string)) {
                    if (!string4.startsWith(string2) || !string4.endsWith(string2)) continue;
                    boolean bl3 = true;
                    return bl3;
                }
            }
            n = 0;
            return n != 0;
        }
        catch (Throwable throwable) {
            return bl;
        }
    }

    public static boolean guessHeader(File file, Charset charset, String string) {
        boolean bl;
        block8: {
            InputStream inputStream = FileUtility.createInputStream(file);
            try {
                bl = FileUtility.guessHeader(inputStream, charset, string);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    public static boolean guessHeader(InputStream inputStream, Charset charset, String string) {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        try {
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                return false;
            }
            String[] stringArray = string2.split(string);
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (i > 0 && string3.length() == 0) {
                    return false;
                }
                try {
                    Double.parseDouble(string3);
                    return false;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static File createTempDir(File file) throws IOException {
        String string = "t" + System.currentTimeMillis() + "-";
        for (int i = 0; i < 1000; ++i) {
            File file2 = new File(file, string + i);
            if (!file2.mkdirs()) continue;
            return file2;
        }
        throw new IOException("Failed to create temp directory.");
    }

    public static String replaceToLF(String string) {
        char[] cArray = new char[string.length()];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n2 = string.charAt(i);
            if (n2 == 13) {
                if (i + 1 < string.length() && string.charAt(i + 1) == '\n') {
                    ++i;
                }
                n2 = 10;
            }
            cArray[n++] = n2;
        }
        return new String(cArray, 0, n);
    }
}

