/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.file;

import com.ef_prime.rflow.core.base.Project;
import com.ef_prime.rflow.core.base.SessionEntry;
import com.ef_prime.rflow.core.common.xml.XmlContext;
import com.ef_prime.rflow.core.common.xml.XmlUtility;
import com.ef_prime.rflow.ui.view.ViewPosition;
import java.io.File;
import javax.swing.Icon;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileViewerSessionEntry
extends SessionEntry {
    private String file;

    public FileViewerSessionEntry() {
    }

    public FileViewerSessionEntry(Project project, File file, ViewPosition viewPosition, boolean bl, Icon icon) {
        super(viewPosition, bl, icon);
        this.file = project.toProjectAbstractPath(file);
    }

    @Override
    public String getTitle() {
        return FilenameUtils.getName((String)this.file);
    }

    @Override
    public String getType() {
        return "fileviewer";
    }

    public String getFile(Project project) {
        return project.toProjectAbsolutePath(this.file);
    }

    @Override
    public void storeToElement(XmlContext xmlContext, Document document, Element element) {
        super.storeToElement(xmlContext, document, element);
        if (this.file != null) {
            element.setAttribute("file", this.file);
        }
    }

    @Override
    public void loadElement(Element element, XmlContext xmlContext) {
        super.loadElement(element, xmlContext);
        this.file = XmlUtility.getAttribute(element, "file", null);
    }
}

