/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.file;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.file.PageTextReader;
import com.ef_prime.rflow.core.app.file.TextReader;
import com.ef_prime.rflow.core.app.r.script.RSyntaxDocumentWithIndentChanged;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditBackups;
import com.ef_prime.rflow.core.base.FileEditSupport;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.FileKey;
import com.ef_prime.rflow.core.common.keyvalue.IntKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.util.Archive;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.resource.Messages;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.CsvReader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;

public class TextFile
extends ValueMap
implements FileEdit,
DocumentListener {
    private static final Logger LOGGER = Logger.getLogger(TextFile.class.getName());
    public static final String ENCODING_SYSTEM_DEFAULT = "<system_default>";
    public static final String NEWLINE_SYSTEM_DEFAULT = "<system_default>";
    public static final String NEWLINE_LF = "LF";
    public static final String NEWLINE_CRLF = "CRLF";
    public static final String TYPE_PLAIN = "Plain Text";
    public static final String TYPE_SEP_DATA = "Separated Data";
    public static final String SYNTAX_PLAIN = "plain";
    public static final String SYNTAX_ACTIONSCRIPT = "actionscript";
    public static final String SYNTAX_ASSEMBLER_X86 = "asm";
    public static final String SYNTAX_BBCODE = "bbcode";
    public static final String SYNTAX_C = "c";
    public static final String SYNTAX_CLOJURE = "clojure";
    public static final String SYNTAX_CPLUSPLUS = "cpp";
    public static final String SYNTAX_CSHARP = "cs";
    public static final String SYNTAX_CSS = "css";
    public static final String SYNTAX_D = "d";
    public static final String SYNTAX_DART = "dart";
    public static final String SYNTAX_DELPHI = "delphi";
    public static final String SYNTAX_DOCKERFILE = "dockerfile";
    public static final String SYNTAX_DTD = "dtd";
    public static final String SYNTAX_FORTRAN = "fortran";
    public static final String SYNTAX_GROOVY = "groovy";
    public static final String SYNTAX_HOSTS = "hosts";
    public static final String SYNTAX_HTACCESS = "htaccess";
    public static final String SYNTAX_HTML = "html";
    public static final String SYNTAX_JAVA = "java";
    public static final String SYNTAX_JAVASCRIPT = "javascript";
    public static final String SYNTAX_JSHINTRC = "jshintrc";
    public static final String SYNTAX_JSON = "json";
    public static final String SYNTAX_JSP = "jsp";
    public static final String SYNTAX_LATEX = "latex";
    public static final String SYNTAX_LESS = "less";
    public static final String SYNTAX_LISP = "lisp";
    public static final String SYNTAX_LUA = "lua";
    public static final String SYNTAX_MAKEFILE = "makefile";
    public static final String SYNTAX_MXML = "mxml";
    public static final String SYNTAX_NSIS = "nsis";
    public static final String SYNTAX_PERL = "perl";
    public static final String SYNTAX_PHP = "php";
    public static final String SYNTAX_PROPERTIES_FILE = "properties";
    public static final String SYNTAX_PYTHON = "python";
    public static final String SYNTAX_RUBY = "ruby";
    public static final String SYNTAX_SAS = "sas";
    public static final String SYNTAX_SCALA = "scala";
    public static final String SYNTAX_SQL = "sql";
    public static final String SYNTAX_TCL = "tcl";
    public static final String SYNTAX_TYPESCRIPT = "typescript";
    public static final String SYNTAX_UNIX_SHELL = "shellscript";
    public static final String SYNTAX_VISUAL_BASIC = "visualbasic";
    public static final String SYNTAX_WINDOWS_BATCH = "bat";
    public static final String SYNTAX_XML = "xml";
    public static final String SPACE = " ";
    public static final String TAB = "\t";
    public static final String COMMA = ",";
    public static final String SEMICOLON = ";";
    public static final String QUOTED_NONE = "none";
    public static final String QUOTED_SIMPLE = "simple";
    public static final String QUOTED_NORMAL = "quoted";
    public static final List<Choice> ENCODING_CHOICES;
    public static final FileKey FILE;
    public static final ChoiceKey ENCODING;
    public static final ChoiceKey NEWLINE;
    public static final IntKey SKIPLINES;
    public static final ChoiceKey TYPE;
    public static final ChoiceKey ARCHIVE;
    public static final IntKey NUM_LF;
    public static final IntKey NUM_CRLF;
    public static final IntKey NUM_CR;
    public static final ChoiceKey SYNTAX;
    public static final BoolKey WHITESPACE;
    public static final ChoiceKey SEP;
    public static final ChoiceKey QUOTED;
    public static final BoolKey HEADER;
    public static final BoolKey DIRTY;
    public static final BoolKey USER_CHECK_KEY_DIRTY;
    public static final BoolKey PROJECT_CHECK_KEY_DIRTY;
    private FileEditSupport resourceSupport;
    private RSyntaxDocument document;
    private static final Set<Key<?>> USER_CHECK_KEYS;
    private static final Set<Key<?>> PROJECT_CHECK_KEYS;
    private static final Map<File, TextFile> TEXTFILES;
    private static final Map<File, TextFile> USER_TEXTFILES;
    private static final Map<File, TextFile> PROJECT_TEXTFILES;

    public TextFile() {
        this.registerKeys(FILE, ENCODING, NEWLINE, SKIPLINES, TYPE, ARCHIVE, NUM_LF, NUM_CR, NUM_CRLF, SYNTAX, WHITESPACE, SEP, QUOTED, HEADER, DIRTY, USER_CHECK_KEY_DIRTY, PROJECT_CHECK_KEY_DIRTY);
    }

    public static TextFile get(File file) {
        if (file == null) {
            return null;
        }
        TextFile textFile = TEXTFILES.get(file = WorkingDirectory.toAbsolutePath(file));
        if (textFile == null) {
            textFile = new TextFile();
            textFile.setFileAndGuessSettings(file);
            TextFile.overwriteConfig(file, textFile, USER_TEXTFILES, USER_CHECK_KEYS);
            TextFile.overwriteConfig(file, textFile, PROJECT_TEXTFILES, PROJECT_CHECK_KEYS);
            TEXTFILES.put(file, textFile);
        }
        return textFile;
    }

    private static void overwriteConfig(File file, TextFile textFile, Map<File, TextFile> map, Set<Key<?>> set) {
        TextFile textFile2 = map.remove(file);
        if (textFile2 != null) {
            for (Key<?> key : set) {
                textFile.putValue(key, textFile2.getValue(key));
            }
        }
    }

    private void setFileAndGuessSettings(File file) {
        this.putValue(FILE, file.getPath());
        String string = FileUtility.detectSeparator2(file);
        this.putValue(TYPE, string == null ? TYPE_PLAIN : TYPE_SEP_DATA);
        this.putValue(SEP, TextFile.separatorKey(string));
        Charset charset = FileUtility.detectEncoding(file, null);
        this.putValue(ENCODING, charset == null ? Rflow.project().getEncoding() : charset.name());
        this.putValue(HEADER, FileUtility.guessHeader(file, charset, string));
        Archive archive = FileUtility.detectArchive(file);
        if (archive != null) {
            this.putValue(ARCHIVE, archive.toString());
        }
        this.guessSyntax();
        this.putValue(USER_CHECK_KEY_DIRTY, Boolean.FALSE);
        this.putValue(PROJECT_CHECK_KEY_DIRTY, Boolean.FALSE);
    }

    @Override
    protected void processValueChanged(ValueChangeEvent valueChangeEvent) {
        super.processValueChanged(valueChangeEvent);
        if (USER_CHECK_KEYS.contains(valueChangeEvent.getKey())) {
            this.putValue(USER_CHECK_KEY_DIRTY, Boolean.TRUE);
        }
        if (PROJECT_CHECK_KEYS.contains(valueChangeEvent.getKey())) {
            this.putValue(PROJECT_CHECK_KEY_DIRTY, Boolean.TRUE);
        }
        if (ENCODING.equals(valueChangeEvent.getKey()) && !this.isDirty()) {
            this.clearEdit();
            this.dispatchFileEditEvent(4);
        }
    }

    private static Path getUserConfigFile() {
        return Rflow.project().getStateDir().toPath().resolve("text.yaml");
    }

    private static Path getProjectConfigFile() {
        return Rflow.project().getConfDir().toPath().resolve("text.yaml");
    }

    private static void load() {
        TextFile.loadConfig(TextFile.getUserConfigFile(), USER_TEXTFILES);
        TextFile.loadConfig(TextFile.getProjectConfigFile(), PROJECT_TEXTFILES);
    }

    private static void loadConfig(Path path, Map<File, TextFile> map) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            YamlEx yamlEx = new YamlEx();
            Map map2 = (Map)yamlEx.load(path.toFile());
            map2.entrySet().stream().forEach(entry -> {
                File file = new File(Rflow.project().toProjectAbsolutePath((String)entry.getKey()));
                TextFile textFile = new TextFile();
                textFile.loadYamlValue(yamlEx, entry.getValue());
                map.put(file, textFile);
                TEXTFILES.remove(file);
            });
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to read text file settings.", exception);
        }
    }

    private static void save() {
        if (Rflow.project().isNewProject()) {
            return;
        }
        TextFile.saveConfig(TextFile.getUserConfigFile(), USER_CHECK_KEY_DIRTY, USER_CHECK_KEYS, USER_TEXTFILES);
        TextFile.saveConfig(TextFile.getProjectConfigFile(), PROJECT_CHECK_KEY_DIRTY, PROJECT_CHECK_KEYS, PROJECT_TEXTFILES);
    }

    private static void saveConfig(Path path2, BoolKey boolKey, Set<Key<?>> set, Map<File, TextFile> map) {
        try {
            Files.createDirectories(path2.getParent(), new FileAttribute[0]);
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            YamlEx yamlEx = new YamlEx();
            Consumer<Map.Entry> consumer = entry -> linkedHashMap.put(Rflow.project().toProjectAbstractPath((File)entry.getKey()), ((TextFile)entry.getValue()).toYamlValue(yamlEx, set));
            TEXTFILES.entrySet().stream().filter(entry -> ((TextFile)entry.getValue()).getValue(boolKey)).forEach(consumer);
            map.entrySet().stream().forEach(consumer);
            FileUtility.safeSave(path2, path2.getParent(), path -> yamlEx.dump(path.toFile(), linkedHashMap));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to write text file settings.", exception);
        }
    }

    @Override
    public File getFile() {
        return new File(this.getValue(FILE));
    }

    public Charset getEncoding() {
        return this.getEncoding(Charset.defaultCharset());
    }

    public Charset getEncoding(Charset charset) {
        return this.getEncoding(ENCODING, charset);
    }

    private Charset getEncoding(ChoiceKey choiceKey, Charset charset) {
        String string = this.getValue(choiceKey);
        if (string.equals("<system_default>")) {
            return charset;
        }
        return Charset.forName(string);
    }

    public boolean isDefaultEncoding() {
        String string = this.getValue(ENCODING);
        return string.equals("<system_default>");
    }

    public String getNewLine() {
        String string = this.getValue(NEWLINE);
        if (string.equals(NEWLINE_LF)) {
            return "\n";
        }
        if (string.equals(NEWLINE_CRLF)) {
            return "\r\n";
        }
        return "\n";
    }

    public Archive getArchive() {
        String string = this.getValue(ARCHIVE);
        if (StringUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            Archive archive = Archive.valueOf(string);
            return archive;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getType() {
        return this.getValue(TYPE);
    }

    public synchronized RSyntaxDocument load(Path object, boolean bl, boolean bl2) throws IOException {
        Object object2;
        if (this.document != null) {
            return this.document;
        }
        boolean bl3 = false;
        if (!bl2 && (object2 = FileEditBackups.getInstance().getBackupFile(this)) != null && Files.exists((Path)object2, new LinkOption[0])) {
            object = object2;
            bl3 = true;
        }
        object2 = null;
        if (!Files.exists((Path)object, new LinkOption[0])) {
            object2 = "";
        } else {
            BufferedReader bufferedReader;
            if (bl) {
                bufferedReader = new BufferedReader(new InputStreamReader(FileUtility.createInputStream(object.toFile()), this.getEncoding()));
                try {
                    object2 = IOUtils.toString((Reader)bufferedReader);
                }
                finally {
                    bufferedReader.close();
                }
            }
            bufferedReader = new BufferedReader(new InputStreamReader(FileUtility.createInputStream(object.toFile()), this.getEncoding().newDecoder()));
            try {
                object2 = IOUtils.toString((Reader)bufferedReader);
            }
            finally {
                bufferedReader.close();
            }
        }
        this.countNewLines((String)object2);
        if (!this.allLFNewLines()) {
            object2 = FileUtility.replaceToLF((String)object2);
        }
        this.document = new RSyntaxDocumentWithIndentChanged("");
        try {
            this.document.insertString(0, (String)object2, null);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException);
        }
        this.document.addDocumentListener((DocumentListener)this);
        if (bl3) {
            this.setDirty(true);
            FileEditBackups.getInstance().clearBackupEntry(this);
        } else {
            this.setDirty(false);
        }
        this.updateLastModified();
        return this.document;
    }

    @Override
    public void save(Path path) throws IOException {
        this.saveInternal(path);
    }

    @Override
    public void saveBackup(Path path) throws IOException {
        this.saveInternal(path);
    }

    private void saveInternal(Path path) throws IOException {
        RSyntaxDocument rSyntaxDocument = this.document;
        if (rSyntaxDocument == null) {
            throw new IOException("No document model to save");
        }
        rSyntaxDocument.readLock();
        try {
            String string = this.getNewLine();
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, this.getEncoding(), new OpenOption[0]);){
                Segment segment = new Segment();
                segment.setPartialReturn(true);
                if (string.equals("\n")) {
                    int n = 0;
                    int n2 = rSyntaxDocument.getLength();
                    while (n2 > 0) {
                        rSyntaxDocument.getText(n, n2, segment);
                        ((Writer)bufferedWriter).write(segment.array, segment.offset, segment.count);
                        n2 -= segment.count;
                        n += segment.count;
                    }
                } else {
                    Element element = rSyntaxDocument.getDefaultRootElement();
                    for (int i = 0; i < element.getElementCount(); ++i) {
                        boolean bl;
                        Element element2 = element.getElement(i);
                        int n = element2.getEndOffset();
                        if (n > rSyntaxDocument.getLength()) {
                            n = rSyntaxDocument.getLength();
                        }
                        int n3 = element2.getStartOffset();
                        int n4 = n - element2.getStartOffset();
                        if (n4 == 0) continue;
                        boolean bl2 = bl = rSyntaxDocument.charAt(n - 1) == '\n';
                        if (bl) {
                            --n4;
                        }
                        while (n4 > 0) {
                            rSyntaxDocument.getText(n3, n4, segment);
                            ((Writer)bufferedWriter).write(segment.array, segment.offset, segment.count);
                            n4 -= segment.count;
                            n3 += segment.count;
                        }
                        if (!bl) continue;
                        bufferedWriter.write(string);
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException);
        }
        finally {
            rSyntaxDocument.readUnlock();
        }
    }

    public void countNewLines(String string) {
        int[] nArray = new int[3];
        block8: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\r': {
                    if (i + 1 < string.length() && string.charAt(i + 1) == '\n') {
                        ++i;
                        nArray[1] = nArray[1] + 1;
                        continue block8;
                    }
                    nArray[2] = nArray[2] + 1;
                    continue block8;
                }
                case '\n': {
                    nArray[0] = nArray[0] + 1;
                }
            }
        }
        this.putValueQuietly(NUM_LF, nArray[0]);
        this.putValueQuietly(NUM_CRLF, nArray[1]);
        this.putValueQuietly(NUM_CR, nArray[2]);
        if (Arrays.stream(nArray).allMatch(n -> n == 0)) {
            this.putValueQuietly(NEWLINE, Rflow.project().getNewline());
        } else {
            OptionalInt optionalInt = IntStream.range(0, nArray.length).reduce((n, n2) -> nArray[n] > nArray[n2] ? n : (nArray[n] < nArray[n2] ? n2 : n));
            if (optionalInt.isPresent()) {
                switch (optionalInt.getAsInt()) {
                    case 0: {
                        this.putValueQuietly(NEWLINE, NEWLINE_LF);
                        break;
                    }
                    case 1: {
                        this.putValueQuietly(NEWLINE, NEWLINE_CRLF);
                        break;
                    }
                    default: {
                        this.putValueQuietly(NEWLINE, Rflow.project().getNewline());
                    }
                }
            }
        }
    }

    public boolean allLFNewLines() {
        return this.getValue(NUM_CRLF) == 0 && this.getValue(NUM_CR) == 0;
    }

    public boolean areNewlinesMixed() {
        int n = 0;
        for (IntKey intKey : new IntKey[]{NUM_LF, NUM_CRLF, NUM_CR}) {
            if (this.getValue(intKey) != 0) continue;
            ++n;
        }
        return n < 2;
    }

    public synchronized void copyValuesFrom(TextFile textFile) {
        this.copyValues(textFile);
        this.document = textFile.getDocument();
        if (this.document != null) {
            this.document.addDocumentListener((DocumentListener)this);
        }
    }

    public synchronized void copyModel() {
        if (this.document != null) {
            this.document.removeDocumentListener((DocumentListener)this);
            RSyntaxDocumentWithIndentChanged rSyntaxDocumentWithIndentChanged = new RSyntaxDocumentWithIndentChanged(this.document.getSyntaxStyle());
            try {
                rSyntaxDocumentWithIndentChanged.insertString(0, this.document.getText(0, this.document.getLength()), null);
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.SEVERE, "Failed to copy document.", badLocationException);
            }
            rSyntaxDocumentWithIndentChanged.addDocumentListener(this);
            this.document = rSyntaxDocumentWithIndentChanged;
        }
    }

    private void guessSyntax() {
        String string;
        String string2 = SYNTAX_PLAIN;
        String string3 = this.getFile().getName();
        switch (string = string3.toLowerCase()) {
            case "makefile": {
                string2 = SYNTAX_MAKEFILE;
                break;
            }
            case "dockerfile": {
                string2 = SYNTAX_DOCKERFILE;
                break;
            }
            case "hosts": {
                string2 = SYNTAX_HOSTS;
                break;
            }
            case ".htaccess": {
                string2 = SYNTAX_HTACCESS;
            }
        }
        if (string2 == SYNTAX_PLAIN) {
            switch (FilenameUtils.getExtension((String)string3)) {
                case "as": {
                    string2 = SYNTAX_ACTIONSCRIPT;
                    break;
                }
                case "asm": {
                    string2 = SYNTAX_ASSEMBLER_X86;
                    break;
                }
                case "c": 
                case "h": {
                    string2 = SYNTAX_C;
                    break;
                }
                case "clj": {
                    string2 = SYNTAX_CLOJURE;
                    break;
                }
                case "cpp": 
                case "hpp": {
                    string2 = SYNTAX_CPLUSPLUS;
                    break;
                }
                case "cs": {
                    string2 = SYNTAX_CSHARP;
                    break;
                }
                case "css": {
                    string2 = SYNTAX_CSS;
                    break;
                }
                case "d": {
                    string2 = SYNTAX_D;
                    break;
                }
                case "dart": {
                    string2 = SYNTAX_DART;
                    break;
                }
                case "pas": {
                    string2 = SYNTAX_DELPHI;
                    break;
                }
                case "dtd": {
                    string2 = SYNTAX_DTD;
                    break;
                }
                case "f": 
                case "f90": 
                case "f95": 
                case "f03": 
                case "for": {
                    string2 = SYNTAX_FORTRAN;
                    break;
                }
                case "groovy": {
                    string2 = SYNTAX_GROOVY;
                    break;
                }
                case "html": 
                case "htm": {
                    string2 = SYNTAX_HTML;
                    break;
                }
                case "java": {
                    string2 = SYNTAX_JAVA;
                    break;
                }
                case "js": {
                    string2 = SYNTAX_JAVASCRIPT;
                    break;
                }
                case "json": {
                    string2 = SYNTAX_JSON;
                    break;
                }
                case "jshintrc": {
                    string2 = SYNTAX_JSHINTRC;
                    break;
                }
                case "jsp": {
                    string2 = SYNTAX_JSP;
                    break;
                }
                case "tex": {
                    string2 = SYNTAX_LATEX;
                    break;
                }
                case "less": {
                    string2 = SYNTAX_LESS;
                    break;
                }
                case "lisp": {
                    string2 = SYNTAX_LISP;
                    break;
                }
                case "lua": {
                    string2 = SYNTAX_LUA;
                    break;
                }
                case "mxml": {
                    string2 = SYNTAX_MXML;
                    break;
                }
                case "nsh": 
                case "nsi": {
                    string2 = SYNTAX_NSIS;
                    break;
                }
                case "pl": {
                    string2 = SYNTAX_PERL;
                    break;
                }
                case "php": {
                    string2 = SYNTAX_PHP;
                    break;
                }
                case "properties": {
                    string2 = SYNTAX_PROPERTIES_FILE;
                    break;
                }
                case "py": {
                    string2 = SYNTAX_PYTHON;
                    break;
                }
                case "rb": {
                    string2 = SYNTAX_RUBY;
                    break;
                }
                case "sas": {
                    string2 = SYNTAX_SAS;
                    break;
                }
                case "scala": {
                    string2 = SYNTAX_SCALA;
                    break;
                }
                case "sql": {
                    string2 = SYNTAX_SQL;
                    break;
                }
                case "tcl": {
                    string2 = SYNTAX_TCL;
                    break;
                }
                case "ts": {
                    string2 = SYNTAX_TYPESCRIPT;
                    break;
                }
                case "sh": {
                    string2 = SYNTAX_UNIX_SHELL;
                    break;
                }
                case "bat": {
                    string2 = SYNTAX_WINDOWS_BATCH;
                    break;
                }
                case "vb": {
                    string2 = SYNTAX_VISUAL_BASIC;
                    break;
                }
                case "xml": {
                    string2 = SYNTAX_XML;
                    break;
                }
            }
        }
        this.putValue(SYNTAX, string2);
    }

    public boolean isHeader() {
        return this.getValue(HEADER);
    }

    public Character getSeparator() {
        String string;
        switch (string = this.getValue(SEP)) {
            case " ": {
                return Character.valueOf(' ');
            }
            case "\t": {
                return Character.valueOf('\t');
            }
            case ",": {
                return Character.valueOf(',');
            }
            case ";": {
                return Character.valueOf(';');
            }
        }
        return Character.valueOf(',');
    }

    public static String separatorKey(String string) {
        if (string == null) {
            return COMMA;
        }
        switch (string) {
            case " ": {
                return SPACE;
            }
            case "\t": {
                return TAB;
            }
            case ",": {
                return COMMA;
            }
            case ";": {
                return SEMICOLON;
            }
        }
        return COMMA;
    }

    public int getSkipLines() {
        return this.getValue(SKIPLINES) + (this.getValue(HEADER) != false ? 1 : 0);
    }

    public boolean isColumnNames() {
        return this.getValue(HEADER) != false && FileUtility.getFileSize(this.getFile()) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getColumnNames() throws IOException {
        CsvReader csvReader = this.createReader(0L, false);
        try {
            List list = csvReader.readValues();
            if (list == null) {
                throw new IOException();
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        finally {
            IOUtils.closeQuietly((Closeable)csvReader);
        }
    }

    public TextReader reader() throws IOException {
        return new SepTextReader(0L, true);
    }

    public TextReader reader(long l) throws IOException {
        return new SepTextReader(l, true);
    }

    public PageTextReader pageReader(int n, int n2) throws IOException {
        return new SepPageTextReader(n, n2);
    }

    public boolean supportsPageReader() {
        return this.getFile().exists() && FileUtility.detectArchive(this.getFile()) == null;
    }

    private CsvReader createReader(long l, boolean bl) throws IOException {
        CsvConfig csvConfig = this.createConfig(bl);
        InputStream inputStream = FileUtility.createInputStream(this.getFile());
        if (l > 0L) {
            inputStream.skip(l);
        }
        return new CsvReader((Reader)new InputStreamReader(inputStream, this.getEncoding()), csvConfig);
    }

    private CsvConfig createConfig(boolean bl) {
        int n = bl && this.getValue(HEADER) != false ? 1 : 0;
        CsvConfig csvConfig = new CsvConfig();
        csvConfig.setSeparator(this.getSeparator().charValue());
        csvConfig.setSkipLines(n);
        csvConfig.setQuoteDisabled(this.getValue(QUOTED).equals(QUOTED_NONE));
        return csvConfig;
    }

    @Override
    public String getFileEditName() {
        return this.getFile().getName();
    }

    @Override
    public boolean canBackup() {
        File file = this.getFile();
        return this.document != null && !file.isDirectory() && file.length() < 0xA00000L;
    }

    @Override
    public synchronized void clearEdit() {
        if (this.document != null) {
            this.document.removeDocumentListener((DocumentListener)this);
            this.document = null;
        }
        this.setDirty(false);
    }

    @Override
    public void loadFileEdit() {
        this.getFileEditSupport().loadFileEdit();
        Path path = FileEditBackups.getInstance().getBackupFile(this);
        if (this.document == null && path != null && Files.exists(path, new LinkOption[0])) {
            this.setDirty(true);
        }
    }

    @Override
    public void unloadFileEdit(boolean bl) {
        this.getFileEditSupport().unloadFileEdit(bl);
        if (bl) {
            if (this.isDirtyForBackup()) {
                try {
                    FileEditBackups.getInstance().backup(this);
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, "Failed to save backup.", iOException);
                }
            }
            this.clearEdit();
        } else {
            this.clearEdit();
            FileEditBackups.getInstance().removeBackup(this);
        }
    }

    @Override
    public FileEditSupport getFileEditSupport() {
        if (this.resourceSupport == null) {
            this.resourceSupport = new FileEditSupport(this);
        }
        return this.resourceSupport;
    }

    @Override
    public boolean autoOpenView() {
        return true;
    }

    @Override
    public void setDirty(boolean bl) {
        FileEdit.super.setDirty(bl);
        this.putValue(DIRTY, bl);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty(true);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public RSyntaxDocument getDocument() {
        return this.document;
    }

    public synchronized void setDocument(RSyntaxDocument rSyntaxDocument) {
        this.document = rSyntaxDocument;
    }

    static {
        FILE = ((FileKey.Builder)((Key.Builder)FileKey.builder("file", "File").setFileNameEdit(true)).setNoSave(true)).build();
        NEWLINE = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("newline", Messages.getString("File.TextSettings.new_line_for_save")).setValuesAndLabels(NEWLINE_LF, "", NEWLINE_CRLF, "")).setNoSave(true)).build();
        SKIPLINES = ((IntKey.Builder)((IntKey.Builder)IntKey.builder("skiplines", "").setDefaultValue(0)).setNoSave(true)).build();
        TYPE = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("type", "").setDefaultValue(TYPE_PLAIN)).setValues(TYPE_PLAIN, TYPE_SEP_DATA)).setNoSave(true)).build();
        ARCHIVE = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("archive", "").setDefaultValue("")).setValues("None", Archive.GZIP.toString(), Archive.ZIP.toString())).setNoSave(true)).build();
        NUM_LF = ((IntKey.Builder)((IntKey.Builder)IntKey.builder("num_lf", "Number of LF").setDefaultValue(-1)).setNoSave(true)).build();
        NUM_CRLF = ((IntKey.Builder)((IntKey.Builder)IntKey.builder("num_crlf", "Number of CRLF").setDefaultValue(-1)).setNoSave(true)).build();
        NUM_CR = ((IntKey.Builder)((IntKey.Builder)IntKey.builder("num_cr", "Number of CR").setDefaultValue(-1)).setNoSave(true)).build();
        SYNTAX = ((ChoiceKey.Builder)ChoiceKey.builder("syntax", Messages.getString("File.TextSettings.syntax_highlighting")).setValuesAndLabels(SYNTAX_PLAIN, "(" + Messages.getString("Message.none") + ")", SYNTAX_ACTIONSCRIPT, "ActionScript", SYNTAX_ASSEMBLER_X86, "Assembly x86", SYNTAX_BBCODE, "BBCode", SYNTAX_C, "C", SYNTAX_CLOJURE, "Clojure", SYNTAX_CPLUSPLUS, "C++", SYNTAX_CSHARP, "C#", SYNTAX_CSS, "CSS", SYNTAX_D, "D", SYNTAX_DART, "Dart", SYNTAX_DELPHI, "Delphi", SYNTAX_DOCKERFILE, "Dockerfile", SYNTAX_DTD, "DTD", SYNTAX_FORTRAN, "FORTRAN", SYNTAX_GROOVY, "Groovy", SYNTAX_HOSTS, SYNTAX_HOSTS, SYNTAX_HTACCESS, SYNTAX_HTACCESS, SYNTAX_HTML, "HTML", SYNTAX_JAVA, "Java", SYNTAX_JAVASCRIPT, "JavaScript", SYNTAX_JSHINTRC, SYNTAX_JSHINTRC, SYNTAX_JSON, "JSON", SYNTAX_JSP, "JSP", SYNTAX_LATEX, "Latex", SYNTAX_LESS, "LESS", SYNTAX_LISP, "Lisp", SYNTAX_LUA, "Lua", SYNTAX_MAKEFILE, "Makefile", SYNTAX_MXML, "MXML", SYNTAX_NSIS, "NSIS", SYNTAX_PERL, "Perl", SYNTAX_PHP, "PHP", SYNTAX_PROPERTIES_FILE, "Properties", SYNTAX_PYTHON, "Python", SYNTAX_RUBY, "Ruby", SYNTAX_SAS, "SAS", SYNTAX_SCALA, "Scala", SYNTAX_SQL, "SQL", SYNTAX_TCL, "Tcl", SYNTAX_TYPESCRIPT, "TypeScript", SYNTAX_UNIX_SHELL, "ShellScript", SYNTAX_WINDOWS_BATCH, "Windows Batch", SYNTAX_VISUAL_BASIC, "Visual Basic", SYNTAX_XML, "XML")).build();
        WHITESPACE = ((BoolKey.Builder)BoolKey.builder("whitespace", Messages.getString("File.TextSettings.show_whitespace")).setNoSave(true)).build();
        SEP = ((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("separator", Messages.getString("File.TextSettings.separator")).setDefaultValue(COMMA)).setValuesAndLabels(COMMA, Messages.getString("File.TextSettings.comma"), TAB, Messages.getString("File.TextSettings.tab"), SPACE, Messages.getString("File.TextSettings.space"), SEMICOLON, Messages.getString("File.TextSettings.semicolon"))).build();
        QUOTED = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder(QUOTED_NORMAL, "").setDefaultValue(QUOTED_NORMAL)).setValues(QUOTED_NONE, QUOTED_SIMPLE, QUOTED_NORMAL)).setNoSave(true)).build();
        HEADER = BoolKey.builder("header", Messages.getString("File.TextSettings.header")).build();
        DIRTY = ((BoolKey.Builder)BoolKey.builder("dirty", "").setNoSave(true)).build();
        USER_CHECK_KEY_DIRTY = ((BoolKey.Builder)BoolKey.builder("user_check_key_dirty", "").setNoSave(true)).build();
        PROJECT_CHECK_KEY_DIRTY = ((BoolKey.Builder)BoolKey.builder("project_check_key_dirty", "").setNoSave(true)).build();
        USER_CHECK_KEYS = Sets.newHashSet((Object[])new Key[]{SYNTAX});
        TEXTFILES = new HashMap<File, TextFile>();
        USER_TEXTFILES = new HashMap<File, TextFile>();
        PROJECT_TEXTFILES = new HashMap<File, TextFile>();
        ENCODING_CHOICES = new ArrayList<Choice>();
        ENCODING_CHOICES.add(new Choice("<system_default>", "(" + Messages.getString("File.TextSettings.system_default") + ")"));
        for (Charset charset : Charset.availableCharsets().values()) {
            if (!charset.isRegistered()) continue;
            String string = "";
            if (charset.name().equals("windows-31j")) {
                string = "windows-31j (Windows Shift_JIS)";
            }
            Choice choice = new Choice(charset.name(), string);
            ENCODING_CHOICES.add(choice);
        }
        ENCODING = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("encoding", Messages.getString("File.TextSettings.encoding")).setDefaultValue("<system_default>")).setChoices(ENCODING_CHOICES)).addEnabledKeyLink(DIRTY, false)).build();
        PROJECT_CHECK_KEYS = Sets.newHashSet((Object[])new Key[]{ENCODING, SEP, HEADER});
        Rflow.getInstance().addRflowEventHandler(new RflowEventHandler(){

            @Override
            public void rflowWillShutdown() {
            }

            @Override
            public void rflowProjectWillEnd() {
                TextFile.save();
                TEXTFILES.clear();
                USER_TEXTFILES.clear();
                PROJECT_TEXTFILES.clear();
            }

            @Override
            public void rflowProjectDidStart() {
                TextFile.load();
            }
        });
    }

    private class SepTextReader
    extends TextReader {
        private CsvReader csvReader;
        private boolean closed;
        private boolean started;
        private List<String> nextLine;

        public SepTextReader(long l, boolean bl) throws IOException {
            CsvConfig csvConfig = TextFile.this.createConfig(bl);
            InputStream inputStream = FileUtility.createInputStream(TextFile.this.getFile());
            if (l > 0L) {
                inputStream.skip(l);
            }
            this.csvReader = new CsvReader((Reader)new InputStreamReader(inputStream, TextFile.this.getEncoding()), csvConfig);
        }

        @Override
        protected List<String> next() throws IOException {
            if (!this.started) {
                this.started = true;
                this.nextLine = this.csvReader.readValues();
            }
            List<String> list = this.nextLine;
            this.nextLine = this.csvReader.readValues();
            if (this.nextLine == null && list != null && (list.isEmpty() || list.size() == 1 && StringUtils.isWhitespace((CharSequence)list.get(0)))) {
                return null;
            }
            return list;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed && this.csvReader != null) {
                IOUtils.closeQuietly((Closeable)this.csvReader);
            }
            this.closed = true;
        }
    }

    private class SepPageTextReader
    extends PageTextReader {
        private long pos;
        private int columnCount;

        public SepPageTextReader(int n, int n2) {
            super(n, n2);
        }

        @Override
        public List<String[]> nextPage() throws IOException {
            int n;
            Object object;
            ByteArrayOutputStream byteArrayOutputStream;
            CsvConfig csvConfig;
            block15: {
                csvConfig = TextFile.this.createConfig(this.pos == 0L);
                byteArrayOutputStream = new ByteArrayOutputStream(0x100000);
                byte[] byArray = new byte[1024];
                object = new FileInputStream(TextFile.this.getFile());
                try {
                    if (this.pos > 0L) {
                        ((FileInputStream)object).skip(this.pos);
                    }
                    int n2 = 0;
                    while ((n = ((FileInputStream)object).read(byArray)) > 0) {
                        for (int i = 0; i < n; ++i) {
                            if (byArray[i] != 10 || ++n2 != this.getPageLines()) continue;
                            byteArrayOutputStream.write(byArray, 0, i + 1);
                            break block15;
                        }
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                }
                finally {
                    ((FileInputStream)object).close();
                }
            }
            this.pos += (long)byteArrayOutputStream.size();
            this.columnCount = this.getHeaderColumnCount();
            object = new ArrayList(this.getPageLines());
            try (CsvReader csvReader = new CsvReader((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), TextFile.this.getEncoding()), csvConfig);){
                for (n = 0; n < this.getPageLines(); ++n) {
                    List list = csvReader.readValues();
                    if (list == null) {
                        break;
                    }
                    this.columnCount = Math.max(this.columnCount, list.size());
                    object.add(list.toArray(new String[list.size()]));
                }
            }
            return object;
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }
    }
}

