/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.file;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;

public abstract class TextReader
implements Closeable {
    protected int rowNum;
    private List<String> cachedLine;

    public int getRowNum() {
        return this.rowNum;
    }

    public boolean hasNext() throws IOException {
        if (this.cachedLine != null) {
            return true;
        }
        this.cachedLine = this.next();
        return this.cachedLine != null;
    }

    public List<String> nextLine() throws IOException {
        if (this.cachedLine != null) {
            ++this.rowNum;
            List<String> list = this.cachedLine;
            this.cachedLine = null;
            return list;
        }
        List<String> list = this.next();
        if (list != null) {
            ++this.rowNum;
        }
        return list;
    }

    protected abstract List<String> next() throws IOException;
}

