/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.file;

import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.common.util.Archive;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class ZipFileUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSingleFileToZip(File file, File file2, String string) throws IOException {
        FileUtils.forceMkdir((File)file2.getParentFile());
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));){
            ZipEntry zipEntry = new ZipEntry(string);
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
                zipOutputStream.putNextEntry(zipEntry);
                int n = 0;
                byte[] byArray = new byte[1024];
                while ((n = bufferedInputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n);
                }
            }
            zipOutputStream.closeEntry();
        }
    }

    public static boolean isZipExtension(File file) {
        return file.getPath().endsWith(".zip");
    }

    public static String path(String string) {
        return FilenameUtils.separatorsToUnix((String)string);
    }

    public static File getParentZipFile(File file) {
        if (file.exists()) {
            return null;
        }
        while (file != null && !file.exists()) {
            file = file.getParentFile();
        }
        if (file == null) {
            return null;
        }
        if (FileUtility.detectArchive(file) == Archive.ZIP) {
            return file;
        }
        return null;
    }

    public static String getInnerPath(File file, File file2) {
        String string = ZipFileUtility.path(file2.getAbsolutePath());
        String string2 = ZipFileUtility.path(file.getAbsolutePath());
        return string2.substring(string.length() + 1);
    }

    public static ZipArchiveEntry getEntry(ZipFile zipFile, File file, File file2) {
        String string = ZipFileUtility.getInnerPath(file, file2);
        ZipArchiveEntry zipArchiveEntry = zipFile.getEntry(string);
        if (zipArchiveEntry == null) {
            zipArchiveEntry = zipFile.getEntry(string + "/");
        }
        return zipArchiveEntry;
    }

    public static void extract(ZipFile zipFile, Path path) throws IOException {
        Enumeration enumeration = zipFile.getEntries();
        while (enumeration.hasMoreElements()) {
            ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)enumeration.nextElement();
            Path path2 = path.resolve(zipArchiveEntry.getName());
            if (zipArchiveEntry.isDirectory()) {
                Files.createDirectories(path2, new FileAttribute[0]);
                continue;
            }
            Files.createDirectories(path2.getParent(), new FileAttribute[0]);
            OutputStream outputStream = Files.newOutputStream(path2, new OpenOption[0]);
            try {
                InputStream inputStream = zipFile.getInputStream(zipArchiveEntry);
                try {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            finally {
                if (outputStream == null) continue;
                outputStream.close();
            }
        }
    }
}

