/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.file;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.base.RflowEventHandler;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.resource.Messages;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipInfo
extends ValueMap {
    private static final Logger LOGGER = Logger.getLogger(ZipInfo.class.getName());
    public static final ChoiceKey ENCODING = ((ChoiceKey.Builder)((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("encoding", Messages.getString("File.Zip.filename_encoding")).setDefaultValue("<system_default>")).setChoices(TextFile.ENCODING_CHOICES)).setIcon("16/script_binary.png")).setLabelPosition("empty")).build();
    private File file;
    private boolean dirty;
    private static final Map<File, ZipInfo> ZIPINFOS = new HashMap<File, ZipInfo>();
    private static final Map<File, ZipInfo> PROJECT_ZIPINFOS = new HashMap<File, ZipInfo>();

    private ZipInfo(File file) {
        this.init();
        this.file = file;
    }

    private ZipInfo() {
        this.init();
    }

    private void init() {
        this.registerKeys(ENCODING);
    }

    @Override
    protected void processValueChanged(ValueChangeEvent valueChangeEvent) {
        super.processValueChanged(valueChangeEvent);
        this.dirty = true;
    }

    public static ZipInfo get(File file) {
        if (file == null) {
            return null;
        }
        ZipInfo zipInfo = ZIPINFOS.get(file = WorkingDirectory.toAbsolutePath(file));
        if (zipInfo == null) {
            zipInfo = new ZipInfo(file);
            ZipInfo zipInfo2 = PROJECT_ZIPINFOS.remove(file);
            if (zipInfo2 != null) {
                zipInfo.putValue(ENCODING, zipInfo2.getValue(ENCODING));
            }
            ZIPINFOS.put(file, zipInfo);
        }
        return zipInfo;
    }

    private static Path getConfigFile() {
        return Rflow.project().getConfDir().toPath().resolve("zip.yaml");
    }

    protected static void save() {
        if (Rflow.project().isNewProject()) {
            return;
        }
        try {
            Path path2 = ZipInfo.getConfigFile();
            Files.createDirectories(path2.getParent(), new FileAttribute[0]);
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            YamlEx yamlEx = new YamlEx();
            Consumer<Map.Entry> consumer = entry -> linkedHashMap.put(Rflow.project().toProjectAbstractPath((File)entry.getKey()), ((ZipInfo)entry.getValue()).toYamlValue(yamlEx));
            ZIPINFOS.entrySet().stream().filter(entry -> ((ZipInfo)entry.getValue()).isDirty()).forEach(consumer);
            PROJECT_ZIPINFOS.entrySet().stream().forEach(consumer);
            FileUtility.safeSave(path2, path2.getParent(), path -> yamlEx.dump(path.toFile(), linkedHashMap));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to zip info file settings.", exception);
        }
    }

    protected static void load() {
        try {
            Path path = ZipInfo.getConfigFile();
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            YamlEx yamlEx = new YamlEx();
            Map map = (Map)yamlEx.load(path.toFile());
            map.entrySet().stream().forEach(entry -> {
                File file = new File(Rflow.project().toProjectAbsolutePath((String)entry.getKey()));
                ZipInfo zipInfo = new ZipInfo();
                zipInfo.loadYamlValue(yamlEx, entry.getValue());
                zipInfo.dirty = false;
                PROJECT_ZIPINFOS.put(file, zipInfo);
                ZIPINFOS.remove(file);
            });
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Failed to read text file settings.", exception);
        }
    }

    public ZipFile createZipFile() throws IOException {
        String string = this.getEncoding();
        if (string.equals("<system_default>")) {
            string = Charset.defaultCharset().name();
        }
        return new ZipFile(this.file, string);
    }

    public String getEncoding() {
        return this.getValue(ENCODING);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    static {
        Rflow.getInstance().addRflowEventHandler(new RflowEventHandler(){

            @Override
            public void rflowWillShutdown() {
            }

            @Override
            public void rflowProjectWillEnd() {
                ZipInfo.save();
                ZIPINFOS.clear();
                PROJECT_ZIPINFOS.clear();
            }

            @Override
            public void rflowProjectDidStart() {
                ZipInfo.load();
            }
        });
    }
}

