/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.base.KeyModel;
import com.ef_prime.rflow.core.app.r.RArgKeyEntry;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTextKey;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditBackups;
import com.ef_prime.rflow.core.base.FileEditSupport;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ListAndDetailsKey;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.SplitPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TabWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.UIValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.Validator;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueErrors;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValueMapKey;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.ViewWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.util.YamlEx;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.RAddonOpData;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RAddonBuilderPreview;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.keyvalue.RArgEntryWidget;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RAddonBuilderModel
extends UIValueMap
implements FileEdit,
ChangeEventHandler {
    public static final String TYPE_NAME = "r-default";
    private File file;
    private FileEditSupport fileSupport = new FileEditSupport(this);
    private static final StrKey VERSION = StrKey.builder("version", "Version").build();
    private static final String TYPE_DEFAULT = "default";
    private static final String TYPE_CUSTOM_FUCTION = "custom";
    public static final RadioButtonKey TYPE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("type", "Type").setValuesAndLabels("default", "Default", "custom", "User Defined Function")).setLabelPosition("none")).build();
    private static final StrKey FUNCTION = ((StrKey.Builder)((StrKey.Builder)StrKey.builder("function", "Function").setRequired(true)).addVisibleKeyLink(TYPE, "default")).build();
    private static final RChoiceKey PACKAGE = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("package", "Package").addVisibleKeyLink(TYPE, "default")).setCompletionSupport(RChoiceProvider.packages())).build();
    private static final StrKey TITLE = ((StrKey.Builder)StrKey.builder("title", "Title").setDynamicDefault(true)).build();
    private static final BoolKey OUTPUT = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("output", "Output to Object").setDefaultValue(Boolean.TRUE)).setLabelPosition("none")).build();
    private static final BoolKey OUTPUT_REQUIRED = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("output_required", Messages.getString("Node.builder.key.required")).setDefaultValue(Boolean.TRUE)).setLabelPosition("none")).addVisibleKeyLink(OUTPUT, true)).build();
    private static final RStrKey OUTPUT_DEFAULT = ((RStrKey.Builder)RStrKey.builder("output_default", Messages.getString("Node.builder.key.default")).addVisibleKeyLink(OUTPUT, true)).build();
    private static final BoolKey PREVIEW = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("preview", "Enable preview").setDefaultValue(Boolean.TRUE)).setLabelPosition("none")).build();
    private static final ValueMapKey ARGS_ARG = ValueMapKey.builder("arg", "Arg", new RArgKeyEntry()).build();
    public static final ListAndDetailsKey ARGS = ((ListAndDetailsKey.Builder)ListAndDetailsKey.builderForCatalog("args", "Arguments", ARGS_ARG).setUnboundTableArea(true)).build();
    private static final RTextKey FUNCTION_DEFINITION = ((RTextKey.Builder)RTextKey.builder("function-definition", "Function Definition").setDefaultValue("function(){\n\t\n}")).build();
    private List<RPackage> autoPackages = Collections.emptyList();
    private static final RChoiceKey COL_PACKAGE_NAME = RChoiceKey.builder("name", "Name").build();
    private static final RTableKey PACKAGES = RTableKey.builder("packages", "Required Packages", COL_PACKAGE_NAME).build();

    public RAddonBuilderModel(File file) {
        this.loadResource();
        this.file = file;
        this.addChangeEventHandler(this);
        this.putValueQuietly(VERSION, "0.2");
    }

    @Override
    protected void initKeys() {
        this.registerKeys(VERSION, TYPE, TITLE, FUNCTION, PACKAGE, OUTPUT, OUTPUT_REQUIRED, OUTPUT_DEFAULT, PREVIEW, ARGS, FUNCTION_DEFINITION, PACKAGES);
    }

    public String getTitle() {
        return this.getValueOrDefault(TITLE);
    }

    @Override
    public boolean isValidationEnabled() {
        return true;
    }

    @Override
    protected void configureValidationContext(ValidationContext validationContext) {
        super.configureValidationContext(validationContext);
        validationContext.addValidator(TITLE, new Validator(){

            @Override
            public void validate(Key<?> key, Object object, ValidationContext validationContext) {
                String string = RAddonBuilderModel.this.getValueOrDefault(TITLE);
                if (string == null || string.isEmpty()) {
                    validationContext.addError(this, ValueErrors.required(TITLE));
                }
            }
        });
    }

    @Override
    public Object getDynamicDefaultValue(Key<?> key) {
        if (key == TITLE && this.getValue(TYPE).equals(TYPE_DEFAULT)) {
            return this.getValue(FUNCTION);
        }
        return super.getDynamicDefaultValue(key);
    }

    /*
     * WARNING - void declaration
     */
    public RAddonOpData getModelData(String string) {
        void var6_9;
        List<String> list;
        Object object;
        ArrayList arrayList = new ArrayList();
        if (this.getValue(OUTPUT).booleanValue()) {
            arrayList.add(((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("_output", "Output Object").setRequired(this.getValue(OUTPUT_REQUIRED))).setDefaultValue(this.getValue(OUTPUT_DEFAULT))).build());
        }
        int n = 0;
        DecimalFormat decimalFormat = new DecimalFormat("00");
        for (ValueMap object22 : this.getValue(ARGS).getValues(ARGS_ARG)) {
            object = (RArgKeyEntry)object22;
            list = ((RArgKeyEntry)object).getKeyModel();
            Object object2 = (String)((ValueMap)((Object)list)).getValue("id");
            if (((String)object2).isEmpty()) {
                object2 = "_empty" + decimalFormat.format(n++);
                list = (KeyModel)((Operation)((Object)list)).copy();
                ((ValueMap)((Object)list)).putValue((StrKey)((ValueMap)((Object)list)).getKey("id"), object2);
            }
            arrayList.add(((KeyModel)((Object)list)).getKey());
        }
        RPackage[] rPackageArray = new RPackage[]{};
        Object var6_7 = null;
        object = "";
        if (this.getValue(TYPE).equals(TYPE_CUSTOM_FUCTION)) {
            String string2 = this.getValue(FUNCTION_DEFINITION);
            list = this.getValue(PACKAGES).getValues(COL_PACKAGE_NAME);
            if (!list.isEmpty()) {
                rPackageArray = new RPackage[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    rPackageArray[i] = new RPackage((String)list.get(i), true, false);
                }
            }
        } else {
            object = this.getValue(FUNCTION);
            if (!this.getValue(PACKAGE).isEmpty()) {
                object = this.getValue(PACKAGE) + "::" + (String)object;
                rPackageArray = new RPackage[]{new RPackage(this.getValue(PACKAGE), true, false)};
            }
        }
        return RAddonOpData.function(this, string, this.getValueOrDefault(TITLE), (String)object, (String)var6_9, arrayList, rPackageArray, this.getValue(PREVIEW));
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        WidgetNode widgetNode = new PanelWidgetNode().addElements(FUNCTION_DEFINITION);
        widgetNode.addValueChangeEventHandler(new FunctionValueChangeEventHandler());
        TabPaneWidgetNode tabPaneWidgetNode = new TabPaneWidgetNode().addTabWithElements("Main", TYPE, FUNCTION, PACKAGE, OUTPUT, new PanelWidgetNode().setIndent(true).addVisibleKeyLink(OUTPUT, true).addElements(OUTPUT_REQUIRED, OUTPUT_DEFAULT), TITLE, PREVIEW).addTab("Parameters", new ViewWidgetNode(RArgEntryWidget.class).setGrowY(true)).addTab((TabWidgetNode)new TabWidgetNode("Function").add(widgetNode).addVisibleKeyLink(TYPE, TYPE_CUSTOM_FUCTION));
        WidgetNode widgetNode2 = new TabPaneWidgetNode().add(new ViewWidgetNode(RAddonBuilderPreview.class));
        return new SplitPaneWidgetNode(true, 0.6f).add(tabPaneWidgetNode).add(widgetNode2);
    }

    public String getFunction() {
        Object object = "";
        if (this.getValue(TYPE).equals(TYPE_DEFAULT)) {
            object = this.getValue(FUNCTION);
            if (!this.getValue(PACKAGE).isEmpty()) {
                object = this.getValue(PACKAGE) + "::" + (String)object;
            }
        }
        return object;
    }

    public boolean isTypeDefault() {
        return this.getValue(TYPE).equals(TYPE_DEFAULT);
    }

    public List<Choice> getArgChoices() {
        if (this.isTypeDefault()) {
            Object object = this.getValue(FUNCTION);
            if (!this.getValue(PACKAGE).isEmpty()) {
                object = this.getValue(PACKAGE) + "::" + (String)object;
            }
            return RChoiceProvider.args((String)object, false, null).getChoices(this);
        }
        return RChoiceProvider.args(this.getValue(FUNCTION_DEFINITION), false, null).getChoices(this);
    }

    public List<Choice> getArguments() {
        List<ValueMap> list = this.getValue(ARGS).getValues(ARGS_ARG);
        ArrayList<Choice> arrayList = new ArrayList<Choice>(list.size());
        for (ValueMap valueMap : list) {
            RArgKeyEntry rArgKeyEntry = (RArgKeyEntry)valueMap;
            arrayList.add(new Choice(rArgKeyEntry.getArgument()));
        }
        return arrayList;
    }

    public void load() throws IOException {
        this.putValueQuietly(VERSION, null);
        YamlEx yamlEx = new YamlEx();
        this.loadYamlValue(yamlEx, YamlEx.valueInYamlValue(yamlEx.load(this.file)));
        this.loaded();
    }

    public void load(Object object) {
        this.putValueQuietly(VERSION, null);
        YamlEx yamlEx = new YamlEx();
        this.loadYamlValue(yamlEx, YamlEx.valueInYamlValue(object));
        this.loaded();
    }

    private void loaded() {
        this.setDirty(false);
        if (this.getValue(VERSION).isEmpty()) {
            this.putValueQuietly(OUTPUT_REQUIRED, Boolean.FALSE);
        }
    }

    public boolean isNew() {
        return this.file == null;
    }

    @Override
    public String getFileEditName() {
        return this.file == null ? Messages.getString("Node.builder.new_title") : this.file.getName();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public void save(Path path) throws IOException {
        this.saveInternal(path);
        this.setDirty(false);
        FileEditBackups.getInstance().removeBackup(this);
    }

    @Override
    public void saveBackup(Path path) throws IOException {
        this.saveInternal(path);
        this.setDirtyForBackup(false);
    }

    private void saveInternal(Path path) throws IOException {
        this.setAutoPackages();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        new YamlEx().dump(path.toFile(), YamlEx.yamlValueWithType(TYPE_NAME, this));
    }

    @Override
    public void clearEdit() {
    }

    @Override
    public boolean canBackup() {
        return false;
    }

    @Override
    public FileEditSupport getFileEditSupport() {
        return this.fileSupport;
    }

    private void updateAutoPackages() {
        this.autoPackages = RPackage.detectRequiredPackages(this.getValue(FUNCTION_DEFINITION), false);
    }

    private void setAutoPackages() {
        this.getValue(PACKAGES).removeAllRows();
        int n = 0;
        for (RPackage rPackage : this.autoPackages) {
            this.getValue(PACKAGES).insertNewRow(n++, rPackage.getName(), false);
        }
    }

    @Override
    public void handleChanged(ChangeEvent changeEvent) {
        this.setDirty(true);
    }

    private class FunctionValueChangeEventHandler
    implements ValueChangeEventHandler {
        private FunctionValueChangeEventHandler() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            RAddonBuilderModel.this.updateAutoPackages();
        }
    }
}

