/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.SplitPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import java.awt.datatransfer.Transferable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RAggregate
extends ROperation {
    private static final String TYPE_SUM = "sum";
    private static final String TYPE_AVERAGE = "ave";
    private static final String TYPE_MEDIAN = "median";
    private static final String TYPE_MIN = "min";
    private static final String TYPE_MAX = "max";
    private static final String TYPE_COUNT = "count";
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Data").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("output", "Output").setAutoValueLink(DATA)).setRequired(true)).setOutput(true)).build();
    private static final ChoiceKey TYPE = ((ChoiceKey.Builder)ChoiceKey.builder("type", "Type").setValuesAndLabels("sum", "Sum", "ave", "Average", "median", "Median", "min", "Min", "max", "Max", "count", "Count")).build();
    private static final RChoiceKey TARGET = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("target", "Target").setCompletionSupport(RChoiceProvider.columns(DATA, true))).setRequired(true)).setObsolete(true)).build();
    private static final RChoiceKey COL_TARGET = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("col_target", "Target").setCompletionSupport(RChoiceProvider.columns(DATA, true))).setRequired(true)).build();
    private static final RTableKey TARGETS = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("targets", "Target", COL_TARGET).setUiControls(GeneralTableModel.UI_DEFAULT2)).setDefaultRowPredicate()).addInvisibleKeyLink(TYPE, "count")).build();
    private static final RChoiceKey COLUMN = ((RChoiceKey.Builder)RChoiceKey.builder("column", "Column").setCompletionSupport(RChoiceProvider.columns(DATA.getId(), true))).build();
    private static final RTableKey COLUMNS = ((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("columns", "Group By", COLUMN).setUiControls(GeneralTableModel.UI_DEFAULT2)).setDefaultRowPredicate()).build();
    private static final RTableKey ADVANCED = RAggregate.argsKey("stats:::aggregate.formula", "aggregate", "formula", "FUN");

    @Override
    public Version getVersion() {
        return new Version(0, 2, 1);
    }

    @Override
    public void updateVersion(Version version) {
        if (version.isOlderThan("0.1")) {
            this.getValue(TARGETS).addNewRow(this.getValue(TARGET));
        }
    }

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, OUTPUT, TYPE, TARGETS, COLUMNS, ADVANCED, TARGET);
    }

    @Override
    public String getDefaultTitle() {
        return "Aggregate";
    }

    @Override
    public String getOpClass() {
        return "transform";
    }

    @Override
    public boolean canImport(Transferable transferable) {
        return this.isDataOrColumns(transferable, DATA);
    }

    @Override
    protected void importValues(Transferable transferable) {
        this.importDataOrColumns(transferable, DATA, TARGETS, 0, true);
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            return RAggregate.suffix(this.getValue(DATA), ".aggregate");
        }
        return super.getAutoValue(key);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        List<String> list;
        List<String> list2 = this.getValue(COLUMNS).getValidValues(COLUMN);
        Object object = "";
        if (this.getValue(TYPE).equals(TYPE_COUNT)) {
            object = "cbind(n = 1:nrow(" + this.getValue(DATA) + ")) ";
        } else {
            list = this.getValue(TARGETS).getValidValues(COL_TARGET);
            if (!list.isEmpty()) {
                object = list.size() == 1 ? (String)list.get(0) : "cbind(" + StringUtils.join((Iterable)list, (String)", ") + ")";
                object = (String)object + " ";
            }
        }
        list = (String)object + "~ ";
        list = (String)((Object)list) + (list2.isEmpty() ? "1" : StringUtils.join(list2, (String)" + "));
        return RUtility.assignFunction(this.getValue(OUTPUT), "aggregate", this.getArgs(ADVANCED), new String[]{"", list, "data", this.getValue(DATA), "FUN", this.getFunctionOfType()});
    }

    private String getFunctionOfType() {
        switch (this.getValue(TYPE)) {
            case "sum": {
                return TYPE_SUM;
            }
            case "ave": {
                return "mean";
            }
            case "median": {
                return TYPE_MEDIAN;
            }
            case "min": {
                return TYPE_MIN;
            }
            case "max": {
                return TYPE_MAX;
            }
            case "count": {
                return "length";
            }
        }
        throw new RuntimeException("Unsupported type: " + this.getValue(TYPE));
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTabWithElements("Main", new SplitPaneWidgetNode(false, 0.5f).setGrowY(true).addElements(new PanelWidgetNode().addElements(DATA, OUTPUT, TYPE, TARGETS), new PanelWidgetNode().addElements(COLUMNS))).addTabWithElements("Advanced", ADVANCED);
    }
}

