/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.base.KeyModel;
import com.ef_prime.rflow.core.app.r.RAddonBuilderModel;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceProvider;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.MutableValue;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import java.util.List;

public class RChoiceKeyAutoModel
extends KeyModel {
    private static final String TYPE_OBJECTS = "objects";
    private static final String TYPE_COLUMNS = "columns";
    private static final String CTYPE_NUMERIC = "numeric";
    private static final String CTYPE_INTEGER = "integer";
    private static final String CTYPE_LOGICAL = "logical";
    private static final String CTYPE_CHARACTER = "character";
    private static final String CTYPE_FACTOR = "factor";
    protected static final RStrKey DEFAULT = RStrKey.builder("default", Messages.getString("Node.builder.key.default")).build();
    private static final ChoiceKey TYPE = ((ChoiceKey.Builder)ChoiceKey.builder("type", Messages.getString("Node.builder.key.type")).setValuesAndLabels("objects", Messages.getString("Node.builder.key.auto_choice.objects"), "columns", Messages.getString("Node.builder.key.auto_choice.columns"))).build();
    private static final ChoiceKey CLASS = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("class", Messages.getString("Node.builder.key.auto_choice.class")).setChoiceEditable(true)).showValueAndLabel(true)).setValuesAndLabels("", Messages.getString("Node.builder.key.auto_choice.all"), "data.frame", "", "matrix", "")).addVisibleKeyLink(TYPE, "objects")).build();
    private static final ChoiceKey KEY = ((ChoiceKey.Builder)((ChoiceKey.Builder)((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("key", Messages.getString("Node.builder.key.auto_choice.argument")).addVisibleKeyLink(TYPE, "columns")).setChoiceEditable(true)).showValueAndLabel(true)).setChoiceProvider(new ArgumentProvider())).build();
    private static final ChoiceKey COLUMN_TYPE = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("column_type", Messages.getString("Node.builder.key.auto_choice.column_type")).setValuesAndLabels("", Messages.getString("Node.builder.key.auto_choice.all"), "numeric", "", "integer", "", "logical", "", "character", "", "factor", "")).addVisibleKeyLink(TYPE, "columns")).build();

    public RChoiceKeyAutoModel() {
        this.registerKeys(ARGUMENT, TITLE, DEFAULT, REQUIRED, TYPE, CLASS, KEY, COLUMN_TYPE);
    }

    @Override
    public String getDefaultTitle() {
        return Messages.getString("Node.builder.key.auto_choice.title");
    }

    @Override
    public String getSmallIconKey() {
        return "16/combo_box.png";
    }

    @Override
    public Key<?> getKey() {
        RChoiceProvider rChoiceProvider = null;
        switch (this.getValue(TYPE)) {
            case "objects": {
                String string = this.getValue(CLASS);
                if (string.isEmpty()) {
                    rChoiceProvider = RChoiceProvider.globalObjects();
                    break;
                }
                rChoiceProvider = RChoiceProvider.inherits(string);
                break;
            }
            case "columns": {
                String string = this.getValue(COLUMN_TYPE);
                String string2 = "";
                switch (string) {
                    case "numeric": {
                        string2 = "is.numeric";
                        break;
                    }
                    case "integer": {
                        string2 = "is.integer";
                        break;
                    }
                    case "logical": {
                        string2 = "is.logical";
                        break;
                    }
                    case "character": {
                        string2 = "is.character";
                        break;
                    }
                    case "factor": {
                        string2 = "is.factor";
                        break;
                    }
                }
                rChoiceProvider = RChoiceProvider.names(this.getValue(KEY), false, string2);
            }
        }
        return ((RChoiceKey.Builder)((Key.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder(this.getValue(ARGUMENT), this.getValueOrDefault(TITLE_ARG)).setDefaultValue(this.getValue(DEFAULT))).setRequired(this.getValue(REQUIRED))).setCompletionSupport(rChoiceProvider)).setPreviewFunction(this.getPreviewFunction())).build();
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        return new PanelWidgetNode().addElements(TITLE_ARG, REQUIRED, TYPE, CLASS, KEY, COLUMN_TYPE, this.createPreviewWidgetNode());
    }

    private static class ArgumentProvider
    implements ChoiceProvider {
        private ArgumentProvider() {
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            RAddonBuilderModel rAddonBuilderModel = MutableValue.getParent(valueMap, RAddonBuilderModel.class);
            if (rAddonBuilderModel != null) {
                List<Choice> list = rAddonBuilderModel.getArguments();
                list.remove(new Choice(valueMap.getValue(ARGUMENT)));
                return list;
            }
            return EMPTY;
        }

        @Override
        public boolean isLabel() {
            return true;
        }

        @Override
        public boolean isDescription() {
            return false;
        }

        @Override
        public boolean isExclusive() {
            return false;
        }
    }
}

