/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.base.KeyModel;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.BasicValueError;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.Validator;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import java.util.ArrayList;
import java.util.List;

public class RChoiceKeyModel
extends KeyModel {
    protected static final RChoiceKey DEFAULT = ((RChoiceKey.Builder)RChoiceKey.builder("default", Messages.getString("Node.builder.key.default")).setChoiceProvider(new DefaultChoiceProvider())).build();
    protected static final BoolKey INPUT = ((BoolKey.Builder)BoolKey.builder("input", Messages.getString("Node.builder.key.choice.editable")).setDefaultValue(true)).build();
    private static final RStrKey COL_VALUE = ((RStrKey.Builder)RStrKey.builder("value", Messages.getString("Node.builder.key.choice.value")).setRequired(true)).build();
    private static final StrKey COL_LABEL = StrKey.builder("label", Messages.getString("Node.builder.key.choice.label")).build();
    private static final RTableKey CHOICES = ((RTableKey.Builder)RTableKey.builder("choices", Messages.getString("Node.builder.key.choice.choices"), COL_VALUE, COL_LABEL).setUiControls(GeneralTableModel.UI_DEFAULT2)).build();

    public RChoiceKeyModel() {
        this.registerKeys(ARGUMENT, TITLE_ARG, INPUT, DEFAULT, REQUIRED, CHOICES);
    }

    @Override
    public String getDefaultTitle() {
        return Messages.getString("Node.builder.key.choice.title");
    }

    @Override
    public String getSmallIconKey() {
        return "16/combo_box.png";
    }

    @Override
    public Key<?> getKey() {
        KeysTableModel keysTableModel = this.getValue(CHOICES);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        for (KeysTableRow keysTableRow : keysTableModel) {
            arrayList.add(keysTableRow.getValue(COL_VALUE));
            String string = keysTableRow.getValue(COL_LABEL);
            if (!string.isEmpty()) {
                bl = true;
            }
            arrayList2.add(string);
        }
        if (!this.getValue(INPUT).booleanValue() && arrayList.isEmpty()) {
            arrayList.add("");
        }
        RChoiceKey.Builder builder = (RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder(this.getValue(ARGUMENT), this.getValueOrDefault(TITLE_ARG)).setDefaultValue(this.getValue(DEFAULT))).setRequired(this.getValue(REQUIRED))).setChoiceEditable(this.getValue(INPUT))).setValues(arrayList.toArray(new String[arrayList.size()]))).setPreviewFunction(this.getPreviewFunction());
        if (bl) {
            builder.setLabels(arrayList2.toArray(new String[arrayList2.size()]));
            builder.showValueAndLabel(true);
        }
        return builder.build();
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        return new PanelWidgetNode().addElements(TITLE_ARG, REQUIRED, CHOICES, INPUT, DEFAULT, this.createPreviewWidgetNode());
    }

    @Override
    protected void configureValidationContext(ValidationContext validationContext) {
        Validator validator = new Validator(){

            @Override
            public void validate(Key<?> key, Object object, ValidationContext validationContext) {
                List<String> list;
                if (!(RChoiceKeyModel.this.getValue(INPUT).booleanValue() || RChoiceKeyModel.this.getValue(DEFAULT).isEmpty() || (list = RChoiceKeyModel.this.getValue(CHOICES).getValues(COL_VALUE)).contains(RChoiceKeyModel.this.getValue(DEFAULT)))) {
                    validationContext.addError(this, new BasicValueError(4, "Value must be one of the choices.", DEFAULT));
                }
            }
        };
        validationContext.addValidator(CHOICES, validator);
        validationContext.addValidator(DEFAULT, validator);
    }

    private static class DefaultChoiceProvider
    extends RChoiceProvider {
        private DefaultChoiceProvider() {
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            KeysTableModel keysTableModel = valueMap.getValue(CHOICES);
            ArrayList<Choice> arrayList = new ArrayList<Choice>(keysTableModel.getRowCount());
            for (KeysTableRow keysTableRow : keysTableModel) {
                String string = keysTableRow.getValue(COL_VALUE);
                String string2 = keysTableRow.getValue(COL_LABEL);
                arrayList.add(new Choice(string, string2));
            }
            return arrayList;
        }

        @Override
        public boolean isLabel() {
            return true;
        }

        @Override
        public Object toYaml() {
            return null;
        }
    }
}

