/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RAnonymousFunction;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RArgsKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.AutoValueLink;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.MultipleKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.SplitPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;

public class RCluster
extends ROperation {
    private static final String VAR_NUMERIC = "numeric";
    private static final String VAR_SELECT = "select";
    private static final String VAR_ALL = "all";
    private static final String TYPE_HIERARCHICAL = "hierarchical";
    private static final String TYPE_KMEANS = "kmeans";
    private static final String SCALE_NONE = "none";
    private static final String SCALE_STANDARDIZATION = "standardization";
    private static final String SCALE_NORMALIZATION = "normalization";
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Data").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((Key.Builder)RStrKey.builder("_output", "Output").setOutput(true)).setAutoValueLink("data", "type")).build();
    private static final ChoiceKey VARIABLE = ((ChoiceKey.Builder)ChoiceKey.builder("variable", "Variable").setValuesAndLabels("numeric", "All Numerics", "select", "Select", "all", "All Variables")).build();
    private static final RChoiceKey VAR = ((RChoiceKey.Builder)RChoiceKey.builder("var", "Var").setChoiceProvider(RChoiceProvider.columns(DATA, false))).build();
    private static final RTableKey VARIABLES = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("variables", "Variables", VAR).setUiControls(GeneralTableModel.UI_DEFAULT2)).addVisibleKeyLink(VARIABLE, "select")).setDefaultRowPredicate()).setLabelPosition("none")).setRequired(true)).build();
    private static final BoolKey COERCE_TO_NUMERIC = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("coerce_to_numeric", "Coerce to numeric").setLabelPosition("none")).addVisibleKeyLink(VARIABLE, "select", "all")).build();
    private static final ChoiceKey SCALE_TYPE = ((ChoiceKey.Builder)ChoiceKey.builder("scale_type", "Scaling").setValuesAndLabels("none", "None", "standardization", "Mean 0, Variance 1", "normalization", "Min 0, Max 1")).build();
    private static final BoolKey OUTPUT_CLUSTER = ((BoolKey.Builder)BoolKey.builder("output_cluster", "Output cluster ID").setLabelPosition("none")).build();
    private static final RStrKey CLUSTER_OUT_NAME = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("cluster_out_name", "Name").addVisibleKeyLink(OUTPUT_CLUSTER, true)).setRequired(true)).setDefaultValue("cluster")).build();
    private static final BoolKey ADD_TO_DATA = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("add_to_data", "Add column to input data").setLabelPosition("none")).setDefaultValue(Boolean.TRUE)).addVisibleKeyLink(OUTPUT_CLUSTER, true)).build();
    private static final RadioButtonKey TYPE = ((RadioButtonKey.Builder)RadioButtonKey.builder("type", "Type").setValuesAndLabels("hierarchical", "Hierarchical", "kmeans", "K-means")).build();
    private static final RChoiceKey DISTANCE = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("distance", "Distance").addVisibleKeyLink(TYPE, "hierarchical")).setChoiceEditable(false)).setValuesAndLabels(RCluster.sQuote("euclidean"), "Euclidean / L2 Norm", RCluster.sQuote("maximum"), "Maximum / L\u221e Norm", RCluster.sQuote("manhattan"), "Manhattan / L1 Norm", RCluster.sQuote("canberra"), "Canberra", RCluster.sQuote("binary"), "Binary", RCluster.sQuote("minkowski"), "Minkowski / Lp Norm")).build();
    private static final RStrKey P = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("p", "P").addKeyLink(KeyLink.visible(StrKeyTest.create(DISTANCE, RCluster.sQuote("minkowski"))))).setDefaultValue("2")).build();
    private static final RChoiceKey METHOD = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("method", "Method").addVisibleKeyLink(TYPE, "hierarchical")).setChoiceEditable(false)).setValuesAndLabels(RCluster.sQuote("ward.D2"), "Ward", RCluster.sQuote("single"), "Single / Nearest Neighbour", RCluster.sQuote("complete"), "Complete / Farthest Neighbour", RCluster.sQuote("average"), "Average / UPGMA", RCluster.sQuote("mcquitty"), "McQuitty / WPGMA", RCluster.sQuote("median"), "Median / WPGMC", RCluster.sQuote("centroid"), "Centroid / UPGMC", RCluster.sQuote("ward.D"), "Ward [Older Implementation]")).build();
    private static final RStrKey N_CLUSTER = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("n_cluster", "Number of Clusters").addKeyLink(KeyLink.visible(MultipleKeyTest.and(StrKeyTest.create(TYPE, "hierarchical"), BoolKeyTest.create(OUTPUT_CLUSTER, true))))).setDefaultValue("3")).build();
    private static final RStrKey CENTERS = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("centers", "Number of Clusters (or Initial Centers Matrix)").addVisibleKeyLink(TYPE, "kmeans")).setDefaultValue("3")).build();
    private static final RStrKey ITER_MAX = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("iter.max", "Maximum Number of Iterations").addVisibleKeyLink(TYPE, "kmeans")).setDefaultValue("10")).build();
    private static final RStrKey NSTART = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("nstart", "Number of Initial Random Clusters").addVisibleKeyLink(TYPE, "kmeans")).setDefaultValue("25")).build();
    private static final RChoiceKey ALGORITHM = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("algorithm", "Algorithm").addVisibleKeyLink(TYPE, "kmeans")).setChoiceEditable(false)).setValuesAndLabels(RCluster.sQuote("Hartigan-Wong"), "Hartigan and Wong", RCluster.sQuote("Lloyd"), "Lloyd (= Forgy)", RCluster.sQuote("Forgy"), "Forgy (= Lloyd)", RCluster.sQuote("MacQueen"), "MacQueen")).build();
    private static final BoolKey EXCLUDE_NON_FINITE = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("exclude_non_finite", "Exclude rows with NA, NaN, Inf or -Inf").setLabelPosition("none")).setDefaultValue(Boolean.TRUE)).build();
    private static final ChoiceKey ARGS_SWITCH = RCluster.argsSwitchKey("args_switch", new AutoValueLink(true, TYPE), "hclust", "dist", "cutree", "kmeans", "fitted");
    private static final RArgsKey ARGS_HCLUST = RCluster.argsKey("args_hclust", "hclust", null, ARGS_SWITCH, "d");
    private static final RArgsKey ARGS_DIST = RCluster.argsKey("args_dist", "dist", null, ARGS_SWITCH, "x");
    private static final RArgsKey ARGS_CUTREE = RCluster.argsKey("args_cutree", "cutree", null, ARGS_SWITCH, "tree", "k");
    private static final RArgsKey ARGS_KMEANS = RCluster.argsKey("args_kmeans", "kmeans", null, ARGS_SWITCH, "x");
    private static final RArgsKey ARGS_FITTED = RCluster.argsKey("args_fited", "stats:::fitted.kmeans", "fitted", ARGS_SWITCH, "object");

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, OUTPUT, VARIABLE, VARIABLES, COERCE_TO_NUMERIC, SCALE_TYPE, OUTPUT_CLUSTER, ADD_TO_DATA, CLUSTER_OUT_NAME, TYPE, DISTANCE, P, METHOD, N_CLUSTER, CENTERS, ITER_MAX, NSTART, ALGORITHM, EXCLUDE_NON_FINITE, ARGS_SWITCH, ARGS_HCLUST, ARGS_DIST, ARGS_CUTREE, ARGS_KMEANS, ARGS_FITTED);
    }

    @Override
    protected String getDefaultTitle() {
        return "Cluster Analysis";
    }

    @Override
    public String getOpClass() {
        return "summary";
    }

    @Override
    protected StrKey getRObjectImportKey() {
        return DATA;
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            return RCluster.suffix(this.getValue(DATA), switch (this.getValue(TYPE)) {
                case TYPE_HIERARCHICAL -> ".hc";
                default -> ".km";
            });
        }
        if (ARGS_SWITCH.equals(key)) {
            switch (this.getValue(TYPE)) {
                case "hierarchical": {
                    return ARGS_HCLUST.getFunction();
                }
            }
            return ARGS_KMEANS.getFunction();
        }
        return super.getAutoValue(key);
    }

    private String rows(String string) {
        return "apply(" + string + ", 1, function(x) { all(is.finite(x)) })";
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        RAnonymousFunction rAnonymousFunction = new RAnonymousFunction();
        rAnonymousFunction.addArgs("x", RCluster.data(this.getValue(DATA), previewOption));
        ScriptBuilder scriptBuilder = RCluster.scriptBuilder();
        scriptBuilder.appLnInd(rAnonymousFunction.getHeadStr());
        boolean bl3 = this.getValue(COERCE_TO_NUMERIC);
        switch (this.getValue(VARIABLE)) {
            case "numeric": {
                scriptBuilder.appendLn("if (is.data.frame(x)) {");
                scriptBuilder.indentLn("x <- x[, sapply(x, is.numeric), drop = FALSE]");
                scriptBuilder.unind_Ln("} else {");
                scriptBuilder.indentLn("stopifnot(is.numeric(x))");
                scriptBuilder.unind_Ln("}");
                bl3 = false;
                break;
            }
            case "select": {
                object = this.getValue(VARIABLES).getValidValues(VAR);
                scriptBuilder.appendLn("x <- x[, " + RUtility.combineCharacters(object) + "]");
                break;
            }
        }
        if (this.getValue(EXCLUDE_NON_FINITE).booleanValue()) {
            scriptBuilder.appendLn("n <- nrow(x)");
            scriptBuilder.appendLn("rows <- " + this.rows("x"));
            scriptBuilder.appendLn("x <- x[rows, ]");
        }
        if (bl3) {
            scriptBuilder.appendLn("x <- if(is.data.frame(x)) {");
            scriptBuilder.indentLn("do.call(cbind, lapply(x, as.numeric))");
            scriptBuilder.unind_Ln("} else {");
            scriptBuilder.indentLn("as.numeric(x)");
            scriptBuilder.unind_Ln("}");
        }
        switch (this.getValue(SCALE_TYPE)) {
            case "standardization": {
                scriptBuilder.appendLn("allSame <- apply(x, 2, function(x) {r <- range(x, finite = TRUE); any(is.infinite(r)) || diff(r) == 0})");
                scriptBuilder.appendLn("x <- scale(x)");
                scriptBuilder.appendLn("x[, allSame] <- 0");
                break;
            }
            case "normalization": {
                scriptBuilder.appendLn("allSame <- apply(x, 2, function(x) {r <- range(x, finite = TRUE); any(is.infinite(r)) || diff(r) == 0})");
                scriptBuilder.appendLn("x <- apply(x, 2, function(x){ (max(x) - x) / (max(x) - min(x)) })");
                scriptBuilder.appendLn("x[, allSame] <- 0.5");
                break;
            }
        }
        boolean bl4 = !this.getValue(OUTPUT).isEmpty();
        String string = "";
        if (this.getValue(OUTPUT_CLUSTER).booleanValue() && this.getValue(EXCLUDE_NON_FINITE).booleanValue() || !bl4) {
            string = "model";
        }
        switch (this.getValue(TYPE)) {
            case "hierarchical": {
                scriptBuilder.appendLn(RUtility.assignFunction("d", "dist", this.getArgs(ARGS_DIST), "x", "x", "method", this.getValue(DISTANCE), "p", this.getValue(DISTANCE).equals(RCluster.sQuote("minkowski")) ? this.getValue(P) : ""));
                scriptBuilder.appendLn(RUtility.assignFunction(string, "hclust", this.getArgs(ARGS_HCLUST), "d", "d", "method", this.getValue(METHOD)));
                break;
            }
            default: {
                scriptBuilder.appendLn(RUtility.assignFunction(string, TYPE_KMEANS, this.getArgs(ARGS_KMEANS), "x", "x", "centers", this.getValue(CENTERS), "iter.max", this.getValue(ITER_MAX), "nstart", this.getValue(NSTART), "algorithm", this.getValue(ALGORITHM)));
            }
        }
        if (!this.getValue(OUTPUT_CLUSTER).booleanValue()) {
            scriptBuilder.unind_Ln(rAnonymousFunction.getTailStr());
            return RUtility.assign(this.getValue(OUTPUT), scriptBuilder.toString());
        }
        String string2 = string.isEmpty() ? this.getValue(OUTPUT) : string;
        Object object = switch (this.getValue(TYPE)) {
            case TYPE_HIERARCHICAL -> RUtility.function("cutree", this.getArgs(ARGS_CUTREE), "tree", string2, "k", this.getValue(N_CLUSTER));
            default -> RUtility.function("fitted", this.getArgs(ARGS_FITTED), "object", string2, "method", RCluster.sQuote("classes"));
        };
        if (this.getValue(EXCLUDE_NON_FINITE).booleanValue() || !bl4) {
            if (bl4) {
                scriptBuilder.appendLn(RUtility.function("assign", "x", RCluster.quote(this.getValue(OUTPUT)), "value", string, "pos", "parent.frame()"));
            }
            if (this.getValue(EXCLUDE_NON_FINITE).booleanValue()) {
                scriptBuilder.appendLn(RUtility.assign(this.getValue(CLUSTER_OUT_NAME), "rep(NA, n)"));
                scriptBuilder.appendLn(RUtility.assign(this.getValue(CLUSTER_OUT_NAME) + "[rows]", (String)object));
                scriptBuilder.appendLn(this.getValue(CLUSTER_OUT_NAME));
            } else {
                scriptBuilder.appendLn((CharSequence)object);
            }
            scriptBuilder.unind_Ln(rAnonymousFunction.getTailStr());
            return this.assignToCluster(previewOption, scriptBuilder.toString());
        }
        scriptBuilder.unind_Ln(rAnonymousFunction.getTailStr());
        Object object2 = RCluster.scriptBuilder();
        ((ScriptBuilder)object2).append(RUtility.assign(this.getValue(OUTPUT), scriptBuilder.toString()));
        ((ScriptBuilder)object2).append(this.assignToCluster(previewOption, (String)object));
        return ((ScriptBuilder)object2).toString();
    }

    private String assignToCluster(PreviewOption previewOption, String string) {
        if (previewOption.isEnabled() && this.getValue(ADD_TO_DATA).booleanValue()) {
            return RUtility.assign(this.getValue(DATA), RUtility.function("`[<-`", "", RCluster.data(this.getValue(DATA), previewOption), "", " ", "", RCluster.quote(this.getValue(CLUSTER_OUT_NAME)), "", string));
        }
        if (this.getValue(ADD_TO_DATA).booleanValue()) {
            return RUtility.assign(this.getValue(DATA) + "[, " + RCluster.quote(this.getValue(CLUSTER_OUT_NAME)) + "]", string);
        }
        return RUtility.assign(this.getValue(CLUSTER_OUT_NAME), string);
    }

    @Override
    protected String[] getNewRObjects() {
        String string;
        if (!this.getValue(OUTPUT_CLUSTER).booleanValue()) {
            return new String[]{this.getValue(OUTPUT)};
        }
        String string2 = string = this.getValue(ADD_TO_DATA) != false ? this.getValue(DATA) : this.getValue(CLUSTER_OUT_NAME);
        if (this.getValue(OUTPUT).isEmpty()) {
            return new String[]{string};
        }
        return new String[]{this.getValue(OUTPUT), string};
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTab("Main", new SplitPaneWidgetNode(false, 0.5f).addElements(new PanelWidgetNode().addElements(DATA, OUTPUT, VARIABLE, VARIABLES, COERCE_TO_NUMERIC, SCALE_TYPE), new PanelWidgetNode().addElements(PanelWidgetNode.noScroll().addKeys(TYPE), DISTANCE, P, METHOD, CENTERS, OUTPUT_CLUSTER, PanelWidgetNode.indent().addElements(CLUSTER_OUT_NAME, ADD_TO_DATA, N_CLUSTER)))).addTab("Options", new PanelWidgetNode().addElements(EXCLUDE_NON_FINITE, ITER_MAX, NSTART, ALGORITHM)).addTabWithElements("Advanced", ARGS_SWITCH, ARGS_HCLUST, ARGS_DIST, ARGS_CUTREE, ARGS_KMEANS, ARGS_FITTED);
    }

    @Override
    public Version getVersion() {
        return new Version(0, 0, 0, 1);
    }
}

