/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;

public class RCorCov
extends ROperation {
    private static final String TYPE_COR = "cor";
    private static final String TYPE_COV = "cov";
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Data").setCompletionSupport(RChoiceProvider.inheritsOrMatrices(new String[]{"data.frame"}, new String[]{"double", "integer"}))).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).build();
    private static final ChoiceKey TYPE = ((ChoiceKey.Builder)ChoiceKey.builder("type", "Type").setValuesAndLabels("cor", "Correlation", "cov", "Variance and Covariance")).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("_output", "Output").setAutoValueLink(DATA, TYPE)).setRequired(true)).setOutput(true)).build();
    private static final RChoiceKey METHOD = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("method", "Method").setValuesAndLabels(RCorCov.quote("pearson"), "Pearson's r", RCorCov.quote("spearman"), "Spearman's rho (rank)", RCorCov.quote("kendall"), "Kendall's tau (rank)")).setDefaultValue(RCorCov.quote("pearson"))).build();
    private static final RChoiceKey USE = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("use", "Ignore Data with Missing Values").setValuesAndLabels(RCorCov.quote("everything"), "Do Not Ignore", RCorCov.quote("na.or.complete"), "by Rows", RCorCov.quote("pairwise.complete.obs"), "by Each Pair of Variables")).setDefaultValue(RCorCov.quote("everything"))).build();

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, OUTPUT, TYPE, METHOD, USE);
    }

    @Override
    protected String getDefaultTitle() {
        return "Correlation/Covariance Matrix";
    }

    @Override
    public String getOpClass() {
        return "summary";
    }

    @Override
    protected StrKey getRObjectImportKey() {
        return DATA;
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            String string = this.getValue(TYPE).equals(TYPE_COR) ? ".cor" : ".cov";
            return RCorCov.suffix(this.getValue(DATA), string);
        }
        return super.getAutoValue(key);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        String string = this.getValue(TYPE).equals(TYPE_COR) ? TYPE_COR : TYPE_COV;
        String string2 = "if(is.data.frame($x)) $x[, sapply($x, is.numeric), drop = FALSE] else $x";
        string2 = string2.replaceAll("\\$x", this.getValue(DATA));
        return RUtility.assignFunction(this.getValue(OUTPUT), string, "\n\tx", string2, "\n\tuse", this.getValue(USE), "method", this.getValue(METHOD));
    }

    @Override
    protected int getSplitHeight() {
        return 190;
    }
}

