/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.RAddColumnEntry;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.HasValueLink;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueSetter;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import java.util.HashSet;
import java.util.List;

@Deprecated
public class RCreateDummy
extends ROperation
implements ValueSetter,
HasValueLink,
RAddColumnEntry {
    private static final String TARGET_ALL = "all";
    private static final String TARGET_CHOOSE = "choose";
    private static final String VALUE_ONE_ZERO = "1_0";
    private static final String VALUE_TRUE_FALSE = "true_false";
    private static final String NAME_VALUE = "value";
    private static final String NAME_AUTO_PREFIX = "prefix";
    private static final String NAME_AUTO_SUFFIX = "suffix";
    private static final StrKey KEY_DATA = ((StrKey.Builder)StrKey.builder("data").setHidden(true)).build();
    private static final RChoiceKey KEY_COLUMN = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("column", "Column").setCompletionSupport(RChoiceProvider.columns(KEY_DATA, false))).setRequired(true)).build();
    private static final ChoiceKey KEY_TARGET = ((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("target", "Target").setValues("all", "choose")).setLabels("All", "Choose")).build();
    private static final RChoiceKey COL_VALUE = ((RChoiceKey.Builder)RChoiceKey.builder("value", "Value").setCompletionSupport(RChoiceProvider.levels("data", "column"))).build();
    private static final RTableKey KEY_TARGET_VALUES = ((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("target_values", "Target Values", COL_VALUE).setUiControls(GeneralTableModel.UI_DEFAULT2)).addVisibleKeyLink(KEY_TARGET, "choose")).build();
    private static final ChoiceKey KEY_VALUE = ((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("value", "Value").setValues("1_0", "true_false")).setLabels("0/1", "TRUE/FALSE")).build();
    private static final ChoiceKey KEY_NAME_AUTO_TYPE = ((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("name_auto_type", "Name").setValues("prefix", "suffix", "value")).setLabels("Prefix", "Suffix", "Value")).build();
    private static final StrKey KEY_NAME_SEPARATOR = ((StrKey.Builder)((StrKey.Builder)StrKey.builder("name_separator", "Separator").setDefaultValue("_")).addInvisibleKeyLink(KEY_NAME_AUTO_TYPE, "value")).build();

    @Override
    protected void initKeys() {
        this.registerKeys(KEY_COLUMN, KEY_TARGET, KEY_TARGET_VALUES, KEY_VALUE, KEY_NAME_AUTO_TYPE, KEY_NAME_SEPARATOR);
        this.registerKeys(KEY_DATA);
    }

    @Override
    public String getDefaultTitle() {
        return "Dummy";
    }

    @Override
    public String getSummary() {
        return "Dummy (" + this.getColumn() + ")";
    }

    @Override
    public String getDescription() {
        return "\u30ab\u30c6\u30b4\u30ea\u5909\u6570\u3092TRUE/FALSE\u306a\u3069\u306e\u30c0\u30df\u30fc\u5909\u6570\u306b\u5909\u63db\u3057\u307e\u3059\u3002";
    }

    @Override
    public String getSmallIconKey() {
        return "16/no_requirements.png";
    }

    private String getColumn() {
        return this.getValue(KEY_COLUMN);
    }

    private String getValuePair() {
        String string = this.getValue(KEY_VALUE);
        if (VALUE_TRUE_FALSE.equals(string)) {
            return "c(TRUE, FALSE)";
        }
        return "c(1L, 0L)";
    }

    private List<String> getTargetValues() {
        return this.getValue(KEY_TARGET_VALUES).getValues(COL_VALUE);
    }

    private String getName(String string, String string2) {
        String string3 = this.getValue(KEY_NAME_SEPARATOR);
        switch (this.getValue(KEY_NAME_AUTO_TYPE)) {
            case "value": {
                return "as.character(" + string2 + ")";
            }
            case "prefix": {
                return "paste(" + string + ", " + string2 + ", sep=" + RUtility.quote(string3) + ")";
            }
        }
        return "paste(" + string2 + ", " + string + ", sep=" + RUtility.quote(string3) + ")";
    }

    public String toString() {
        return this.getSummary();
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        return super.getContentWidgetNode(viewOptions);
    }

    @Override
    public String getScript(String string) {
        ScriptBuilder scriptBuilder = new ScriptBuilder("\n");
        scriptBuilder.appendLn("temp <- local({");
        scriptBuilder.appendLn("n <- nrow(" + string + ")");
        scriptBuilder.appendLn("column <- " + RUtility.quote(this.getColumn()));
        scriptBuilder.appendLn("value <- " + this.getValuePair());
        if (this.getValue(KEY_TARGET).equals(TARGET_CHOOSE)) {
            scriptBuilder.appendLn("labels <- " + RUtility.combine(this.getTargetValues()));
            scriptBuilder.appendLn("x <- matrix(value[2], n, length(labels))");
            scriptBuilder.appendLn("columnNames <- character()");
            scriptBuilder.appendLn("for (i in seq_along(labels)) {");
            scriptBuilder.appendLn("    x[, i][data[[column]] == labels[i]] <- value[1]");
            scriptBuilder.appendLn("    columnNames[i] <- " + this.getName("column", "labels[i]"));
            scriptBuilder.appendLn("}");
        } else {
            scriptBuilder.appendLn("cl <- as.factor(data[[column]])");
            scriptBuilder.appendLn("labels <- levels(cl)");
            scriptBuilder.appendLn("x <- matrix(value[2], n, length(labels))");
            scriptBuilder.appendLn("x[(1L:n) + n * (unclass(cl) - 1L)] <- value[1]");
            scriptBuilder.appendLn("columnNames <- character()");
            scriptBuilder.appendLn("for (i in seq_along(labels)) {");
            scriptBuilder.appendLn("    columnNames[i] <- " + this.getName("column", "labels[i]"));
            scriptBuilder.appendLn("}");
        }
        scriptBuilder.appendLn("dimnames(x) <- list(NULL, columnNames)");
        scriptBuilder.appendLn("x");
        scriptBuilder.appendLn("})");
        scriptBuilder.appendLn(string + "[,colnames(temp)] <- temp");
        return scriptBuilder.toString();
    }

    @Override
    public void setValue(Key<?> key, Object object) {
        if (!key.equals(KEY_TARGET_VALUES) || !(object instanceof List)) {
            return;
        }
        KeysTableModel keysTableModel = this.getValue(KEY_TARGET_VALUES);
        HashSet<String> hashSet = new HashSet<String>(this.getTargetValues());
        List list = (List)object;
        for (Object e : list) {
            String string = e.toString();
            if (hashSet.contains(string)) continue;
            keysTableModel.insertNewRow(keysTableModel.getRowCount(), string);
        }
    }

    @Override
    public String[] getValueLinkNames() {
        return new String[]{"r.input"};
    }

    @Override
    public Key<?> getValueLinkKey(String string) {
        if ("r.input".equals(string)) {
            return KEY_DATA;
        }
        return null;
    }
}

