/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RTypeGuesser;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RArgsKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.common.keyvalue.AutoValueLink;
import com.ef_prime.rflow.core.common.keyvalue.BasicValueError;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.UnboundTableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.Validator;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.UnboundTableModel;
import com.ef_prime.rflow.core.util.ArgsList;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RDirectDataInput
extends ROperation {
    private static final String TYPE_DATAFRAME = "data.frame";
    private static final String TYPE_MATRIX = "matrix";
    private static final String TYPE_VECTOR = "vector";
    private static final String VECTOR_READ_BY_ROW = "row";
    private static final String VECTOR_READ_BY_COLUMN = "column";
    private static final UnboundTableKey DATA = UnboundTableKey.builder("data", "Input Data").build();
    private static final ChoiceKey TYPE = ((ChoiceKey.Builder)ChoiceKey.builder("type", "Type").setValuesAndLabels("data.frame", "Data Frame", "matrix", "Matrix", "vector", "Vector")).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("_output", "Output Object").setRequired(true)).setAutoValueLink(TYPE)).build();
    private static final BoolKey HEADER = ((BoolKey.Builder)((Key.Builder)BoolKey.builder("header", "Header").setText("Use 1st Row")).addInvisibleKeyLink(TYPE, "vector")).build();
    private static final BoolKey ROW_NAMES = ((BoolKey.Builder)((Key.Builder)BoolKey.builder("row.names", "Row Names").setText("Use 1st Column")).addInvisibleKeyLink(TYPE, "vector")).build();
    private static final ChoiceKey VECTOR_READ_BY = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("vector_read_by", "Read by").setValuesAndLabels("row", "Row", "column", "Column")).addVisibleKeyLink(TYPE, "vector")).build();
    private static final BoolKey VECTOR_NAMES = ((BoolKey.Builder)BoolKey.builder("vector_names", "Names Included").addVisibleKeyLink(TYPE, "vector")).build();
    private static final ChoiceKey COL_NA_STRINGS = ((ChoiceKey.Builder)((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("col_na.strings", "Missing Value").setValuesAndLabels("", "Empty String", "NA", "")).setChoiceEditable(true)).showValueAndLabel(true)).build();
    private static final TableKey VECTOR_NA_STRINGS = ((TableKey.Builder)((TableKey.Builder)TableKey.builder("na.strings", "Interpret as Missing Values:", COL_NA_STRINGS).setUiControls(GeneralTableModel.UI_DEFAULT2)).addRow("")).build();
    private static final RChoiceKey STRINGS_AS_FACTORS = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("stringsAsFactors", "Convert Characters to Factors").setDefaultValue("FALSE")).setValues("", "TRUE", "FALSE")).addVisibleKeyLink(TYPE, "data.frame")).build();
    private static final RChoiceKey CHECK_NAMES = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("check.names", "Convert Invalid Column Names").setDefaultMessage("TRUE")).setValues("", "TRUE", "FALSE")).addVisibleKeyLink(TYPE, "data.frame")).build();
    private static final BoolKey CHECK_NAMES2 = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("check.names2", "Convert Invalid Column Names").setDefaultValue(Boolean.TRUE)).addVisibleKeyLink(TYPE, "data.frame")).build();
    private static final ChoiceKey ARGS_SWITCH = RDirectDataInput.argsSwitchKey("args_switch", new AutoValueLink(true, TYPE), "data.frame", "matrix");
    private static final RArgsKey ARGS_DATA_FRAME = RDirectDataInput.argsKey("args_dataframe", "data.frame", null, ARGS_SWITCH, new String[0]);
    private static final RArgsKey ARGS_MATRIX = RDirectDataInput.argsKey("args_matrix", "matrix", null, ARGS_SWITCH, new String[0]);

    @Override
    public Version getVersion() {
        return new Version(0, 1, 0);
    }

    @Override
    public void updateVersion(Version version) {
        if (version.isOlderThan("0.1")) {
            String string = this.getValue(CHECK_NAMES);
            boolean bl = !string.equals("FALSE") && !string.equals("F");
            this.putValue(CHECK_NAMES2, bl);
        }
    }

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, OUTPUT, TYPE, HEADER, ROW_NAMES, VECTOR_READ_BY, VECTOR_NAMES, STRINGS_AS_FACTORS, CHECK_NAMES, CHECK_NAMES2, VECTOR_NA_STRINGS, ARGS_SWITCH, ARGS_DATA_FRAME, ARGS_MATRIX);
    }

    @Override
    protected String getDefaultTitle() {
        return "Enter Data";
    }

    @Override
    public String getOpClass() {
        return "io";
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            switch (this.getValue(TYPE)) {
                case "matrix": {
                    return "mat";
                }
                case "vector": {
                    return "vec";
                }
            }
            return "dat";
        }
        if (ARGS_SWITCH.equals(key)) {
            switch (this.getValue(TYPE)) {
                case "data.frame": {
                    return ARGS_DATA_FRAME.getFunction();
                }
                case "matrix": {
                    return ARGS_MATRIX.getFunction();
                }
            }
        }
        return super.getAutoValue(key);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        List<Object> list;
        int n;
        boolean bl3;
        UnboundTableModel unboundTableModel = this.getValue(DATA);
        int n2 = -1;
        if (unboundTableModel.getRowCount() * unboundTableModel.getColumnCount() > 10000) {
            n2 = 10000 / unboundTableModel.getColumnCount();
        }
        if (previewOption.isEnabled() && !previewOption.useAllRows()) {
            n2 = Math.min(n2, (int)previewOption.getNumber());
        }
        Iterator iterator = unboundTableModel.iterator();
        if (n2 >= 0) {
            iterator = Iterators.limit(iterator, (int)n2);
        }
        ScriptBuilder scriptBuilder = new ScriptBuilder("\n", unboundTableModel.getRowCount() * unboundTableModel.getColumnCount() * 6);
        ArrayList<Object> arrayList = new ArrayList<Object>(0);
        int n3 = unboundTableModel.getColumnCount();
        int n4 = 0;
        boolean bl4 = !this.getValue(TYPE).equals(TYPE_VECTOR) && this.getValue(ROW_NAMES) != false || this.getValue(TYPE).equals(TYPE_VECTOR) && this.getValue(VECTOR_NAMES) != false && this.getValue(VECTOR_READ_BY).equals(VECTOR_READ_BY_COLUMN);
        boolean bl5 = bl3 = !this.getValue(TYPE).equals(TYPE_VECTOR) && this.getValue(HEADER) != false || this.getValue(TYPE).equals(TYPE_VECTOR) && this.getValue(VECTOR_NAMES) != false && this.getValue(VECTOR_READ_BY).equals(VECTOR_READ_BY_ROW);
        if (bl4) {
            --n3;
            n4 = 1;
        }
        String[] stringArray = new String[n3];
        if (bl3 && iterator.hasNext()) {
            ArrayList<Object> arrayList2 = (ArrayList<Object>)iterator.next();
            if (arrayList2 == null) {
                arrayList2 = arrayList;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                int n5 = i + n4;
                String string2 = string = n5 < arrayList2.size() ? arrayList2.get(n5) : "";
                if (string == null) {
                    string = "";
                }
                stringArray[i] = string.toString();
            }
        } else if (this.getValue(TYPE).equals(TYPE_DATAFRAME)) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = "V" + (i + 1);
            }
        }
        Iterator<List<Object>> iterator2 = unboundTableModel.iterator();
        if (bl3 && iterator2.hasNext()) {
            iterator2.next();
        }
        HashSet<String> hashSet = new HashSet<String>(this.getValue(VECTOR_NA_STRINGS).getValues(COL_NA_STRINGS));
        switch (this.getValue(TYPE)) {
            case "data.frame": {
                Object object;
                int n6;
                RTypeGuesser[] rTypeGuesserArray = new RTypeGuesser[unboundTableModel.getColumnCount()];
                for (int i = 0; i < rTypeGuesserArray.length; ++i) {
                    rTypeGuesserArray[i] = new RTypeGuesser(hashSet);
                }
                if (bl4) {
                    rTypeGuesserArray[0].input("dummy");
                }
                while (iterator2.hasNext()) {
                    List<Object> list2 = iterator2.next();
                    if (list2 == null) {
                        list2 = arrayList;
                    }
                    for (n6 = n4; n6 < unboundTableModel.getColumnCount(); ++n6) {
                        Object object2;
                        object = rTypeGuesserArray[n6];
                        if (((RTypeGuesser)object).isCharacter()) continue;
                        Object object3 = object2 = n6 < list2.size() ? list2.get(n6) : null;
                        if (object2 == null) {
                            object2 = "";
                        }
                        ((RTypeGuesser)object).input(object2.toString());
                    }
                }
                StringBuilder[] stringBuilderArray = new StringBuilder[unboundTableModel.getColumnCount()];
                for (n6 = 0; n6 < stringBuilderArray.length; ++n6) {
                    object = new StringBuilder(unboundTableModel.getRowCount() * 8);
                    stringBuilderArray[n6] = object;
                }
                n6 = 0;
                while (iterator.hasNext()) {
                    object = (List)iterator.next();
                    if (object == null) {
                        object = arrayList;
                    }
                    for (int i = 0; i < stringBuilderArray.length; ++i) {
                        String string = i < object.size() ? object.get(i) : "";
                        stringBuilderArray[i].append(this.valueToCode(string, rTypeGuesserArray[i].isCharacter(), (Set<String>)(bl4 && i == 0 ? null : hashSet)));
                        if (iterator.hasNext()) {
                            stringBuilderArray[i].append(", ");
                        }
                        if ((n6 + 1) % 10 != 0) continue;
                        stringBuilderArray[i].append("\n");
                    }
                    ++n6;
                }
                String string = this.getValue(OUTPUT);
                if (string != null && !string.isEmpty()) {
                    scriptBuilder.append(string + " <- ");
                }
                scriptBuilder.appendLn("structure(data.frame(").indent();
                for (int i = 0; i < stringArray.length; ++i) {
                    scriptBuilder.append("c(");
                    scriptBuilder.append(stringBuilderArray[i + n4]).append(")");
                    if (i == stringArray.length - 1) continue;
                    scriptBuilder.appendLn(", ");
                }
                ArgsList argsList = new ArgsList();
                if (this.getValue(ROW_NAMES).booleanValue()) {
                    argsList.add("row.names", "c(" + String.valueOf(stringBuilderArray[0]) + ")");
                }
                argsList.add("stringsAsFactors", this.getValue(STRINGS_AS_FACTORS));
                argsList.addAll(this.getArgs(ARGS_DATA_FRAME));
                scriptBuilder.appendLn(", ");
                scriptBuilder.append(RUtility.args(argsList));
                scriptBuilder.appendLn("),");
                Object object4 = RUtility.combineCharacters(stringArray);
                if (this.getValue(CHECK_NAMES2).booleanValue()) {
                    object4 = "make.names(" + (String)object4 + ", unique = TRUE)";
                }
                scriptBuilder.appendLn("names = " + (String)object4 + ")");
                return scriptBuilder.toString();
            }
        }
        boolean bl6 = this.getValue(TYPE).equals(TYPE_VECTOR);
        StringBuilder stringBuilder = null;
        if (bl4) {
            stringBuilder = new StringBuilder(unboundTableModel.getRowCount() * 8);
        }
        RTypeGuesser rTypeGuesser = new RTypeGuesser(hashSet);
        block17: while (iterator2.hasNext()) {
            List<Object> list3 = iterator2.next();
            if (list3 == null) {
                list3 = arrayList;
            }
            for (n = n4; n < unboundTableModel.getColumnCount(); ++n) {
                ArrayList<Object> arrayList3 = list = n < list3.size() ? list3.get(n) : null;
                if (list == null) {
                    list = "";
                }
                rTypeGuesser.input(((Object)list).toString());
                if (rTypeGuesser.isCharacter()) continue block17;
            }
        }
        boolean bl7 = rTypeGuesser.isCharacter();
        scriptBuilder.appendLn("c(").indent();
        if (bl6 && this.getValue(VECTOR_READ_BY).equals(VECTOR_READ_BY_COLUMN)) {
            n = 1;
            for (int i = 0; i < unboundTableModel.getColumnCount(); ++i) {
                iterator = unboundTableModel.iterator();
                if (n2 >= 0) {
                    iterator = Iterators.limit(iterator, (int)n2);
                }
                while (iterator.hasNext()) {
                    List list4 = (List)iterator.next();
                    Object v4 = var30_51 = list4 != null && i < list4.size() ? list4.get(i) : null;
                    if (bl4 && i == 0) {
                        stringBuilder.append(this.valueToCode(var30_51, true, null));
                        if (iterator.hasNext()) {
                            stringBuilder.append(", ");
                            if (n % 10 == 0) {
                                stringBuilder.append("\n\t");
                            }
                        }
                    } else {
                        scriptBuilder.append(this.valueToCode(var30_51, bl7, hashSet));
                        if (iterator.hasNext() || i != unboundTableModel.getColumnCount() - 1) {
                            scriptBuilder.append(", ");
                            if (n % 10 == 0) {
                                scriptBuilder.append("\n\t");
                            }
                        }
                    }
                    ++n;
                }
            }
        } else {
            n = 1;
            while (iterator.hasNext()) {
                list = (List)iterator.next();
                if (list == null) {
                    list = arrayList;
                }
                for (int i = 0; i < unboundTableModel.getColumnCount(); ++i) {
                    Object v5 = var30_51 = i < list.size() ? list.get(i) : null;
                    if (bl4 && i == 0) {
                        stringBuilder.append(this.valueToCode(var30_51, true, null));
                        if (iterator.hasNext()) {
                            stringBuilder.append(", ");
                        }
                    } else {
                        scriptBuilder.append(this.valueToCode(var30_51, bl7, hashSet));
                        if (iterator.hasNext() || i != unboundTableModel.getColumnCount() - 1) {
                            scriptBuilder.append(", ");
                        }
                    }
                    if (bl6 && n % 10 == 0) {
                        scriptBuilder.appendLn("");
                    }
                    ++n;
                }
                if (bl6 || !iterator.hasNext()) continue;
                scriptBuilder.appendLn("");
            }
        }
        scriptBuilder.appendLn("");
        scriptBuilder.append(")");
        Object object = "NULL";
        if (stringBuilder != null) {
            object = "c(" + String.valueOf(stringBuilder) + ")";
        }
        String string = "NULL";
        if (bl3) {
            string = RUtility.combineCharacters(stringArray);
        }
        if (this.getValue(TYPE).equals(TYPE_MATRIX)) {
            String string3 = null;
            if (bl4 || bl3) {
                string3 = RUtility.function("list", new String[]{"", object, "", string});
            }
            int n7 = unboundTableModel.getRowCount();
            if (bl3) {
                --n7;
            }
            ArgsList argsList = new ArgsList().addAll("data", scriptBuilder.toString(), "nrow", Integer.toString(n7), "ncol", Integer.toString(n3), "byrow", "TRUE", "dimnames", string3);
            argsList.addAll(this.getArgs(ARGS_MATRIX));
            ScriptBuilder scriptBuilder2 = RDirectDataInput.scriptBuilder();
            scriptBuilder2.append("matrix(");
            scriptBuilder2.append(RUtility.args(argsList));
            scriptBuilder2.append(")");
            return RUtility.assign(this.getValue(OUTPUT), scriptBuilder2.toString());
        }
        if (bl4 || bl3) {
            return RUtility.assignFunction(this.getValue(OUTPUT), "structure", new String[]{"", scriptBuilder.toString(), "names", bl4 ? object : string});
        }
        return RUtility.assign(this.getValue(OUTPUT), scriptBuilder.toString());
    }

    private String valueToCode(Object object, boolean bl, Set<String> set) {
        String string;
        String string2 = string = object == null ? "" : object.toString();
        if (set != null && set.contains(string)) {
            return "NA";
        }
        if (bl) {
            return RDirectDataInput.quote(string);
        }
        if (string.isEmpty()) {
            string = "NA";
        }
        return string;
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTabWithElements("Main", DATA, OUTPUT, TYPE, HEADER, ROW_NAMES, VECTOR_READ_BY, VECTOR_NAMES).addTabWithElements("Options", STRINGS_AS_FACTORS, CHECK_NAMES2, VECTOR_NA_STRINGS).addTabWithElements("Advanced", ARGS_SWITCH, ARGS_DATA_FRAME, ARGS_MATRIX);
    }

    @Override
    protected void configureValidationContext(ValidationContext validationContext) {
        validationContext.addValidator(DATA, new Validator(){

            @Override
            public void validate(Key<?> key, Object object, ValidationContext validationContext) {
                UnboundTableModel unboundTableModel = (UnboundTableModel)object;
                if (unboundTableModel.getRowCount() * unboundTableModel.getColumnCount() > 10000) {
                    validationContext.addError(this, new BasicValueError(4, "Element count limit exceeded: > 10000", key));
                }
            }
        });
    }
}

